/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.io.netty.handler.codec.sockjs.handler;

import io.netty.channel.ChannelHandlerContext;
import io.netty.util.concurrent.ScheduledFuture;
import io.netty.util.internal.StringUtil;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.util.concurrent.TimeUnit;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.SockJsSessionContext;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.handler.SessionState;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.handler.SockJsSession;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.protocol.HeartbeatFrame;

class WebSocketSessionState
implements SessionState {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(WebSocketSessionState.class);
    private final SockJsSession session;
    private ScheduledFuture<?> heartbeatFuture;

    WebSocketSessionState(SockJsSession session) {
        this.session = session;
    }

    @Override
    public SessionState.State getState() {
        return this.session.getState();
    }

    @Override
    public void setState(SessionState.State state) {
        this.session.setState(state);
    }

    @Override
    public void onConnect(ChannelHandlerContext ctx, SockJsSessionContext sockJsSessionContext) {
        this.session.setConnectionContext(ctx);
        this.session.onOpen(sockJsSessionContext);
        this.startHeartbeatTimer(ctx, this.session);
    }

    private void startHeartbeatTimer(final ChannelHandlerContext ctx, final SockJsSession session) {
        long interval = session.config().webSocketHeartbeatInterval();
        if (interval > 0L) {
            if (logger.isDebugEnabled()) {
                logger.info("Starting heartbeat with interval {}", (Object)interval);
            }
            this.heartbeatFuture = ctx.executor().scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    if (ctx.channel().isActive() && ctx.channel().isRegistered()) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("Sending heartbeat for {}", (Object)session);
                        }
                        ctx.channel().writeAndFlush((Object)new HeartbeatFrame());
                    }
                }
            }, interval, interval, TimeUnit.MILLISECONDS);
        }
    }

    @Override
    public void onOpen(ChannelHandlerContext ctx) {
        this.session.setInuse(true);
    }

    @Override
    public void onMessage(String message) throws Exception {
        this.session.onMessage(message);
    }

    @Override
    public void storeMessage(String message) {
        this.session.addMessage(message);
    }

    @Override
    public ChannelHandlerContext getSendingContext() {
        return this.session.connectionContext();
    }

    @Override
    public boolean isInUse() {
        return this.session.connectionContext().channel().isActive();
    }

    @Override
    public void setInuse() {
    }

    @Override
    public void resetInuse() {
    }

    @Override
    public void onSockJSServerInitiatedClose() {
        this.shutdownHearbeat();
    }

    public String toString() {
        return StringUtil.simpleClassName((Object)this);
    }

    @Override
    public void onClose() {
        this.session.onClose();
        this.session.setInuse(false);
        this.shutdownHearbeat();
    }

    private void shutdownHearbeat() {
        if (this.heartbeatFuture != null) {
            logger.debug("Stopping heartbeat job");
            this.heartbeatFuture.cancel(true);
        }
    }
}

