/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.io.netty.handler.codec.sockjs.protocol;

import com.fasterxml.jackson.core.io.JsonStringEncoder;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.DefaultByteBufHolder;
import io.netty.buffer.Unpooled;
import io.netty.util.CharsetUtil;
import io.netty.util.internal.StringUtil;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.protocol.Frame;

public class MessageFrame
extends DefaultByteBufHolder
implements Frame {
    private final List<String> messages;

    public MessageFrame(String message) {
        this(new String[]{message});
    }

    public MessageFrame(String ... messages) {
        this(new ArrayList<String>(Arrays.asList(messages)));
    }

    public MessageFrame(List<String> messages) {
        super(MessageFrame.generateContent(messages));
        this.messages = messages;
    }

    public List<String> messages() {
        return Collections.unmodifiableList(this.messages);
    }

    @Override
    public MessageFrame copy() {
        return new MessageFrame(this.messages);
    }

    @Override
    public MessageFrame duplicate() {
        return new MessageFrame(this.messages);
    }

    @Override
    public MessageFrame retain() {
        super.retain();
        return this;
    }

    @Override
    public MessageFrame retain(int increment) {
        super.retain(increment);
        return this;
    }

    public String toString() {
        return StringUtil.simpleClassName((Object)this) + "[messages=" + this.messages + ']';
    }

    private static ByteBuf generateContent(List<String> messages) {
        JsonStringEncoder jsonEndocder = new JsonStringEncoder();
        ByteBuf content = Unpooled.buffer();
        content.writeByte(97).writeByte(91);
        int size = messages.size();
        for (int i = 0; i < size; ++i) {
            content.writeByte(34);
            String element = messages.get(i);
            if (element == null) {
                messages.subList(i, size).clear();
                break;
            }
            String escaped = MessageFrame.escapeCharacters(jsonEndocder.quoteAsString(element));
            ByteBuf escapedBuf = Unpooled.copiedBuffer((CharSequence)escaped, (Charset)CharsetUtil.UTF_8);
            content.writeBytes(escapedBuf).writeByte(34);
            escapedBuf.release();
            if (i >= size - 1) continue;
            content.writeByte(44);
        }
        return content.writeByte(93);
    }

    private static String escapeCharacters(char[] value) {
        StringBuilder sb = new StringBuilder(value.length);
        for (char ch : value) {
            if (ch >= '\u0000' && ch <= '\u001f' || ch >= '\ud800' && ch <= '\udfff' || ch >= '\u200c' && ch <= '\u200f' || ch >= '\u2028' && ch <= '\u202f' || ch >= '\u2060' && ch <= '\u206f' || ch >= '\ufff0' && ch <= '\uffff') {
                String ss = Integer.toHexString(ch);
                sb.append('\\');
                sb.append('u');
                for (int k = 0; k < 4 - ss.length(); ++k) {
                    sb.append('0');
                }
                sb.append(ss.toLowerCase());
                continue;
            }
            sb.append(ch);
        }
        return sb.toString();
    }
}

