/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.io.netty.handler.codec.sockjs.transport;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerAdapter;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelPromise;
import io.netty.handler.codec.http.DefaultHttpContent;
import io.netty.handler.codec.http.DefaultHttpResponse;
import io.netty.handler.codec.http.FullHttpResponse;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponse;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.handler.codec.http.QueryStringDecoder;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import java.nio.charset.Charset;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.SockJsConfig;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.handler.SessionHandler;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.protocol.Frame;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.transport.Transports;

public class HtmlFileTransport
extends ChannelHandlerAdapter {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(HtmlFileTransport.class);
    private static final ByteBuf HEADER_PART1 = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.copiedBuffer((CharSequence)"<!doctype html>\n<html><head>\n  <meta http-equiv=\"X-UA-Compatible\" content=\"IE=edge\" />\n  <meta http-equiv=\"Content-Type\" content=\"text/html; charset=UTF-8\" />\n</head><body><h2>Don't panic!</h2>\n  <script>\n    document.domain = document.domain;\n    var c = parent.", (Charset)CharsetUtil.UTF_8));
    private static final ByteBuf HEADER_PART2 = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.copiedBuffer((CharSequence)";\n    c.start();\n    function p(d) {c.message(d);};\n    window.onload = function() {c.stop();};\n  </script>", (Charset)CharsetUtil.UTF_8));
    private static final ByteBuf PREFIX = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.copiedBuffer((CharSequence)"<script>\np(\"", (Charset)CharsetUtil.UTF_8));
    private static final ByteBuf POSTFIX = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.copiedBuffer((CharSequence)"\");\n</script>\r\n", (Charset)CharsetUtil.UTF_8));
    private static final ByteBuf END_HEADER = Unpooled.unreleasableBuffer((ByteBuf)Unpooled.copiedBuffer((byte[])new byte[]{13, 10, 13, 10}));
    private final SockJsConfig config;
    private final HttpRequest request;
    private final AtomicBoolean headerSent = new AtomicBoolean(false);
    private final AtomicInteger bytesSent = new AtomicInteger(0);
    private String callback;

    public HtmlFileTransport(SockJsConfig config, HttpRequest request) {
        this.config = config;
        this.request = request;
    }

    public void channelRead(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof HttpRequest) {
            String c = HtmlFileTransport.getCallbackFromRequest((HttpRequest)msg);
            if (c.isEmpty()) {
                ReferenceCountUtil.release((Object)msg);
                this.respondCallbackRequired(ctx);
                ctx.fireUserEventTriggered((Object)SessionHandler.Event.CLOSE_SESSION);
                return;
            }
            this.callback = c;
        }
        ctx.fireChannelRead(msg);
    }

    private static String getCallbackFromRequest(HttpRequest request) {
        QueryStringDecoder qsd = new QueryStringDecoder(request.getUri());
        List c = (List)qsd.parameters().get("c");
        return c == null || c.isEmpty() ? "" : (String)c.get(0);
    }

    public void write(ChannelHandlerContext ctx, Object msg, ChannelPromise promise) throws Exception {
        if (msg instanceof Frame) {
            Frame frame = (Frame)msg;
            if (this.headerSent.compareAndSet(false, true)) {
                HttpResponse response = this.createResponse("text/html; charset=UTF-8");
                ByteBuf header = ctx.alloc().buffer();
                header.writeBytes(HEADER_PART1.duplicate());
                ByteBuf content = Unpooled.copiedBuffer((CharSequence)this.callback, (Charset)CharsetUtil.UTF_8);
                header.writeBytes(content);
                content.release();
                header.writeBytes(HEADER_PART2.duplicate());
                int spaces = 1024 * header.readableBytes();
                ByteBuf paddedBuffer = ctx.alloc().buffer(1074);
                paddedBuffer.writeBytes(header);
                header.release();
                for (int s = 0; s < spaces + 20; ++s) {
                    paddedBuffer.writeByte(32);
                }
                paddedBuffer.writeBytes(END_HEADER.duplicate());
                ctx.write((Object)response, promise);
                ctx.writeAndFlush((Object)new DefaultHttpContent(paddedBuffer));
            }
            ByteBuf data = ctx.alloc().buffer();
            data.writeBytes(PREFIX.duplicate());
            data.writeBytes(Transports.escapeJson(frame.content(), data));
            frame.content().release();
            data.writeBytes(POSTFIX.duplicate());
            int dataSize = data.readableBytes();
            ctx.writeAndFlush((Object)new DefaultHttpContent(data));
            if (this.maxBytesLimit(dataSize)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("max bytesSize limit reached [{}]", (Object)this.config.maxStreamingBytesSize());
                }
                ctx.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            }
        } else {
            ctx.write(ReferenceCountUtil.retain((Object)msg), promise);
        }
    }

    private void respondCallbackRequired(ChannelHandlerContext ctx) {
        FullHttpResponse response = Transports.responseWithContent(this.request.getProtocolVersion(), HttpResponseStatus.INTERNAL_SERVER_ERROR, "text/plain; charset=UTF-8", "\"callback\" parameter required");
        Transports.setNoCacheHeaders((HttpResponse)response);
        Transports.writeResponse(ctx, (HttpResponse)response);
    }

    private boolean maxBytesLimit(int bytesWritten) {
        this.bytesSent.addAndGet(bytesWritten);
        return this.bytesSent.get() >= this.config.maxStreamingBytesSize();
    }

    protected HttpResponse createResponse(String contentType) {
        HttpVersion version = this.request.getProtocolVersion();
        DefaultHttpResponse response = new DefaultHttpResponse(version, HttpResponseStatus.OK);
        if (this.request.getProtocolVersion().equals((Object)HttpVersion.HTTP_1_1)) {
            response.headers().set(HttpHeaders.Names.TRANSFER_ENCODING, (Object)HttpHeaders.Values.CHUNKED);
        }
        response.headers().set(HttpHeaders.Names.CONTENT_TYPE, (Object)contentType);
        Transports.setDefaultHeaders((HttpResponse)response, this.config);
        return response;
    }
}

