/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.io.netty.handler.codec.sockjs.transport;

import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.websocketx.CloseWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PingWebSocketFrame;
import io.netty.handler.codec.http.websocketx.PongWebSocketFrame;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketFrame;
import io.netty.handler.codec.http.websocketx.WebSocketHandshakeException;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshaker;
import io.netty.handler.codec.http.websocketx.WebSocketServerHandshakerFactory;
import io.netty.util.AttributeKey;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.internal.logging.InternalLogger;
import io.netty.util.internal.logging.InternalLoggerFactory;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.SockJsConfig;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.SockJsService;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.SockJsSessionContext;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.handler.CorsInboundHandler;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.handler.CorsOutboundHandler;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.handler.SockJsHandler;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.transport.RawWebSocketSendHandler;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.transport.Transports;

public class RawWebSocketTransport
extends SimpleChannelInboundHandler<Object> {
    private static final InternalLogger logger = InternalLoggerFactory.getInstance(RawWebSocketTransport.class);
    private static final AttributeKey<HttpRequest> REQUEST_KEY = AttributeKey.valueOf((String)"raw.ws.request.key");
    private final SockJsConfig config;
    private final SockJsService service;
    private WebSocketServerHandshaker handshaker;

    public RawWebSocketTransport(SockJsConfig config, SockJsService service) {
        this.config = config;
        this.service = service;
    }

    protected void messageReceived(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof FullHttpRequest) {
            this.handleHttpRequest(ctx, (FullHttpRequest)msg);
        } else if (msg instanceof WebSocketFrame) {
            this.handleWebSocketFrame(ctx, (WebSocketFrame)msg);
        } else {
            ctx.fireChannelRead(msg);
        }
    }

    private static boolean checkRequestHeaders(ChannelHandlerContext ctx, HttpRequest req) {
        if (req.getMethod() != HttpMethod.GET) {
            ctx.writeAndFlush((Object)Transports.methodNotAllowedResponse(req.getProtocolVersion())).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            return false;
        }
        String upgradeHeader = req.headers().get(HttpHeaders.Names.UPGRADE);
        if (upgradeHeader == null || !"websocket".equals(upgradeHeader.toLowerCase())) {
            ctx.writeAndFlush((Object)Transports.badRequestResponse(req.getProtocolVersion(), "Can \"Upgrade\" only to \"WebSocket\".")).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            return false;
        }
        String connectHeader = req.headers().get(HttpHeaders.Names.CONNECTION);
        if (connectHeader != null && "keep-alive".equals(connectHeader.toLowerCase())) {
            req.headers().set(HttpHeaders.Names.CONNECTION, (Object)HttpHeaders.Values.UPGRADE);
            connectHeader = HttpHeaders.Values.UPGRADE.toString();
        }
        if (connectHeader == null || !"upgrade".equals(connectHeader.toLowerCase())) {
            ctx.writeAndFlush((Object)Transports.badRequestResponse(req.getProtocolVersion(), "\"Connection\" must be \"Upgrade\".")).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
            return false;
        }
        return true;
    }

    private void handleHttpRequest(final ChannelHandlerContext ctx, FullHttpRequest req) {
        if (!RawWebSocketTransport.checkRequestHeaders(ctx, (HttpRequest)req)) {
            return;
        }
        ctx.attr(REQUEST_KEY).set((Object)req);
        String wsUrl = RawWebSocketTransport.getWebSocketLocation(this.config.isTls(), req, Transports.Type.WEBSOCKET.path());
        WebSocketServerHandshakerFactory wsFactory = new WebSocketServerHandshakerFactory(wsUrl, this.config.webSocketProtocolCSV(), false);
        this.handshaker = wsFactory.newHandshaker((HttpRequest)req);
        if (this.handshaker == null) {
            WebSocketServerHandshakerFactory.sendUnsupportedWebSocketVersionResponse((Channel)ctx.channel());
        } else {
            ChannelFuture handshakeFuture = this.handshaker.handshake(ctx.channel(), req);
            handshakeFuture.addListener((GenericFutureListener)new ChannelFutureListener(){

                public void operationComplete(ChannelFuture future) throws Exception {
                    if (future.isSuccess()) {
                        ctx.pipeline().remove(SockJsHandler.class);
                        ctx.pipeline().remove(CorsInboundHandler.class);
                        ctx.pipeline().remove(CorsOutboundHandler.class);
                        ctx.pipeline().addLast(new ChannelHandler[]{new RawWebSocketSendHandler()});
                        RawWebSocketTransport.this.service.onOpen(new SockJsSessionContext(){

                            @Override
                            public void send(String message) {
                                ctx.writeAndFlush((Object)new TextWebSocketFrame(message));
                            }

                            @Override
                            public void close() {
                                ctx.close();
                            }

                            @Override
                            public ChannelHandlerContext getContext() {
                                return ctx;
                            }
                        });
                    }
                }
            });
        }
    }

    private static String getWebSocketLocation(boolean tls, FullHttpRequest req, String path) {
        String protocol = tls ? "wss://" : "ws://";
        return protocol + req.headers().get(HttpHeaders.Names.HOST) + path;
    }

    private void handleWebSocketFrame(ChannelHandlerContext ctx, WebSocketFrame wsFrame) throws Exception {
        if (wsFrame instanceof CloseWebSocketFrame) {
            wsFrame.retain();
            this.service.onClose();
            this.handshaker.close(ctx.channel(), (CloseWebSocketFrame)wsFrame);
            return;
        }
        if (wsFrame instanceof PingWebSocketFrame) {
            wsFrame.content().retain();
            ctx.channel().writeAndFlush((Object)new PongWebSocketFrame(wsFrame.content()));
            return;
        }
        if (!(wsFrame instanceof TextWebSocketFrame)) {
            throw new UnsupportedOperationException(String.format("%s frame types not supported", wsFrame.getClass().getName()));
        }
        String message = ((TextWebSocketFrame)wsFrame).text();
        this.service.onMessage(message);
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (cause instanceof WebSocketHandshakeException) {
            HttpRequest request = (HttpRequest)ctx.attr(REQUEST_KEY).get();
            logger.error("Failed with ws handshake for request: " + request, cause);
            ctx.writeAndFlush((Object)Transports.internalServerErrorResponse(request.getProtocolVersion(), cause.getMessage())).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else {
            ctx.fireExceptionCaught(cause);
        }
    }
}

