/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.io.netty.handler.codec.sockjs.util;

import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.io.CharTypes;
import com.fasterxml.jackson.core.json.JsonWriteContext;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.module.SimpleModule;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.handler.codec.http.websocketx.TextWebSocketFrame;
import io.netty.util.CharsetUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;

public final class JsonUtil {
    private static final ObjectMapper MAPPER;
    private static final String[] EMPTY_STRING_ARRAY;
    private static final char[] HEX_CHARS;
    private static final int[] ESCAPE_CODES;

    private JsonUtil() {
    }

    public static String[] decode(TextWebSocketFrame frame) throws IOException {
        ByteBuf content = frame.content();
        if (content.readableBytes() == 0) {
            return EMPTY_STRING_ARRAY;
        }
        ByteBufInputStream byteBufInputStream = new ByteBufInputStream(content);
        byte firstByte = content.getByte(0);
        if (firstByte == 91) {
            return (String[])MAPPER.readValue((InputStream)byteBufInputStream, String[].class);
        }
        if (firstByte == 123) {
            return new String[]{content.toString(CharsetUtil.UTF_8)};
        }
        return new String[]{(String)MAPPER.readValue((InputStream)byteBufInputStream, String.class)};
    }

    public static String[] decode(String content) throws IOException {
        JsonNode root = MAPPER.readTree(content);
        if (root.isObject()) {
            return new String[]{root.toString()};
        }
        if (root.isValueNode()) {
            return new String[]{root.asText()};
        }
        if (!root.isArray()) {
            throw new JsonMappingException("content must be a JSON Array but was : " + content);
        }
        ArrayList<String> messages = new ArrayList<String>();
        Iterator elements = root.elements();
        while (elements.hasNext()) {
            JsonNode field = (JsonNode)elements.next();
            if (field.isValueNode()) {
                messages.add(field.asText());
                continue;
            }
            messages.add(field.toString());
        }
        return messages.toArray(new String[messages.size()]);
    }

    public static String encode(String content) throws JsonMappingException {
        try {
            return MAPPER.writeValueAsString((Object)content);
        }
        catch (Exception e) {
            throw new JsonMappingException("content must be a JSON Array but was : " + content);
        }
    }

    static {
        EMPTY_STRING_ARRAY = new String[0];
        HEX_CHARS = "0123456789abcdef".toCharArray();
        ESCAPE_CODES = CharTypes.get7BitOutputEscapes();
        MAPPER = new ObjectMapper();
        SimpleModule simpleModule = new SimpleModule("simplepush", new Version(0, 10, 0, null, "org.jboss.aerogear", "aerogear-netty-codec-sockjs"));
        simpleModule.addSerializer(String.class, (JsonSerializer)new JsonSerializer<String>(){

            private void writeUnicodeEscape(JsonGenerator gen, char c) throws IOException {
                gen.writeRaw('\\');
                gen.writeRaw('u');
                gen.writeRaw(HEX_CHARS[c >> 12 & 0xF]);
                gen.writeRaw(HEX_CHARS[c >> 8 & 0xF]);
                gen.writeRaw(HEX_CHARS[c >> 4 & 0xF]);
                gen.writeRaw(HEX_CHARS[c & 0xF]);
            }

            private void writeShortEscape(JsonGenerator gen, char c) throws IOException {
                gen.writeRaw('\\');
                gen.writeRaw(c);
            }

            public void serialize(String str, JsonGenerator gen, SerializerProvider provider) throws IOException {
                int status = ((JsonWriteContext)gen.getOutputContext()).writeValue();
                switch (status) {
                    case 2: {
                        gen.writeRaw(':');
                        break;
                    }
                    case 1: {
                        gen.writeRaw(',');
                        break;
                    }
                    case 5: {
                        throw new JsonGenerationException("Can not write string value here");
                    }
                }
                gen.writeRaw('\"');
                for (char c : str.toCharArray()) {
                    int code;
                    if (c >= '\u0080') {
                        this.writeUnicodeEscape(gen, c);
                        continue;
                    }
                    int n = code = c < ESCAPE_CODES.length ? ESCAPE_CODES[c] : 0;
                    if (code == 0) {
                        gen.writeRaw(c);
                        continue;
                    }
                    if (code == -1) {
                        this.writeUnicodeEscape(gen, c);
                        continue;
                    }
                    this.writeShortEscape(gen, (char)code);
                }
                gen.writeRaw('\"');
            }
        });
        MAPPER.registerModule((Module)simpleModule);
    }
}

