/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.simplepush.server.datastore;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.ektorp.BulkDeleteDocument;
import org.ektorp.CouchDbInstance;
import org.ektorp.ViewQuery;
import org.ektorp.ViewResult;
import org.ektorp.http.HttpClient;
import org.ektorp.http.StdHttpClient;
import org.ektorp.impl.StdCouchDbConnector;
import org.ektorp.impl.StdCouchDbInstance;
import org.ektorp.support.DesignDocument;
import org.jboss.aerogear.simplepush.protocol.Ack;
import org.jboss.aerogear.simplepush.protocol.impl.AckImpl;
import org.jboss.aerogear.simplepush.server.Channel;
import org.jboss.aerogear.simplepush.server.DefaultChannel;
import org.jboss.aerogear.simplepush.server.datastore.ChannelNotFoundException;
import org.jboss.aerogear.simplepush.server.datastore.DataStore;
import org.jboss.aerogear.simplepush.server.datastore.VersionException;
import org.jboss.aerogear.simplepush.server.datastore.Views;

public class CouchDBDataStore
implements DataStore {
    private static final String UAID_FIELD = "uaid";
    private static final String TYPE_FIELD = "type";
    private static final String TOKEN_FIELD = "token";
    private static final String CHID_FIELD = "chid";
    private static final String VERSION_FIELD = "version";
    private static final String DOC_FIELD = "doc";
    private final HttpClient httpClient;
    private final StdCouchDbInstance stdCouchDbInstance;
    private final StdCouchDbConnector db;
    private final DesignDocument designDocument;
    private static final Charset UTF_8 = Charset.forName("UTF-8");

    public CouchDBDataStore(String url, String dbName) {
        try {
            this.httpClient = new StdHttpClient.Builder().url(url).build();
        }
        catch (MalformedURLException e) {
            throw new IllegalStateException(e);
        }
        this.stdCouchDbInstance = new StdCouchDbInstance(this.httpClient);
        this.db = new StdCouchDbConnector(dbName, (CouchDbInstance)this.stdCouchDbInstance);
        this.db.createDatabaseIfNotExists();
        this.designDocument = new DesignDocument("_design/channels");
        this.addView(this.designDocument, Views.CHANNEL);
        this.addView(this.designDocument, Views.UAID);
        this.addView(this.designDocument, Views.TOKEN);
        this.addView(this.designDocument, Views.UNACKS);
        this.addView(this.designDocument, Views.SERVER);
        if (!this.db.contains(this.designDocument.getId())) {
            this.db.create((Object)this.designDocument);
        }
    }

    private void addView(DesignDocument doc, Views view) {
        if (!doc.containsView(view.viewName())) {
            doc.addView(view.viewName(), new DesignDocument.View(view.mapFunction()));
        }
    }

    public void savePrivateKeySalt(byte[] salt) {
        byte[] privateKeySalt = this.getPrivateKeySalt();
        if (privateKeySalt.length == 0) {
            HashMap<String, String> map = new HashMap<String, String>(2);
            map.put(TYPE_FIELD, Views.SERVER.viewName());
            map.put("salt", new String(salt, UTF_8));
            this.db.create(map);
        }
    }

    public byte[] getPrivateKeySalt() {
        ViewQuery viewQuery = new ViewQuery().dbPath(this.db.path()).viewName(Views.SERVER.viewName()).designDocId(this.designDocument.getId());
        ViewResult viewResult = this.db.queryView(viewQuery);
        if (viewResult.isEmpty()) {
            return new byte[0];
        }
        ViewResult.Row row = (ViewResult.Row)viewResult.getRows().get(0);
        return row.getKeyAsNode().get("salt").asText().getBytes(UTF_8);
    }

    public boolean saveChannel(Channel channel) {
        this.db.create(this.channelAsMap(channel));
        return true;
    }

    private Map<String, String> channelAsMap(Channel channel) {
        HashMap<String, String> map = new HashMap<String, String>(5);
        map.put(UAID_FIELD, channel.getUAID());
        map.put(TYPE_FIELD, Views.CHANNEL.viewName());
        map.put(TOKEN_FIELD, channel.getEndpointToken());
        map.put(CHID_FIELD, channel.getChannelId());
        map.put(VERSION_FIELD, Long.toString(channel.getVersion()));
        return map;
    }

    public Channel getChannel(String channelId) throws ChannelNotFoundException {
        return this.channelFromJson(this.getChannelJson(channelId));
    }

    private JsonNode getChannelJson(String channelId) throws ChannelNotFoundException {
        ViewResult viewResult = this.db.queryView(this.query(Views.CHANNEL.viewName(), channelId));
        List rows = viewResult.getRows();
        if (rows.isEmpty()) {
            throw new ChannelNotFoundException("Cound not find channel", channelId);
        }
        if (rows.size() > 1) {
            throw new IllegalStateException("There should not be multiple channelId with the same id");
        }
        return ((ViewResult.Row)rows.get(0)).getValueAsNode();
    }

    private Channel channelFromJson(JsonNode node) {
        JsonNode doc = node.get(DOC_FIELD);
        return new DefaultChannel(doc.get(UAID_FIELD).asText(), doc.get(CHID_FIELD).asText(), doc.get(VERSION_FIELD).asLong(), doc.get(TOKEN_FIELD).asText());
    }

    public void removeChannels(String uaid) {
        ViewResult viewResult = this.db.queryView(this.query(Views.UAID.viewName(), uaid));
        List rows = viewResult.getRows();
        HashSet<String> channelIds = new HashSet<String>(rows.size());
        for (ViewResult.Row row : rows) {
            JsonNode json = row.getValueAsNode().get(DOC_FIELD);
            channelIds.add(json.get(CHID_FIELD).asText());
        }
        this.removeChannels(channelIds);
    }

    private ViewQuery query(String viewName, String key) {
        return new ViewQuery().dbPath(this.db.path()).viewName(viewName).designDocId(this.designDocument.getId()).key(key);
    }

    public void removeChannels(Set<String> channelIds) {
        ViewResult viewResult = this.db.queryView(this.channelsQuery(channelIds));
        List rows = viewResult.getRows();
        LinkedHashSet<BulkDeleteDocument> removals = new LinkedHashSet<BulkDeleteDocument>();
        for (ViewResult.Row row : rows) {
            JsonNode json = row.getValueAsNode();
            removals.add(BulkDeleteDocument.of((Object)json.get(DOC_FIELD)));
        }
        this.db.executeBulk(removals);
    }

    private ViewQuery channelsQuery(Set<String> keys) {
        return new ViewQuery().dbPath(this.db.path()).viewName(Views.CHANNEL.viewName()).designDocId(this.designDocument.getId()).keys(keys);
    }

    public Set<String> getChannelIds(String uaid) {
        ViewResult viewResult = this.db.queryView(this.query(Views.UAID.viewName(), uaid));
        List rows = viewResult.getRows();
        if (rows.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<String> channelIds = new HashSet<String>(rows.size());
        for (ViewResult.Row row : rows) {
            channelIds.add(row.getValueAsNode().get(DOC_FIELD).get(CHID_FIELD).asText());
        }
        return channelIds;
    }

    public String updateVersion(String endpointToken, long version) throws VersionException, ChannelNotFoundException {
        ViewResult viewResult = this.db.queryView(this.query(Views.TOKEN.viewName(), endpointToken));
        List rows = viewResult.getRows();
        if (rows.isEmpty()) {
            throw new ChannelNotFoundException("Cound not find channel for endpointToken", endpointToken);
        }
        ObjectNode node = (ObjectNode)((ViewResult.Row)rows.get(0)).getValueAsNode().get(DOC_FIELD);
        long currentVersion = node.get(VERSION_FIELD).asLong();
        if (version <= currentVersion) {
            throw new VersionException("version [" + version + "] must be greater than the current version [" + currentVersion + "]");
        }
        node.put(VERSION_FIELD, String.valueOf(version));
        this.db.update((Object)node);
        return node.get(CHID_FIELD).asText();
    }

    public String saveUnacknowledged(String channelId, long version) throws ChannelNotFoundException {
        JsonNode json = this.getChannelJson(channelId);
        Map<String, String> unack = this.docToAckMap((ObjectNode)json.get(DOC_FIELD), version);
        this.db.create(unack);
        return unack.get(UAID_FIELD);
    }

    private Map<String, String> docToAckMap(ObjectNode doc, long version) {
        String uaid = doc.get(UAID_FIELD).asText();
        String chid = doc.get(CHID_FIELD).asText();
        String token = doc.get(TOKEN_FIELD).asText();
        HashMap<String, String> map = new HashMap<String, String>(5);
        map.put(UAID_FIELD, uaid);
        map.put(TYPE_FIELD, "ack");
        map.put(TOKEN_FIELD, token);
        map.put(CHID_FIELD, chid);
        map.put(VERSION_FIELD, Long.toString(version));
        return map;
    }

    public Set<Ack> getUnacknowledged(String uaid) {
        ViewResult viewResult = this.db.queryView(this.query(Views.UNACKS.viewName(), uaid));
        return this.rowsToAcks(viewResult.getRows());
    }

    public Set<Ack> removeAcknowledged(String uaid, Set<Ack> acked) {
        ViewResult viewResult = this.db.queryView(this.query(Views.UNACKS.viewName(), uaid));
        List rows = viewResult.getRows();
        LinkedHashSet<BulkDeleteDocument> removals = new LinkedHashSet<BulkDeleteDocument>();
        Iterator iter = rows.iterator();
        while (iter.hasNext()) {
            ViewResult.Row row = (ViewResult.Row)iter.next();
            JsonNode json = row.getValueAsNode();
            JsonNode doc = json.get(DOC_FIELD);
            String channelId = doc.get(CHID_FIELD).asText();
            for (Ack ack : acked) {
                if (!ack.getChannelId().equals(channelId)) continue;
                removals.add(BulkDeleteDocument.of((Object)doc));
                iter.remove();
            }
        }
        this.db.executeBulk(removals);
        return this.rowsToAcks(rows);
    }

    private Set<Ack> rowsToAcks(List<ViewResult.Row> rows) {
        if (rows.isEmpty()) {
            return Collections.emptySet();
        }
        HashSet<Ack> unacks = new HashSet<Ack>(rows.size());
        for (ViewResult.Row row : rows) {
            JsonNode json = row.getValueAsNode().get(DOC_FIELD);
            unacks.add((Ack)new AckImpl(json.get(CHID_FIELD).asText(), json.get(VERSION_FIELD).asLong()));
        }
        return unacks;
    }
}

