/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.simplepush.server.datastore;

import java.nio.charset.Charset;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.pool.impl.GenericObjectPool;
import org.jboss.aerogear.simplepush.protocol.Ack;
import org.jboss.aerogear.simplepush.protocol.impl.AckImpl;
import org.jboss.aerogear.simplepush.server.Channel;
import org.jboss.aerogear.simplepush.server.DefaultChannel;
import org.jboss.aerogear.simplepush.server.datastore.ChannelNotFoundException;
import org.jboss.aerogear.simplepush.server.datastore.DataStore;
import org.jboss.aerogear.simplepush.server.datastore.VersionException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import redis.clients.jedis.Jedis;
import redis.clients.jedis.JedisPool;
import redis.clients.jedis.JedisPoolConfig;
import redis.clients.jedis.Transaction;

public class RedisDataStore
implements DataStore {
    private static final String CHID_LOOKUP_KEY_PREFIX = "chid:lookup:";
    private static final String UAID_LOOKUP_KEY_PREFIX = "uaid:lookup:";
    private static final String TOKEN_LOOKUP_KEY_PREFIX = "token:lookup:";
    private static final String ACK_LOOKUP_KEY_PREFIX = "ack:";
    private static final String ACKS_LOOKUP_KEY_PREFIX = "acks:";
    private static final String TOKEN_KEY = "token";
    private static final String UAID_KEY = "uaid";
    private final Logger logger = LoggerFactory.getLogger(RedisDataStore.class);
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private final JedisPool jedisPool;

    public RedisDataStore(String host, int port) {
        this.jedisPool = new JedisPool((GenericObjectPool.Config)new JedisPoolConfig(), host, port);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void savePrivateKeySalt(byte[] salt) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            jedis.set("salt", new String(salt, UTF_8));
        }
        finally {
            this.jedisPool.returnResource((Object)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] getPrivateKeySalt() {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            String salt = jedis.get("salt");
            byte[] byArray = salt != null ? salt.getBytes(UTF_8) : new byte[]{};
            return byArray;
        }
        finally {
            this.jedisPool.returnResource((Object)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveChannel(Channel channel) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            String uaid = channel.getUAID();
            String chid = channel.getChannelId();
            if (jedis.sismember(RedisDataStore.uaidLookupKey(uaid), chid).booleanValue()) {
                boolean bl = false;
                return bl;
            }
            String endpointToken = channel.getEndpointToken();
            Transaction tx = jedis.multi();
            tx.set(endpointToken, Long.toString(channel.getVersion()));
            tx.set(RedisDataStore.tokenLookupKey(endpointToken), chid);
            tx.hmset(RedisDataStore.chidLookupKey(chid), this.mapOf(endpointToken, uaid));
            tx.sadd(RedisDataStore.uaidLookupKey(uaid), chid);
            tx.exec();
            boolean bl = true;
            return bl;
        }
        finally {
            this.jedisPool.returnResource((Object)jedis);
        }
    }

    private Map<String, String> mapOf(String endpointToken, String uaid) {
        HashMap<String, String> map = new HashMap<String, String>(2);
        map.put(TOKEN_KEY, endpointToken);
        map.put(UAID_KEY, uaid);
        return map;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeChannel(String channelId) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Channel channel = this.getChannel(channelId);
            String endpointToken = channel.getEndpointToken();
            Transaction tx = jedis.multi();
            tx.del(new String[]{endpointToken});
            tx.del(new String[]{RedisDataStore.chidLookupKey(channelId)});
            tx.del(new String[]{RedisDataStore.tokenLookupKey(endpointToken)});
            tx.srem(RedisDataStore.uaidLookupKey(channel.getUAID()), channelId);
            tx.exec();
        }
        catch (ChannelNotFoundException e) {
            this.logger.debug("ChannelId [" + channelId + "] was not found");
        }
        finally {
            this.jedisPool.returnResource((Object)jedis);
        }
    }

    public void removeChannels(Set<String> channelIds) {
        for (String channelId : channelIds) {
            this.removeChannel(channelId);
        }
    }

    public Channel getChannel(String channelId) throws ChannelNotFoundException {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            List endpointTokenAndUaid = jedis.hmget(RedisDataStore.chidLookupKey(channelId), new String[]{TOKEN_KEY, UAID_KEY});
            if (!endpointTokenAndUaid.isEmpty()) {
                String endpointToken = (String)endpointTokenAndUaid.get(0);
                String uaid = (String)endpointTokenAndUaid.get(1);
                if (endpointToken == null || uaid == null) {
                    throw RedisDataStore.channelNotFoundException(channelId);
                }
                DefaultChannel defaultChannel = new DefaultChannel(uaid, channelId, Long.valueOf(jedis.get(endpointToken)).longValue(), endpointToken);
                return defaultChannel;
            }
            throw RedisDataStore.channelNotFoundException(channelId);
        }
        finally {
            this.jedisPool.returnResource((Object)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<String> getChannelIds(String uaid) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Set set = jedis.smembers(RedisDataStore.uaidLookupKey(uaid));
            return set;
        }
        finally {
            this.jedisPool.returnResource((Object)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeChannels(String uaid) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            for (String channelId : this.getChannelIds(uaid)) {
                this.removeChannel(channelId);
            }
            jedis.del(new String[]{RedisDataStore.uaidLookupKey(uaid)});
        }
        finally {
            this.jedisPool.returnResource((Object)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String updateVersion(String endpointToken, long newVersion) throws VersionException, ChannelNotFoundException {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            jedis.watch(new String[]{endpointToken});
            String versionString = jedis.get(endpointToken);
            if (versionString == null) {
                throw RedisDataStore.channelNotFoundException(endpointToken);
            }
            long currentVersion = Long.valueOf(versionString);
            if (newVersion <= currentVersion) {
                throw new VersionException("version [" + newVersion + "] must be greater than the current version [" + currentVersion + "]");
            }
            Transaction tx = jedis.multi();
            tx.set(endpointToken, String.valueOf(newVersion));
            tx.exec();
            this.logger.debug(RedisDataStore.tokenLookupKey(endpointToken));
            String string = jedis.get(RedisDataStore.tokenLookupKey(endpointToken));
            return string;
        }
        finally {
            this.jedisPool.returnResource((Object)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String saveUnacknowledged(String channelId, long version) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            jedis.set(RedisDataStore.ackLookupKey(channelId), Long.toString(version));
            List hashValues = jedis.hmget(RedisDataStore.chidLookupKey(channelId), new String[]{UAID_KEY});
            String uaid = (String)hashValues.get(0);
            jedis.sadd(RedisDataStore.acksLookupKey(uaid), channelId);
            String string = uaid;
            return string;
        }
        finally {
            this.jedisPool.returnResource((Object)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Ack> getUnacknowledged(String uaid) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            Set unacks = jedis.smembers(RedisDataStore.acksLookupKey(uaid));
            if (unacks.isEmpty()) {
                Set<Ack> set = Collections.emptySet();
                return set;
            }
            HashSet<Ack> acks = new HashSet<Ack>(unacks.size());
            for (String channelId : unacks) {
                acks.add((Ack)new AckImpl(channelId, Long.valueOf(jedis.get(RedisDataStore.ackLookupKey(channelId))).longValue()));
            }
            HashSet<Ack> hashSet = acks;
            return hashSet;
        }
        finally {
            this.jedisPool.returnResource((Object)jedis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Ack> removeAcknowledged(String uaid, Set<Ack> acks) {
        Jedis jedis = (Jedis)this.jedisPool.getResource();
        try {
            for (Ack ack : acks) {
                jedis.del(new String[]{RedisDataStore.ackLookupKey(ack.getChannelId())});
                jedis.srem(RedisDataStore.acksLookupKey(uaid), ack.getChannelId());
            }
            Set<Ack> set = this.getUnacknowledged(uaid);
            return set;
        }
        finally {
            this.jedisPool.returnResource((Object)jedis);
        }
    }

    private static String chidLookupKey(String channelId) {
        return CHID_LOOKUP_KEY_PREFIX + channelId;
    }

    private static String tokenLookupKey(String endpointToken) {
        return TOKEN_LOOKUP_KEY_PREFIX + endpointToken;
    }

    private static String uaidLookupKey(String uaid) {
        return UAID_LOOKUP_KEY_PREFIX + uaid;
    }

    private static String ackLookupKey(String channelId) {
        return ACK_LOOKUP_KEY_PREFIX + channelId;
    }

    private static String acksLookupKey(String uaid) {
        return ACKS_LOOKUP_KEY_PREFIX + uaid;
    }

    private static ChannelNotFoundException channelNotFoundException(String channelId) {
        return new ChannelNotFoundException("Could not find channel [" + channelId + "]", channelId);
    }
}

