/*
 * Decompiled with CFR 0.152.
 */
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Arrays;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.jboss.aerogear.simplepush.MessageListener;
import org.jboss.aerogear.simplepush.RegistrationListener;
import org.jboss.aerogear.simplepush.SimplePushClient;
import org.jboss.aerogear.simplepush.protocol.Ack;
import org.jboss.aerogear.unifiedpush.PushConfig;
import org.jboss.aerogear.unifiedpush.UnifiedPushClient;

public class Usage {
    private static JFrame frame = new JFrame("HelloWorldSwing");
    private static SimplePushClient client;
    private static UnifiedPushClient unifiedPushClient;

    public static void main(String ... args) {
        unifiedPushClient = new UnifiedPushClient("http://localhost:8080/ag-push/rest/registry/device", "4f766e2c-b4da-42f5-8bfb-d7adc4030939", "c9af3659-e7ce-4861-bcde-22b4b8b29492");
        client = new SimplePushClient("ws://localhost:7777/simplepush/websocket");
        client.connect();
        client.register(new RegistrationListener(){

            @Override
            public void onRegistered(String channelId, String simplePushEndPoint) {
                PushConfig config = new PushConfig();
                config.setDeviceToken(channelId);
                config.setSimplePushEndpoint(simplePushEndPoint);
                config.setAlias("john");
                config.setCategories(Arrays.asList("lead"));
                unifiedPushClient.register(config);
            }
        });
        client.addMessageListener(new MessageListener(){

            @Override
            public void onMessage(Ack ack) {
                JOptionPane.showMessageDialog(frame, "Message received for " + ack);
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Usage.createAndShowGUI();
            }
        });
    }

    private static void createAndShowGUI() {
        frame.setDefaultCloseOperation(3);
        frame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                String channelId = client.getChannelId(0);
                unifiedPushClient.unRegister(channelId);
                client.unregister(channelId);
            }
        });
        JLabel panel = new JLabel();
        panel.setIcon(new ImageIcon(Usage.class.getResource("/logo.jpeg")));
        frame.add(panel);
        frame.setSize(400, 200);
        frame.setVisible(true);
    }
}

