/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.simplepush;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.List;
import net.wessendorf.websocket.SimpleWebSocketClient;
import net.wessendorf.websocket.WebSocketHandlerAdapter;
import org.jboss.aerogear.simplepush.MessageListener;
import org.jboss.aerogear.simplepush.RegistrationListener;
import org.jboss.aerogear.simplepush.protocol.Ack;
import org.jboss.aerogear.simplepush.protocol.MessageType;
import org.jboss.aerogear.simplepush.protocol.impl.HelloMessageImpl;
import org.jboss.aerogear.simplepush.protocol.impl.NotificationMessageImpl;
import org.jboss.aerogear.simplepush.protocol.impl.RegisterMessageImpl;
import org.jboss.aerogear.simplepush.protocol.impl.RegisterResponseImpl;
import org.jboss.aerogear.simplepush.protocol.impl.UnregisterMessageImpl;
import org.jboss.aerogear.simplepush.protocol.impl.json.JsonUtil;
import org.jboss.aerogear.simplepush.util.UUIDUtil;

public class SimplePushClient {
    private final SimpleWebSocketClient websocketClient;
    private RegistrationListener registrationListener;
    private MessageListener listener;
    private List<String> registeredChannels = new ArrayList<String>();

    public SimplePushClient(String simplePushServerURL) {
        try {
            this.websocketClient = new SimpleWebSocketClient(simplePushServerURL);
            this.websocketClient.setWebSocketHandler(new WebSocketHandlerAdapter(){

                @Override
                public void onOpen() {
                }

                @Override
                public void onMessage(String message) {
                    MessageType messageType = JsonUtil.parseFrame(message);
                    switch (messageType.getMessageType()) {
                        case REGISTER: {
                            RegisterResponseImpl registerResponse = JsonUtil.fromJson(message, RegisterResponseImpl.class);
                            if (SimplePushClient.this.registrationListener == null) break;
                            SimplePushClient.this.registrationListener.onRegistered(registerResponse.getChannelId(), registerResponse.getPushEndpoint());
                            break;
                        }
                        case NOTIFICATION: {
                            NotificationMessageImpl notificationMessage = JsonUtil.fromJson(message, NotificationMessageImpl.class);
                            for (Ack ack : notificationMessage.getAcks()) {
                                SimplePushClient.this.websocketClient.sendText(JsonUtil.toJson(ack));
                                SimplePushClient.this.listener.onMessage(ack);
                            }
                            break;
                        }
                        case UNREGISTER: {
                            UnregisterMessageImpl unregisterMessage = JsonUtil.fromJson(message, UnregisterMessageImpl.class);
                            SimplePushClient.this.registeredChannels.remove(unregisterMessage.getChannelId());
                        }
                    }
                }
            });
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("simplePushServerURL is an invalid URL");
        }
    }

    public void connect() {
        this.websocketClient.connect();
        HelloMessageImpl helloMessage = new HelloMessageImpl(UUIDUtil.newUAID());
        this.websocketClient.sendText(JsonUtil.toJson(helloMessage));
    }

    public String getChannelId(int index) {
        return this.registeredChannels.get(index);
    }

    public void register(RegistrationListener registrationListener) {
        this.registrationListener = registrationListener;
        String channelID = UUIDUtil.newUAID();
        this.registeredChannels.add(channelID);
        String register = JsonUtil.toJson(new RegisterMessageImpl(channelID));
        this.websocketClient.sendText(register);
    }

    public void unregister(String channelId) {
        UnregisterMessageImpl unregisterMessage = new UnregisterMessageImpl(channelId);
        this.websocketClient.sendText(JsonUtil.toJson(unregisterMessage));
    }

    public void close() {
        this.websocketClient.close();
    }

    public void addMessageListener(MessageListener listener) {
        this.listener = listener;
    }

    public SimpleWebSocketClient getWebsocketClient() {
        return this.websocketClient;
    }
}

