/*
 * Decompiled with CFR 0.152.
 */
package net.wessendorf.websocket;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.CloseReason;
import javax.websocket.ContainerProvider;
import javax.websocket.Endpoint;
import javax.websocket.EndpointConfig;
import javax.websocket.MessageHandler;
import javax.websocket.RemoteEndpoint;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import net.wessendorf.websocket.ReadyState;
import net.wessendorf.websocket.WebSocketHandler;
import net.wessendorf.websocket.WebSocketHandlerAdapter;
import net.wessendorf.websocket.WebSocketUtil;

public class SimpleWebSocketClient {
    private final URI websocketURI;
    private final WebSocketContainer container = ContainerProvider.getWebSocketContainer();
    private ReadyState readyState = ReadyState.CLOSED;
    private Session webSocketSession;
    private WebSocketHandler webSocketHandler;

    public ReadyState getReadyState() {
        return this.readyState;
    }

    public void setWebSocketHandler(WebSocketHandler webSocketHandler) {
        this.webSocketHandler = webSocketHandler;
    }

    public SimpleWebSocketClient(URI websocketURI) throws URISyntaxException {
        this.websocketURI = WebSocketUtil.applyDefaultPorts(websocketURI);
    }

    public SimpleWebSocketClient(String websocketURI) throws URISyntaxException {
        this(new URI(websocketURI));
    }

    public void connect() {
        this.readyState = ReadyState.CONNECTING;
        try {
            if (this.webSocketHandler == null) {
                this.webSocketHandler = new WebSocketHandlerAdapter();
            }
            this.container.connectToServer(new SimpleWebSocketClientEndpoint(), ClientEndpointConfig.Builder.create().build(), this.websocketURI);
        }
        catch (Exception e) {
            this.readyState = ReadyState.CLOSED;
            throw new RuntimeException("could not establish connection");
        }
    }

    public void close() {
        this.readyState = ReadyState.CLOSING;
        try {
            this.webSocketSession.close(new CloseReason(CloseReason.CloseCodes.NORMAL_CLOSURE, null));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void sendText(String payload) {
        this.getRemote().sendText(payload);
    }

    public void sendBinary(ByteBuffer payload) {
        this.getRemote().sendBinary(payload);
    }

    public URI getWebsocketURI() {
        return this.websocketURI;
    }

    private RemoteEndpoint.Async getRemote() {
        return this.webSocketSession.getAsyncRemote();
    }

    private class SimpleWebSocketClientEndpoint
    extends Endpoint {
        private SimpleWebSocketClientEndpoint() {
        }

        @Override
        public void onOpen(Session session, EndpointConfig config) {
            SimpleWebSocketClient.this.readyState = ReadyState.OPEN;
            SimpleWebSocketClient.this.webSocketSession = session;
            SimpleWebSocketClient.this.webSocketHandler.onOpen();
            SimpleWebSocketClient.this.webSocketSession.addMessageHandler(new MessageHandler.Whole<String>(){

                @Override
                public void onMessage(String message) {
                    SimpleWebSocketClient.this.webSocketHandler.onMessage(message);
                }
            });
            SimpleWebSocketClient.this.webSocketSession.addMessageHandler(new MessageHandler.Whole<ByteBuffer>(){

                @Override
                public void onMessage(ByteBuffer message) {
                    SimpleWebSocketClient.this.webSocketHandler.onMessage(message);
                }
            });
        }

        @Override
        public void onClose(Session session, CloseReason closeReason) {
            SimpleWebSocketClient.this.readyState = ReadyState.CLOSED;
            SimpleWebSocketClient.this.webSocketHandler.onClose(closeReason.getCloseCode().getCode(), closeReason.getReasonPhrase());
        }

        @Override
        public void onError(Session session, Throwable throwable) {
            SimpleWebSocketClient.this.readyState = ReadyState.CLOSED;
            throwable.printStackTrace();
            SimpleWebSocketClient.this.webSocketHandler.onError(throwable);
        }
    }
}

