/*
 * Decompiled with CFR 0.152.
 */
package net.wessendorf.websocket;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.Objects;

public final class WebSocketUtil {
    public static final String WS_SCHEME = "ws";
    public static final String WSS_SCHEME = "wss";

    private WebSocketUtil() {
    }

    public static boolean containsWebSocketScheme(URI uri) {
        Objects.requireNonNull(uri, "no URI object given");
        String scheme = uri.getScheme();
        return scheme != null && (scheme.equals(WS_SCHEME) || scheme.equals(WSS_SCHEME));
    }

    public static URI applyDefaultPorts(URI uri) throws URISyntaxException {
        if (WebSocketUtil.containsWebSocketScheme(uri)) {
            if (uri.getPort() == -1) {
                if (WS_SCHEME.equals(uri.getScheme())) {
                    return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), 80, uri.getPath(), uri.getQuery(), uri.getFragment());
                }
                return new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), 443, uri.getPath(), uri.getQuery(), uri.getFragment());
            }
            return uri;
        }
        throw new IllegalArgumentException("Can not apply WebSocket ports to invalid URI scheme");
    }
}

