/*
 * Decompiled with CFR 0.152.
 */
package org.glassfish.tyrus.client;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.websocket.ClientEndpointConfig;
import javax.websocket.CloseReason;
import javax.websocket.Extension;
import javax.websocket.Session;
import org.glassfish.tyrus.client.RedirectException;
import org.glassfish.tyrus.client.auth.AuthConfig;
import org.glassfish.tyrus.client.auth.AuthenticationException;
import org.glassfish.tyrus.client.auth.Authenticator;
import org.glassfish.tyrus.client.auth.Credentials;
import org.glassfish.tyrus.core.Handshake;
import org.glassfish.tyrus.core.HandshakeException;
import org.glassfish.tyrus.core.ProtocolHandler;
import org.glassfish.tyrus.core.RequestContext;
import org.glassfish.tyrus.core.TyrusEndpointWrapper;
import org.glassfish.tyrus.core.TyrusExtension;
import org.glassfish.tyrus.core.TyrusWebSocket;
import org.glassfish.tyrus.core.Utils;
import org.glassfish.tyrus.core.Version;
import org.glassfish.tyrus.core.WebSocketException;
import org.glassfish.tyrus.core.extension.ExtendedExtension;
import org.glassfish.tyrus.core.frame.CloseFrame;
import org.glassfish.tyrus.core.frame.Frame;
import org.glassfish.tyrus.core.l10n.LocalizationMessages;
import org.glassfish.tyrus.spi.ClientEngine;
import org.glassfish.tyrus.spi.Connection;
import org.glassfish.tyrus.spi.ReadHandler;
import org.glassfish.tyrus.spi.UpgradeRequest;
import org.glassfish.tyrus.spi.UpgradeResponse;
import org.glassfish.tyrus.spi.Writer;

public class TyrusClientEngine
implements ClientEngine {
    public static final int DEFAULT_INCOMING_BUFFER_SIZE = 0x40000B;
    private static final Logger LOGGER = Logger.getLogger(TyrusClientEngine.class.getName());
    private static final Version DEFAULT_VERSION = Version.DRAFT17;
    private static final int BUFFER_STEP_SIZE = 256;
    private static final int DEFAULT_REDIRECT_THRESHOLD = 5;
    private final ProtocolHandler protocolHandler = DEFAULT_VERSION.createHandler(true);
    private final TyrusEndpointWrapper endpointWrapper;
    private final ClientHandshakeListener listener;
    private final Map<String, Object> properties;
    private final URI connectToServerUriParam;
    private final Boolean redirectEnabled;
    private final int redirectThreshold;
    private volatile Handshake clientHandShake = null;
    private volatile ClientEngine.TimeoutHandler timeoutHandler = null;
    private volatile TyrusClientEngineState clientEngineState = TyrusClientEngineState.INIT;
    private volatile URI redirectLocation = null;
    private final Set<URI> redirectUriHistory;
    private static final ClientEngine.ClientUpgradeInfo UPGRADE_INFO_FAILED = new ClientEngine.ClientUpgradeInfo(){

        @Override
        public ClientEngine.ClientUpgradeStatus getUpgradeStatus() {
            return ClientEngine.ClientUpgradeStatus.UPGRADE_REQUEST_FAILED;
        }

        @Override
        public Connection createConnection() {
            return null;
        }
    };
    private static final ClientEngine.ClientUpgradeInfo UPGRADE_INFO_ANOTHER_REQUEST_REQUIRED = new ClientEngine.ClientUpgradeInfo(){

        @Override
        public ClientEngine.ClientUpgradeStatus getUpgradeStatus() {
            return ClientEngine.ClientUpgradeStatus.ANOTHER_UPGRADE_REQUEST_REQUIRED;
        }

        @Override
        public Connection createConnection() {
            return null;
        }
    };

    TyrusClientEngine(TyrusEndpointWrapper endpointWrapper, ClientHandshakeListener listener, Map<String, Object> properties, URI connectToServerUriParam) {
        this.endpointWrapper = endpointWrapper;
        this.listener = listener;
        this.properties = properties;
        this.connectToServerUriParam = connectToServerUriParam;
        this.redirectUriHistory = Collections.synchronizedSet(new HashSet(5));
        this.redirectEnabled = Utils.getProperty(properties, "org.glassfish.tyrus.client.http.redirect.enabled", Boolean.class, false);
        Integer redirectThreshold = Utils.getProperty(properties, "org.glassfish.tyrus.client.http.redirect.threshold", Integer.class, 5);
        if (redirectThreshold == null) {
            redirectThreshold = 5;
        }
        this.redirectThreshold = redirectThreshold;
    }

    @Override
    public UpgradeRequest createUpgradeRequest(ClientEngine.TimeoutHandler timeoutHandler) {
        switch (this.clientEngineState) {
            case INIT: {
                ClientEndpointConfig config = (ClientEndpointConfig)this.endpointWrapper.getEndpointConfig();
                this.timeoutHandler = timeoutHandler;
                this.clientHandShake = Handshake.createClientHandshake(RequestContext.Builder.create().requestURI(this.connectToServerUriParam).secure("wss".equals(this.connectToServerUriParam.getScheme())).build());
                this.clientHandShake.setExtensions(config.getExtensions());
                this.clientHandShake.setSubProtocols(config.getPreferredSubprotocols());
                this.clientHandShake.prepareRequest();
                RequestContext upgradeRequest = this.clientHandShake.getRequest();
                config.getConfigurator().beforeRequest(upgradeRequest.getHeaders());
                this.clientEngineState = TyrusClientEngineState.UPGRADE_REQUEST_CREATED;
                return upgradeRequest;
            }
            case REDIRECT_REQUIRED: {
                this.timeoutHandler = timeoutHandler;
                URI requestUri = this.redirectLocation;
                RequestContext requestContext = RequestContext.Builder.create(this.clientHandShake.getRequest()).requestURI(requestUri).secure("wss".equalsIgnoreCase(requestUri.getScheme())).build();
                Handshake.updateHostAndOrigin(requestContext);
                this.clientEngineState = TyrusClientEngineState.UPGRADE_REQUEST_CREATED;
                return requestContext;
            }
            case AUTH_REQUIRED: {
                RequestContext upgradeRequest = this.clientHandShake.getRequest();
                if (this.clientEngineState.getAuthenticator() != null) {
                    String authorizationHeader;
                    try {
                        Credentials credentials = (Credentials)this.properties.get("org.glassfish.tyrus.client.http.auth.Credentials");
                        authorizationHeader = this.clientEngineState.getAuthenticator().generateAuthorizationHeader(upgradeRequest.getRequestURI(), this.clientEngineState.getWwwAuthenticateHeader(), credentials);
                    }
                    catch (AuthenticationException e) {
                        this.listener.onError(e);
                        return null;
                    }
                    upgradeRequest.getHeaders().put("Authorization", Collections.singletonList(authorizationHeader));
                }
                this.clientEngineState = TyrusClientEngineState.AUTH_UPGRADE_REQUEST_CREATED;
                return upgradeRequest;
            }
        }
        this.redirectUriHistory.clear();
        throw new IllegalStateException();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ClientEngine.ClientUpgradeInfo processResponse(UpgradeResponse upgradeResponse, Writer writer, Connection.CloseListener closeListener) {
        switch (this.clientEngineState) {
            case AUTH_UPGRADE_REQUEST_CREATED: 
            case UPGRADE_REQUEST_CREATED: {
                if (upgradeResponse == null) {
                    throw new IllegalArgumentException(LocalizationMessages.ARGUMENT_NOT_NULL("upgradeResponse"));
                }
                switch (upgradeResponse.getStatus()) {
                    case 101: {
                        this.clientEngineState = TyrusClientEngineState.SUCCESS;
                        try {
                            ClientEngine.ClientUpgradeInfo clientUpgradeInfo = this.processUpgradeResponse(upgradeResponse, writer, closeListener);
                            return clientUpgradeInfo;
                        }
                        catch (HandshakeException e) {
                            this.clientEngineState = TyrusClientEngineState.FAILED;
                            this.listener.onError(e);
                            ClientEngine.ClientUpgradeInfo clientUpgradeInfo = UPGRADE_INFO_FAILED;
                            return clientUpgradeInfo;
                        }
                        finally {
                            this.redirectUriHistory.clear();
                        }
                    }
                    case 300: 
                    case 301: 
                    case 302: 
                    case 303: 
                    case 307: 
                    case 308: {
                        boolean alreadyRequested;
                        URI location;
                        if (!this.redirectEnabled.booleanValue()) {
                            this.clientEngineState = TyrusClientEngineState.FAILED;
                            this.listener.onError(new RedirectException(upgradeResponse.getStatus(), LocalizationMessages.HANDSHAKE_HTTP_REDIRECTION_NOT_ENABLED(upgradeResponse.getStatus())));
                            return UPGRADE_INFO_FAILED;
                        }
                        String locationString = null;
                        List<String> locationHeader = upgradeResponse.getHeaders().get("Location");
                        if (locationHeader != null) {
                            locationString = Utils.getHeaderFromList(locationHeader);
                        }
                        if (locationString == null || locationString.equals("")) {
                            this.listener.onError(new RedirectException(upgradeResponse.getStatus(), LocalizationMessages.HANDSHAKE_HTTP_REDIRECTION_NEW_LOCATION_MISSING()));
                            this.clientEngineState = TyrusClientEngineState.FAILED;
                            return UPGRADE_INFO_FAILED;
                        }
                        try {
                            location = new URI(locationString);
                            String scheme = location.getScheme();
                            if ("http".equalsIgnoreCase(scheme)) {
                                scheme = "ws";
                            }
                            if ("https".equalsIgnoreCase(scheme)) {
                                scheme = "wss";
                            }
                            int port = Utils.getWsPort(location, scheme);
                            if (!(location = new URI(scheme, location.getUserInfo(), location.getHost(), port, location.getPath(), location.getQuery(), location.getFragment())).isAbsolute()) {
                                URI baseUri = this.redirectLocation == null ? this.connectToServerUriParam : this.redirectLocation;
                                location = baseUri.resolve(location.normalize());
                                if (LOGGER.isLoggable(Level.FINEST)) {
                                    LOGGER.finest("HTTP Redirect - Base URI for resolving target location: " + baseUri);
                                    LOGGER.finest("HTTP Redirect - Location URI header: " + locationString);
                                    LOGGER.finest("HTTP Redirect - Normalized and resolved Location URI header against base URI: " + location);
                                }
                            }
                        }
                        catch (URISyntaxException e) {
                            this.clientEngineState = TyrusClientEngineState.FAILED;
                            this.listener.onError(new RedirectException(upgradeResponse.getStatus(), LocalizationMessages.HANDSHAKE_HTTP_REDIRECTION_NEW_LOCATION_ERROR(locationString)));
                            return UPGRADE_INFO_FAILED;
                        }
                        boolean bl = alreadyRequested = !this.redirectUriHistory.add(location);
                        if (alreadyRequested) {
                            this.clientEngineState = TyrusClientEngineState.FAILED;
                            this.listener.onError(new RedirectException(upgradeResponse.getStatus(), LocalizationMessages.HANDSHAKE_HTTP_REDIRECTION_INFINITE_LOOP()));
                            return UPGRADE_INFO_FAILED;
                        }
                        if (this.redirectUriHistory.size() > this.redirectThreshold) {
                            this.clientEngineState = TyrusClientEngineState.FAILED;
                            this.listener.onError(new RedirectException(upgradeResponse.getStatus(), LocalizationMessages.HANDSHAKE_HTTP_REDIRECTION_MAX_REDIRECTION(this.redirectThreshold)));
                            return UPGRADE_INFO_FAILED;
                        }
                        this.clientEngineState = TyrusClientEngineState.REDIRECT_REQUIRED;
                        this.redirectLocation = location;
                        return UPGRADE_INFO_ANOTHER_REQUEST_REQUIRED;
                    }
                    case 401: {
                        if (this.clientEngineState == TyrusClientEngineState.AUTH_UPGRADE_REQUEST_CREATED) {
                            this.clientEngineState = TyrusClientEngineState.FAILED;
                            this.listener.onError(new AuthenticationException(LocalizationMessages.AUTHENTICATION_FAILED()));
                            return UPGRADE_INFO_FAILED;
                        }
                        AuthConfig authConfig = Utils.getProperty(this.properties, "org.glassfish.tyrus.client.http.auth.AuthConfig", AuthConfig.class, AuthConfig.Builder.create().build());
                        if (authConfig == null) {
                            this.clientEngineState = TyrusClientEngineState.FAILED;
                            this.listener.onError(new AuthenticationException(LocalizationMessages.AUTHENTICATION_FAILED()));
                            return UPGRADE_INFO_FAILED;
                        }
                        String wwwAuthenticateHeader = null;
                        List<String> authHeader = upgradeResponse.getHeaders().get("WWW-Authenticate");
                        if (authHeader != null) {
                            wwwAuthenticateHeader = Utils.getHeaderFromList(authHeader);
                        }
                        if (wwwAuthenticateHeader == null || wwwAuthenticateHeader.equals("")) {
                            this.clientEngineState = TyrusClientEngineState.FAILED;
                            this.listener.onError(new AuthenticationException(LocalizationMessages.AUTHENTICATION_FAILED()));
                            return UPGRADE_INFO_FAILED;
                        }
                        String[] tokens = wwwAuthenticateHeader.trim().split("\\s+", 2);
                        String scheme = tokens[0];
                        Authenticator authenticator = authConfig.getAuthenticators().get(scheme);
                        if (authenticator == null) {
                            this.clientEngineState = TyrusClientEngineState.FAILED;
                            this.listener.onError(new AuthenticationException(LocalizationMessages.AUTHENTICATION_FAILED()));
                            return UPGRADE_INFO_FAILED;
                        }
                        this.clientEngineState = TyrusClientEngineState.AUTH_REQUIRED;
                        this.clientEngineState.setAuthenticator(authenticator);
                        this.clientEngineState.setWwwAuthenticateHeader(wwwAuthenticateHeader);
                        return UPGRADE_INFO_ANOTHER_REQUEST_REQUIRED;
                    }
                }
                this.clientEngineState = TyrusClientEngineState.FAILED;
                HandshakeException e = new HandshakeException(upgradeResponse.getStatus(), LocalizationMessages.INVALID_RESPONSE_CODE(101, upgradeResponse.getStatus()));
                this.listener.onError(e);
                this.redirectUriHistory.clear();
                return UPGRADE_INFO_FAILED;
            }
        }
        this.redirectUriHistory.clear();
        throw new IllegalStateException();
    }

    @Override
    public void processError(Throwable t) {
        if (this.clientEngineState == TyrusClientEngineState.SUCCESS) {
            throw new IllegalStateException();
        }
        if (this.clientEngineState != TyrusClientEngineState.FAILED) {
            this.clientEngineState = TyrusClientEngineState.FAILED;
            this.listener.onError(t);
        }
    }

    private ClientEngine.ClientUpgradeInfo processUpgradeResponse(UpgradeResponse upgradeResponse, final Writer writer, final Connection.CloseListener closeListener) throws HandshakeException {
        this.clientHandShake.validateServerResponse(upgradeResponse);
        final TyrusWebSocket socket = new TyrusWebSocket(this.protocolHandler, this.endpointWrapper);
        List<Extension> handshakeResponseExtensions = TyrusExtension.fromHeaders(upgradeResponse.getHeaders().get("Sec-WebSocket-Extensions"));
        ArrayList<Extension> extensions = new ArrayList<Extension>();
        final ExtendedExtension.ExtensionContext extensionContext = new ExtendedExtension.ExtensionContext(){
            private final Map<String, Object> properties = new HashMap<String, Object>();

            @Override
            public Map<String, Object> getProperties() {
                return this.properties;
            }
        };
        for (Extension responseExtension : handshakeResponseExtensions) {
            for (Extension installedExtension : ((ClientEndpointConfig)this.endpointWrapper.getEndpointConfig()).getExtensions()) {
                if (responseExtension.getName() == null || !responseExtension.getName().equals(installedExtension.getName())) continue;
                if (installedExtension instanceof ExtendedExtension) {
                    ((ExtendedExtension)installedExtension).onHandshakeResponse(extensionContext, responseExtension.getParameters());
                }
                extensions.add(installedExtension);
            }
        }
        final Session sessionForRemoteEndpoint = this.endpointWrapper.createSessionForRemoteEndpoint(socket, upgradeResponse.getFirstHeaderValue("Sec-WebSocket-Protocol"), extensions);
        ((ClientEndpointConfig)this.endpointWrapper.getEndpointConfig()).getConfigurator().afterResponse(upgradeResponse);
        this.protocolHandler.setWriter(writer);
        this.protocolHandler.setWebSocket(socket);
        this.protocolHandler.setExtensions(extensions);
        this.protocolHandler.setExtensionContext(extensionContext);
        socket.onConnect(this.clientHandShake.getRequest(), null, null, null);
        this.listener.onSessionCreated(sessionForRemoteEndpoint);
        Integer tyrusIncomingBufferSize = Utils.getProperty(this.properties, "org.glassfish.tyrus.incomingBufferSize", Integer.class);
        Integer wlsIncomingBufferSize = Utils.getProperty(this.endpointWrapper.getEndpointConfig().getUserProperties(), "weblogic.websocket.tyrus.incoming-buffer-size", Integer.class);
        final Integer incomingBufferSize = tyrusIncomingBufferSize == null && wlsIncomingBufferSize == null ? Integer.valueOf(0x40000B) : (wlsIncomingBufferSize != null ? wlsIncomingBufferSize : tyrusIncomingBufferSize);
        return new ClientEngine.ClientUpgradeInfo(){

            @Override
            public ClientEngine.ClientUpgradeStatus getUpgradeStatus() {
                return ClientEngine.ClientUpgradeStatus.SUCCESS;
            }

            @Override
            public Connection createConnection() {
                return new Connection(){
                    private final ReadHandler readHandler;
                    {
                        this.readHandler = new TyrusReadHandler(TyrusClientEngine.this.protocolHandler, socket, incomingBufferSize, sessionForRemoteEndpoint.getNegotiatedExtensions(), extensionContext);
                    }

                    @Override
                    public ReadHandler getReadHandler() {
                        return this.readHandler;
                    }

                    @Override
                    public Writer getWriter() {
                        return writer;
                    }

                    @Override
                    public Connection.CloseListener getCloseListener() {
                        return closeListener;
                    }

                    @Override
                    public void close(CloseReason reason) {
                        try {
                            writer.close();
                        }
                        catch (IOException e) {
                            Logger.getLogger(this.getClass().getName()).log(Level.WARNING, e.getMessage(), e);
                        }
                        socket.close(reason.getCloseCode().getCode(), reason.getReasonPhrase());
                        for (Extension extension : sessionForRemoteEndpoint.getNegotiatedExtensions()) {
                            if (!(extension instanceof ExtendedExtension)) continue;
                            ((ExtendedExtension)extension).destroy(extensionContext);
                        }
                    }
                };
            }
        };
    }

    public ClientEngine.TimeoutHandler getTimeoutHandler() {
        return this.timeoutHandler;
    }

    private static enum TyrusClientEngineState {
        INIT,
        REDIRECT_REQUIRED,
        AUTH_REQUIRED,
        AUTH_UPGRADE_REQUEST_CREATED,
        UPGRADE_REQUEST_CREATED,
        FAILED,
        SUCCESS;

        private volatile Authenticator authenticator;
        private volatile String wwwAuthenticateHeader;

        Authenticator getAuthenticator() {
            return this.authenticator;
        }

        void setAuthenticator(Authenticator authenticator) {
            this.authenticator = authenticator;
        }

        String getWwwAuthenticateHeader() {
            return this.wwwAuthenticateHeader;
        }

        void setWwwAuthenticateHeader(String wwwAuthenticateHeader) {
            this.wwwAuthenticateHeader = wwwAuthenticateHeader;
        }
    }

    private static class TyrusReadHandler
    implements ReadHandler {
        private final int incomingBufferSize;
        private final ProtocolHandler handler;
        private final TyrusWebSocket socket;
        private final List<Extension> negotiatedExtensions;
        private final ExtendedExtension.ExtensionContext extensionContext;
        private ByteBuffer buffer = null;

        TyrusReadHandler(ProtocolHandler protocolHandler, TyrusWebSocket socket, int incomingBufferSize, List<Extension> negotiatedExtensions, ExtendedExtension.ExtensionContext extensionContext) {
            this.handler = protocolHandler;
            this.socket = socket;
            this.incomingBufferSize = incomingBufferSize;
            this.negotiatedExtensions = negotiatedExtensions;
            this.extensionContext = extensionContext;
            protocolHandler.setExtensionContext(extensionContext);
        }

        @Override
        public void handle(ByteBuffer data) {
            block11: {
                try {
                    if (data == null || !data.hasRemaining()) break block11;
                    if (this.buffer != null) {
                        data = Utils.appendBuffers(this.buffer, data, this.incomingBufferSize, 256);
                    } else {
                        int newSize = data.remaining();
                        if (newSize > this.incomingBufferSize) {
                            throw new IllegalArgumentException("Buffer overflow.");
                        }
                        int roundedSize = newSize % 256 > 0 ? (newSize / 256 + 1) * 256 : newSize;
                        ByteBuffer result = ByteBuffer.allocate(roundedSize > this.incomingBufferSize ? newSize : roundedSize);
                        result.flip();
                        data = Utils.appendBuffers(result, data, this.incomingBufferSize, 256);
                    }
                    while (true) {
                        Frame frame;
                        if ((frame = this.handler.unframe(data)) == null) {
                            this.buffer = data;
                            break;
                        }
                        for (Extension extension : this.negotiatedExtensions) {
                            if (!(extension instanceof ExtendedExtension)) continue;
                            try {
                                frame = ((ExtendedExtension)extension).processIncoming(this.extensionContext, frame);
                            }
                            catch (Throwable t) {
                                LOGGER.log(Level.FINE, String.format("Extension '%s' threw an exception during processIncoming method invocation: \"%s\".", extension.getName(), t.getMessage()), t);
                            }
                        }
                        this.handler.process(frame, this.socket);
                    }
                }
                catch (WebSocketException e) {
                    LOGGER.log(Level.FINE, e.getMessage(), e);
                    this.socket.onClose(new CloseFrame(e.getCloseReason()));
                }
                catch (Exception e) {
                    LOGGER.log(Level.FINE, e.getMessage(), e);
                    this.socket.onClose(new CloseFrame(new CloseReason(CloseReason.CloseCodes.UNEXPECTED_CONDITION, e.getMessage())));
                }
            }
        }
    }

    public static interface ClientHandshakeListener {
        public void onSessionCreated(Session var1);

        public void onError(Throwable var1);
    }
}

