/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.HttpURLConnection;
import java.net.URL;
import net.iharder.Base64;
import org.jboss.aerogear.simplepush.protocol.impl.json.JsonUtil;
import org.jboss.aerogear.unifiedpush.PushConfig;

public class UnifiedPushClient {
    private static final String UTF_8 = "UTF-8";
    private final String variantId;
    private final String variantSecret;
    private final String pushServerURL;

    public UnifiedPushClient(String pushServerURL, String variantId, String variantSecret) {
        this.pushServerURL = pushServerURL;
        this.variantId = variantId;
        this.variantSecret = variantSecret;
    }

    public void register(PushConfig config) {
        try {
            byte[] configJson = JsonUtil.toJson(config).getBytes(UTF_8);
            this.post(this.getCredentials(), configJson);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private String getCredentials() throws UnsupportedEncodingException {
        return Base64.encodeBytes((this.variantId + ":" + this.variantSecret).getBytes(UTF_8));
    }

    public void unRegister(String channelId) {
        try {
            this.delete(this.getCredentials(), channelId);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
    }

    private void delete(String credentials, String id) {
        this.send("DELETE", credentials, null, this.pushServerURL + "/" + id);
    }

    private void post(String credentials, byte[] bytes) {
        this.send("POST", credentials, bytes, this.pushServerURL);
    }

    void send(String method, String credentials, byte[] body, String url) {
        block19: {
            HttpURLConnection conn = null;
            try {
                conn = (HttpURLConnection)new URL(url).openConnection();
                conn.setDoOutput(true);
                conn.setUseCaches(false);
                conn.setRequestProperty("Authorization", "Basic " + credentials);
                conn.setRequestProperty("Content-Type", "application/json");
                conn.setRequestProperty("Accept", "application/json");
                conn.setRequestMethod(method);
                if (body != null) {
                    conn.setFixedLengthStreamingMode(body.length);
                    try (BufferedOutputStream out = new BufferedOutputStream(conn.getOutputStream());){
                        ((OutputStream)out).write(body);
                        break block19;
                    }
                }
                conn.connect();
            }
            catch (IOException e) {
                throw new RuntimeException("could not register simple end point with unified push server", e);
            }
            finally {
                if (conn != null) {
                    conn.disconnect();
                }
            }
        }
    }
}

