/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.simplepush.server.netty;

import io.netty.channel.Channel;
import java.util.Iterator;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.SockJsSessionContext;
import org.jboss.aerogear.simplepush.server.SimplePushServer;
import org.jboss.aerogear.simplepush.server.netty.UserAgent;
import org.jboss.aerogear.simplepush.server.netty.UserAgents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserAgentReaper
implements Runnable {
    private final Logger logger = LoggerFactory.getLogger(UserAgentReaper.class);
    private final SimplePushServer simplePushServer;
    private final UserAgents userAgents = UserAgents.getInstance();

    public UserAgentReaper(SimplePushServer simplePushServer) {
        this.simplePushServer = simplePushServer;
    }

    @Override
    public void run() {
        this.logger.info("Running reaper at interval of " + this.simplePushServer.config().userAgentReaperTimeout());
        Iterator<UserAgent<SockJsSessionContext>> it = this.userAgents.all().iterator();
        while (it.hasNext()) {
            UserAgent<SockJsSessionContext> userAgent = it.next();
            long now = System.currentTimeMillis();
            if (!this.isChannelInactive(userAgent) || userAgent.timestamp() + this.simplePushServer.config().userAgentReaperTimeout() >= now) continue;
            this.logger.info("Removing inactive UserAgent [" + userAgent.uaid() + "]");
            it.remove();
            this.simplePushServer.removeAllChannels(userAgent.uaid());
            userAgent.context().close();
        }
    }

    private boolean isChannelInactive(UserAgent<SockJsSessionContext> userAgent) {
        Channel ch = userAgent.context().getConnectionContext().channel();
        return !ch.isActive() && !ch.isRegistered();
    }
}

