/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.simplepush.server.netty;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.FullHttpRequest;
import io.netty.handler.codec.http.HttpHeaders;
import io.netty.handler.codec.http.HttpMethod;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.CharsetUtil;
import io.netty.util.ReferenceCountUtil;
import io.netty.util.concurrent.GenericFutureListener;
import java.nio.charset.Charset;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.SockJsSessionContext;
import org.jboss.aerogear.simplepush.protocol.impl.NotificationMessageImpl;
import org.jboss.aerogear.simplepush.protocol.impl.json.JsonUtil;
import org.jboss.aerogear.simplepush.server.Notification;
import org.jboss.aerogear.simplepush.server.SimplePushServer;
import org.jboss.aerogear.simplepush.server.datastore.ChannelNotFoundException;
import org.jboss.aerogear.simplepush.server.datastore.VersionException;
import org.jboss.aerogear.simplepush.server.netty.UserAgents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NotificationHandler
extends SimpleChannelInboundHandler<Object> {
    private final UserAgents userAgents = UserAgents.getInstance();
    private final Logger logger = LoggerFactory.getLogger(NotificationHandler.class);
    private final SimplePushServer simplePushServer;
    private final ExecutorService executorServer;

    public NotificationHandler(SimplePushServer simplePushServer) {
        this.simplePushServer = simplePushServer;
        this.executorServer = Executors.newFixedThreadPool(simplePushServer.config().notifierMaxThreads());
    }

    public void messageReceived(ChannelHandlerContext ctx, Object msg) throws Exception {
        if (msg instanceof FullHttpRequest) {
            FullHttpRequest request = (FullHttpRequest)msg;
            String requestUri = request.getUri();
            this.logger.debug(requestUri);
            if (requestUri.startsWith(this.simplePushServer.config().endpointPrefix())) {
                this.handleHttpRequest(ctx, request);
            } else {
                ctx.fireChannelRead(ReferenceCountUtil.retain((Object)msg));
            }
        } else {
            ctx.fireChannelRead(ReferenceCountUtil.retain((Object)msg));
        }
    }

    private void handleHttpRequest(ChannelHandlerContext ctx, FullHttpRequest req) throws Exception {
        if (this.isHttpRequestValid(req, ctx.channel())) {
            this.executorServer.submit(new Notifier(req.getUri(), req.content()));
            this.sendHttpResponse(HttpResponseStatus.OK, req, ctx.channel());
        }
    }

    private boolean isHttpRequestValid(FullHttpRequest request, Channel channel) {
        if (!request.getDecoderResult().isSuccess()) {
            this.sendHttpResponse(HttpResponseStatus.BAD_REQUEST, request, channel);
            return false;
        }
        if (request.getMethod() != HttpMethod.PUT && request.getMethod() != HttpMethod.GET) {
            this.sendHttpResponse(HttpResponseStatus.FORBIDDEN, request, channel);
            return false;
        }
        return true;
    }

    private void sendHttpResponse(HttpResponseStatus status, FullHttpRequest request, Channel channel) {
        ByteBuf content = Unpooled.copiedBuffer((CharSequence)status.reasonPhrase(), (Charset)CharsetUtil.UTF_8);
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, status, content);
        response.headers().set(HttpHeaders.Names.CONTENT_LENGTH, (Object)content.readableBytes());
        response.headers().set(HttpHeaders.Names.CONTENT_TYPE, (Object)"text/html; charset=UTF-8");
        channel.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
    }

    private class Notifier
    implements Callable<Void> {
        private final String endpoint;
        private final ByteBuf payload;

        private Notifier(String requestUri, ByteBuf payload) {
            this.endpoint = requestUri.substring(requestUri.lastIndexOf(47) + 1);
            this.payload = payload;
            this.payload.retain();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void call() throws Exception {
            try {
                Notification notification = NotificationHandler.this.simplePushServer.handleNotification(this.endpoint, this.payload.toString(CharsetUtil.UTF_8));
                String uaid = notification.uaid();
                SockJsSessionContext session = NotificationHandler.this.userAgents.get(uaid).context();
                if (NotificationHandler.this.logger.isDebugEnabled()) {
                    NotificationHandler.this.logger.debug("Sending notification for UAID [ " + notification.uaid() + "] " + JsonUtil.toJson((Object)new NotificationMessageImpl(notification.ack())));
                }
                session.send(JsonUtil.toJson((Object)new NotificationMessageImpl(notification.ack())));
                NotificationHandler.this.userAgents.updateAccessedTime(uaid);
            }
            catch (ChannelNotFoundException e) {
                NotificationHandler.this.logger.debug("Could not find channel for [" + this.endpoint + "]");
            }
            catch (VersionException e) {
                NotificationHandler.this.logger.debug(e.getMessage());
            }
            finally {
                this.payload.release();
            }
            return null;
        }
    }
}

