/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.simplepush.server.netty;

import io.netty.util.concurrent.ScheduledFuture;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.SockJsConfig;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.SockJsService;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.SockJsSessionContext;
import org.jboss.aerogear.simplepush.protocol.AckMessage;
import org.jboss.aerogear.simplepush.protocol.HelloMessage;
import org.jboss.aerogear.simplepush.protocol.HelloResponse;
import org.jboss.aerogear.simplepush.protocol.MessageType;
import org.jboss.aerogear.simplepush.protocol.RegisterMessage;
import org.jboss.aerogear.simplepush.protocol.RegisterResponse;
import org.jboss.aerogear.simplepush.protocol.UnregisterMessage;
import org.jboss.aerogear.simplepush.protocol.UnregisterResponse;
import org.jboss.aerogear.simplepush.protocol.impl.AckMessageImpl;
import org.jboss.aerogear.simplepush.protocol.impl.HelloMessageImpl;
import org.jboss.aerogear.simplepush.protocol.impl.NotificationMessageImpl;
import org.jboss.aerogear.simplepush.protocol.impl.PingMessageImpl;
import org.jboss.aerogear.simplepush.protocol.impl.RegisterMessageImpl;
import org.jboss.aerogear.simplepush.protocol.impl.UnregisterMessageImpl;
import org.jboss.aerogear.simplepush.protocol.impl.json.JsonUtil;
import org.jboss.aerogear.simplepush.server.SimplePushServer;
import org.jboss.aerogear.simplepush.server.netty.UserAgents;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimplePushSockJSService
implements SockJsService {
    private final Logger logger = LoggerFactory.getLogger(SimplePushSockJSService.class);
    private final UserAgents userAgents = UserAgents.getInstance();
    private final SockJsConfig sockjsConfig;
    private final SimplePushServer simplePushServer;
    private String uaid;
    private SockJsSessionContext session;
    private ScheduledFuture<?> ackJobFuture;

    public SimplePushSockJSService(SockJsConfig sockjsConfig, SimplePushServer simplePushServer) {
        this.sockjsConfig = sockjsConfig;
        this.simplePushServer = simplePushServer;
    }

    public SockJsConfig config() {
        return this.sockjsConfig;
    }

    public void onOpen(SockJsSessionContext session) {
        this.logger.info("SimplePushSockJSServer onOpen");
        this.session = session;
    }

    public void onMessage(String message) throws Exception {
        MessageType messageType = JsonUtil.parseFrame((String)message);
        this.logger.info("messageType: " + messageType.getMessageType());
        switch (messageType.getMessageType()) {
            case HELLO: {
                if (this.checkHandshakeCompleted(this.uaid)) break;
                HelloResponse response = this.simplePushServer.handleHandshake((HelloMessage)JsonUtil.fromJson((String)message, HelloMessageImpl.class));
                this.session.send(JsonUtil.toJson((Object)response));
                this.uaid = response.getUAID();
                this.userAgents.add(this.uaid, this.session);
                this.processUnacked(this.uaid, this.session, 0L);
                this.logger.info("UserAgent [" + this.uaid + "] handshake done");
                break;
            }
            case REGISTER: {
                if (!this.checkHandshakeCompleted(this.uaid)) break;
                RegisterResponse response = this.simplePushServer.handleRegister((RegisterMessage)JsonUtil.fromJson((String)message, RegisterMessageImpl.class), this.uaid);
                this.session.send(JsonUtil.toJson((Object)response));
                this.logger.info("UserAgent [" + this.uaid + "] Registered[" + response.getChannelId() + "]");
                break;
            }
            case UNREGISTER: {
                if (!this.checkHandshakeCompleted(this.uaid)) break;
                UnregisterMessage unregister = (UnregisterMessage)JsonUtil.fromJson((String)message, UnregisterMessageImpl.class);
                UnregisterResponse response = this.simplePushServer.handleUnregister(unregister, this.uaid);
                this.session.send(JsonUtil.toJson((Object)response));
                this.logger.info("UserAgent [" + this.uaid + "] Unregistered[" + response.getChannelId() + "]");
                break;
            }
            case ACK: {
                if (!this.checkHandshakeCompleted(this.uaid)) break;
                AckMessage ack = (AckMessage)JsonUtil.fromJson((String)message, AckMessageImpl.class);
                this.simplePushServer.handleAcknowledgement(ack, this.uaid);
                this.processUnacked(this.uaid, this.session, this.simplePushServer.config().acknowledmentInterval());
                break;
            }
            case PING: {
                this.session.send(PingMessageImpl.JSON);
            }
        }
        this.userAgents.updateAccessedTime(this.uaid);
    }

    private void processUnacked(final String uaid, final SockJsSessionContext session, long delay) {
        Set unacked = this.simplePushServer.getUnacknowledged(uaid);
        if (unacked.isEmpty()) {
            if (this.ackJobFuture != null && !this.ackJobFuture.isCancelled()) {
                this.ackJobFuture.cancel(false);
                this.logger.info("Cancelled Re-Acknowledger job");
            }
        } else if (this.ackJobFuture == null) {
            this.ackJobFuture = session.getContext().executor().scheduleAtFixedRate(new Runnable(){

                @Override
                public void run() {
                    Set unacked = SimplePushSockJSService.this.simplePushServer.getUnacknowledged(uaid);
                    SimplePushSockJSService.this.logger.info("Resending " + unacked);
                    session.send(JsonUtil.toJson((Object)new NotificationMessageImpl(unacked)));
                }
            }, delay, this.simplePushServer.config().acknowledmentInterval(), TimeUnit.MILLISECONDS);
        }
    }

    private boolean checkHandshakeCompleted(String uaid) {
        if (uaid == null) {
            this.logger.debug("Hello frame has not been sent");
            return false;
        }
        if (!this.userAgents.contains(uaid)) {
            this.uaid = uaid;
            return false;
        }
        return true;
    }

    public void onClose() {
        this.logger.info("SimplePushSockJSServer onClose");
        if (this.ackJobFuture != null) {
            this.ackJobFuture.cancel(true);
        }
    }
}

