/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.simplepush.server.netty.standalone;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import org.jboss.aerogear.simplepush.server.SimplePushServerConfig;
import org.jboss.aerogear.simplepush.server.netty.SockJSChannelInitializer;
import org.jboss.aerogear.simplepush.server.netty.standalone.ConfigReader;
import org.jboss.aerogear.simplepush.server.netty.standalone.StandaloneConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettySockJSServer {
    private final Logger logger = LoggerFactory.getLogger(NettySockJSServer.class);
    private final StandaloneConfig config;

    public NettySockJSServer(StandaloneConfig standaloneConfig) {
        this.config = standaloneConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() throws Exception {
        NioEventLoopGroup bossGroup = new NioEventLoopGroup();
        NioEventLoopGroup workerGroup = new NioEventLoopGroup();
        DefaultEventExecutorGroup reaperExcutorGroup = new DefaultEventExecutorGroup(1);
        SimplePushServerConfig simplePushConfig = this.config.simplePushServerConfig();
        try {
            ServerBootstrap sb = new ServerBootstrap();
            sb.group((EventLoopGroup)bossGroup, (EventLoopGroup)workerGroup).channel(NioServerSocketChannel.class).childHandler((ChannelHandler)new SockJSChannelInitializer(simplePushConfig, this.config.dataStore(), this.config.sockJsConfig(), (EventExecutorGroup)reaperExcutorGroup));
            Channel ch = sb.bind(simplePushConfig.host(), simplePushConfig.port()).sync().channel();
            this.logger.info("Server started");
            this.logger.debug(this.config.toString());
            ch.closeFuture().sync();
        }
        finally {
            bossGroup.shutdownGracefully();
            workerGroup.shutdownGracefully();
        }
    }

    public static void main(String[] args) throws Exception {
        String configFile = args.length == 1 ? args[0] : "/simplepush-config.json";
        StandaloneConfig config = ConfigReader.parse(configFile);
        new NettySockJSServer(config).run();
    }
}

