/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.simplepush.vertx;

import java.util.concurrent.ConcurrentMap;
import org.jboss.aerogear.simplepush.protocol.impl.NotificationMessageImpl;
import org.jboss.aerogear.simplepush.protocol.impl.json.JsonUtil;
import org.jboss.aerogear.simplepush.server.Notification;
import org.jboss.aerogear.simplepush.server.SimplePushServer;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.http.HttpServerRequest;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.platform.Container;

public class HttpNotificationHandler
implements Handler<HttpServerRequest> {
    private final SimplePushServer simplePushServer;
    private final Vertx vertx;
    private final Logger logger;
    private final ConcurrentMap<String, String> writeHandlerMap;

    public HttpNotificationHandler(SimplePushServer simplePushServer, Vertx vertx, Container container) {
        this.simplePushServer = simplePushServer;
        this.vertx = vertx;
        this.writeHandlerMap = vertx.sharedData().getMap("simplepush.writehandler.map");
        this.logger = container.logger();
    }

    public void handle(final HttpServerRequest request) {
        request.bodyHandler((Handler)new Handler<Buffer>(){

            public void handle(Buffer buffer) {
                try {
                    String endpointToken = request.params().get("endpoint");
                    String payload = buffer.toString();
                    HttpNotificationHandler.this.logger.info((Object)("Notification endpointToken  [" + endpointToken + "] " + payload));
                    Notification notification = HttpNotificationHandler.this.simplePushServer.handleNotification(endpointToken, payload);
                    NotificationMessageImpl notificationMessage = new NotificationMessageImpl(notification.ack());
                    HttpNotificationHandler.this.vertx.eventBus().send((String)HttpNotificationHandler.this.writeHandlerMap.get(notification.uaid()), new Buffer(JsonUtil.toJson((Object)notificationMessage)));
                    request.response().setStatusCode(200);
                    request.response().end();
                }
                catch (Exception e) {
                    HttpNotificationHandler.this.logger.error((Object)e);
                    request.response().setStatusCode(400);
                    request.response().setStatusMessage(e.getMessage());
                    request.response().end();
                }
            }
        });
    }
}

