/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.simplepush.vertx;

import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.jboss.aerogear.simplepush.protocol.AckMessage;
import org.jboss.aerogear.simplepush.protocol.HelloMessage;
import org.jboss.aerogear.simplepush.protocol.HelloResponse;
import org.jboss.aerogear.simplepush.protocol.MessageType;
import org.jboss.aerogear.simplepush.protocol.RegisterMessage;
import org.jboss.aerogear.simplepush.protocol.RegisterResponse;
import org.jboss.aerogear.simplepush.protocol.UnregisterMessage;
import org.jboss.aerogear.simplepush.protocol.UnregisterResponse;
import org.jboss.aerogear.simplepush.protocol.impl.AckMessageImpl;
import org.jboss.aerogear.simplepush.protocol.impl.HelloMessageImpl;
import org.jboss.aerogear.simplepush.protocol.impl.NotificationMessageImpl;
import org.jboss.aerogear.simplepush.protocol.impl.PingMessageImpl;
import org.jboss.aerogear.simplepush.protocol.impl.RegisterMessageImpl;
import org.jboss.aerogear.simplepush.protocol.impl.UnregisterMessageImpl;
import org.jboss.aerogear.simplepush.protocol.impl.json.JsonUtil;
import org.jboss.aerogear.simplepush.server.SimplePushServer;
import org.jboss.aerogear.simplepush.util.UUIDUtil;
import org.vertx.java.core.Handler;
import org.vertx.java.core.Vertx;
import org.vertx.java.core.buffer.Buffer;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.sockjs.SockJSSocket;
import org.vertx.java.platform.Container;

public class SimplePushServerHandler
implements Handler<SockJSSocket> {
    private final SimplePushServer simplePushServer;
    private final Logger logger;
    private final ConcurrentMap<String, String> writeHandlerMap;
    private final ConcurrentMap<String, Long> lastAccessedMap;
    private final Vertx vertx;
    private final Container container;
    private String uaid;

    public SimplePushServerHandler(SimplePushServer simplePushServer, Vertx vertx, Container container) {
        this.simplePushServer = simplePushServer;
        this.container = container;
        this.logger = container.logger();
        this.vertx = vertx;
        this.writeHandlerMap = vertx.sharedData().getMap("simplepush.writehandler.map");
        this.lastAccessedMap = vertx.sharedData().getMap("simplepush.lastaccessed.map");
    }

    public void handle(final SockJSSocket sock) {
        sock.dataHandler((Handler)new Handler<Buffer>(){

            public void handle(Buffer buffer) {
                MessageType messageType = JsonUtil.parseFrame((String)buffer.toString());
                switch (messageType.getMessageType()) {
                    case HELLO: {
                        HelloMessage handshakeMessage = (HelloMessage)JsonUtil.fromJson((String)buffer.toString(), HelloMessageImpl.class);
                        if (!SimplePushServerHandler.this.writeHandlerMap.containsKey(handshakeMessage.getUAID())) {
                            handshakeMessage = new HelloMessageImpl(UUIDUtil.newUAID());
                        }
                        HelloResponse helloResponse = SimplePushServerHandler.this.simplePushServer.handleHandshake(handshakeMessage);
                        sock.write(new Buffer(JsonUtil.toJson((Object)helloResponse)));
                        SimplePushServerHandler.this.uaid = helloResponse.getUAID();
                        SimplePushServerHandler.this.writeHandlerMap.put(SimplePushServerHandler.this.uaid.toString(), sock.writeHandlerID());
                        SimplePushServerHandler.this.lastAccessedMap.put(SimplePushServerHandler.this.uaid.toString(), System.currentTimeMillis());
                        SimplePushServerHandler.this.logger.info((Object)("UserAgent [" + SimplePushServerHandler.this.uaid + "] handshake done"));
                        break;
                    }
                    case REGISTER: {
                        if (!SimplePushServerHandler.this.checkHandshakeCompleted(SimplePushServerHandler.this.uaid)) break;
                        RegisterResponse response = SimplePushServerHandler.this.simplePushServer.handleRegister((RegisterMessage)JsonUtil.fromJson((String)buffer.toString(), RegisterMessageImpl.class), SimplePushServerHandler.this.uaid);
                        sock.write(new Buffer(JsonUtil.toJson((Object)response)));
                        SimplePushServerHandler.this.logger.info((Object)("UserAgent [" + SimplePushServerHandler.this.uaid + "] Registered[" + response + "]"));
                        break;
                    }
                    case UNREGISTER: {
                        if (!SimplePushServerHandler.this.checkHandshakeCompleted(SimplePushServerHandler.this.uaid)) break;
                        UnregisterMessage unregister = (UnregisterMessage)JsonUtil.fromJson((String)buffer.toString(), UnregisterMessageImpl.class);
                        UnregisterResponse response = SimplePushServerHandler.this.simplePushServer.handleUnregister(unregister, SimplePushServerHandler.this.uaid);
                        sock.write(new Buffer(JsonUtil.toJson((Object)response)));
                        SimplePushServerHandler.this.logger.info((Object)("UserAgent [" + SimplePushServerHandler.this.uaid + "] Unregistered[" + response.getChannelId() + "]"));
                        break;
                    }
                    case ACK: {
                        if (!SimplePushServerHandler.this.checkHandshakeCompleted(SimplePushServerHandler.this.uaid)) break;
                        AckMessage ack = (AckMessage)JsonUtil.fromJson((String)buffer.toString(), AckMessageImpl.class);
                        SimplePushServerHandler.this.simplePushServer.handleAcknowledgement(ack, SimplePushServerHandler.this.uaid);
                        SimplePushServerHandler.this.processUnacked(SimplePushServerHandler.this.uaid);
                        break;
                    }
                    case PING: {
                        sock.write(new Buffer(PingMessageImpl.JSON));
                        break;
                    }
                }
                SimplePushServerHandler.this.updateAccessedTime(SimplePushServerHandler.this.uaid);
            }
        });
    }

    private boolean checkHandshakeCompleted(String uaid) {
        if (uaid == null) {
            this.logger.debug((Object)"Hello frame has not been sent");
            return false;
        }
        return true;
    }

    private void updateAccessedTime(String uaid) {
        if (uaid != null) {
            this.lastAccessedMap.put(uaid, System.currentTimeMillis());
        }
    }

    private void processUnacked(final String uaid) {
        Set unacked = this.simplePushServer.getUnacknowledged(uaid);
        if (!unacked.isEmpty()) {
            Long interval = this.container.config().getLong("ackInterval", 60000L);
            this.vertx.setPeriodic(interval.longValue(), (Handler)new Handler<Long>(){

                public void handle(Long timerID) {
                    Set unacked = SimplePushServerHandler.this.simplePushServer.getUnacknowledged(uaid);
                    if (unacked.isEmpty()) {
                        SimplePushServerHandler.this.logger.info((Object)"Nothing to ack. Stopping periodic task");
                        SimplePushServerHandler.this.vertx.cancelTimer(timerID.longValue());
                    } else {
                        SimplePushServerHandler.this.logger.info((Object)("Resending " + unacked));
                        Buffer buf = new Buffer(JsonUtil.toJson((Object)new NotificationMessageImpl(unacked)));
                        SimplePushServerHandler.this.vertx.eventBus().send((String)SimplePushServerHandler.this.writeHandlerMap.get(uaid.toString()), buf);
                    }
                }
            });
        }
    }
}

