/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.simplepush.vertx;

import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import org.vertx.java.core.Handler;
import org.vertx.java.core.logging.Logger;
import org.vertx.java.core.shareddata.ConcurrentSharedMap;
import org.vertx.java.platform.Verticle;

public class UserAgentReaper
extends Verticle {
    public void start() {
        final Logger logger = this.container.logger();
        Long reaperTimeout = this.container.config().getLong("userAgentReaperTimeout", 300000L);
        logger.info((Object)("Started UserAgent Reaper with timeout of [" + reaperTimeout + "]"));
        ConcurrentSharedMap lastAccessedMap = this.vertx.sharedData().getMap("simplepush.lastaccessed.map");
        ConcurrentSharedMap writeHandlerMap = this.vertx.sharedData().getMap("simplepush.writehandler.map");
        this.vertx.setPeriodic(reaperTimeout.longValue(), (Handler)new Handler<Long>((ConcurrentMap)lastAccessedMap, reaperTimeout, (ConcurrentMap)writeHandlerMap){
            final /* synthetic */ ConcurrentMap val$lastAccessedMap;
            final /* synthetic */ Long val$reaperTimeout;
            final /* synthetic */ ConcurrentMap val$writeHandlerMap;
            {
                this.val$lastAccessedMap = concurrentMap;
                this.val$reaperTimeout = l;
                this.val$writeHandlerMap = concurrentMap2;
            }

            public void handle(Long timerId) {
                logger.info((Object)"UserAgentReaper reaping....");
                HashSet<String> markedForRemoval = new HashSet<String>();
                Set entrySet = this.val$lastAccessedMap.entrySet();
                for (Map.Entry entry : entrySet) {
                    String uaid = (String)entry.getKey();
                    Long timestamp = (Long)entry.getValue();
                    long now = System.currentTimeMillis();
                    if (timestamp + this.val$reaperTimeout >= now) continue;
                    markedForRemoval.add(uaid);
                    UserAgentReaper.this.vertx.eventBus().send("simplepush.useragent.remover", uaid);
                }
                for (String uaid : markedForRemoval) {
                    this.val$lastAccessedMap.remove(uaid);
                    this.val$writeHandlerMap.remove(uaid);
                }
            }
        });
    }
}

