/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.simplepush.subsystem;

import java.util.List;
import org.jboss.aerogear.simplepush.subsystem.CouchDBDataStoreService;
import org.jboss.aerogear.simplepush.subsystem.DataStoreDefinition;
import org.jboss.aerogear.simplepush.subsystem.DataStoreService;
import org.jboss.aerogear.simplepush.subsystem.InMemoryDataStoreService;
import org.jboss.aerogear.simplepush.subsystem.JpaDataStoreService;
import org.jboss.aerogear.simplepush.subsystem.RedisDataStoreService;
import org.jboss.as.controller.AbstractAddStepHandler;
import org.jboss.as.controller.OperationContext;
import org.jboss.as.controller.OperationFailedException;
import org.jboss.as.controller.PathAddress;
import org.jboss.as.controller.ServiceVerificationHandler;
import org.jboss.as.naming.deployment.ContextNames;
import org.jboss.dmr.ModelNode;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceBuilder;
import org.jboss.msc.service.ServiceController;
import org.jboss.msc.service.ServiceListener;
import org.jboss.msc.service.ServiceName;

class DataStoreAdd
extends AbstractAddStepHandler {
    public static final DataStoreAdd INSTANCE = new DataStoreAdd();
    private final Logger logger = Logger.getLogger(DataStoreAdd.class);

    private DataStoreAdd() {
    }

    protected void populateModel(ModelNode operation, ModelNode model) throws OperationFailedException {
        DataStoreDefinition.DATASOURCE_ATTR.validateAndSet(operation, model);
        DataStoreDefinition.PERSISTENCE_UNIT_ATTR.validateAndSet(operation, model);
        DataStoreDefinition.HOST_ATTR.validateAndSet(operation, model);
        DataStoreDefinition.PORT_ATTR.validateAndSet(operation, model);
        DataStoreDefinition.URL_ATTR.validateAndSet(operation, model);
        DataStoreDefinition.DB_NAME_ATTR.validateAndSet(operation, model);
    }

    protected void performRuntime(OperationContext context, ModelNode operation, ModelNode model, ServiceVerificationHandler verificationHandler, List<ServiceController<?>> newControllers) throws OperationFailedException {
        ServiceBuilder sb;
        PathAddress pathAddress = PathAddress.pathAddress((ModelNode)operation.get("address"));
        String serverName = pathAddress.getElement(1).getValue();
        String type = pathAddress.getLastElement().getValue();
        switch (DataStoreDefinition.Element.of(type)) {
            case JPA: {
                ModelNode datasourceNode = DataStoreDefinition.DATASOURCE_ATTR.resolveModelAttribute(context, model);
                ModelNode persistenceUnitNode = DataStoreDefinition.PERSISTENCE_UNIT_ATTR.resolveModelAttribute(context, model);
                ContextNames.BindInfo bindinfo = ContextNames.bindInfoFor((String)datasourceNode.asString());
                this.logger.debug((Object)("Adding dependency to [" + bindinfo.getAbsoluteJndiName() + "]"));
                JpaDataStoreService jpa = new JpaDataStoreService(persistenceUnitNode.asString());
                sb = context.getServiceTarget().addService(DataStoreService.SERVICE_NAME.append(new String[]{serverName}), (Service)jpa);
                sb.addDependencies(new ServiceName[]{bindinfo.getBinderServiceName()});
                break;
            }
            case REDIS: {
                ModelNode hostNode = DataStoreDefinition.HOST_ATTR.resolveModelAttribute(context, model);
                ModelNode portNode = DataStoreDefinition.PORT_ATTR.resolveModelAttribute(context, model);
                RedisDataStoreService redis = new RedisDataStoreService(hostNode.asString(), portNode.asInt());
                sb = context.getServiceTarget().addService(DataStoreService.SERVICE_NAME.append(new String[]{serverName}), (Service)redis);
                break;
            }
            case COUCHDB: {
                ModelNode urlNode = DataStoreDefinition.URL_ATTR.resolveModelAttribute(context, model);
                ModelNode dbNameNode = DataStoreDefinition.DB_NAME_ATTR.resolveModelAttribute(context, model);
                CouchDBDataStoreService couchdb = new CouchDBDataStoreService(urlNode.asString(), dbNameNode.asString());
                sb = context.getServiceTarget().addService(DataStoreService.SERVICE_NAME.append(new String[]{serverName}), (Service)couchdb);
                break;
            }
            case IN_MEMORY: {
                sb = context.getServiceTarget().addService(DataStoreService.SERVICE_NAME.append(new String[]{serverName}), (Service)new InMemoryDataStoreService());
                break;
            }
            default: {
                throw new IllegalStateException("invalid datastore type");
            }
        }
        sb.addListener((ServiceListener)verificationHandler);
        sb.setInitialMode(ServiceController.Mode.ACTIVE);
        newControllers.add(sb.install());
    }
}

