/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.simplepush.subsystem;

import java.util.HashMap;
import java.util.Map;
import org.jboss.aerogear.simplepush.subsystem.DataStoreAdd;
import org.jboss.aerogear.simplepush.subsystem.DataStoreRemove;
import org.jboss.aerogear.simplepush.subsystem.SimplePushExtension;
import org.jboss.aerogear.simplepush.subsystem.SimplePushSocketBindingHandler;
import org.jboss.as.controller.AttributeDefinition;
import org.jboss.as.controller.OperationStepHandler;
import org.jboss.as.controller.PathElement;
import org.jboss.as.controller.SimpleAttributeDefinition;
import org.jboss.as.controller.SimpleResourceDefinition;
import org.jboss.as.controller.descriptions.ResourceDescriptionResolver;
import org.jboss.as.controller.registry.ManagementResourceRegistration;
import org.jboss.dmr.ModelType;

public class DataStoreDefinition
extends SimpleResourceDefinition {
    public static final SimpleAttributeDefinition DATASOURCE_ATTR = new SimpleAttributeDefinition(Element.DATASOURCE.localName(), ModelType.STRING, true);
    public static final SimpleAttributeDefinition PERSISTENCE_UNIT_ATTR = new SimpleAttributeDefinition(Element.PERSISTENCE_UNIT.localName(), ModelType.STRING, true);
    public static final SimpleAttributeDefinition HOST_ATTR = new SimpleAttributeDefinition(Element.HOST.localName(), ModelType.STRING, true);
    public static final SimpleAttributeDefinition PORT_ATTR = new SimpleAttributeDefinition(Element.PORT.localName(), ModelType.STRING, true);
    public static final SimpleAttributeDefinition URL_ATTR = new SimpleAttributeDefinition(Element.URL.localName(), ModelType.STRING, true);
    public static final SimpleAttributeDefinition DB_NAME_ATTR = new SimpleAttributeDefinition(Element.DB_NAME.localName(), ModelType.STRING, true);
    public static final String DATASTORE = "datastore";
    public static final PathElement DATASTORE_PATH = PathElement.pathElement((String)"datastore");
    public static final DataStoreDefinition INSTANCE = new DataStoreDefinition();

    private DataStoreDefinition() {
        super(DATASTORE_PATH, (ResourceDescriptionResolver)SimplePushExtension.getResourceDescriptionResolver("server.datastore"), (OperationStepHandler)DataStoreAdd.INSTANCE, (OperationStepHandler)DataStoreRemove.INSTANCE);
    }

    public void registerAttributes(ManagementResourceRegistration resourceRegistration) {
        super.registerAttributes(resourceRegistration);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)DATASOURCE_ATTR, null, (OperationStepHandler)SimplePushSocketBindingHandler.INSTANCE);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)PERSISTENCE_UNIT_ATTR, null, (OperationStepHandler)SimplePushSocketBindingHandler.INSTANCE);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)HOST_ATTR, null, (OperationStepHandler)SimplePushSocketBindingHandler.INSTANCE);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)PORT_ATTR, null, (OperationStepHandler)SimplePushSocketBindingHandler.INSTANCE);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)URL_ATTR, null, (OperationStepHandler)SimplePushSocketBindingHandler.INSTANCE);
        resourceRegistration.registerReadWriteAttribute((AttributeDefinition)DB_NAME_ATTR, null, (OperationStepHandler)SimplePushSocketBindingHandler.INSTANCE);
    }

    public static enum Element {
        UNKNOWN(null),
        JPA("jpa"),
        DATASOURCE("datasource-jndi-name"),
        PERSISTENCE_UNIT("persistence-unit"),
        REDIS("redis"),
        COUCHDB("couchdb"),
        IN_MEMORY("in-memory"),
        HOST("host"),
        PORT("port"),
        URL("url"),
        DB_NAME("database-name");

        private final String name;
        private static final Map<String, Element> MAP;

        private Element(String name) {
            this.name = name;
        }

        public String localName() {
            return this.name;
        }

        public static Element of(String localName) {
            Element element = MAP.get(localName);
            return element == null ? UNKNOWN : element;
        }

        static {
            HashMap<String, Element> map = new HashMap<String, Element>();
            for (Element element : Element.values()) {
                String name = element.localName();
                if (name == null) continue;
                map.put(name, element);
            }
            MAP = map;
        }
    }
}

