/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.simplepush.subsystem;

import io.netty.bootstrap.ServerBootstrap;
import io.netty.channel.Channel;
import io.netty.channel.ChannelHandler;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.nio.NioServerSocketChannel;
import io.netty.util.concurrent.DefaultEventExecutorGroup;
import io.netty.util.concurrent.EventExecutorGroup;
import org.jboss.aerogear.io.netty.handler.codec.sockjs.SockJsConfig;
import org.jboss.aerogear.simplepush.server.DefaultSimplePushConfig;
import org.jboss.aerogear.simplepush.server.SimplePushServerConfig;
import org.jboss.aerogear.simplepush.server.datastore.DataStore;
import org.jboss.aerogear.simplepush.server.netty.SockJSChannelInitializer;
import org.jboss.as.network.SocketBinding;
import org.jboss.logging.Logger;
import org.jboss.msc.service.Service;
import org.jboss.msc.service.ServiceName;
import org.jboss.msc.service.StartContext;
import org.jboss.msc.service.StartException;
import org.jboss.msc.service.StopContext;
import org.jboss.msc.value.InjectedValue;

public class SimplePushService
implements Service<SimplePushService> {
    private final Logger logger = Logger.getLogger(SimplePushService.class);
    private final InjectedValue<SocketBinding> injectedSocketBinding = new InjectedValue();
    private final InjectedValue<SocketBinding> injectedNotificationSocketBinding = new InjectedValue();
    private final InjectedValue<DataStore> injectedDataStore = new InjectedValue();
    private final DefaultSimplePushConfig.Builder simplePushConfig;
    private final SockJsConfig sockJsConfig;
    private Channel channel;

    public SimplePushService(DefaultSimplePushConfig.Builder simplePushConfig, SockJsConfig sockJsConfig) {
        this.simplePushConfig = simplePushConfig;
        this.sockJsConfig = sockJsConfig;
    }

    public synchronized void start(StartContext context) throws StartException {
        try {
            SocketBinding notificationSocketBinding = (SocketBinding)this.injectedNotificationSocketBinding.getOptionalValue();
            if (notificationSocketBinding != null) {
                this.simplePushConfig.endpointHost(notificationSocketBinding.getSocketAddress().getHostName());
                this.simplePushConfig.endpointPort(notificationSocketBinding.getPort());
            }
            DefaultEventExecutorGroup reaperExcutorGroup = new DefaultEventExecutorGroup(1);
            DataStore datastore = (DataStore)this.injectedDataStore.getValue();
            SimplePushServerConfig simplePushServerConfig = this.simplePushConfig.build();
            ServerBootstrap serverBootstrap = new ServerBootstrap().group((EventLoopGroup)new NioEventLoopGroup(), (EventLoopGroup)new NioEventLoopGroup()).channel(NioServerSocketChannel.class).childHandler((ChannelHandler)new SockJSChannelInitializer(simplePushServerConfig, datastore, this.sockJsConfig, (EventExecutorGroup)reaperExcutorGroup));
            SocketBinding socketBinding = (SocketBinding)this.injectedSocketBinding.getValue();
            this.logger.info((Object)("SimplePush Server binding to [" + socketBinding.getAddress() + ":" + socketBinding.getPort() + "]"));
            this.logger.info((Object)("SimplePush Server config " + simplePushServerConfig));
            this.channel = serverBootstrap.bind(socketBinding.getAddress(), socketBinding.getPort()).sync().channel();
        }
        catch (Exception e) {
            throw new StartException((Throwable)e);
        }
    }

    public synchronized void stop(StopContext context) {
        this.logger.info((Object)"SimplePush Server shutting down.");
        this.channel.eventLoop().shutdownGracefully();
    }

    public InjectedValue<SocketBinding> getInjectedSocketBinding() {
        return this.injectedSocketBinding;
    }

    public InjectedValue<SocketBinding> getInjectedNotificationSocketBinding() {
        return this.injectedNotificationSocketBinding;
    }

    public InjectedValue<DataStore> getInjectedDataStore() {
        return this.injectedDataStore;
    }

    public SimplePushService getValue() throws IllegalStateException, IllegalArgumentException {
        return this;
    }

    public static ServiceName createServiceName(String name) {
        return ServiceName.JBOSS.append(new String[]{"aerogear", name});
    }
}

