/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.simplepush.subsystem;

import java.util.List;
import javax.xml.stream.XMLStreamConstants;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.jboss.aerogear.simplepush.subsystem.DataStoreDefinition;
import org.jboss.aerogear.simplepush.subsystem.ServerDefinition;
import org.jboss.as.controller.parsing.ParseUtils;
import org.jboss.as.controller.persistence.SubsystemMarshallingContext;
import org.jboss.dmr.ModelNode;
import org.jboss.dmr.Property;
import org.jboss.staxmapper.XMLElementReader;
import org.jboss.staxmapper.XMLElementWriter;
import org.jboss.staxmapper.XMLExtendedStreamReader;
import org.jboss.staxmapper.XMLExtendedStreamWriter;

public class SimplePushSubsystemParser
implements XMLStreamConstants,
XMLElementReader<List<ModelNode>>,
XMLElementWriter<SubsystemMarshallingContext> {
    public void readElement(XMLExtendedStreamReader reader, List<ModelNode> list) throws XMLStreamException {
        ModelNode address = new ModelNode();
        address.add("subsystem", "simplepush");
        address.protect();
        ModelNode subsystem = new ModelNode();
        subsystem.get("operation").set("add");
        subsystem.get("address").set(address);
        list.add(subsystem);
        while (reader.hasNext() && reader.nextTag() != 2) {
            if (!reader.isStartElement()) continue;
            this.readServerType(reader, list, address);
        }
    }

    private void readServerType(XMLExtendedStreamReader reader, List<ModelNode> modelNodes, ModelNode parentAddress) throws XMLStreamException {
        ModelNode node = new ModelNode();
        node.get("operation").set("add");
        modelNodes.add(node);
        this.readServerAttributes(reader, node, parentAddress);
        this.readServerElements(reader, node, modelNodes);
        ParseUtils.requireNoContent((XMLExtendedStreamReader)reader);
    }

    private void readServerAttributes(XMLExtendedStreamReader reader, ModelNode node, ModelNode parentAddress) throws XMLStreamException {
        String serverName = "simplepush";
        int count = reader.getAttributeCount();
        for (int i = 0; i < count; ++i) {
            String name = reader.getAttributeLocalName(i);
            String value = reader.getAttributeValue(i);
            switch (ServerDefinition.Element.of(name)) {
                case SERVER_NAME: {
                    serverName = value;
                    break;
                }
                case SOCKET_BINDING: {
                    ServerDefinition.SOCKET_BINDING_ATTR.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    break;
                }
                case PASSWORD: {
                    ServerDefinition.PASSWORD_ATTR.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    break;
                }
                case REAPER_TIMEOUT: {
                    ServerDefinition.REAPER_TIMEOUT_ATTR.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    break;
                }
                case ENDPOINT_PREFIX: {
                    ServerDefinition.ENDPOINT_PREFIX_ATTR.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    break;
                }
                case ENDPOINT_TLS: {
                    ServerDefinition.ENDPOINT_TLS_ATTR.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    break;
                }
                case ENDPOINT_ACK_INTERVAL: {
                    ServerDefinition.ENDPOINT_ACK_INTERVAL_ATTR.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    break;
                }
                case ENDPOINT_SOCKET_BINDING: {
                    ServerDefinition.ENDPOINT_SOCKET_BINDING_ATTR.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    break;
                }
                case NOTIFIER_MAX_THREADS: {
                    ServerDefinition.NOTIFIER_MAX_THREADS.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    break;
                }
                case SOCKJS_PREFIX: {
                    ServerDefinition.SOCKJS_PREFIX_ATTR.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    break;
                }
                case SOCKJS_COOKIES_NEEDED: {
                    ServerDefinition.SOCKJS_COOKIES_NEEDED_ATTR.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    break;
                }
                case SOCKJS_URL: {
                    ServerDefinition.SOCKJS_URL_ATTR.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    break;
                }
                case SOCKJS_SESSION_TIMEOUT: {
                    ServerDefinition.SOCKJS_SESSION_TIMEOUT_ATTR.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    break;
                }
                case SOCKJS_HEARTBEAT_INTERVAL: {
                    ServerDefinition.SOCKJS_HEARTBEAT_INTERVAL_ATTR.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    break;
                }
                case SOCKJS_MAX_STREAMING_BYTES_SIZE: {
                    ServerDefinition.SOCKJS_MAX_STREAMING_BYTES_SIZE_ATTR.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    break;
                }
                case SOCKJS_TLS: {
                    ServerDefinition.SOCKJS_TLS_ATTR.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    break;
                }
                case SOCKJS_KEYSTORE: {
                    ServerDefinition.SOCKJS_KEYSTORE_ATTR.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    break;
                }
                case SOCKJS_KEYSTORE_PASSWORD: {
                    ServerDefinition.SOCKJS_KEYSTORE_PASSWORD_ATTR.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    break;
                }
                case SOCKJS_ENABLE_WEBSOCKET: {
                    ServerDefinition.SOCKJS_ENABLE_WEBSOCKET_ATTR.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    break;
                }
                case SOCKJS_WEBSOCKET_HEARTBEAT_INTERVAL: {
                    ServerDefinition.SOCKJS_WEBSOCKET_HEARTBEAT_INTERVAL_ATTR.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    break;
                }
                case SOCKJS_WEBSOCKET_PROTOCOLS: {
                    ServerDefinition.SOCKJS_WEBSOCKET_PROTOCOLS.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    break;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
            node.get("address").set(parentAddress).add("server", serverName);
        }
    }

    private void readServerElements(XMLExtendedStreamReader reader, ModelNode node, List<ModelNode> modelNodes) throws XMLStreamException {
        while (reader.hasNext() && reader.nextTag() != 2) {
            String tagName = reader.getLocalName();
            if (!tagName.equals("datastore")) continue;
            block7: while (reader.hasNext() && reader.nextTag() != 2) {
                switch (DataStoreDefinition.Element.of(reader.getLocalName())) {
                    case JPA: {
                        ModelNode jpa = this.readJpaElement(reader, node.get("address"));
                        modelNodes.add(jpa);
                        continue block7;
                    }
                    case REDIS: {
                        ModelNode redis = this.readRedisElement(reader, node.get("address"));
                        modelNodes.add(redis);
                        continue block7;
                    }
                    case COUCHDB: {
                        ModelNode couchdb = this.readCouchDBElement(reader, node.get("address"));
                        modelNodes.add(couchdb);
                        continue block7;
                    }
                    case IN_MEMORY: {
                        ModelNode inmem = this.readInMemoryDBElement(reader, node.get("address"));
                        modelNodes.add(inmem);
                        continue block7;
                    }
                }
                throw ParseUtils.unexpectedElement((XMLExtendedStreamReader)reader);
            }
        }
    }

    private ModelNode readJpaElement(XMLExtendedStreamReader reader, ModelNode parentAddress) throws XMLStreamException {
        ModelNode node = new ModelNode();
        node.get("operation").set("add");
        node.get("address").set(parentAddress).add("datastore", DataStoreDefinition.Element.JPA.localName());
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            String name = reader.getAttributeLocalName(i);
            String value = reader.getAttributeValue(i);
            switch (DataStoreDefinition.Element.of(name)) {
                case DATASOURCE: {
                    DataStoreDefinition.DATASOURCE_ATTR.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    continue block4;
                }
                case PERSISTENCE_UNIT: {
                    DataStoreDefinition.PERSISTENCE_UNIT_ATTR.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        return node;
    }

    private ModelNode readRedisElement(XMLExtendedStreamReader reader, ModelNode parentAddress) throws XMLStreamException {
        ModelNode node = new ModelNode();
        node.get("operation").set("add");
        node.get("address").set(parentAddress).add("datastore", DataStoreDefinition.Element.REDIS.localName());
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            String name = reader.getAttributeLocalName(i);
            String value = reader.getAttributeValue(i);
            switch (DataStoreDefinition.Element.of(name)) {
                case HOST: {
                    DataStoreDefinition.HOST_ATTR.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    continue block4;
                }
                case PORT: {
                    DataStoreDefinition.PORT_ATTR.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        return node;
    }

    private ModelNode readCouchDBElement(XMLExtendedStreamReader reader, ModelNode parentAddress) throws XMLStreamException {
        ModelNode node = new ModelNode();
        node.get("operation").set("add");
        node.get("address").set(parentAddress).add("datastore", DataStoreDefinition.Element.COUCHDB.localName());
        int count = reader.getAttributeCount();
        block4: for (int i = 0; i < count; ++i) {
            String name = reader.getAttributeLocalName(i);
            String value = reader.getAttributeValue(i);
            switch (DataStoreDefinition.Element.of(name)) {
                case URL: {
                    DataStoreDefinition.URL_ATTR.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    continue block4;
                }
                case DB_NAME: {
                    DataStoreDefinition.DB_NAME_ATTR.parseAndSetParameter(value, node, (XMLStreamReader)reader);
                    continue block4;
                }
                default: {
                    throw ParseUtils.unexpectedAttribute((XMLExtendedStreamReader)reader, (int)i);
                }
            }
        }
        return node;
    }

    private ModelNode readInMemoryDBElement(XMLExtendedStreamReader reader, ModelNode parentAddress) throws XMLStreamException {
        ModelNode node = new ModelNode();
        node.get("operation").set("add");
        node.get("address").set(parentAddress).add("datastore", DataStoreDefinition.Element.IN_MEMORY.localName());
        return node;
    }

    public void writeContent(XMLExtendedStreamWriter writer, SubsystemMarshallingContext context) throws XMLStreamException {
        context.startSubsystemElement("urn:org.jboss.aerogear.simplepush:1.0", false);
        ModelNode node = context.getModelNode();
        ModelNode server = node.get("server");
        for (Property property : server.asPropertyList()) {
            writer.writeStartElement("server");
            ModelNode entry = property.getValue();
            ServerDefinition.SOCKET_BINDING_ATTR.marshallAsAttribute(entry, true, (XMLStreamWriter)writer);
            ServerDefinition.PASSWORD_ATTR.marshallAsAttribute(entry, true, (XMLStreamWriter)writer);
            ServerDefinition.REAPER_TIMEOUT_ATTR.marshallAsAttribute(entry, true, (XMLStreamWriter)writer);
            ServerDefinition.ENDPOINT_TLS_ATTR.marshallAsAttribute(entry, true, (XMLStreamWriter)writer);
            ServerDefinition.ENDPOINT_PREFIX_ATTR.marshallAsAttribute(entry, true, (XMLStreamWriter)writer);
            ServerDefinition.ENDPOINT_ACK_INTERVAL_ATTR.marshallAsAttribute(entry, true, (XMLStreamWriter)writer);
            ServerDefinition.ENDPOINT_SOCKET_BINDING_ATTR.marshallAsAttribute(entry, true, (XMLStreamWriter)writer);
            ServerDefinition.NOTIFIER_MAX_THREADS.marshallAsAttribute(entry, true, (XMLStreamWriter)writer);
            ServerDefinition.SOCKJS_PREFIX_ATTR.marshallAsAttribute(entry, true, (XMLStreamWriter)writer);
            ServerDefinition.SOCKJS_COOKIES_NEEDED_ATTR.marshallAsAttribute(entry, true, (XMLStreamWriter)writer);
            ServerDefinition.SOCKJS_URL_ATTR.marshallAsAttribute(entry, true, (XMLStreamWriter)writer);
            ServerDefinition.SOCKJS_SESSION_TIMEOUT_ATTR.marshallAsAttribute(entry, true, (XMLStreamWriter)writer);
            ServerDefinition.SOCKJS_HEARTBEAT_INTERVAL_ATTR.marshallAsAttribute(entry, true, (XMLStreamWriter)writer);
            ServerDefinition.SOCKJS_MAX_STREAMING_BYTES_SIZE_ATTR.marshallAsAttribute(entry, true, (XMLStreamWriter)writer);
            ServerDefinition.SOCKJS_TLS_ATTR.marshallAsAttribute(entry, true, (XMLStreamWriter)writer);
            ServerDefinition.SOCKJS_KEYSTORE_ATTR.marshallAsAttribute(entry, true, (XMLStreamWriter)writer);
            ServerDefinition.SOCKJS_KEYSTORE_PASSWORD_ATTR.marshallAsAttribute(entry, true, (XMLStreamWriter)writer);
            ServerDefinition.SOCKJS_ENABLE_WEBSOCKET_ATTR.marshallAsAttribute(entry, true, (XMLStreamWriter)writer);
            ServerDefinition.SOCKJS_WEBSOCKET_HEARTBEAT_INTERVAL_ATTR.marshallAsAttribute(entry, true, (XMLStreamWriter)writer);
            ServerDefinition.SOCKJS_WEBSOCKET_PROTOCOLS.marshallAsAttribute(entry, true, (XMLStreamWriter)writer);
            ModelNode datastore = entry.get("datastore");
            if (datastore.isDefined()) {
                writer.writeStartElement("datastore");
                switch (DataStoreDefinition.Element.of((String)datastore.keys().iterator().next())) {
                    case JPA: {
                        writer.writeStartElement(DataStoreDefinition.Element.JPA.localName());
                        ModelNode jpa = datastore.get(DataStoreDefinition.Element.JPA.localName());
                        DataStoreDefinition.DATASOURCE_ATTR.marshallAsAttribute(jpa, true, (XMLStreamWriter)writer);
                        DataStoreDefinition.PERSISTENCE_UNIT_ATTR.marshallAsAttribute(jpa, true, (XMLStreamWriter)writer);
                        writer.writeEndElement();
                        break;
                    }
                    case REDIS: {
                        writer.writeStartElement(DataStoreDefinition.Element.REDIS.localName());
                        ModelNode redis = datastore.get(DataStoreDefinition.Element.REDIS.localName());
                        DataStoreDefinition.HOST_ATTR.marshallAsAttribute(redis, true, (XMLStreamWriter)writer);
                        DataStoreDefinition.PORT_ATTR.marshallAsAttribute(redis, true, (XMLStreamWriter)writer);
                        writer.writeEndElement();
                        break;
                    }
                    case COUCHDB: {
                        writer.writeStartElement(DataStoreDefinition.Element.COUCHDB.localName());
                        ModelNode couchdb = datastore.get(DataStoreDefinition.Element.COUCHDB.localName());
                        DataStoreDefinition.URL_ATTR.marshallAsAttribute(couchdb, true, (XMLStreamWriter)writer);
                        DataStoreDefinition.DB_NAME_ATTR.marshallAsAttribute(couchdb, true, (XMLStreamWriter)writer);
                        writer.writeEndElement();
                        break;
                    }
                    case IN_MEMORY: {
                        writer.writeStartElement(DataStoreDefinition.Element.IN_MEMORY.localName());
                        writer.writeEndElement();
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Non supported datastore type");
                    }
                }
                writer.writeEndElement();
            }
            writer.writeEndElement();
        }
        writer.writeEndElement();
    }
}

