/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.webpush.netty;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelFutureListener;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.http.DefaultFullHttpResponse;
import io.netty.handler.codec.http.HttpHeaderNames;
import io.netty.handler.codec.http.HttpHeaderUtil;
import io.netty.handler.codec.http.HttpHeaderValues;
import io.netty.handler.codec.http.HttpMessage;
import io.netty.handler.codec.http.HttpRequest;
import io.netty.handler.codec.http.HttpResponseStatus;
import io.netty.handler.codec.http.HttpVersion;
import io.netty.util.CharsetUtil;
import io.netty.util.concurrent.GenericFutureListener;
import org.jboss.aerogear.webpush.WebPushServer;

public class WebPushHttp11Handler
extends SimpleChannelInboundHandler<HttpRequest> {
    static final byte[] RESPONSE_BYTES = "WebPush HTTP 1.1".getBytes(CharsetUtil.UTF_8);
    private final WebPushServer webPushServer;

    public WebPushHttp11Handler(WebPushServer webPushServer) {
        this.webPushServer = webPushServer;
    }

    public void channelRead0(ChannelHandlerContext ctx, HttpRequest req) throws Exception {
        if (HttpHeaderUtil.is100ContinueExpected((HttpMessage)req)) {
            ctx.write((Object)new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.CONTINUE));
        }
        ByteBuf content = ctx.alloc().buffer();
        content.writeBytes(RESPONSE_BYTES);
        DefaultFullHttpResponse response = new DefaultFullHttpResponse(HttpVersion.HTTP_1_1, HttpResponseStatus.OK, content);
        response.headers().set((CharSequence)HttpHeaderNames.CONTENT_TYPE, (Object)"text/plain; charset=UTF-8");
        response.headers().setInt((CharSequence)HttpHeaderNames.CONTENT_LENGTH, response.content().readableBytes());
        if (!HttpHeaderUtil.isKeepAlive((HttpMessage)req)) {
            ctx.writeAndFlush((Object)response).addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        } else {
            response.headers().set((CharSequence)HttpHeaderNames.CONNECTION, (Object)HttpHeaderValues.KEEP_ALIVE);
            ctx.writeAndFlush((Object)response);
        }
    }

    public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
        cause.printStackTrace();
        ctx.close();
    }
}

