/*
 * Decompiled with CFR 0.152.
 */
package com.offbytwo.jenkins.client;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.collect.Lists;
import com.google.common.io.ByteStreams;
import com.offbytwo.jenkins.client.FormBinaryField;
import com.offbytwo.jenkins.client.PreemptiveAuth;
import com.offbytwo.jenkins.client.util.EncodingUtils;
import com.offbytwo.jenkins.client.util.RequestReleasingInputStream;
import com.offbytwo.jenkins.client.validator.HttpResponseValidator;
import com.offbytwo.jenkins.model.BaseModel;
import com.offbytwo.jenkins.model.Crumb;
import com.offbytwo.jenkins.model.ExtractHeader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import net.sf.json.JSONObject;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.entity.UrlEncodedFormEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.HttpMultipartMode;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JenkinsHttpClient {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    private URI uri;
    private CloseableHttpClient client;
    private HttpContext localContext;
    private HttpResponseValidator httpResponseValidator;
    private ObjectMapper mapper;
    private String context;
    private String jenkinsVersion;

    public JenkinsHttpClient(URI uri, CloseableHttpClient client) {
        this.context = uri.getPath();
        if (!this.context.endsWith("/")) {
            this.context = this.context + "/";
        }
        this.uri = uri;
        this.mapper = this.getDefaultMapper();
        this.client = client;
        this.httpResponseValidator = new HttpResponseValidator();
        this.jenkinsVersion = null;
        this.LOGGER.debug("uri={}", (Object)uri.toString());
    }

    public JenkinsHttpClient(URI uri, HttpClientBuilder builder) {
        this(uri, builder.build());
    }

    public JenkinsHttpClient(URI uri) {
        this(uri, HttpClientBuilder.create());
    }

    public JenkinsHttpClient(URI uri, String username, String password) {
        this(uri, JenkinsHttpClient.addAuthentication(HttpClientBuilder.create(), uri, username, password));
        if (StringUtils.isNotBlank((String)username)) {
            this.localContext = new BasicHttpContext();
            this.localContext.setAttribute("preemptive-auth", (Object)new BasicScheme());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends BaseModel> T get(String path, Class<T> cls) throws IOException {
        HttpGet getMethod = new HttpGet(this.api(path));
        CloseableHttpResponse response = this.client.execute((HttpUriRequest)getMethod, this.localContext);
        this.getJenkinsVersionFromHeader((HttpResponse)response);
        try {
            this.httpResponseValidator.validateResponse((HttpResponse)response);
            T t = this.objectFromResponse(cls, (HttpResponse)response);
            return t;
        }
        finally {
            EntityUtils.consume((HttpEntity)response.getEntity());
            this.releaseConnection((HttpRequestBase)getMethod);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String get(String path) throws IOException {
        HttpGet getMethod = new HttpGet(this.api(path));
        CloseableHttpResponse response = this.client.execute((HttpUriRequest)getMethod, this.localContext);
        this.getJenkinsVersionFromHeader((HttpResponse)response);
        this.LOGGER.debug("get({}), version={}, responseCode={}", new Object[]{path, this.jenkinsVersion, response.getStatusLine().getStatusCode()});
        try {
            this.httpResponseValidator.validateResponse((HttpResponse)response);
            String string = IOUtils.toString((InputStream)response.getEntity().getContent());
            return string;
        }
        finally {
            EntityUtils.consume((HttpEntity)response.getEntity());
            this.releaseConnection((HttpRequestBase)getMethod);
        }
    }

    public <T extends BaseModel> T getQuietly(String path, Class<T> cls) {
        try {
            T value = this.get(path, cls);
            return value;
        }
        catch (IOException e) {
            this.LOGGER.debug("getQuietly({}, {})", new Object[]{path, cls.getName(), e});
            return null;
        }
    }

    public InputStream getFile(URI path) throws IOException {
        HttpGet getMethod = new HttpGet(path);
        CloseableHttpResponse response = this.client.execute((HttpUriRequest)getMethod, this.localContext);
        this.getJenkinsVersionFromHeader((HttpResponse)response);
        this.httpResponseValidator.validateResponse((HttpResponse)response);
        return new RequestReleasingInputStream(response.getEntity().getContent(), (HttpRequestBase)getMethod);
    }

    public <R extends BaseModel, D> R post(String path, D data, Class<R> cls) throws IOException {
        return this.post(path, data, cls, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <R extends BaseModel, D> R post(String path, D data, Class<R> cls, boolean crumbFlag) throws IOException {
        Crumb crumb;
        HttpPost request = new HttpPost(this.api(path));
        if (crumbFlag && (crumb = this.getQuietly("/crumbIssuer", Crumb.class)) != null) {
            request.addHeader((Header)new BasicHeader(crumb.getCrumbRequestField(), crumb.getCrumb()));
        }
        if (data != null) {
            String value = this.mapper.writeValueAsString(data);
            StringEntity stringEntity = new StringEntity(value, ContentType.APPLICATION_JSON);
            request.setEntity((HttpEntity)stringEntity);
        }
        CloseableHttpResponse response = this.client.execute((HttpUriRequest)request, this.localContext);
        this.getJenkinsVersionFromHeader((HttpResponse)response);
        try {
            this.httpResponseValidator.validateResponse((HttpResponse)response);
            if (cls != null) {
                Object responseObject;
                if (cls.equals(ExtractHeader.class)) {
                    ExtractHeader location = new ExtractHeader();
                    location.setLocation(response.getFirstHeader("Location").getValue());
                    responseObject = location;
                } else {
                    responseObject = this.objectFromResponse(cls, (HttpResponse)response);
                }
                R r = responseObject;
                return r;
            }
            R r = null;
            return r;
        }
        finally {
            EntityUtils.consume((HttpEntity)response.getEntity());
            this.releaseConnection((HttpRequestBase)request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void post_form(String path, Map<String, String> data, boolean crumbFlag) throws IOException {
        Crumb crumb;
        HttpPost request;
        if (data != null) {
            ArrayList queryParams = Lists.newArrayList();
            for (String param : data.keySet()) {
                queryParams.add(param + "=" + EncodingUtils.encodeParam(data.get(param)));
            }
            queryParams.add("json=" + EncodingUtils.encodeParam(JSONObject.fromObject(data).toString()));
            String value = this.mapper.writeValueAsString(data);
            StringEntity stringEntity = new StringEntity(value, ContentType.APPLICATION_FORM_URLENCODED);
            request = new HttpPost(this.noapi(path) + StringUtils.join((Collection)queryParams, (String)"&"));
            request.setEntity((HttpEntity)stringEntity);
        } else {
            request = new HttpPost(this.noapi(path));
        }
        if (crumbFlag && (crumb = this.get("/crumbIssuer", Crumb.class)) != null) {
            request.addHeader((Header)new BasicHeader(crumb.getCrumbRequestField(), crumb.getCrumb()));
        }
        CloseableHttpResponse response = this.client.execute((HttpUriRequest)request, this.localContext);
        this.getJenkinsVersionFromHeader((HttpResponse)response);
        try {
            this.httpResponseValidator.validateResponse((HttpResponse)response);
        }
        finally {
            EntityUtils.consume((HttpEntity)response.getEntity());
            this.releaseConnection((HttpRequestBase)request);
        }
    }

    public HttpResponse post_form_with_result(String path, List<NameValuePair> data, boolean crumbFlag) throws IOException {
        Crumb crumb;
        HttpPost request;
        if (data != null) {
            UrlEncodedFormEntity urlEncodedFormEntity = new UrlEncodedFormEntity(data);
            request = new HttpPost(this.noapi(path));
            request.setEntity((HttpEntity)urlEncodedFormEntity);
        } else {
            request = new HttpPost(this.noapi(path));
        }
        if (crumbFlag && (crumb = this.get("/crumbIssuer", Crumb.class)) != null) {
            request.addHeader((Header)new BasicHeader(crumb.getCrumbRequestField(), crumb.getCrumb()));
        }
        CloseableHttpResponse response = this.client.execute((HttpUriRequest)request, this.localContext);
        this.getJenkinsVersionFromHeader((HttpResponse)response);
        return response;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void post_form_json(String path, Map<String, Object> data, boolean crumbFlag) throws IOException {
        Crumb crumb;
        HttpPost request;
        if (data != null) {
            ArrayList queryParams = Lists.newArrayList();
            queryParams.add("json=" + EncodingUtils.encodeParam(JSONObject.fromObject(data).toString()));
            String value = this.mapper.writeValueAsString(data);
            StringEntity stringEntity = new StringEntity(value, ContentType.APPLICATION_FORM_URLENCODED);
            request = new HttpPost(this.noapi(path) + StringUtils.join((Collection)queryParams, (String)"&"));
            request.setEntity((HttpEntity)stringEntity);
        } else {
            request = new HttpPost(this.noapi(path));
        }
        if (crumbFlag && (crumb = this.get("/crumbIssuer", Crumb.class)) != null) {
            request.addHeader((Header)new BasicHeader(crumb.getCrumbRequestField(), crumb.getCrumb()));
        }
        CloseableHttpResponse response = this.client.execute((HttpUriRequest)request, this.localContext);
        this.getJenkinsVersionFromHeader((HttpResponse)response);
        try {
            this.httpResponseValidator.validateResponse((HttpResponse)response);
        }
        finally {
            EntityUtils.consume((HttpEntity)response.getEntity());
            this.releaseConnection((HttpRequestBase)request);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void post_multipart_form_json(String path, Map<String, Object> data, boolean crumbFlag) throws IOException {
        Crumb crumb;
        HttpPost request;
        if (data != null) {
            MultipartEntityBuilder builder = MultipartEntityBuilder.create();
            builder.setMode(HttpMultipartMode.BROWSER_COMPATIBLE);
            for (Map.Entry<String, Object> entry : data.entrySet()) {
                String fieldName = entry.getKey();
                Object fieldValue = entry.getValue();
                if (fieldValue instanceof String) {
                    builder.addTextBody(fieldName, (String)fieldValue);
                    continue;
                }
                if (fieldValue instanceof byte[]) {
                    builder.addBinaryBody(fieldName, (byte[])fieldValue);
                    continue;
                }
                if (fieldValue instanceof FormBinaryField) {
                    FormBinaryField binaryField = (FormBinaryField)fieldValue;
                    builder.addBinaryBody(fieldName, binaryField.getContent(), ContentType.create((String)binaryField.getContentType()), binaryField.getFileName());
                    continue;
                }
                if (fieldValue instanceof File) {
                    builder.addBinaryBody(fieldName, (File)fieldValue);
                    continue;
                }
                if (fieldValue instanceof InputStream) {
                    builder.addBinaryBody(fieldName, (InputStream)fieldValue);
                    continue;
                }
                builder.addTextBody(fieldName, JSONObject.fromObject((Object)fieldValue).toString());
            }
            request = new HttpPost(this.noapi(path));
            request.setEntity(builder.build());
        } else {
            request = new HttpPost(this.noapi(path));
        }
        if (crumbFlag && (crumb = this.get("/crumbIssuer", Crumb.class)) != null) {
            request.addHeader((Header)new BasicHeader(crumb.getCrumbRequestField(), crumb.getCrumb()));
        }
        CloseableHttpResponse response = this.client.execute((HttpUriRequest)request, this.localContext);
        this.getJenkinsVersionFromHeader((HttpResponse)response);
        try {
            this.httpResponseValidator.validateResponse((HttpResponse)response);
        }
        finally {
            EntityUtils.consume((HttpEntity)response.getEntity());
            this.releaseConnection((HttpRequestBase)request);
        }
    }

    public String post_xml(String path, String xml_data) throws IOException {
        return this.post_xml(path, xml_data, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String post_xml(String path, String xml_data, boolean crumbFlag) throws IOException {
        Crumb crumb;
        HttpPost request = new HttpPost(this.api(path));
        if (crumbFlag && (crumb = this.getQuietly("/crumbIssuer", Crumb.class)) != null) {
            request.addHeader((Header)new BasicHeader(crumb.getCrumbRequestField(), crumb.getCrumb()));
        }
        if (xml_data != null) {
            request.setEntity((HttpEntity)new StringEntity(xml_data, ContentType.create((String)"text/xml", (String)"utf-8")));
        }
        CloseableHttpResponse response = this.client.execute((HttpUriRequest)request, this.localContext);
        this.getJenkinsVersionFromHeader((HttpResponse)response);
        try {
            this.httpResponseValidator.validateResponse((HttpResponse)response);
            String string = IOUtils.toString((InputStream)response.getEntity().getContent());
            return string;
        }
        finally {
            EntityUtils.consume((HttpEntity)response.getEntity());
            this.releaseConnection((HttpRequestBase)request);
        }
    }

    public String post_text(String path, String textData, boolean crumbFlag) throws IOException {
        return this.post_text(path, textData, ContentType.DEFAULT_TEXT, crumbFlag);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String post_text(String path, String textData, ContentType contentType, boolean crumbFlag) throws IOException {
        Crumb crumb;
        HttpPost request = new HttpPost(this.api(path));
        if (crumbFlag && (crumb = this.get("/crumbIssuer", Crumb.class)) != null) {
            request.addHeader((Header)new BasicHeader(crumb.getCrumbRequestField(), crumb.getCrumb()));
        }
        if (textData != null) {
            request.setEntity((HttpEntity)new StringEntity(textData, contentType));
        }
        CloseableHttpResponse response = this.client.execute((HttpUriRequest)request, this.localContext);
        this.getJenkinsVersionFromHeader((HttpResponse)response);
        try {
            this.httpResponseValidator.validateResponse((HttpResponse)response);
            String string = IOUtils.toString((InputStream)response.getEntity().getContent());
            return string;
        }
        finally {
            EntityUtils.consume((HttpEntity)response.getEntity());
            this.releaseConnection((HttpRequestBase)request);
        }
    }

    public void post(String path) throws IOException {
        this.post(path, null, null, false);
    }

    public void post(String path, boolean crumbFlag) throws IOException {
        this.post(path, null, null, crumbFlag);
    }

    private String urlJoin(String path1, String path2) {
        if (!path1.endsWith("/")) {
            path1 = path1 + "/";
        }
        if (path2.startsWith("/")) {
            path2 = path2.substring(1);
        }
        return path1 + path2;
    }

    private URI api(String path) {
        if (!path.toLowerCase().matches("https?://.*")) {
            path = this.urlJoin(this.context, path);
        }
        if (!path.contains("?")) {
            path = this.urlJoin(path, "api/json");
        } else {
            String[] components = path.split("\\?", 2);
            path = this.urlJoin(components[0], "api/json") + "?" + components[1];
        }
        return this.uri.resolve("/").resolve(path.replace(" ", "%20"));
    }

    private URI noapi(String path) {
        if (!path.toLowerCase().matches("https?://.*")) {
            path = this.urlJoin(this.context, path);
        }
        return this.uri.resolve("/").resolve(path);
    }

    private <T extends BaseModel> T objectFromResponse(Class<T> cls, HttpResponse response) throws IOException {
        InputStream content = response.getEntity().getContent();
        byte[] bytes = ByteStreams.toByteArray((InputStream)content);
        BaseModel result = (BaseModel)this.mapper.readValue(bytes, cls);
        result.setClient(this);
        return (T)result;
    }

    private ObjectMapper getDefaultMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        return mapper;
    }

    public String getJenkinsVersion() {
        return this.jenkinsVersion;
    }

    private void getJenkinsVersionFromHeader(HttpResponse response) {
        Header[] headers = response.getHeaders("X-Jenkins");
        if (headers.length == 1) {
            this.jenkinsVersion = headers[0].getValue();
        }
    }

    private void releaseConnection(HttpRequestBase httpRequestBase) {
        httpRequestBase.releaseConnection();
    }

    protected static HttpClientBuilder addAuthentication(HttpClientBuilder builder, URI uri, String username, String password) {
        if (StringUtils.isNotBlank((String)username)) {
            BasicCredentialsProvider provider = new BasicCredentialsProvider();
            AuthScope scope = new AuthScope(uri.getHost(), uri.getPort(), "realm");
            UsernamePasswordCredentials credentials = new UsernamePasswordCredentials(username, password);
            provider.setCredentials(scope, (Credentials)credentials);
            builder.setDefaultCredentialsProvider((CredentialsProvider)provider);
            builder.addInterceptorFirst((HttpRequestInterceptor)new PreemptiveAuth());
        }
        return builder;
    }

    protected HttpContext getLocalContext() {
        return this.localContext;
    }

    protected void setLocalContext(HttpContext localContext) {
        this.localContext = localContext;
    }
}

