/*
 * Decompiled with CFR 0.152.
 */
package com.offbytwo.jenkins.model;

import com.google.common.base.Predicate;
import com.google.common.base.Strings;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableMap;
import com.offbytwo.jenkins.helper.BuildConsoleStreamListener;
import com.offbytwo.jenkins.model.Artifact;
import com.offbytwo.jenkins.model.Build;
import com.offbytwo.jenkins.model.BuildCause;
import com.offbytwo.jenkins.model.BuildChangeSet;
import com.offbytwo.jenkins.model.BuildChangeSetAuthor;
import com.offbytwo.jenkins.model.BuildResult;
import com.offbytwo.jenkins.model.ConsoleLog;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.NameValuePair;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BuildWithDetails
extends Build {
    private final Logger LOGGER = LoggerFactory.getLogger(this.getClass());
    public static final String TEXT_SIZE_HEADER = "x-text-size";
    public static final String MORE_DATA_HEADER = "x-more-data";
    public static final BuildWithDetails BUILD_HAS_NEVER_RUN = new BuildWithDetails(){

        @Override
        public List getActions() {
            return Collections.emptyList();
        }

        @Override
        public List<Artifact> getArtifacts() {
            return Collections.emptyList();
        }

        @Override
        public List<BuildCause> getCauses() {
            return Collections.emptyList();
        }

        @Override
        public List<BuildChangeSetAuthor> getCulprits() {
            return Collections.emptyList();
        }

        @Override
        public BuildResult getResult() {
            return BuildResult.NOT_BUILT;
        }
    };
    public static final BuildWithDetails BUILD_HAS_BEEN_CANCELLED = new BuildWithDetails(){

        @Override
        public List getActions() {
            return Collections.emptyList();
        }

        @Override
        public List<Artifact> getArtifacts() {
            return Collections.emptyList();
        }

        @Override
        public List<BuildCause> getCauses() {
            return Collections.emptyList();
        }

        @Override
        public List<BuildChangeSetAuthor> getCulprits() {
            return Collections.emptyList();
        }

        @Override
        public BuildResult getResult() {
            return BuildResult.CANCELLED;
        }
    };
    private List actions;
    private boolean building;
    private String description;
    private String displayName;
    private long duration;
    private long estimatedDuration;
    private String fullDisplayName;
    private String id;
    private long timestamp;
    private BuildResult result;
    private List<Artifact> artifacts;
    private String consoleOutputText;
    private String consoleOutputHtml;
    private BuildChangeSet changeSet;
    private String builtOn;
    private List<BuildChangeSetAuthor> culprits;

    public BuildWithDetails() {
    }

    public BuildWithDetails(BuildWithDetails details) {
        this.actions = details.actions;
        this.description = details.description;
        this.displayName = details.displayName;
        this.building = details.building;
        this.duration = details.duration;
        this.estimatedDuration = details.estimatedDuration;
        this.fullDisplayName = details.fullDisplayName;
        this.id = details.id;
        this.timestamp = details.timestamp;
        this.result = details.result;
        this.artifacts = details.artifacts;
        this.consoleOutputHtml = details.consoleOutputHtml;
        this.consoleOutputText = details.consoleOutputText;
        this.changeSet = details.changeSet;
        this.builtOn = details.builtOn;
        this.culprits = details.culprits;
        this.setClient(details.getClient());
    }

    public List<Artifact> getArtifacts() {
        return this.artifacts;
    }

    public boolean isBuilding() {
        return this.building;
    }

    public List<BuildCause> getCauses() {
        Collection causes = Collections2.filter((Collection)this.actions, (Predicate)new Predicate<Map<String, Object>>(){

            public boolean apply(Map<String, Object> action) {
                return action.containsKey("causes");
            }
        });
        ArrayList<BuildCause> result = new ArrayList<BuildCause>();
        if (causes != null && !causes.isEmpty()) {
            List causes_blob = (List)((Map)causes.toArray()[0]).get("causes");
            for (Map cause : causes_blob) {
                BuildCause convertToBuildCause = this.convertToBuildCause(cause);
                result.add(convertToBuildCause);
            }
        }
        return result;
    }

    public void updateDisplayNameAndDescription(String displayName, String description, boolean crumbFlag) throws IOException {
        Objects.requireNonNull(displayName, "displayName is not allowed to be null.");
        Objects.requireNonNull(description, "description is not allowed to be null.");
        ImmutableMap params = ImmutableMap.of((Object)"displayName", (Object)displayName, (Object)"description", (Object)description, (Object)"core:apply", (Object)"", (Object)"Submit", (Object)"Save");
        this.client.post_form(this.getUrl() + "/configSubmit?", (Map<String, String>)params, crumbFlag);
    }

    public void updateDisplayNameAndDescription(String displayName, String description) throws IOException {
        this.updateDisplayNameAndDescription(displayName, description, false);
    }

    public void updateDisplayName(String displayName, boolean crumbFlag) throws IOException {
        Objects.requireNonNull(displayName, "displayName is not allowed to be null.");
        String description = this.getDescription() == null ? "" : this.getDescription();
        ImmutableMap params = ImmutableMap.of((Object)"displayName", (Object)displayName, (Object)"description", (Object)description, (Object)"core:apply", (Object)"", (Object)"Submit", (Object)"Save");
        this.client.post_form(this.getUrl() + "/configSubmit?", (Map<String, String>)params, crumbFlag);
    }

    public void updateDisplayName(String displayName) throws IOException {
        this.updateDisplayName(displayName, false);
    }

    public void updateDescription(String description, boolean crumbFlag) throws IOException {
        Objects.requireNonNull(description, "description is not allowed to be null.");
        String displayName = this.getDisplayName() == null ? "" : this.getDisplayName();
        ImmutableMap params = ImmutableMap.of((Object)"displayName", (Object)displayName, (Object)"description", (Object)description, (Object)"core:apply", (Object)"", (Object)"Submit", (Object)"Save");
        this.client.post_form(this.getUrl() + "/configSubmit?", (Map<String, String>)params, crumbFlag);
    }

    public void updateDescription(String description) throws IOException {
        this.updateDescription(description, false);
    }

    private BuildCause convertToBuildCause(Map<String, Object> cause) {
        String userName;
        String userId;
        String upstreamProject;
        Integer upstreamBuild;
        BuildCause cause_object = new BuildCause();
        String description = (String)cause.get("shortDescription");
        if (!Strings.isNullOrEmpty((String)description)) {
            cause_object.setShortDescription(description);
        }
        if ((upstreamBuild = (Integer)cause.get("upstreamBuild")) != null) {
            cause_object.setUpstreamBuild(upstreamBuild);
        }
        if (!Strings.isNullOrEmpty((String)(upstreamProject = (String)cause.get("upstreamProject")))) {
            cause_object.setUpstreamProject(upstreamProject);
        }
        String upstreamUrl = (String)cause.get("upstreamUrl");
        if (!Strings.isNullOrEmpty((String)upstreamProject)) {
            cause_object.setUpstreamUrl(upstreamUrl);
        }
        if (!Strings.isNullOrEmpty((String)(userId = (String)cause.get("userId")))) {
            cause_object.setUserId(userId);
        }
        if (!Strings.isNullOrEmpty((String)(userName = (String)cause.get("userName")))) {
            cause_object.setUserName(userName);
        }
        return cause_object;
    }

    public String getDescription() {
        return this.description;
    }

    public long getDuration() {
        return this.duration;
    }

    public long getEstimatedDuration() {
        return this.estimatedDuration;
    }

    public String getFullDisplayName() {
        return this.fullDisplayName;
    }

    public String getDisplayName() {
        return this.displayName;
    }

    public String getId() {
        return this.id;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public BuildResult getResult() {
        return this.result;
    }

    public String getBuiltOn() {
        return this.builtOn;
    }

    public List getActions() {
        return this.actions;
    }

    public Map<String, String> getParameters() {
        Collection parameters = Collections2.filter((Collection)this.actions, (Predicate)new Predicate<Map<String, Object>>(){

            public boolean apply(Map<String, Object> action) {
                return action.containsKey("parameters");
            }
        });
        HashMap<String, String> params = new HashMap<String, String>();
        if (parameters != null && !parameters.isEmpty()) {
            for (Map param : (List)((Map)parameters.toArray()[0]).get("parameters")) {
                String key = (String)param.get("name");
                Object value = param.get("value");
                params.put(key, String.valueOf(value));
            }
        }
        return params;
    }

    public String getConsoleOutputText() throws IOException {
        return this.client.get(this.getUrl() + "/logText/progressiveText");
    }

    public String getConsoleOutputHtml() throws IOException {
        return this.client.get(this.getUrl() + "/logText/progressiveHtml");
    }

    public void streamConsoleOutput(BuildConsoleStreamListener listener, int poolingInterval, int poolingTimeout) throws InterruptedException, IOException {
        block3: {
            long currentTime;
            long startTime = System.currentTimeMillis();
            long timeoutTime = startTime + (long)(poolingTimeout * 1000);
            int bufferOffset = 0;
            do {
                Thread.sleep(poolingInterval * 1000);
                ConsoleLog consoleLog = null;
                consoleLog = this.getConsoleOutputText(bufferOffset);
                String logString = consoleLog.getConsoleLog();
                if (logString != null && !logString.isEmpty()) {
                    listener.onData(logString);
                }
                if (!consoleLog.getHasMoreData().booleanValue()) {
                    listener.finished();
                    break block3;
                }
                bufferOffset = consoleLog.getCurrentBufferSize();
            } while ((currentTime = System.currentTimeMillis()) <= timeoutTime);
            this.LOGGER.warn("Pooling for build {0} for {2} timeout! Check if job stuck in jenkins", (Object)this.getDisplayName(), (Object)this.getNumber());
        }
    }

    public ConsoleLog getConsoleOutputText(int bufferOffset) throws IOException {
        ArrayList<NameValuePair> formData = new ArrayList<NameValuePair>();
        formData.add((NameValuePair)new BasicNameValuePair("start", Integer.toString(bufferOffset)));
        String path = this.getUrl() + "logText/progressiveText";
        HttpResponse httpResponse = this.client.post_form_with_result(path, formData, false);
        Header moreDataHeader = httpResponse.getFirstHeader(MORE_DATA_HEADER);
        Header textSizeHeader = httpResponse.getFirstHeader(TEXT_SIZE_HEADER);
        String response = EntityUtils.toString((HttpEntity)httpResponse.getEntity());
        boolean hasMoreData = false;
        if (moreDataHeader != null) {
            hasMoreData = Boolean.TRUE.toString().equals(moreDataHeader.getValue());
        }
        Integer currentBufferSize = bufferOffset;
        if (textSizeHeader != null) {
            try {
                currentBufferSize = Integer.parseInt(textSizeHeader.getValue());
            }
            catch (NumberFormatException e) {
                this.LOGGER.warn("Cannot parse buffer size for job {0} build {1}. Using current offset!", (Object)this.getDisplayName(), (Object)this.getNumber());
            }
        }
        return new ConsoleLog(response, hasMoreData, currentBufferSize);
    }

    public BuildChangeSet getChangeSet() {
        return this.changeSet;
    }

    public void setChangeSet(BuildChangeSet changeSet) {
        this.changeSet = changeSet;
    }

    public List<BuildChangeSetAuthor> getCulprits() {
        return this.culprits;
    }

    public void setCulprits(List<BuildChangeSetAuthor> culprits) {
        this.culprits = culprits;
    }

    public void setResult(BuildResult result) {
        this.result = result;
    }

    public InputStream downloadArtifact(Artifact a) throws IOException, URISyntaxException {
        URI uri = new URI(this.getUrl());
        String artifactPath = uri.getPath() + "artifact/" + a.getRelativePath();
        URI artifactUri = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), artifactPath, "", "");
        return this.client.getFile(artifactUri);
    }

    @Override
    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BuildWithDetails other = (BuildWithDetails)obj;
        if (this.actions == null ? other.actions != null : !this.actions.equals(other.actions)) {
            return false;
        }
        if (this.artifacts == null ? other.artifacts != null : !this.artifacts.equals(other.artifacts)) {
            return false;
        }
        if (this.building != other.building) {
            return false;
        }
        if (this.builtOn == null ? other.builtOn != null : !this.builtOn.equals(other.builtOn)) {
            return false;
        }
        if (this.changeSet == null ? other.changeSet != null : !this.changeSet.equals(other.changeSet)) {
            return false;
        }
        if (this.consoleOutputHtml == null ? other.consoleOutputHtml != null : !this.consoleOutputHtml.equals(other.consoleOutputHtml)) {
            return false;
        }
        if (this.consoleOutputText == null ? other.consoleOutputText != null : !this.consoleOutputText.equals(other.consoleOutputText)) {
            return false;
        }
        if (this.culprits == null ? other.culprits != null : !this.culprits.equals(other.culprits)) {
            return false;
        }
        if (this.description == null ? other.description != null : !this.description.equals(other.description)) {
            return false;
        }
        if (this.displayName == null ? other.displayName != null : !this.displayName.equals(other.displayName)) {
            return false;
        }
        if (this.duration != other.duration) {
            return false;
        }
        if (this.estimatedDuration != other.estimatedDuration) {
            return false;
        }
        if (this.fullDisplayName == null ? other.fullDisplayName != null : !this.fullDisplayName.equals(other.fullDisplayName)) {
            return false;
        }
        if (this.id == null ? other.id != null : !this.id.equals(other.id)) {
            return false;
        }
        if (this.result != other.result) {
            return false;
        }
        return this.timestamp == other.timestamp;
    }

    @Override
    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.actions == null ? 0 : this.actions.hashCode());
        result = 31 * result + (this.artifacts == null ? 0 : this.artifacts.hashCode());
        result = 31 * result + (this.building ? 1231 : 1237);
        result = 31 * result + (this.builtOn == null ? 0 : this.builtOn.hashCode());
        result = 31 * result + (this.changeSet == null ? 0 : this.changeSet.hashCode());
        result = 31 * result + (this.consoleOutputHtml == null ? 0 : this.consoleOutputHtml.hashCode());
        result = 31 * result + (this.consoleOutputText == null ? 0 : this.consoleOutputText.hashCode());
        result = 31 * result + (this.culprits == null ? 0 : this.culprits.hashCode());
        result = 31 * result + (this.description == null ? 0 : this.description.hashCode());
        result = 31 * result + (this.displayName == null ? 0 : this.displayName.hashCode());
        result = 31 * result + (int)(this.duration ^ this.duration >>> 32);
        result = 31 * result + (int)(this.estimatedDuration ^ this.estimatedDuration >>> 32);
        result = 31 * result + (this.fullDisplayName == null ? 0 : this.fullDisplayName.hashCode());
        result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
        result = 31 * result + (this.result == null ? 0 : this.result.hashCode());
        result = 31 * result + (int)(this.timestamp ^ this.timestamp >>> 32);
        return result;
    }
}

