/*
 * Decompiled with CFR 0.152.
 */
package com.offbytwo.jenkins.model;

import com.google.common.base.Function;
import com.google.common.collect.Collections2;
import com.google.common.escape.Escaper;
import com.google.common.net.UrlEscapers;
import com.offbytwo.jenkins.model.BaseModel;
import com.offbytwo.jenkins.model.ExtractHeader;
import com.offbytwo.jenkins.model.JobWithDetails;
import com.offbytwo.jenkins.model.QueueReference;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang.StringUtils;

public class Job
extends BaseModel {
    private String name;
    private String url;

    public Job() {
    }

    public Job(String name, String url) {
        this();
        this.name = name;
        this.url = url;
    }

    public String getName() {
        return this.name;
    }

    public String getUrl() {
        return this.url;
    }

    public JobWithDetails details() throws IOException {
        return this.client.get(this.url, JobWithDetails.class);
    }

    public String getFileFromWorkspace(String fileName) throws IOException {
        int length;
        InputStream is = this.client.getFile(URI.create(this.url + "/ws/" + fileName));
        ByteArrayOutputStream result = new ByteArrayOutputStream();
        byte[] buffer = new byte[1024];
        while ((length = is.read(buffer)) != -1) {
            result.write(buffer, 0, length);
        }
        return result.toString("UTF-8");
    }

    public QueueReference build() throws IOException {
        ExtractHeader location = this.client.post(this.url + "build", null, ExtractHeader.class, false);
        return new QueueReference(location.getLocation());
    }

    public QueueReference build(boolean crumbFlag) throws IOException {
        ExtractHeader location = this.client.post(this.url + "build", null, ExtractHeader.class, crumbFlag);
        return new QueueReference(location.getLocation());
    }

    public QueueReference build(Map<String, String> params) throws IOException {
        return this.build(params, false);
    }

    public QueueReference build(Map<String, String> params, boolean crumbFlag) throws IOException {
        String qs = StringUtils.join((Collection)Collections2.transform(params.entrySet(), (Function)new MapEntryToQueryStringPair()), (String)"&");
        ExtractHeader location = this.client.post(this.url + "buildWithParameters?" + qs, null, ExtractHeader.class, crumbFlag);
        return new QueueReference(location.getLocation());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Job job = (Job)o;
        if (this.name != null ? !this.name.equals(job.name) : job.name != null) {
            return false;
        }
        return !(this.url != null ? !this.url.equals(job.url) : job.url != null);
    }

    public int hashCode() {
        int result = this.name != null ? this.name.hashCode() : 0;
        result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
        return result;
    }

    private static class MapEntryToQueryStringPair
    implements Function<Map.Entry<String, String>, String> {
        private MapEntryToQueryStringPair() {
        }

        public String apply(Map.Entry<String, String> entry) {
            Escaper escaper = UrlEscapers.urlFormParameterEscaper();
            return escaper.escape(entry.getKey()) + "=" + escaper.escape(entry.getValue());
        }
    }
}

