/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.sync.client;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ConcurrentMap;
import org.jboss.aerogear.sync.BackupShadowDocument;
import org.jboss.aerogear.sync.ClientDocument;
import org.jboss.aerogear.sync.Diff;
import org.jboss.aerogear.sync.Edit;
import org.jboss.aerogear.sync.ShadowDocument;
import org.jboss.aerogear.sync.client.ClientDataStore;

public class ClientInMemoryDataStore<T, S extends Edit<? extends Diff>>
implements ClientDataStore<T, S> {
    private final Queue<S> emptyQueue = new LinkedList<S>();
    private final ConcurrentMap<Id, ClientDocument<T>> documents = new ConcurrentHashMap<Id, ClientDocument<T>>();
    private final ConcurrentMap<Id, ShadowDocument<T>> shadows = new ConcurrentHashMap<Id, ShadowDocument<T>>();
    private final ConcurrentMap<Id, BackupShadowDocument<T>> backups = new ConcurrentHashMap<Id, BackupShadowDocument<T>>();
    private final ConcurrentHashMap<Id, Queue<S>> pendingEdits = new ConcurrentHashMap();

    public void saveShadowDocument(ShadowDocument<T> shadowDocument) {
        this.shadows.put(this.id(shadowDocument.document()), shadowDocument);
    }

    public ShadowDocument<T> getShadowDocument(String documentId, String clientId) {
        return (ShadowDocument)this.shadows.get(ClientInMemoryDataStore.id(documentId, clientId));
    }

    public void saveBackupShadowDocument(BackupShadowDocument<T> backupShadow) {
        this.backups.put(this.id(backupShadow.shadow().document()), backupShadow);
    }

    public BackupShadowDocument<T> getBackupShadowDocument(String documentId, String clientId) {
        return (BackupShadowDocument)this.backups.get(ClientInMemoryDataStore.id(documentId, clientId));
    }

    public void saveClientDocument(ClientDocument<T> document) {
        this.documents.put(this.id(document), document);
    }

    public ClientDocument<T> getClientDocument(String documentId, String clientId) {
        return (ClientDocument)this.documents.get(ClientInMemoryDataStore.id(documentId, clientId));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void saveEdits(S edit, String documentId, String clientId) {
        Id id = ClientInMemoryDataStore.id(documentId, clientId);
        ConcurrentLinkedQueue<S> newEdits = new ConcurrentLinkedQueue<S>();
        while (true) {
            Queue<S> currentEdits;
            if ((currentEdits = this.pendingEdits.get(id)) == null) {
                newEdits.add(edit);
                Queue previous = this.pendingEdits.putIfAbsent(id, newEdits);
                if (previous == null) return;
                newEdits.addAll(previous);
                if (!this.pendingEdits.replace(id, previous, newEdits)) continue;
                return;
            }
            newEdits.addAll(currentEdits);
            newEdits.add(edit);
            if (this.pendingEdits.replace(id, currentEdits, newEdits)) return;
        }
    }

    public void removeEdit(S edit, String documentId, String clientId) {
        Queue<S> currentEdits;
        Id id = ClientInMemoryDataStore.id(documentId, clientId);
        while ((currentEdits = this.pendingEdits.get(id)) != null) {
            ConcurrentLinkedQueue<S> newEdits = new ConcurrentLinkedQueue<S>();
            newEdits.addAll(currentEdits);
            Iterator iter = newEdits.iterator();
            while (iter.hasNext()) {
                Edit oldEdit = (Edit)iter.next();
                if (oldEdit.clientVersion() > edit.clientVersion()) continue;
                iter.remove();
            }
            if (!this.pendingEdits.replace(id, currentEdits, newEdits)) continue;
            break;
        }
    }

    public Queue<S> getEdits(String documentId, String clientId) {
        Queue<S> edits = this.pendingEdits.get(ClientInMemoryDataStore.id(documentId, clientId));
        if (edits == null) {
            return this.emptyQueue;
        }
        return edits;
    }

    public void removeEdits(String documentId, String clientId) {
        this.pendingEdits.remove(ClientInMemoryDataStore.id(documentId, clientId));
    }

    private Id id(ClientDocument<T> document) {
        return ClientInMemoryDataStore.id(document.id(), document.clientId());
    }

    private static Id id(String documentId, String clientId) {
        return new Id(documentId, clientId);
    }

    private static class Id {
        private final String clientId;
        private final String documentId;

        private Id(String documentId, String clientId) {
            this.clientId = clientId;
            this.documentId = documentId;
        }

        public String clientId() {
            return this.clientId;
        }

        public String getDocumentId() {
            return this.documentId;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof Id)) {
                return false;
            }
            Id id = (Id)o;
            if (this.clientId != null ? !this.clientId.equals(id.clientId) : id.clientId != null) {
                return false;
            }
            return this.documentId != null ? this.documentId.equals(id.documentId) : id.documentId == null;
        }

        public int hashCode() {
            int result = this.clientId != null ? this.clientId.hashCode() : 0;
            result = 31 * result + (this.documentId != null ? this.documentId.hashCode() : 0);
            return result;
        }
    }
}

