/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.sync.jsonmergepatch.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.Queue;
import org.jboss.aerogear.sync.ClientDocument;
import org.jboss.aerogear.sync.DefaultClientDocument;
import org.jboss.aerogear.sync.DefaultShadowDocument;
import org.jboss.aerogear.sync.PatchMessage;
import org.jboss.aerogear.sync.ShadowDocument;
import org.jboss.aerogear.sync.client.ClientSynchronizer;
import org.jboss.aerogear.sync.jsonmergepatch.JsonMapper;
import org.jboss.aerogear.sync.jsonmergepatch.JsonMergePatchEdit;
import org.jboss.aerogear.sync.jsonmergepatch.JsonMergePatchMessage;

public class JsonMergePatchClientSynchronizer
implements ClientSynchronizer<JsonNode, JsonMergePatchEdit> {
    private static final String UTF_8 = Charset.forName("UTF-8").displayName();

    public JsonMergePatchEdit clientDiff(ShadowDocument<JsonNode> shadowDocument, ClientDocument<JsonNode> document) {
        JsonNode shadowObject = (JsonNode)shadowDocument.document().content();
        return JsonMergePatchEdit.withPatch((JsonNode)((JsonNode)document.content())).checksum(JsonMergePatchClientSynchronizer.checksum(shadowObject)).build();
    }

    public JsonMergePatchEdit serverDiff(ClientDocument<JsonNode> document, ShadowDocument<JsonNode> shadowDocument) {
        JsonNode shadowObject = (JsonNode)shadowDocument.document().content();
        return JsonMergePatchEdit.withPatch((JsonNode)shadowObject).serverVersion(shadowDocument.serverVersion()).clientVersion(shadowDocument.clientVersion()).checksum(JsonMergePatchClientSynchronizer.checksum(shadowObject)).build();
    }

    public ShadowDocument<JsonNode> patchShadow(JsonMergePatchEdit edit, ShadowDocument<JsonNode> shadowDocument) {
        JsonNode content = JsonMergePatchClientSynchronizer.patch(edit, (JsonNode)shadowDocument.document().content());
        return new DefaultShadowDocument(shadowDocument.serverVersion(), shadowDocument.clientVersion(), (ClientDocument)new DefaultClientDocument(shadowDocument.document().id(), shadowDocument.document().clientId(), (Object)content));
    }

    public ClientDocument<JsonNode> patchDocument(JsonMergePatchEdit edit, ClientDocument<JsonNode> document) {
        JsonNode content = JsonMergePatchClientSynchronizer.patch(edit, (JsonNode)document.content());
        return new DefaultClientDocument(document.id(), document.clientId(), (Object)content);
    }

    public PatchMessage<JsonMergePatchEdit> createPatchMessage(String documentId, String clientId, Queue<JsonMergePatchEdit> edits) {
        return new JsonMergePatchMessage(documentId, clientId, edits);
    }

    public PatchMessage<JsonMergePatchEdit> patchMessageFromJson(String json) {
        return (PatchMessage)JsonMapper.fromJson((String)json, JsonMergePatchMessage.class);
    }

    public void addContent(JsonNode content, ObjectNode objectNode, String fieldName) {
        objectNode.put(fieldName, content);
    }

    private static JsonNode patch(JsonMergePatchEdit edit, JsonNode target) {
        try {
            return edit.diff().jsonMergePatch().apply(target);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String checksum(JsonNode content) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            md.update(content.asText().getBytes(UTF_8));
            return new BigInteger(1, md.digest()).toString(16);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e.getCause());
        }
    }
}

