/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.sync.jsonmergepatch.server;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.fge.jsonpatch.JsonPatchException;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.Queue;
import org.jboss.aerogear.sync.ClientDocument;
import org.jboss.aerogear.sync.DefaultClientDocument;
import org.jboss.aerogear.sync.DefaultDocument;
import org.jboss.aerogear.sync.DefaultShadowDocument;
import org.jboss.aerogear.sync.Document;
import org.jboss.aerogear.sync.PatchMessage;
import org.jboss.aerogear.sync.ShadowDocument;
import org.jboss.aerogear.sync.jsonmergepatch.JsonMapper;
import org.jboss.aerogear.sync.jsonmergepatch.JsonMergePatchEdit;
import org.jboss.aerogear.sync.jsonmergepatch.JsonMergePatchMessage;
import org.jboss.aerogear.sync.server.ServerSynchronizer;

public class JsonMergePatchServerSynchronizer
implements ServerSynchronizer<JsonNode, JsonMergePatchEdit> {
    private static final String UTF_8 = Charset.forName("UTF-8").displayName();

    public JsonMergePatchEdit clientDiff(Document<JsonNode> document, ShadowDocument<JsonNode> shadowDocument) {
        JsonNode shadowObject = (JsonNode)shadowDocument.document().content();
        return JsonMergePatchEdit.withPatch((JsonNode)shadowObject).checksum(JsonMergePatchServerSynchronizer.checksum(shadowObject)).build();
    }

    public JsonMergePatchEdit serverDiff(Document<JsonNode> document, ShadowDocument<JsonNode> shadowDocument) {
        JsonNode shadowObject = (JsonNode)shadowDocument.document().content();
        return JsonMergePatchEdit.withPatch((JsonNode)((JsonNode)document.content())).serverVersion(shadowDocument.serverVersion()).clientVersion(shadowDocument.clientVersion()).checksum(JsonMergePatchServerSynchronizer.checksum(shadowObject)).build();
    }

    public ShadowDocument<JsonNode> patchShadow(JsonMergePatchEdit edit, ShadowDocument<JsonNode> shadowDocument) {
        JsonNode content = JsonMergePatchServerSynchronizer.patch(edit, (JsonNode)shadowDocument.document().content());
        return new DefaultShadowDocument(shadowDocument.serverVersion(), shadowDocument.clientVersion(), (ClientDocument)new DefaultClientDocument(shadowDocument.document().id(), shadowDocument.document().clientId(), (Object)content));
    }

    public Document<JsonNode> patchDocument(JsonMergePatchEdit edit, Document<JsonNode> document) {
        JsonNode content = JsonMergePatchServerSynchronizer.patch(edit, (JsonNode)document.content());
        return new DefaultDocument(document.id(), (Object)content);
    }

    public PatchMessage<JsonMergePatchEdit> createPatchMessage(String documentId, String clientId, Queue<JsonMergePatchEdit> edits) {
        return new JsonMergePatchMessage(documentId, clientId, edits);
    }

    public PatchMessage<JsonMergePatchEdit> patchMessageFromJson(String json) {
        return (PatchMessage)JsonMapper.fromJson((String)json, JsonMergePatchMessage.class);
    }

    public Document<JsonNode> documentFromJson(JsonNode json) {
        return new DefaultDocument(json.get("id").asText(), (Object)json.get("content"));
    }

    private static JsonNode patch(JsonMergePatchEdit edit, JsonNode target) {
        try {
            return edit.diff().jsonMergePatch().apply(target);
        }
        catch (JsonPatchException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String checksum(JsonNode content) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            md.update(content.asText().getBytes(UTF_8));
            return new BigInteger(1, md.digest()).toString(16);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e.getCause());
        }
    }
}

