/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.sync.jsonpatch.client;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.github.fge.jsonpatch.JsonPatch;
import com.github.fge.jsonpatch.diff.JsonDiff;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.util.Queue;
import org.jboss.aerogear.sync.ClientDocument;
import org.jboss.aerogear.sync.DefaultClientDocument;
import org.jboss.aerogear.sync.DefaultShadowDocument;
import org.jboss.aerogear.sync.PatchMessage;
import org.jboss.aerogear.sync.ShadowDocument;
import org.jboss.aerogear.sync.client.ClientSynchronizer;
import org.jboss.aerogear.sync.jsonpatch.JsonMapper;
import org.jboss.aerogear.sync.jsonpatch.JsonPatchEdit;
import org.jboss.aerogear.sync.jsonpatch.JsonPatchMessage;

public class JsonPatchClientSynchronizer
implements ClientSynchronizer<JsonNode, JsonPatchEdit> {
    private static final String UTF_8 = Charset.forName("UTF-8").displayName();

    public JsonPatchEdit clientDiff(ShadowDocument<JsonNode> shadowDocument, ClientDocument<JsonNode> document) {
        JsonNode shadowObject = (JsonNode)shadowDocument.document().content();
        return JsonPatchEdit.withPatch((JsonPatch)JsonDiff.asJsonPatch((JsonNode)((JsonNode)document.content()), (JsonNode)shadowObject)).checksum(JsonPatchClientSynchronizer.checksum(shadowObject)).build();
    }

    public JsonPatchEdit serverDiff(ClientDocument<JsonNode> document, ShadowDocument<JsonNode> shadowDocument) {
        JsonNode shadowObject = (JsonNode)shadowDocument.document().content();
        return JsonPatchEdit.withPatch((JsonPatch)JsonDiff.asJsonPatch((JsonNode)shadowObject, (JsonNode)((JsonNode)document.content()))).serverVersion(shadowDocument.serverVersion()).clientVersion(shadowDocument.clientVersion()).checksum(JsonPatchClientSynchronizer.checksum(shadowObject)).build();
    }

    public ShadowDocument<JsonNode> patchShadow(JsonPatchEdit edit, ShadowDocument<JsonNode> shadowDocument) {
        JsonNode content = JsonPatchClientSynchronizer.patch(edit, (JsonNode)shadowDocument.document().content());
        return new DefaultShadowDocument(shadowDocument.serverVersion(), shadowDocument.clientVersion(), (ClientDocument)new DefaultClientDocument(shadowDocument.document().id(), shadowDocument.document().clientId(), (Object)content));
    }

    public ClientDocument<JsonNode> patchDocument(JsonPatchEdit edit, ClientDocument<JsonNode> document) {
        JsonNode content = JsonPatchClientSynchronizer.patch(edit, (JsonNode)document.content());
        return new DefaultClientDocument(document.id(), document.clientId(), (Object)content);
    }

    public PatchMessage<JsonPatchEdit> createPatchMessage(String documentId, String clientId, Queue<JsonPatchEdit> edits) {
        return new JsonPatchMessage(documentId, clientId, edits);
    }

    public PatchMessage<JsonPatchEdit> patchMessageFromJson(String json) {
        return (PatchMessage)JsonMapper.fromJson((String)json, JsonPatchMessage.class);
    }

    public void addContent(JsonNode content, ObjectNode objectNode, String fieldName) {
        objectNode.put(fieldName, content);
    }

    private static JsonNode patch(JsonPatchEdit edit, JsonNode target) {
        try {
            return edit.diff().jsonPatch().apply(target);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    public static String checksum(JsonNode content) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            md.update(content.asText().getBytes(UTF_8));
            return new BigInteger(1, md.digest()).toString(16);
        }
        catch (Exception e) {
            throw new RuntimeException(e.getMessage(), e.getCause());
        }
    }
}

