/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.sync.server;

import com.fasterxml.jackson.databind.JsonNode;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jboss.aerogear.sync.BackupShadowDocument;
import org.jboss.aerogear.sync.ClientDocument;
import org.jboss.aerogear.sync.DefaultBackupShadowDocument;
import org.jboss.aerogear.sync.DefaultClientDocument;
import org.jboss.aerogear.sync.DefaultShadowDocument;
import org.jboss.aerogear.sync.Diff;
import org.jboss.aerogear.sync.Document;
import org.jboss.aerogear.sync.Edit;
import org.jboss.aerogear.sync.PatchMessage;
import org.jboss.aerogear.sync.ShadowDocument;
import org.jboss.aerogear.sync.server.ServerDataStore;
import org.jboss.aerogear.sync.server.ServerSynchronizer;
import org.jboss.aerogear.sync.server.Subscriber;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerSyncEngine<T, S extends Edit<? extends Diff>> {
    private static final Logger logger = LoggerFactory.getLogger(ServerSyncEngine.class);
    private static final int SEEDED_CLIENT_VERSION = -1;
    private static final int SEEDED_SERVER_VERSION = 1;
    private static final ConcurrentHashMap<String, Set<Subscriber<?>>> subscribers = new ConcurrentHashMap();
    private final ServerSynchronizer<T, S> synchronizer;
    private final ServerDataStore<T, S> dataStore;

    public ServerSyncEngine(ServerSynchronizer<T, S> synchronizer, ServerDataStore<T, S> dataStore) {
        this.synchronizer = synchronizer;
        this.dataStore = dataStore;
    }

    public PatchMessage<S> addSubscriber(Subscriber<?> subscriber, Document<T> document) {
        PatchMessage<S> patchMessage = this.addDocument(document, subscriber.clientId());
        this.connectSubscriber(subscriber, document.id());
        return patchMessage;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void connectSubscriber(Subscriber<?> subscriber, String documentId) {
        Set newSub = Collections.newSetFromMap(new ConcurrentHashMap());
        newSub.add(subscriber);
        while (true) {
            Set<Subscriber<?>> currentClients;
            if ((currentClients = subscribers.get(documentId)) == null) {
                Set previous = subscribers.putIfAbsent(documentId, newSub);
                if (previous == null) continue;
                newSub.addAll(previous);
                if (!subscribers.replace(documentId, previous, newSub)) continue;
                return;
            }
            newSub.addAll(currentClients);
            if (subscribers.replace(documentId, currentClients, newSub)) return;
        }
    }

    public void removeSubscriber(Subscriber<?> subscriber, String documentId) {
        Set<Subscriber<?>> currentClients;
        while ((currentClients = subscribers.get(documentId)) != null && !currentClients.isEmpty()) {
            Set newClients = Collections.newSetFromMap(new ConcurrentHashMap());
            newClients.addAll(currentClients);
            boolean removed = newClients.remove(subscriber);
            if (!removed || !subscribers.replace(documentId, currentClients, newClients)) continue;
            break;
        }
    }

    public Set<Subscriber<?>> getSubscribers(String documentId) {
        return subscribers.get(documentId);
    }

    public S diff(String documentId, String clientId) {
        Document<T> document = this.getDocument(documentId);
        S edit = this.serverDiffs(document, clientId);
        this.diffPatchShadow(this.getShadowDocument(documentId, clientId), edit);
        return edit;
    }

    public PatchMessage<S> patch(PatchMessage<S> patchMessage) {
        ShadowDocument<T> patchedShadow = this.patchShadow(patchMessage);
        this.updateDocument(this.patchDocument(patchedShadow));
        this.saveBackupShadow(patchedShadow);
        return patchMessage;
    }

    public void notifySubscribers(PatchMessage<S> patchMessage) {
        Edit peek = (Edit)patchMessage.edits().peek();
        if (peek == null) {
            return;
        }
        String documentId = patchMessage.documentId();
        Set<Subscriber<?>> subscribers1 = this.getSubscribers(documentId);
        for (Subscriber<?> subscriber : subscribers1) {
            PatchMessage<S> patchMessage1 = this.getPatchMessage(documentId, subscriber.clientId());
            logger.debug("Sending to [" + subscriber.clientId() + "] : " + patchMessage1);
            subscriber.patched(patchMessage1);
        }
    }

    public PatchMessage<S> patchMessageFromJson(String json) {
        return this.synchronizer.patchMessageFromJson(json);
    }

    public Document<T> documentFromJson(JsonNode json) {
        return this.synchronizer.documentFromJson(json);
    }

    public PatchMessage<S> getPatchMessage(String documentId, String clientId) {
        this.diff(documentId, clientId);
        return this.synchronizer.createPatchMessage(documentId, clientId, this.dataStore.getEdits(documentId, clientId));
    }

    private PatchMessage<S> addDocument(Document<T> document, String clientId) {
        if (document.content() == null) {
            Document<T> existingDoc = this.getDocument(document.id());
            if (existingDoc == null) {
                return this.synchronizer.createPatchMessage(document.id(), clientId, this.emptyQueue());
            }
            ShadowDocument<T> shadow = this.addShadowForClient(document.id(), clientId);
            logger.debug("Document with id [" + document.id() + "] already exists.");
            S edit = this.serverDiff((Document<T>)shadow.document(), this.seededShadowFrom(shadow, document));
            this.updateDocument(this.patchDocument(shadow));
            return this.synchronizer.createPatchMessage(document.id(), clientId, this.asQueue(edit));
        }
        boolean newDoc = this.saveDocument(document);
        ShadowDocument<T> shadow = this.addShadowForClient(document.id(), clientId);
        if (newDoc) {
            S edit = this.serverDiff((Document<T>)shadow.document(), this.incrementServerVersion(shadow));
            return this.synchronizer.createPatchMessage(document.id(), clientId, this.asQueue(edit));
        }
        logger.debug("Document with id [" + document.id() + "] already exists.");
        S edit = this.serverDiff((Document<T>)shadow.document(), this.seededShadowFrom(shadow, document));
        return this.synchronizer.createPatchMessage(document.id(), clientId, this.asQueue(edit));
    }

    private ShadowDocument<T> seededShadowFrom(ShadowDocument<T> shadow, Document<T> doc) {
        Document<T> document = doc.content() == null ? this.getDocument(doc.id()) : doc;
        ClientDocument<Object> clientDoc = this.newClientDocument(doc.id(), shadow.document().clientId(), document.content());
        return new DefaultShadowDocument(1L, -1L, clientDoc);
    }

    private void diffPatchShadow(ShadowDocument<T> shadow, S edit) {
        this.saveShadow(this.synchronizer.patchShadow(edit, shadow));
    }

    private ShadowDocument<T> addShadowForClient(String documentId, String clientId) {
        return this.addShadow(documentId, clientId, 0L);
    }

    private ShadowDocument<T> addShadow(String documentId, String clientId, long clientVersion) {
        Document<T> document = this.getDocument(documentId);
        ClientDocument<Object> clientDocument = this.newClientDocument(documentId, clientId, document.content());
        ShadowDocument<Object> shadowDocument = this.newShadowDoc(0L, clientVersion, clientDocument);
        this.saveShadow(shadowDocument);
        this.saveBackupShadow(shadowDocument);
        return shadowDocument;
    }

    private S clientDiffs(Document<T> document, ShadowDocument<T> shadow) {
        return this.clientDiff(document, shadow);
    }

    private S serverDiffs(Document<T> document, String clientId) {
        String documentId = document.id();
        ShadowDocument<T> shadow = this.getShadowDocument(documentId, clientId);
        S newEdit = this.serverDiff(document, shadow);
        this.saveEdits(newEdit, documentId, clientId);
        this.saveShadow(this.incrementServerVersion(shadow));
        return newEdit;
    }

    private ShadowDocument<T> patchShadow(PatchMessage<S> patchMessage) {
        String documentId = patchMessage.documentId();
        String clientId = patchMessage.clientId();
        ShadowDocument<T> shadow = this.getShadowDocument(documentId, clientId);
        Iterator iterator = patchMessage.edits().iterator();
        while (iterator.hasNext()) {
            Edit edit = (Edit)iterator.next();
            if (this.droppedServerPacket(edit, shadow)) {
                shadow = this.restoreBackup(shadow, edit);
                continue;
            }
            if (this.hasClientUpdate(edit, shadow)) {
                this.discardEdit(edit, documentId, clientId, iterator);
                continue;
            }
            if (!this.allVersionMatch(edit, shadow)) continue;
            ShadowDocument patchedShadow = this.synchronizer.patchShadow(edit, shadow);
            shadow = this.saveShadowAndRemoveEdit(this.incrementClientVersion(patchedShadow), edit);
        }
        return shadow;
    }

    private ShadowDocument<T> restoreBackup(ShadowDocument<T> shadow, S edit) {
        String clientId;
        String documentId = shadow.document().id();
        BackupShadowDocument<T> backup = this.getBackupShadowDocument(documentId, clientId = shadow.document().clientId());
        if (this.serverVersionMatch(backup, edit)) {
            ShadowDocument patchedShadow = this.synchronizer.patchShadow(edit, backup.shadow());
            this.dataStore.removeEdits(documentId, clientId);
            return this.saveShadow(this.incrementClientVersion(patchedShadow));
        }
        throw new IllegalStateException(backup + " server version does not match version of " + edit.serverVersion());
    }

    private void discardEdit(S edit, String documentId, String clientId, Iterator<S> iterator) {
        this.dataStore.removeEdit(edit, documentId, clientId);
        iterator.remove();
    }

    private ShadowDocument<T> saveShadowAndRemoveEdit(ShadowDocument<T> shadow, S edit) {
        this.dataStore.removeEdit(edit, shadow.document().id(), shadow.document().clientId());
        return this.saveShadow(shadow);
    }

    private boolean serverVersionMatch(BackupShadowDocument<T> backup, S edit) {
        return backup.version() == edit.serverVersion();
    }

    private boolean droppedServerPacket(S edit, ShadowDocument<T> shadowDocument) {
        return edit.serverVersion() < shadowDocument.serverVersion();
    }

    private boolean hasClientUpdate(S edit, ShadowDocument<T> shadowDocument) {
        return edit.clientVersion() < shadowDocument.clientVersion();
    }

    private boolean allVersionMatch(S edit, ShadowDocument<T> shadowDocument) {
        return edit.serverVersion() == shadowDocument.serverVersion() && edit.clientVersion() == shadowDocument.clientVersion();
    }

    private Document<T> patchDocument(ShadowDocument<T> shadowDocument) {
        Document<T> document = this.getDocument(shadowDocument.document().id());
        S edit = this.clientDiffs(document, shadowDocument);
        Document patched = this.synchronizer.patchDocument(edit, document);
        this.saveDocument(patched);
        logger.info("Patched Document [" + patched.id() + "] content: " + patched.content());
        return patched;
    }

    private Document<T> getDocument(String documentId) {
        return this.dataStore.getDocument(documentId);
    }

    private ClientDocument<T> newClientDocument(String documentId, String clientId, T content) {
        return new DefaultClientDocument(documentId, clientId, content);
    }

    private ShadowDocument<T> getShadowDocument(String documentId, String clientId) {
        return this.dataStore.getShadowDocument(documentId, clientId);
    }

    private BackupShadowDocument<T> getBackupShadowDocument(String documentId, String clientId) {
        return this.dataStore.getBackupShadowDocument(documentId, clientId);
    }

    private S clientDiff(Document<T> doc, ShadowDocument<T> shadow) {
        return (S)this.synchronizer.clientDiff(doc, shadow);
    }

    private S serverDiff(Document<T> doc, ShadowDocument<T> shadow) {
        return (S)this.synchronizer.serverDiff(doc, shadow);
    }

    private void saveEdits(S edit, String documentId, String clientId) {
        this.dataStore.saveEdits(edit, documentId, clientId);
    }

    private ShadowDocument<T> incrementClientVersion(ShadowDocument<T> shadow) {
        long clientVersion = shadow.clientVersion() + 1L;
        return this.newShadowDoc(shadow.serverVersion(), clientVersion, shadow.document());
    }

    private ShadowDocument<T> saveShadow(ShadowDocument<T> newShadow) {
        this.dataStore.saveShadowDocument(newShadow);
        return newShadow;
    }

    private ShadowDocument<T> newShadowDoc(long serverVersion, long clientVersion, ClientDocument<T> doc) {
        return new DefaultShadowDocument(serverVersion, clientVersion, doc);
    }

    private ShadowDocument<T> incrementServerVersion(ShadowDocument<T> shadow) {
        long serverVersion = shadow.serverVersion() + 1L;
        return this.newShadowDoc(serverVersion, shadow.clientVersion(), shadow.document());
    }

    private void saveBackupShadow(ShadowDocument<T> newShadow) {
        this.dataStore.saveBackupShadowDocument((BackupShadowDocument)new DefaultBackupShadowDocument(newShadow.serverVersion(), newShadow));
    }

    private boolean saveDocument(Document<T> document) {
        return this.dataStore.saveDocument(document);
    }

    private void updateDocument(Document<T> document) {
        this.dataStore.updateDocument(document);
    }

    private Queue<S> emptyQueue() {
        return new LinkedList();
    }

    private Queue<S> asQueue(S edit) {
        return new LinkedList<S>(Collections.singleton(edit));
    }
}

