/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush;

import java.net.HttpURLConnection;
import java.net.Proxy;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.logging.Logger;
import net.iharder.Base64;
import org.codehaus.jackson.map.ObjectMapper;
import org.jboss.aerogear.unifiedpush.JavaSender;
import org.jboss.aerogear.unifiedpush.http.HttpClient;
import org.jboss.aerogear.unifiedpush.message.MessageResponseCallback;
import org.jboss.aerogear.unifiedpush.message.UnifiedMessage;
import org.jboss.aerogear.unifiedpush.model.ProxyConfig;
import org.jboss.aerogear.unifiedpush.model.TrustStoreConfig;
import org.jboss.aerogear.unifiedpush.utils.ValidationUtils;

public class SenderClient
implements JavaSender {
    private static final Logger logger = Logger.getLogger(SenderClient.class.getName());
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private String serverURL;
    private ProxyConfig proxy;
    private TrustStoreConfig customTrustStore;

    public SenderClient(String rootServerURL) {
        this.setServerURL(rootServerURL);
    }

    public SenderClient() {
    }

    private SenderClient(Builder builder) {
        this.setServerURL(builder.rootServerURL);
        this.proxy = builder.proxy;
        this.customTrustStore = builder.customTrustStore;
    }

    protected String buildUrl() {
        if (ValidationUtils.isEmpty(this.getServerURL())) {
            throw new IllegalStateException("server can not be null");
        }
        return this.getServerURL() + "rest/sender/";
    }

    @Override
    public void send(UnifiedMessage unifiedMessage, MessageResponseCallback callback) {
        Map<String, Object> payloadObject = this.prepareMessage(unifiedMessage);
        String jsonString = this.toJSONString(payloadObject);
        this.submitPayload(this.buildUrl(), jsonString, unifiedMessage.getPushApplicationId(), unifiedMessage.getMasterSecret(), callback);
    }

    @Override
    public void send(UnifiedMessage unifiedMessage) {
        this.send(unifiedMessage, null);
    }

    private Map<String, Object> prepareMessage(UnifiedMessage unifiedMessage) {
        LinkedHashMap<String, Object> payloadObject = new LinkedHashMap<String, Object>();
        if (!ValidationUtils.isEmpty(unifiedMessage.getAliases())) {
            payloadObject.put("alias", unifiedMessage.getAliases());
        }
        if (!ValidationUtils.isEmpty(unifiedMessage.getCategories())) {
            payloadObject.put("categories", unifiedMessage.getCategories());
        }
        if (!ValidationUtils.isEmpty(unifiedMessage.getDeviceType())) {
            payloadObject.put("deviceType", unifiedMessage.getDeviceType());
        }
        if (!ValidationUtils.isEmpty(unifiedMessage.getVariants())) {
            payloadObject.put("variants", unifiedMessage.getVariants());
        }
        if (!ValidationUtils.isEmpty(unifiedMessage.getAttributes())) {
            payloadObject.put("message", unifiedMessage.getAttributes());
        }
        if (!ValidationUtils.isEmpty(unifiedMessage.getSimplePush())) {
            payloadObject.put("simple-push", unifiedMessage.getSimplePush());
        }
        if (unifiedMessage.getTimeToLive() != null) {
            payloadObject.put("ttl", (int)unifiedMessage.getTimeToLive());
        }
        return payloadObject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitPayload(String url, String jsonPayloadObject, String pushApplicationId, String masterSecret, MessageResponseCallback callback) {
        String credentials = pushApplicationId + ":" + masterSecret;
        int statusCode = 0;
        HttpURLConnection httpURLConnection = null;
        try {
            String encoded = Base64.encodeBytes((byte[])credentials.getBytes(UTF_8));
            httpURLConnection = (HttpURLConnection)HttpClient.post(url, encoded, jsonPayloadObject, UTF_8, this.proxy, this.customTrustStore);
            statusCode = httpURLConnection.getResponseCode();
            logger.info(String.format("HTTP Response code from UnifiedPush Server: %s", statusCode));
            if (this.isRedirect(statusCode)) {
                String redirectURL = httpURLConnection.getHeaderField("Location");
                logger.info(String.format("Performing redirect to '%s'", redirectURL));
                this.submitPayload(redirectURL, jsonPayloadObject, pushApplicationId, masterSecret, callback);
            } else if (callback != null) {
                callback.onComplete(statusCode);
            }
        }
        catch (Exception e) {
            logger.severe("Send did not succeed: " + e.getMessage());
            if (callback != null) {
                callback.onError(e);
            }
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    private boolean isRedirect(int statusCode) {
        return statusCode == 301 || statusCode == 302 || statusCode == 303;
    }

    private String toJSONString(Object value) {
        ObjectMapper om = new ObjectMapper();
        String stringPayload = null;
        try {
            stringPayload = om.writeValueAsString(value);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to encode JSON payload");
        }
        return stringPayload;
    }

    @Override
    public String getServerURL() {
        return this.serverURL;
    }

    public ProxyConfig getProxy() {
        return this.proxy;
    }

    public TrustStoreConfig getCustomTrustStore() {
        return this.customTrustStore;
    }

    @Override
    public void setServerURL(String serverURL) {
        if (ValidationUtils.isEmpty(serverURL)) {
            throw new IllegalStateException("server can not be null");
        }
        if (!serverURL.endsWith("/")) {
            serverURL = serverURL.concat("/");
        }
        this.serverURL = serverURL;
    }

    public static class Builder {
        private String rootServerURL;
        private ProxyConfig proxy;
        private TrustStoreConfig customTrustStore;

        public Builder rootServerURL(String rootServerURL) {
            this.rootServerURL = rootServerURL;
            return this;
        }

        public Builder customTrustStore(String trustStorePath, String trustStoreType, String trustStorePassword) {
            this.customTrustStore = new TrustStoreConfig(trustStorePath, trustStoreType, trustStorePassword);
            return this;
        }

        public Builder proxy(String proxyHost, int proxyPort) {
            if (this.proxy == null) {
                this.proxy = new ProxyConfig(Proxy.Type.HTTP);
            }
            this.proxy.setProxyHost(proxyHost);
            this.proxy.setProxyPort(proxyPort);
            return this;
        }

        public Builder proxyUser(String proxyUser) {
            if (this.proxy == null) {
                this.proxy = new ProxyConfig(Proxy.Type.HTTP);
            }
            this.proxy.setProxyUser(proxyUser);
            return this;
        }

        public Builder proxyPassword(String proxyPassword) {
            if (this.proxy == null) {
                this.proxy = new ProxyConfig(Proxy.Type.HTTP);
            }
            this.proxy.setProxyPassword(proxyPassword);
            return this;
        }

        public Builder proxyType(Proxy.Type proxyType) {
            if (this.proxy == null) {
                this.proxy = new ProxyConfig(Proxy.Type.HTTP);
            }
            this.proxy.setProxyType(proxyType);
            return this;
        }

        public SenderClient build() {
            return new SenderClient(this);
        }
    }
}

