/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class UnifiedMessage {
    private String pushApplicationId;
    private String masterSecret;
    private List<String> variants;
    private List<String> aliases;
    private Map<String, Object> attributes;
    private Set<String> categories;
    private List<String> deviceType;
    private String simplePush;
    private Integer timeToLive;

    private UnifiedMessage(Builder builder) {
        this.attributes = builder.attributes;
        this.aliases = builder.aliases;
        this.variants = builder.variants;
        this.categories = builder.categories;
        this.deviceType = builder.deviceType;
        this.pushApplicationId = builder.pushApplicationId;
        this.masterSecret = builder.masterSecret;
        this.simplePush = builder.simplePush;
        this.timeToLive = builder.timeTolive;
    }

    public String getPushApplicationId() {
        return this.pushApplicationId;
    }

    public String getMasterSecret() {
        return this.masterSecret;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public List<String> getVariants() {
        return this.variants;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public Set<String> getCategories() {
        return this.categories;
    }

    public List<String> getDeviceType() {
        return this.deviceType;
    }

    public String getSimplePush() {
        return this.simplePush;
    }

    public Integer getTimeToLive() {
        return this.timeToLive;
    }

    public static class Builder {
        private String pushApplicationId;
        private String masterSecret;
        private Set<String> categories = new HashSet<String>();
        private String simplePush;
        private Integer timeTolive;
        private List<String> deviceType = new ArrayList<String>();
        private List<String> variants = new ArrayList<String>();
        private List<String> aliases = new ArrayList<String>();
        private Map<String, Object> attributes = new HashMap<String, Object>();
        private final String alert = "alert";
        private final String sound = "sound";
        private final String badge = "badge";
        private final String contentAvailable = "content-available";

        public Builder pushApplicationId(String pushApplicationId) {
            this.pushApplicationId = pushApplicationId;
            return this;
        }

        public Builder masterSecret(String masterSecret) {
            this.masterSecret = masterSecret;
            return this;
        }

        public Builder aliases(List<String> aliases) {
            this.aliases = aliases;
            return this;
        }

        public Builder variants(List<String> variants) {
            this.variants = variants;
            return this;
        }

        public Builder categories(Set<String> categories) {
            this.categories = categories;
            return this;
        }

        public Builder categories(String ... categories) {
            this.categories = new HashSet<String>(Arrays.asList(categories));
            return this;
        }

        public Builder deviceType(List<String> deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        public Builder attributes(Map<String, Object> attributes) {
            this.attributes = attributes;
            return this;
        }

        public Builder attribute(String key, String value) {
            this.attributes.put(key, value);
            return this;
        }

        public Builder alert(String message) {
            this.attributes.put("alert", message);
            return this;
        }

        public Builder sound(String sound) {
            this.attributes.put(this.sound, sound);
            return this;
        }

        public Builder badge(String badge) {
            this.attributes.put(this.badge, Integer.parseInt(badge));
            return this;
        }

        public Builder contentAvailable() {
            this.attributes.put(this.contentAvailable, true);
            return this;
        }

        public Builder simplePush(String version) {
            this.simplePush = this.fixVersion(version);
            return this;
        }

        public Builder timeToLive(int seconds) {
            this.timeTolive = seconds;
            return this;
        }

        public UnifiedMessage build() {
            return new UnifiedMessage(this);
        }

        private String fixVersion(String version) {
            if (version != null && !version.startsWith("version=")) {
                version = "version=" + version;
            }
            return version;
        }
    }
}

