/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush;

import java.util.List;
import java.util.Map;
import org.jboss.aerogear.unifiedpush.Client;
import org.jboss.aerogear.unifiedpush.JavaSender;

public class DefaultJavaSender
implements JavaSender {
    private String serverURL;
    private Client client;

    public DefaultJavaSender(String rootServerURL, Client client) {
        if (rootServerURL == null) {
            throw new IllegalStateException("server can not be null");
        }
        if (!rootServerURL.endsWith("/")) {
            rootServerURL = rootServerURL.concat("/");
        }
        this.serverURL = rootServerURL;
        this.client = client;
    }

    protected StringBuilder buildUrl(String type, String pushApplicationID) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.serverURL).append("rest/sender/").append(type);
        return sb;
    }

    @Override
    public void broadcast(Map<String, ? extends Object> json, String pushApplicationID, String masterSecret) {
        StringBuilder sb = this.buildUrl("broadcast", pushApplicationID);
        this.client.post(json, sb.toString(), pushApplicationID, masterSecret);
    }

    @Override
    public void sendTo(List<String> clientIdentifiers, Map<String, ? extends Object> json, String pushApplicationID, String masterSecret) {
        StringBuilder sb = this.buildUrl("selected", pushApplicationID);
        this.client.post(json, clientIdentifiers, sb.toString(), pushApplicationID, masterSecret);
    }
}

