/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush;

import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.logging.Logger;
import net.iharder.Base64;
import org.codehaus.jackson.map.ObjectMapper;
import org.jboss.aerogear.unifiedpush.JavaSender;
import org.jboss.aerogear.unifiedpush.message.UnifiedMessage;

public class SenderClient
implements JavaSender {
    private static final Logger logger = Logger.getLogger(SenderClient.class.getName());
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private String serverURL;

    public SenderClient(String rootServerURL) {
        if (rootServerURL == null) {
            throw new IllegalStateException("server can not be null");
        }
        this.setServerURL(rootServerURL);
    }

    public SenderClient() {
    }

    protected StringBuilder buildUrl(String type) {
        if (this.serverURL == null) {
            throw new IllegalStateException("server can not be null");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.serverURL).append("rest/sender/").append(type);
        return sb;
    }

    @Override
    public void broadcast(UnifiedMessage unifiedMessage) {
        StringBuilder sb = this.buildUrl("broadcast");
        String payload = this.transformJSON(unifiedMessage.getAttributes());
        this.submitPayload(sb.toString(), payload, unifiedMessage.getPushApplicationId(), unifiedMessage.getMasterSecret());
    }

    @Override
    public void sendTo(UnifiedMessage unifiedMessage) {
        StringBuilder sb = this.buildUrl("selected");
        LinkedHashMap<String, Object> selectedPayloadObject = new LinkedHashMap<String, Object>();
        selectedPayloadObject.put("alias", unifiedMessage.getAliases());
        if (unifiedMessage.getCategory() != null) {
            selectedPayloadObject.put("category", unifiedMessage.getAliases());
        }
        if (!unifiedMessage.getDeviceType().isEmpty()) {
            selectedPayloadObject.put("deviceType", unifiedMessage.getDeviceType());
        }
        if (!unifiedMessage.getVariants().isEmpty()) {
            selectedPayloadObject.put("variants", unifiedMessage.getVariants());
        }
        if (unifiedMessage.getSimplePushMap() != null) {
            selectedPayloadObject.put("simple-push", unifiedMessage.getSimplePushMap());
        }
        selectedPayloadObject.put("message", unifiedMessage.getAttributes());
        String payload = this.transformJSON(selectedPayloadObject);
        this.submitPayload(sb.toString(), payload, unifiedMessage.getPushApplicationId(), unifiedMessage.getMasterSecret());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitPayload(String url, String jsonPayloadObject, String pushApplicationId, String masterSecret) {
        String credentials = pushApplicationId + ":" + masterSecret;
        HttpURLConnection httpURLConnection = null;
        try {
            String encoded = Base64.encodeBytes((byte[])credentials.getBytes(UTF_8));
            httpURLConnection = this.post(url, encoded, jsonPayloadObject);
            int status = httpURLConnection.getResponseCode();
            logger.info(String.format("HTTP Response code form UnifiedPush Server: %s", status));
        }
        catch (MalformedURLException e) {
            logger.severe("Invalid Server URL");
        }
        catch (IOException e) {
            logger.severe("IO Exception");
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpURLConnection post(String url, String encodedCredentials, String jsonPayloadObject) throws IOException {
        if (url == null || encodedCredentials == null || jsonPayloadObject == null) {
            throw new IllegalArgumentException("arguments cannot be null");
        }
        byte[] bytes = jsonPayloadObject.getBytes(UTF_8);
        HttpURLConnection conn = this.getConnection(url);
        conn.setDoOutput(true);
        conn.setUseCaches(false);
        conn.setFixedLengthStreamingMode(bytes.length);
        conn.setRequestProperty("Authorization", "Basic " + encodedCredentials);
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setRequestProperty("Accept", "application/json");
        conn.setRequestMethod("POST");
        OutputStream out = null;
        try {
            out = conn.getOutputStream();
            out.write(bytes);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        return conn;
    }

    private HttpURLConnection getConnection(String url) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        return conn;
    }

    private String transformJSON(Object value) {
        ObjectMapper om = new ObjectMapper();
        String stringPayload = null;
        try {
            stringPayload = om.writeValueAsString(value);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to encode JSON payload");
        }
        return stringPayload;
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public void setServerURL(String serverURL) {
        if (!serverURL.endsWith("/")) {
            serverURL = serverURL.concat("/");
        }
        this.serverURL = serverURL;
    }
}

