/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.message;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jboss.aerogear.unifiedpush.utils.ValidationUtils;

public class UnifiedMessage {
    private String pushApplicationId;
    private String masterSecret;
    private List<String> variants;
    private List<String> aliases;
    private Map<String, Object> attributes;
    private String category;
    private List<String> deviceType;
    private Map<String, String> simplePushMap;

    private UnifiedMessage(Builder builder) {
        this.attributes = builder.attributes;
        this.aliases = builder.aliases;
        this.variants = builder.variants;
        this.category = builder.category;
        this.deviceType = builder.deviceType;
        this.pushApplicationId = builder.pushApplicationId;
        this.masterSecret = builder.masterSecret;
        this.simplePushMap = builder.simplePushMap;
    }

    public String getPushApplicationId() {
        return this.pushApplicationId;
    }

    public String getMasterSecret() {
        return this.masterSecret;
    }

    public List<String> getAliases() {
        return this.aliases;
    }

    public List<String> getVariants() {
        return this.variants;
    }

    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    public String getCategory() {
        return this.category;
    }

    public List<String> getDeviceType() {
        return this.deviceType;
    }

    public Map<String, String> getSimplePushMap() {
        return this.simplePushMap;
    }

    public void setSimplePushMap(Map<String, String> simplePushMap) {
        this.simplePushMap = simplePushMap;
    }

    public static class Builder {
        private String pushApplicationId;
        private String masterSecret;
        private String category;
        private List<String> deviceType = new ArrayList<String>();
        private List<String> variants = new ArrayList<String>();
        private List<String> aliases = new ArrayList<String>();
        private Map<String, Object> attributes = new HashMap<String, Object>();
        private Map<String, String> simplePushMap;
        private final String alert = "alert";
        private final String sound = "sound";
        private final String badge = "badge";
        private final String simplePush = "simple-push";

        public Builder pushApplicationId(String pushApplicationId) {
            this.pushApplicationId = pushApplicationId;
            return this;
        }

        public Builder masterSecret(String masterSecret) {
            this.masterSecret = masterSecret;
            return this;
        }

        public Builder aliases(List<String> aliases) {
            this.aliases = aliases;
            return this;
        }

        public Builder variants(List<String> variants) {
            this.variants = variants;
            return this;
        }

        public Builder category(String category) {
            this.category = category;
            return this;
        }

        public Builder deviceType(List<String> deviceType) {
            this.deviceType = deviceType;
            return this;
        }

        public Builder attributes(Map<String, Object> attributes) {
            this.attributes = attributes;
            return this;
        }

        public Builder attribute(String key, String value) {
            this.attributes.put(key, value);
            return this;
        }

        public Builder alert(String message) {
            this.attributes.put("alert", message);
            return this;
        }

        public Builder sound(String sound) {
            this.attributes.put(this.sound, sound);
            return this;
        }

        public Builder badge(String badge) {
            this.attributes.put(this.badge, Integer.parseInt(badge));
            return this;
        }

        public Builder simplePush(String version) {
            this.attributes.put("simple-push", this.fixVersion(version));
            return this;
        }

        public Builder simplePush(Map<String, String> entries) {
            if (!ValidationUtils.isEmpty(entries)) {
                for (Map.Entry<String, String> entry : entries.entrySet()) {
                    entry.setValue(this.fixVersion(entry.getValue()));
                }
            }
            this.simplePushMap = entries;
            return this;
        }

        public UnifiedMessage build() {
            return new UnifiedMessage(this);
        }

        private String fixVersion(String version) {
            if (version != null && !version.startsWith("version=")) {
                version = "version=" + version;
            }
            return version;
        }
    }
}

