/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush;

import java.io.IOException;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.LinkedHashMap;
import java.util.logging.Logger;
import net.iharder.Base64;
import org.codehaus.jackson.map.ObjectMapper;
import org.jboss.aerogear.unifiedpush.JavaSender;
import org.jboss.aerogear.unifiedpush.message.UnifiedMessage;
import org.jboss.aerogear.unifiedpush.utils.ValidationUtils;

public class SenderClient
implements JavaSender {
    private static final Logger logger = Logger.getLogger(SenderClient.class.getName());
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    private String serverURL;

    public SenderClient(String rootServerURL) {
        if (ValidationUtils.isEmpty(rootServerURL)) {
            throw new IllegalStateException("server can not be null");
        }
        this.setServerURL(rootServerURL);
    }

    public SenderClient() {
    }

    protected StringBuilder buildUrl() {
        if (ValidationUtils.isEmpty(this.serverURL)) {
            throw new IllegalStateException("server can not be null");
        }
        StringBuilder sb = new StringBuilder();
        sb.append(this.serverURL).append("rest/sender/");
        return sb;
    }

    @Override
    public void send(UnifiedMessage unifiedMessage) {
        StringBuilder sb = this.buildUrl();
        LinkedHashMap<String, Object> selectedPayloadObject = new LinkedHashMap<String, Object>();
        if (!ValidationUtils.isEmpty(unifiedMessage.getAliases())) {
            selectedPayloadObject.put("alias", unifiedMessage.getAliases());
        }
        if (!ValidationUtils.isEmpty(unifiedMessage.getCategory())) {
            selectedPayloadObject.put("category", unifiedMessage.getCategory());
        }
        if (!ValidationUtils.isEmpty(unifiedMessage.getDeviceType())) {
            selectedPayloadObject.put("deviceType", unifiedMessage.getDeviceType());
        }
        if (!ValidationUtils.isEmpty(unifiedMessage.getVariants())) {
            selectedPayloadObject.put("variants", unifiedMessage.getVariants());
        }
        if (!ValidationUtils.isEmpty(unifiedMessage.getSimplePushMap())) {
            selectedPayloadObject.put("simple-push", unifiedMessage.getSimplePushMap());
        }
        if (!ValidationUtils.isEmpty(unifiedMessage.getAttributes())) {
            selectedPayloadObject.put("message", unifiedMessage.getAttributes());
        }
        String payload = this.transformJSON(selectedPayloadObject);
        this.submitPayload(sb.toString(), payload, unifiedMessage.getPushApplicationId(), unifiedMessage.getMasterSecret());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void submitPayload(String url, String jsonPayloadObject, String pushApplicationId, String masterSecret) {
        String credentials = pushApplicationId + ":" + masterSecret;
        HttpURLConnection httpURLConnection = null;
        try {
            String encoded = Base64.encodeBytes((byte[])credentials.getBytes(UTF_8));
            httpURLConnection = this.post(url, encoded, jsonPayloadObject);
            int statusCode = httpURLConnection.getResponseCode();
            logger.info(String.format("HTTP Response code form UnifiedPush Server: %s", statusCode));
            logger.info("To: " + url);
            if (this.isRedirect(statusCode)) {
                String redirectURL = httpURLConnection.getHeaderField("Location");
                logger.info(String.format("Performing redirect to '%s'", redirectURL));
                this.submitPayload(redirectURL, jsonPayloadObject, pushApplicationId, masterSecret);
            }
        }
        catch (MalformedURLException e) {
            logger.severe("Invalid Server URL");
        }
        catch (IOException e) {
            logger.severe("IO Exception");
        }
        finally {
            if (httpURLConnection != null) {
                httpURLConnection.disconnect();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HttpURLConnection post(String url, String encodedCredentials, String jsonPayloadObject) throws IOException {
        if (url == null || encodedCredentials == null || jsonPayloadObject == null) {
            throw new IllegalArgumentException("arguments cannot be null");
        }
        byte[] bytes = jsonPayloadObject.getBytes(UTF_8);
        HttpURLConnection conn = this.getConnection(url);
        conn.setDoOutput(true);
        conn.setUseCaches(false);
        conn.setFixedLengthStreamingMode(bytes.length);
        conn.setRequestProperty("Authorization", "Basic " + encodedCredentials);
        conn.setRequestProperty("Content-Type", "application/json");
        conn.setRequestProperty("Accept", "application/json");
        conn.setRequestMethod("POST");
        OutputStream out = null;
        try {
            out = conn.getOutputStream();
            out.write(bytes);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
        return conn;
    }

    private HttpURLConnection getConnection(String url) throws IOException {
        HttpURLConnection conn = (HttpURLConnection)new URL(url).openConnection();
        return conn;
    }

    private boolean isRedirect(int statusCode) {
        return statusCode == 301 || statusCode == 302 || statusCode == 303;
    }

    private String transformJSON(Object value) {
        ObjectMapper om = new ObjectMapper();
        String stringPayload = null;
        try {
            stringPayload = om.writeValueAsString(value);
        }
        catch (Exception e) {
            throw new IllegalStateException("Failed to encode JSON payload");
        }
        return stringPayload;
    }

    public String getServerURL() {
        return this.serverURL;
    }

    public void setServerURL(String serverURL) {
        if (!serverURL.endsWith("/")) {
            serverURL = serverURL.concat("/");
        }
        this.serverURL = serverURL;
    }
}

