"use strict";var UPS=function(){var app=angular.module("upsConsole",["upsConsole.services","ngResource","ngRoute","ui.bootstrap","ups.directives","patternfly.notification","patternfly.autofocus","hljs"]),auth={};angular.element(document).ready(function(){var keycloakAuth=new Keycloak("config/keycloak.json");auth.loggedIn=!1,keycloakAuth.init({onLoad:"login-required"}).success(function(){auth.loggedIn=!0,auth.authz=keycloakAuth,auth.logoutUrl=keycloakAuth.authServerUrl+"/realms/aerogear/tokens/logout?redirect_uri="+window.location.href,app.factory("Auth",function(){return auth}),angular.bootstrap(document,["upsConsole"])}).error(function(){window.location.reload()})});var logout=function(){auth.loggedIn=!1,auth.authz=null,window.location=auth.logoutUrl};return app.factory("Auth",function(){return auth}),app.config(function($routeProvider){$routeProvider.when("/applications",{templateUrl:"views/applications.html",controller:"ApplicationController",resolve:{applications:function(pushApplication){return pushApplication.query().$promise}},section:"applications",crumb:{id:"apps",label:"Applications"}}).when("/detail/:applicationId",{templateUrl:"views/detail.html",controller:"DetailController",resolve:{application:function($route,pushApplication){return pushApplication.get({appId:$route.current.params.applicationId}).$promise},counts:function($route,pushApplication){return pushApplication.count({appId:$route.current.params.applicationId}).$promise}},section:"applications",crumb:{id:"app-detail",parent:"apps",label:'$ application.name ? application.name : "Current Application"'}}).when("/:applicationId/installations/:variantId",{templateUrl:"views/installation.html",controller:"InstallationController",section:"applications",crumb:{parent:"app-detail",label:'$ variant.name ? variant.name : "Registering Installations"'}}).when("/example/:applicationId/:variantType/:variantId",{templateUrl:"views/example.html",controller:"ExampleController",section:"applications",crumb:{parent:"app-detail",label:"Example"}}).when("/example/:applicationId/:variantType",{templateUrl:"views/example.html",controller:"ExampleController",section:"applications",crumb:{parent:"app-detail",label:"Example"}}).when("/compose",{templateUrl:"views/compose-app.html",controller:"PreComposeController",resolve:{applications:function(pushApplication){return pushApplication.query({}).$promise}},section:"compose",crumb:{label:"Send Push"}}).when("/compose/:applicationId",{templateUrl:"views/compose.html",controller:"ComposeController",section:"compose",crumb:{parent:"app-detail",label:"Send Push"}}).when("/dashboard",{templateUrl:"views/dashboard.html",controller:"DashboardController",resolve:{totals:function(dashboard){return dashboard.totals({}).$promise},warnings:function(dashboard){return dashboard.warnings({}).$promise},topThree:function(dashboard){return dashboard.topThree({}).$promise}},section:"dashboard",crumb:{id:"dash",label:"Dashboard"}}).when("/activity/:applicationId",{templateUrl:"views/notification.html",controller:"ActivityController",section:"dashboard",crumb:{id:"activity",parent:"dash",label:'$ application.name ? application.name : "Current Application"'}}).when("/activity/:applicationId/:variantId",{templateUrl:"views/notification.html",controller:"ActivityController",section:"dashboard",crumb:{parent:"activity",label:'$ variant.name ? variant.name : "Current variant"'}}).otherwise({redirectTo:"/dashboard"})}),app.factory("authInterceptor",function($q,Auth){return{request:function(config){var deferred=$q.defer();return"rest/sender"===config.url?config:(Auth.authz&&Auth.authz.token&&Auth.authz.updateToken(5).success(function(){config.headers=config.headers||{},config.headers.Authorization="Bearer "+Auth.authz.token,deferred.resolve(config)}).error(function(){window.location.reload()}),deferred.promise)}}}),app.config(function($httpProvider){$httpProvider.interceptors.push("authInterceptor")}),{logout:logout}}();!function($){$(document).on("click",'.dropdown.open a[role="menuitem"]',function(){$(".dropdown.open").removeClass("open")})}($),angular.module("upsConsole").controller("RootController",function($rootScope,Auth){$rootScope.isViewLoading=!1,$rootScope.username=Auth.authz.idToken.preferred_username,$rootScope.accountManagement=function(){window.location=Auth.authz.authServerUrl+"/realms/aerogear/account?referrer=unified-push-server-js"},$rootScope.$on("$routeChangeStart",function(){$rootScope.isViewLoading=!0}),$rootScope.$on("$routeChangeSuccess",function(event,routeData){$rootScope.isViewLoading=!1,routeData.$$route&&routeData.$$route.section&&($rootScope.section=routeData.$$route.section)})}),angular.module("upsConsole").controller("ApplicationController",function($rootScope,$scope,$modal,pushApplication,Notifications,applications){function modalController($scope,$modalInstance,application){$scope.application=application,$scope.ok=function(application){$modalInstance.close(application)},$scope.cancel=function(){$modalInstance.dismiss("cancel")}}function show(application,template){return $modal.open({templateUrl:"views/dialogs/"+template,controller:modalController,resolve:{application:function(){return application}}})}$scope.alerts=[],$scope.applications=applications,$rootScope.application=null,$scope.open=function(application){var modalInstance=show(application,"create-app.html");modalInstance.result.then(function(application){pushApplication.create(application,function(newApp){$scope.applications.push(newApp),Notifications.success('Successfully created application "'+newApp.name+'".')},function(){Notifications.error("Something went wrong...","danger")})})},$scope.edit=function(application){var modalInstance=show(application,"create-app.html");modalInstance.result.then(function(application){var updateApplication={name:application.name,description:application.description};pushApplication.update({appId:application.pushApplicationID},updateApplication,function(){Notifications.success('Successfully edited application "'+application.name+'".')})})},$scope.remove=function(application){var modalInstance=show(application,"remove-app.html");modalInstance.result.then(function(){pushApplication.remove({appId:application.pushApplicationID},function(){$scope.applications.splice($scope.applications.indexOf(application),1),Notifications.success('Successfully removed application "'+application.name+'".')})})}}),angular.module("upsConsole").controller("DetailController",function($rootScope,$scope,$routeParams,$location,$modal,pushApplication,variants,Notifications,breadcrumbs,application,counts,ContextProvider,metrics){function modalController($scope,$modalInstance,variant){$scope.variant=variant,$scope.variant||($scope.variant={}),$scope.variant.certificates=[],$scope.ok=function(variant){$modalInstance.close({variant:variant})},$scope.cancel=function(){$modalInstance.dismiss("cancel")}}function show(variant,template){return $modal.open({templateUrl:"views/dialogs/"+template,controller:modalController,resolve:{variant:function(){return variant}}})}function variantProperties(variant){var properties=["name","description"],result={};switch(variant.type){case"android":properties=properties.concat(["projectNumber","googleKey"]);break;case"simplePush":properties=properties.concat([]);break;case"chrome":properties=properties.concat(["clientId","clientSecret","refreshToken"]);break;case"ios":variant.certificates&&variant.certificates.length&&(variant.certificate=variant.certificates[0]),properties=properties.concat(["production","passphrase","certificate"]);var formData=new FormData;return properties.forEach(function(property){formData.append(property,variant[property]||"")}),formData;default:Notifications.error("Unknown variant type "+variant.type)}return properties.forEach(function(property){result[property]=variant[property]}),result}$rootScope.application=application,$scope.counts=counts,breadcrumbs.generateBreadcrumbs(),$scope.currentLocation=ContextProvider.contextPath(),metrics.application({id:$routeParams.applicationId},function(data){angular.forEach(data,function(warning){angular.forEach(application.variants,function(variant){warning.variantInformations.length&&variant.variantID===warning.variantInformations[0].variantID&&!warning.variantInformations[0].deliveryStatus&&(variant.hasError=!0,variant.error=warning.variantInformations[0].reason)})})}),$scope.addVariant=function(variant){var modalInstance=show(variant,"create-variant.html");modalInstance.result.then(function(result){var variantData=variantProperties(result.variant),params=angular.extend({},{appId:$scope.application.pushApplicationID,variantType:result.variant.type}),createFunction=variantData instanceof FormData?variants.createWithFormData:variants.create;createFunction(params,variantData,function(newVariant){for(var length=application.variants.length,i=0;length>i&&newVariant.type!==application.variants[i].type;i++);$scope.application.variants.splice(i,0,newVariant),Notifications.success("Successfully created variant")},function(){Notifications.error("Something went wrong...")})})},$scope.editVariant=function(variant){var modalInstance=show(variant,"create-variant.html");modalInstance.result.then(function(result){var variantDataUpdate=variantProperties(variant),params=angular.extend({},{appId:$scope.application.pushApplicationID,variantType:result.variant.type,variantId:result.variant.variantID}),successCallback=function(){Notifications.success("Successfully modified variant")},failureCallback=function(){Notifications.error("Something went wrong...")};"ios"!==variant.type?variants.update(params,variantDataUpdate,successCallback,failureCallback):variantDataUpdate.certificate?variants.updateWithFormData(params,variantDataUpdate,successCallback,failureCallback):variants.patch(params,{name:variant.name,description:variant.description},successCallback,failureCallback)})},$scope.removeVariant=function(variant){var modalInstance=show(variant,"remove-variant.html");modalInstance.result.then(function(result){var params=angular.extend({},{appId:$scope.application.pushApplicationID,variantType:result.variant.type,variantId:result.variant.variantID});variants.remove(params,function(){var osVariants=$scope.application.variants;osVariants.splice(osVariants.indexOf(variant),1),Notifications.success("Successfully removed variant")},function(){Notifications.error("Something went wrong...")})})},$scope.renewMasterSecret=function(){var modalInstance=show(null,"renew-master-secret.html");modalInstance.result.then(function(){var app=$scope.application;pushApplication.reset({appId:app.pushApplicationID},function(application){$scope.application.masterSecret=application.masterSecret,Notifications.success('Successfully renewed master secret for "'+app.name+'"')})})},$scope.renewVariantSecret=function(variant){var modalInstance=show(null,"renew-variant-secret.html");modalInstance.result.then(function(){var app=$scope.application,params={appId:app.pushApplicationID,variantType:variant.type,variantId:variant.variantID};variants.reset(params,function(updatedVariant){variant.secret=updatedVariant.secret,Notifications.success('Successfully renewed secret for variant "'+updatedVariant.name+'"')})})}}),angular.module("upsConsole").controller("InstallationController",function($rootScope,$scope,$routeParams,installations,$sce){function fetchInstallations(pageNo){installations.get({variantId:$routeParams.variantId,page:pageNo-1,per_page:10},function(data,responseHeaders){$scope.installations=data,$scope.totalItems=responseHeaders("total")})}$scope.currentPage=1,$scope.expand=function(installation){installation.expand=!installation.expand},$scope.isCollapsed=function(installation){return!installation.expand},$scope.pageChanged=function(){fetchInstallations($scope.currentPage)},$scope.wrapText=function(text){var width=80,block="<br/>";if(text.length>width){var left=text.substring(0,width),right=text.substring(width+1);return $sce.trustAsHtml(left+block+$scope.wrapText(right))}return $sce.trustAsHtml(text)},$scope.update=function(installation){delete installation.expand;var params={variantId:$routeParams.variantId,installationId:installation.id};installation.enabled=!installation.enabled,installations.update(params,installation)},fetchInstallations(1)}),angular.module("upsConsole").controller("ExampleController",function($rootScope,$scope,$routeParams,variants,pushApplication,ContextProvider){function Tab(tabName){this.name=tabName}var params={appId:$routeParams.applicationId,variantType:$routeParams.variantType,variantId:$routeParams.variantId};$scope.variantType=$routeParams.variantType,$scope.applicationId=$routeParams.applicationId,"undefined"!=typeof $routeParams.variantId?variants.get(params,function(variant){$scope.variant=variant,$scope.currentLocation=ContextProvider.contextPath()}):pushApplication.get(params,function(application){$scope.application=application});var activeTab=$routeParams.variantType,tabs={};Object.defineProperty(Tab.prototype,"active",{get:function(){return activeTab===this.name},set:function(active){active&&(activeTab=this.name)}}),$scope.tab=function(tabName){return tabs[tabName]||(tabs[tabName]=new Tab(tabName)),tabs[tabName]},$scope.projectNumber=function(variant){return variant?"android"===$scope.variantType?'senderID: "'+variant.projectNumber+'",':"":void 0},$scope.simplePushUrl=function(){var parser=document.createElement("a");return parser.href=ContextProvider.contextPath(),parser.protocol+"//"+parser.hostname+":8443/simplePush"}}),angular.module("upsConsole").controller("ComposeController",function($rootScope,$scope,$routeParams,$modal,$http,pushApplication,Notifications,messageSender){function modalController($scope,$modalInstance,application,variantSelection,criteria){$scope.variantSelection=variantSelection,$scope.criteria=criteria,$scope.application=application,$scope.ok=function(application){$modalInstance.close(application)},$scope.cancel=function(){$modalInstance.dismiss("cancel")},$scope.toggleSelection=function(variant){var idx=$scope.variantSelection.indexOf(variant);idx>-1?$scope.variantSelection.splice(idx,1):$scope.variantSelection.push(variant)}}function show(application,template){return $modal.open({templateUrl:"views/dialogs/"+template,controller:modalController,resolve:{application:function(){return application},variantSelection:function(){return $scope.variantSelection},criteria:function(){return $scope.criteria}}})}$scope.variantSelection=[],$scope.criteria=[],$scope.pushData={message:{sound:"default",alert:""}},$rootScope.application||pushApplication.get({appId:$routeParams.applicationId},function(application){$rootScope.application=application}),$scope.sendMessage=function(){var pushData=$scope.pushData;if(pushData.alias=void 0,pushData.deviceType=void 0,pushData.categories=void 0,pushData.variants=void 0,$scope.variantSelection.length>0){pushData.variants=[];for(var variant in $scope.variantSelection)pushData.variants.push($scope.variantSelection[variant].variantID)}$scope.criteria.alias&&(pushData.alias=$scope.criteria.alias.split(",")),$scope.criteria.deviceType&&(pushData.deviceType=$scope.criteria.deviceType.split(",")),$scope.criteria.categories&&(pushData.categories=$scope.criteria.categories.split(",")),$http.defaults.headers.common.Authorization="Basic "+btoa($rootScope.application.pushApplicationID+":"+$rootScope.application.masterSecret),messageSender.send({},pushData,function(){Notifications.success("Successfully sent Notification"),$scope.pushData.message.alert=""},function(){Notifications.error("Something went wrong...","danger")})},$scope.changeVariant=function(application){var originalVariantSelection=[];originalVariantSelection=$scope.variantSelection.slice(0);var modalInstance=show(application,"filter-variants.html");modalInstance.result.then(function(){},function(){$scope.variantSelection=originalVariantSelection})},$scope.changeCriteria=function(application){var originalCriteria={alias:angular.copy($scope.criteria.alias),deviceType:angular.copy($scope.criteria.deviceType),categories:angular.copy($scope.criteria.categories)},modalInstance=show(application,"add-criteria.html");modalInstance.result.then(function(){},function(){$scope.criteria=originalCriteria})}}),angular.module("upsConsole").controller("PreComposeController",function($rootScope,$scope,$location,applications){$rootScope.application&&!$scope.applicationChosen&&$location.path("/compose/"+$rootScope.application.pushApplicationID),$scope.applications=applications,$scope.setApplication=function(application){$rootScope.application=application,$scope.applicationChosen=!!application}}),angular.module("upsConsole").controller("DashboardController",function($rootScope,$scope,dashboard,totals,warnings,topThree){$rootScope.application=null,$scope.dashboardData=totals,$scope.warnings=warnings,$scope.topThree=topThree}),angular.module("upsConsole").controller("ActivityController",function($scope,$rootScope,$routeParams,$modal,metrics,pushApplication,breadcrumbs){function forAllVariants(application,variantId,closure){angular.forEach(application.variants,function(variant){variant.variantID===variantId&&closure(variant)})}function onDetailsPage(){return"undefined"!=typeof $routeParams.variantId}function fetchVariantsMetrics(pageNo){metrics.variant({id:$routeParams.variantId,page:pageNo-1,per_page:10,sort:"desc"},function(data,responseHeaders){$scope.totalItems=responseHeaders("total"),$scope.pushMetrics=data,angular.forEach(data,function(metric){metric.totalReceivers=metric.variantInformations[0].receivers,metric.deliveryFailed=!metric.variantInformations[0].deliveryStatus})})}function fetchApplicationMetrics(pageNo){metrics.application({id:$routeParams.applicationId,page:pageNo-1,per_page:10,sort:"desc"},function(data,responseHeaders){function totalReceivers(data){angular.forEach(data,function(metric){angular.forEach(metric.variantInformations,function(variant){variant.deliveryStatus||(metric.deliveryFailed=!0)})})}$scope.totalItems=responseHeaders("total"),$scope.pushMetrics=data,totalReceivers(data)})}function fetch(){onDetailsPage()?fetchVariantsMetrics($scope.currentPage):fetchApplicationMetrics($scope.currentPage)}$scope.applicationId=$routeParams.applicationId,$scope.currentPage=1,pushApplication.get({appId:$routeParams.applicationId},function(application){$rootScope.application=application,"undefined"!=typeof $routeParams.variantId&&forAllVariants(application,$routeParams.variantId,function(variant){$rootScope.variant=variant}),breadcrumbs.generateBreadcrumbs()}),$scope.pageChanged=function(){fetch()},fetch(),$scope.variantMetricInformation=function(metrics){return angular.forEach(metrics,function(variantInfo){forAllVariants($rootScope.application,variantInfo.variantID,function(variant){variantInfo.name=variant.name})}),metrics},$scope.detailsPage=function(){return onDetailsPage()},$scope.expand=function(metric){metric.expand=!metric.expand},$scope.isCollapsed=function(metric){return!metric.expand},$scope.parse=function(metric){try{return JSON.parse(metric.rawJsonMessage)}catch(err){return{}}},$scope.showFullRequest=function(rawJsonMessage){$modal.open({templateUrl:"views/dialogs/request.html",controller:function($scope,$modalInstance,request){$scope.request=request,$scope.cancel=function(){$modalInstance.dismiss("cancel")}},resolve:{request:function(){return JSON.stringify(JSON.parse(rawJsonMessage),null,4)}}})}});var backendMod=angular.module("upsConsole.services",[]).value("version","0.1");backendMod.factory("pushApplication",function($resource){return $resource("rest/applications/:appId/:verb",{appId:"@appId"},{get:{method:"GET"},query:{method:"GET",isArray:!0},create:{method:"POST"},update:{method:"PUT"},"delete":{method:"DELETE"},count:{method:"GET",params:{verb:"count"}},reset:{method:"PUT",params:{verb:"reset"}}})}),backendMod.factory("variants",function($resource){return $resource("rest/applications/:appId/:variantType/:variantId/:verb",{appId:"@appId",variantType:"@variantType",variantId:"@variantId"},{get:{method:"GET"},query:{method:"GET",isArray:!0},create:{method:"POST"},update:{method:"PUT"},"delete":{method:"DELETE"},patch:{method:"PATCH"},createWithFormData:{method:"POST",headers:{"Content-Type":void 0},withCredentials:!0,transformRequest:angular.identity},updateWithFormData:{method:"PUT",headers:{"Content-Type":void 0},withCredentials:!0,transformRequest:angular.identity},reset:{method:"PUT",params:{verb:"reset"}}})}),backendMod.factory("messageSender",function($resource){return $resource("rest/sender",{},{send:{method:"POST",headers:{"aerogear-sender":"AeroGear UnifiedPush Console"}}})}),backendMod.factory("installations",function($resource){return $resource("rest/applications/:variantId/installations/:installationId",{variantId:"@variantId",installationId:"@installationId"},{get:{method:"GET",isArray:!0},update:{method:"PUT"}})}),backendMod.factory("dashboard",function($resource){return $resource("rest/metrics/dashboard/:verb",{},{totals:{method:"GET"},warnings:{method:"GET",isArray:!0,params:{verb:"warnings"}},topThree:{method:"GET",isArray:!0,params:{verb:"active"}}})}),backendMod.factory("metrics",function($resource){return $resource("rest/metrics/messages/:verb/:id",{id:"@id"},{application:{method:"GET",isArray:!0,params:{verb:"application"}},variant:{method:"GET",isArray:!0,params:{verb:"variant"}}})}),backendMod.factory("breadcrumbs",function($rootScope,$route){var BreadcrumbService={breadcrumbs:[],routes:{},get:function(){return this.breadcrumbs},init:function(){var self=this;angular.forEach($route.routes,function(route){route.crumb&&(self.routes[route.crumb.id]=route)})},generateBreadcrumbs:function(){var parent,self=this,getRoute=function(route){if($route.current){var param;return angular.forEach($route.current.params,function(value,key){-1!==route.indexOf(key)&&(param=value),param&&(route=route.replace(":"+key,value))}),route}},label=function(route){return-1!==route.crumb.label.indexOf("$")?$rootScope.$eval(route.crumb.label.substring(1)):route.crumb.label};if(this.breadcrumbs=[],$route.current&&$route.current.crumb){for(self.breadcrumbs.push({label:label($route.current),path:$route.current.path}),parent=$route.current.crumb.parent;parent;){var route=self.routes[parent];route.path=getRoute(route.originalPath),self.breadcrumbs.push({label:label(route),path:route.path}),parent=route.crumb.parent}self.breadcrumbs.reverse()}}};return $rootScope.$on("$routeChangeSuccess",function(){BreadcrumbService.generateBreadcrumbs()}),BreadcrumbService.init(),BreadcrumbService.generateBreadcrumbs(),BreadcrumbService}),angular.module("upsConsole.services").config(function($httpProvider){$httpProvider.interceptors.push(function($q,$interpolate,Notifications){return{responseError:function(rejection){var expression=$interpolate("Server returned {{status}}: {{statusText}}");return Notifications.error(expression(rejection)),$q.reject(rejection)}}})}),angular.module("upsConsole.services").factory("ContextProvider",function($location){return{contextPath:function(){var href=$location.absUrl();return href=href.split("#",1).join(""),href=href.split("?",1).join("")}}}),$.idleTimeout("#idletimeout","#idletimeout a",{idleAfter:300,pollingInterval:60,serverResponseEquals:"",failedRequests:1,onTimeout:function(){UPS.logout(),$(this).slideUp()},onIdle:function(){$(this).slideDown()},onCountdown:function(counter){$(this).find("span").html(counter)},onResume:function(){$(this).slideUp()}}),angular.module("ups.directives",["upsConsole.services"]).directive("upsNavigation",function(){return{scope:{current:"@"},restrict:"E",replace:!0,templateUrl:"directives/ups-navigation.html"}}).directive("upsBreadcrumb",function(){return{templateUrl:"directives/ups-breadcrumb.html",controller:function($scope,$compile,breadcrumbs){$scope.breadcrumbs=breadcrumbs}}}).directive("variant",function(){return{scope:{variant:"=",counts:"=",renewSecret:"&onRenew"},controller:function($rootScope,$scope,$routeParams,ContextProvider){$scope.expand=function(variant){variant.expand=!variant.expand},$scope.isCollapsed=function(variant){return!variant.expand},$scope.editVariant=function(variant,type){$scope.$parent.editVariant(variant,type)},$scope.removeVariant=function(variant,type){$scope.$parent.removeVariant(variant,type)},$scope.applicationId=$routeParams.applicationId,$scope.currentLocation=ContextProvider.contextPath(),$scope.currentVariant=function(variant){$rootScope.variant=variant}},templateUrl:"directives/variant-details.html"}}).directive("upsFiles",function(){return{scope:{files:"=upsFiles"},restrict:"A",replace:!1,link:function($scope,$element){$element.bind("change",function(e){for(;$scope.files.length>0;)$scope.files.pop();for(var i in e.target.files)"object"==typeof e.target.files[i]&&$scope.files.push(e.target.files[i])})}}}).directive("upsPluralize",function(){return{scope:{noun:"@",count:"=",zero:"@"},restrict:"E",template:'<span ng-show="count > 0"><strong>{{count}}</strong> {{ noun }}<span ng-show="count > 1">s</span></span><span ng-show="count == 0">{{zero ? zero : "No"}} {{ noun }}s</span>'}});