angular.module("upsConsole").run(["$templateCache",function($templateCache){"use strict";$templateCache.put("directives/ups-breadcrumb.html",'<ol class="breadcrumb">\n    <li ng-repeat="breadcrumb in breadcrumbs.get() track by breadcrumb.path" ng-class="{ active: $last }">\n        <a ng-if="!$last" ng-href="#{{ breadcrumb.path }}" ng-bind="breadcrumb.label" class="margin-right-xs"></a>\n        <span ng-if="$last" ng-bind="breadcrumb.label"></span>\n    </li>\n</ol>\n'),$templateCache.put("directives/ups-navigation.html",'<aside class="lo-sidebar ups-sidebar col-md-2 fixed clearfix ng-isolate-scope"\n       data-lo-current="storage" data-lo-apps="applications" data-lo-app="curApp">\n\n  <nav class="navbar navbar-vertical" role="navigation">\n    <div class="bs-sidebar">\n      <ul>\n        <li ng-class="{active: current == \'dashboard\'}" class="stats">\n          <a href="#/dashboard">\n            <i class="fa fa-tachometer fa-3x"></i>Dashboard\n          </a>\n        </li>\n        <li ng-class="{active: current == \'applications\'}">\n          <a href="#/applications">\n            <i class="fa fa-th fa-3x"></i>Applications\n          </a>\n        </li>\n        <li ng-class="{active: current == \'compose\'}">\n          <a href="#/compose">\n            <i class="fa fa-send-o fa-3x"></i>Send Push\n          </a>\n        </li>\n      </ul>\n    </div>\n  </nav>\n</aside>\n'),$templateCache.put("directives/variant-details.html",'<ul class="list-group " style="margin-bottom: 0">\n    <li class="list-group-item" style="border: 0; margin-left: 10px">\n        <a class="clickable" ng-click="expand(variant)">\n            <i class="fa" ng-class="{\'fa-plus-square-o\': isCollapsed(variant), \'fa-minus-square-o\': !isCollapsed(variant)}"></i> {{ variant.name }}\n        </a>\n        <span>{{ variant.description }}</span>\n        <div class="pull-left" style="margin-left: -20px">\n          <a role="menuitem" ng-click="editVariant(variant, variant.type)" ng-show="variant.hasError" title="reason: {{ variant.error }}">\n            <i class="fa fa-warning"></i>\n          </a>\n        </div>\n        <div class="pull-right dropdown">\n            <span>\n                <span ng-show="!counts[variant.variantID]">No installations</span>\n                <span ng-show="counts[variant.variantID]">\n                    <strong>\n                        <a href="#/{{applicationId}}/installations/{{variant.variantID}}" ng-click="currentVariant(variant)">\n                            {{ counts[variant.variantID] }}\n                        </a>\n                    </strong>\n                    <ng-pluralize count="counts[variant.variantID]" when="{ \'one\' : \'installation\', \'other\': \'installations\'}"></ng-pluralize>\n                </span>\n            </span>\n\n            <a data-toggle="dropdown" class="dropdown-toggle" href="#"><i class="fa fa-cog"></i> <i class="fa fa-caret-down"></i></a>\n            <ul class="dropdown-menu">\n                <li><a role="menuitem" ng-click="editVariant(variant, variant.type)">Edit...</a></li>\n                <li><a role="menuitem" href="#/activity/{{applicationId}}/{{variant.variantID}}">Activity</a></li>\n                <li role="presentation" class="divider"></li>\n                <li><a role="menuitem" ng-click="removeVariant(variant, variant.type)">Remove...</a></li>\n            </ul>\n        </div>\n        <div class="ups-toggle-box" collapse="isCollapsed(variant)">\n            <div class="ups-panel-details">\n                <h3>Push Network Details</h3>\n                <p ng-show="variant.type == \'ios\'">Apple\'s Push Network (APNs) will be used.\n                To learn more about APNs, visit our <a href="http://aerogear.org/docs/unifiedpush/aerogear-push-ios/">iOS</a>\n                or <a href="http://aerogear.org/docs/guides/aerogear-cordova/AerogearCordovaPush/">Apache Cordova</a> guides for push.\n                </p>\n                <p ng-show="variant.type == \'android\'">Google\'s Cloud Messaging Network (GCM) will be used.\n                To learn more about GCM, visit our <a href="http://aerogear.org/docs/unifiedpush/aerogear-push-android/">Android</a>\n                or <a href="http://aerogear.org/docs/guides/aerogear-cordova/AerogearCordovaPush/">Apache Cordova</a> guides for push.\n                </p>\n                <p ng-show="variant.type == \'chrome\'">Google\'s Cloud Messaging Network (GCM) will be used.\n                To learn more about Chrome Apps, visit our <a href="http://aerogear.org/docs/unifiedpush/aerogear-push-chrome/">Chrome Push guide</a>.\n                </p>\n                <p ng-show="variant.type == \'simplePush\'">A Server implementing the <em>SimplePush</em> protocol will be used.\n                More information can be found in <a href="https://wiki.mozilla.org/WebAPI/SimplePush/Protocol">SimplePush Protocol Draft</a>.\n                The <a href="https://github.com/aerogear/aerogear-simplepush-quickstart">AeroGears\' SimplePush Quickstart</a> also contains useful information.\n                </p>\n                <hr class="spacer-15" />\n                <table ng-show="variant.projectNumber.length">\n                    <tr><td>Project Number:</td><td>{{ variant.projectNumber }}</td></tr>\n                    <tr><td>Google API Key:</td><td>{{ variant.googleKey }}</td></tr>\n                </table>\n                <table ng-show="variant.production != undefined">\n                    <tr><td>Type:</td><td>{{ variant.production ? \'Production\' : \'Development\' }}</td></tr>\n                </table>\n                <table ng-show="variant.clientId.length">\n                    <tr><td>Client Id:</td><td>{{ variant.clientId }}</td></tr>\n                    <tr><td>Client Secret:</td><td>{{ variant.clientSecret }}</td></tr>\n                    <tr><td>Refresh Token:</td><td>{{ variant.refreshToken }}</td></tr>\n                </table>\n            </div>\n            <hr class="spacer-15" />\n            <div class="ups-tip-panel">\n                <div class="ups-tip-panel-illustration ups-registering-installations"></div>\n                <div class="ups-tip-panel-body">\n                    <h2>Registering installations\n                        <div class="pull-right dropdown">\n                            <a href="#/example/{{applicationId}}/{{variant.type}}/{{variant.variantID}}" class="ups-tip-panel-link">Example implementation</a>\n                            <a data-toggle="dropdown" class="dropdown-toggle" href="#"><i class="fa fa-cog"></i>  <i class="fa fa-caret-down"></i></a>\n                            <ul class="dropdown-menu">\n                                <li><a role="menuitem" ng-click="renewSecret()">Renew Secret...</a></li>\n                            </ul>\n                        </div>\n                    </h2>\n                    <table class="ups-tip-panel-details">\n                        <tr><td>Server URL:</td><td>\n                          <input type="text" class="transparent" readonly value="{{ currentLocation }}">\n                        </td></tr>\n                        <tr><td>Variant ID:</td><td>\n                          <input type="text" class="transparent" readonly value="{{ variant.variantID }}">\n                        </td></tr>\n                        <tr><td>Secret: </td><td>\n                          <input type="text" class="transparent" readonly value="{{ variant.secret }}">\n                        </td></tr>\n                    </table>\n                </div>\n                <div style="clearfix"></div>\n            </div>\n        </div>\n    </li>\n</ul>'),$templateCache.put("views/applications.html",'<div class="col-md-10 lo-main-pane ng-scope">\n    <div class="row">\n        <div class="lo-content-area col-md-12">\n            <h2>Applications</h2>\n\n            <div class="lo-page-info">\n                <p>\n                    You have <ups-pluralize noun="application" zero="no" count="applications.length"></ups-pluralize>.\n                </p>\n\n                <div class="pull-right">\n                    <button class="btn btn-primary btn-lg" type="button" ng-click="open()">Create Application</button>\n                </div>\n            </div>\n            <div class="panel panel-default lo-panel lo-panel-storage" ng-repeat="application in applications">\n                <div class="panel-heading">\n                    <h3 class="panel-title"><a href="#/detail/{{application.pushApplicationID}}">{{ application.name }}</a></h3>\n                    <div class="dropdown">\n                        <a class="dropdown-toggle">\n                            <i class="fa fa-cog"></i> <i class="fa fa-caret-down"></i></b>\n                        </a>\n                        <ul class="dropdown-menu pull-right">\n                            <li><a role="menuitem" tabindex="-1" ng-click="edit(application)">Edit...</a></li>\n                            <li class="divider"></li>\n                            <li><a role="menuitem" tabindex="-1" ng-click="remove(application)">Remove...</a></li>\n                        </ul>\n                    </div>\n                </div>\n                <div class="panel-body">\n                    <p ng-show="application.description.length"><em>&ldquo;{{ application.description }}&rdquo;</em><br><br></p>\n                    <ul class="lo-app-opts">\n                      <li><i class="fa fa-cubes"></i><a href="#/detail/{{application.pushApplicationID}}"><ups-pluralize noun="variant" count="application.variants.length"></ups-pluralize></a></li>\n                      <li><i class="fa fa-tachometer"></i><a href="#/activity/{{application.pushApplicationID}}">Activity</a></li>\n                      <li><i class="fa fa-send"></i><a href="#/compose/{{ application.pushApplicationID }}">Send Push</a></li>\n                    </ul>\n                </div>\n            </div>\n        </div>\n    </div>\n</div>\n'),$templateCache.put("views/compose-app.html",'<div class="col-md-10 lo-main-pane ng-scope">\n  <div class="row">\n    <div class="lo-content-area col-md-12">\n      <div ups-breadcrumb/>\n      <h2>Select application to send to</h2>\n      <br>\n\n      <form class="form-horizontal">\n        <div class="form-group">\n          <label class="col-sm-2 control-label" for="select">Application</label>\n\n          <div class="col-sm-10">\n            <select class="form-control" id="select" ng-model="application"\n                    ng-options="app.name for app in applications" ng-change="setApplication(application)">\n              <option value="">-- choose application --</option>\n            </select>\n          </div>\n        </div>\n      </form>\n\n      <div ng-if="applicationChosen">\n        <div ng-include="\'views/include/compose.html\'" ng-controller="ComposeController"></div>\n      </div>\n    </div>\n  </div>\n</div>\n'),$templateCache.put("views/compose.html",'<div class="col-md-10 lo-main-pane ng-scope">\n  <div class="row">\n    <div class="lo-content-area col-md-12">\n      <div ups-breadcrumb/>\n      <h2>Send push to &ldquo;<strong>{{ application.name }}</strong>&rdquo; installations</h2>\n      <br>\n\n      <div ng-include="\'views/include/compose.html\'"></div>\n\n    </div>\n  </div>\n</div>'),$templateCache.put("views/dashboard.html",'<div class="col-md-10 lo-main-pane">\n  <div class="lo-content-area col-md-12">\n\n\n    <div class="dash col-md-12">\n\n    <h2>Welcome!</h2>\n      <div class="panel ups-panel pull-left ups-padding-box expand">\n        <div class="pull-left ups-padding-box">\n          <div class="pull-left dashboard active-apps">\n            <i class="fa fa-list-alt"></i>&nbsp; {{ dashboardData.applications }}&nbsp;\n          </div>\n          <div class="pull-left">applications\n            <br>active\n          </div>\n        </div>\n        <div class="pull-left ups-padding-box">\n          <div class="pull-left dashboard notifications">\n            <i class="fa fa-send"></i>&nbsp; {{ dashboardData.messages }}&nbsp;\n          </div>\n          <div class="pull-left">\n            notifications\n            <br>delivered\n          </div>\n        </div>\n        <div class="pull-left ups-padding-box">\n          <div class="pull-left dashboard installations">\n            <i class="fa fa-tablet"></i>&nbsp; {{ dashboardData.devices }}&nbsp;\n          </div>\n          <div class="pull-left">installations\n            <br>registered\n          </div>\n        </div>\n      </div>\n      <div class="clearfix"></div>\n    </div>\n\n    <div class="row">\n      <div class="dash col-md-6">\n        <div class="panel lo-panel ups-panel-variants">\n          <div class="panel-heading">\n            <div class="pull-left">\n              <h2>Warnings</h2>\n            </div>\n            <div class="pull-right">\n              <span></span>\n            </div>\n            <div class="clearfix"></div>\n          </div>\n          <ul class="list-group ">\n            <li class="list-group-item" ng-repeat="warning in warnings">\n              <i class="fa fa-warning"></i> {{ warning.applicationName }} &raquo; {{ warning.variant.name }}\n              <a class="pull-right" href="#/activity/{{warning.applicationID}}/{{warning.variant.variantID}}">\n                Activity &raquo;\n              </a>\n            </li>\n            <li class="list-group-item" ng-hide="warnings.length">\n              <i class="fa fa-check-circle"></i>&nbsp; No problems detected currently.\n            </li>\n          </ul>\n        </div>\n\n      </div>\n      <div class="dash col-md-6">\n\n        <div class="panel lo-panel ups-panel-variants">\n          <div class="panel-heading">\n            <div class="pull-left">\n              <h2>Recent Activity</h2>\n            </div>\n            <div class="pull-right">\n              <span ng-show="topThree.length">Number of receivers</span>\n            </div>\n            <div class="clearfix"></div>\n          </div>\n          <ul class="list-group " id="recent-activity">\n            <li class="list-group-item" ng-repeat="top in topThree">\n              <a href="#/activity/{{top.id}}">\n                {{ top.name }} &nbsp; ({{ top.submittedDate | date : \'d MMM, HH:mm:ss, yyyy\' }})\n              </a>\n              <div class="pull-right">{{ top.totalReceivers}}</div>\n            </li>\n            <li class="list-group-item" ng-hide="topThree.length">\n              No notifications have yet been sent.\n            </li>\n          </ul>\n        </div>\n\n      </div>\n\n    </div>\n\n  </div>\n</div>\n'),$templateCache.put("views/detail.html",'<div class="col-md-10 lo-main-pane ng-scope">\n    <div class="row">\n        <div class="lo-content-area col-md-12">\n            <div ups-breadcrumb/>\n\n            <div class="lo-page-info">\n                <p ng-show="application.description.length"><em>&ldquo;{{ application.description }}&rdquo;</em></p>\n                <div style="clear: both;"></div>\n            </div>\n\n            <div class="ups-tip-panel">\n                <div class="ups-tip-panel-illustration ups-sending-notifications"></div>\n                <div class="ups-tip-panel-body">\n                    <h2>Sending push notifications\n                        <div class="pull-right dropdown">\n                            <a href="#/example/{{application.pushApplicationID}}/send" class="ups-tip-panel-link">Example implementation</a>\n\n                            <a data-toggle="dropdown" class="dropdown-toggle" href="#"><i class="fa fa-cog"></i> <i class="fa fa-caret-down"></i></a>\n                            <ul class="dropdown-menu">\n                                <li><a role="menuitem" ng-click="renewMasterSecret()">Renew Master Secret...</a></li>\n                            </ul>\n                        </div>\n                    </h2>\n                    <table class="ups-tip-panel-details">\n                        <tr>\n                            <td>Server URL:</td>\n                            <td>\n                              <input type="text" class="transparent" readonly value="{{ currentLocation }}">\n                            </td>\n                        </tr>\n                        <tr>\n                            <td>Application ID:</td>\n                            <td>\n                              <input type="text" class="transparent" readonly value="{{ application.pushApplicationID }}">\n                            </td>\n                        </tr>\n                        <tr>\n                            <td>Master Secret:</td>\n                            <td>\n                              <input type="text" class="transparent" readonly value="{{ application.masterSecret }}">\n                            </td>\n                        </tr>\n                    </table>\n                </div>\n                <div style="clear: both;"></div>\n            </div>\n\n            <h2>Variants</h2>\n\n            <div class="lo-page-info">\n                <p>\n                    You have <ups-pluralize noun="variant" count="application.variants.length"></ups-pluralize>.\n                </p>\n                <div class="pull-right">\n                    <button class="btn btn-primary btn-lg" type="button" ng-click="addVariant()">Add Variant</button>\n                </div>\n\n                <div style="clear: both;"></div>\n            </div>\n\n            <div ng-class="{\'panel lo-panel ups-panel-variants\': true, \'new-line\': application.variants[$index + 1].type == variant.type}" ng-repeat="variant in application.variants">\n              <div class="ups-panel-variants {{variant.type}}" ng-if="application.variants[$index - 1].type != variant.type">\n                <div class="panel-heading">\n                  <div class="pull-left">\n                    <h2 style="text-transform: capitalize" ng-if="variant.type != \'ios\'">{{variant.type}}</h2>\n                    <h2 ng-if="variant.type == \'ios\'">iOS</h2>\n                  </div>\n                  <div class="pull-right">\n                    <ups-pluralize noun="installation" count="counts[variant.type]" ></ups-pluralize>\n                  </div>\n                  <div class="clearfix"></div>\n                </div>\n\n              </div>\n\n              <variant variant="variant" counts="counts" on-renew="renewVariantSecret(variant)"></variant>\n              <div ng-class="{bottom: application.variants[$index + 1].type != variant.type}"></div>\n            </div>\n        </div>\n    </div>\n  <div style="clearfix"></div>\n</div>\n'),$templateCache.put("views/example.html",'<div class="col-md-10 lo-main-pane ng-scope">\n    <div class="row">\n        <div class="lo-content-area col-md-12">\n            <div ups-breadcrumb/>\n\n            <h1>Example:\n                <span ng-hide="variantType != \'send\'">Sending push notifications</span>\n                <span ng-show="variantType != \'send\'">Register devices for receiving notifications</span>\n            </h1>\n\n            <p ng-hide="variantType != \'send\'">Make your backend server send push notifications through this UnifiedPush Server.</p>\n\n            <p ng-show="variantType != \'send\'">Use the code snippet bellow to register your device and allow it to receiving notifications through this UnifiedPush Server.</p>\n\n            <tabset class="ups-code-examples">\n                <tab heading="Simple push" ng-hide="variantType != \'simplePush\'" active="tab(\'simplePush\').active">\n                    <div class="ups-code-block js" hljs compile="true">\n(function() {\n     var endpoint, endpointRequest, SPClient, UPClient;\n\n     // config params for UnifiedPush server\n     var variantId = "{{ variant.variantID }}";\n     var variantSecret = "{{ variant.secret }}";\n     var unifiedPushUrl = "{{ currentLocation }}";\n\n      // If your SimplePush Server is running on Openshift, the URL is {{ simplePushUrl() }}\n      // If your SimplePush Server is using Mozilla\'s network, the URL will be wss://push.services.mozilla.com\n      // or do you run a custom server?\n     var simplePushUrl = "[URL of the SimplePush Server you are using]";\n\n      // create the \'UnifiedPush\' client object:\n     UPClient = AeroGear.UnifiedPushClient(variantId, variantSecret, unifiedPushUrl);\n\n     // onConnect callback function called when SimplePush\n     // successfully establishes connection to the server\n     function spConnect() {\n\n         // use \'PushManager\' to request a new PushServer URL endpoint for \'Mail\' notifications:\n         endpointRequest = navigator.push.register();\n          // the DOMRequest returns \'successfully\':\n         endpointRequest.onsuccess = function( event ) {\n             // extract the endpoint object from the event:\n             endpoint = event.target.result;\n\n             // if it is the first registration, need to register\n             // the \'pushEndpoint\' with the UnifiedPush server.\n             if ( endpoint ) {\n                 // assemble the metadata for registration with the UnifiedPush server\n                 var metadata = {\n                     deviceToken: endpoint\n                 };\n\n                 var settings = {\n                     success: function() {\n                        //success handler\n                     },\n                     error: function() {\n                        //error handler\n                     }\n                 };\n\n                 settings.metadata = metadata;\n\n                 // register with the server\n                 UPClient.registerWithPushServer(settings);\n             } else {\n                 console.log("\'Endpoint\' was already registered!");\n             }\n         };\n         // set the notification handler:\n         navigator.setMessageHandler( "push", function( message ) {\n             if ( message.pushEndpoint === endpoint ) {\n                 // let\'s react on the endpoint\n             }\n         });\n     }\n\n     // onClose callback function:\n     function spClose() {\n         // handle onclose - e.g. allow reconnect\n     }\n\n     SPClient = AeroGear.SimplePushClient({\n         simplePushServerURL: simplePushUrl,\n         onConnect: spConnect,\n         onClose: spClose\n    });\n })();\n                    </div>\n                </tab>\n                <tab heading="Chrome" ng-hide="variantType != \'chrome\'" active="tab(\'chrome\').active">\n                    <div class="ups-code-block js" hljs compile="true">\nchrome.pushMessaging.getChannelId( true, function(channelId) {\n    /*\n        Set our Variant ID and Secret and the location of the UnifiedPush Server\n    */\n    var variantId = "{{ variant.variantID }}",\n        variantSecret = "{{ variant.secret }}",\n        pushServerURL = "{{ currentLocation }}";\n\n    // Once we have the channelID we can then register with the UnifiedPush Server using\n    // the AeroGear.js library\n    var client = AeroGear.UnifiedPushClient(\n            variantId,\n            variantSecret,\n            pushServerURL\n        ),settings = {};\n        // The channelId will be the "device token"\n\n    settings.metadata = {\n        deviceToken: channelId.channelId\n    };\n\n    // Register with the UnifiedPush Server\n    client.registerWithPushServer( settings );\n\n});\n                    </div>\n                </tab>\n                <tab heading="Android" ng-hide="variantType != \'android\'" active="tab(\'android\').active" ng-click="tab(\'android\').active = true">\n <div class="ups-code-block java" hljs compile="true">\npackage com.push.pushapplication;\n\nimport java.net.URI;\nimport java.net.URISyntaxException;\n\nimport org.jboss.aerogear.android.unifiedpush.PushConfig;\nimport org.jboss.aerogear.android.unifiedpush.PushRegistrar;\nimport org.jboss.aerogear.android.unifiedpush.Registrations;\n\nimport android.app.Application;\n\npublic class PushApplication extends Application {\n\n    private final String VARIANT_ID       = "{{ variant.variantID }}";\n    private final String SECRET           = "{{ variant.secret }}";\n    private final String GCM_SENDER_ID    = "{{ variant.projectNumber }}";\n    private final String UNIFIED_PUSH_URL = "{{ currentLocation }}";\n\n    private PushRegistrar registration;\n\n    @Override\n    public void onCreate() {\n        super.onCreate();\n\n        Registrations registrations = new Registrations();\n\n        try {\n            PushConfig config = new PushConfig(new URI(UNIFIED_PUSH_URL), GCM_SENDER_ID);\n            config.setVariantID(VARIANT_ID);\n            config.setSecret(SECRET);\n            config.setAlias(MY_ALIAS);\n\n            registration = registrations.push("unifiedpush", config);\n\n            registration.register(getApplicationContext(), new Callback() {\n                private static final long serialVersionUID = 1L;\n\n                @Override\n                public void onSuccess(Void ignore) {\n                     Toast.makeText(MainActivity.this, "Registration Succeeded!",\n                             Toast.LENGTH_LONG).show();\n               }\n\n               @Override\n               public void onFailure(Exception exception) {\n                     Log.e("MainActivity", exception.getMessage(), exception);\n               }\n            });\n\n        } catch (URISyntaxException e) {\n            throw new RuntimeException(e);\n        }\n    }\n}\n</div>\n                </tab>\n                <tab heading="iOS - Objective-C" ng-hide="variantType != \'ios\'" active="tab(\'ios\').active" ng-click="tab(\'ios\').active = true">\n                    <div class="ups-code-block" hljs compile="true" language="objectivec" include="\'objectivec\'"></div>\n                    <script type="text/ng-template" id="objectivec">\n- (void)application:(UIApplication *)application\n didRegisterForRemoteNotificationsWithDeviceToken:(NSData *)deviceToken {\n   NSLog(@"APNS Success")\n\n   AGDeviceRegistration *registration =\n     [[AGDeviceRegistration alloc] initWithServerURL:\n        [NSURL URLWithString:@"{{ currentLocation }}"]];\n\n   [registration registerWithClientInfo:^(id clientInfo) {\n     \n     // apply the token, to identify this device\n     [clientInfo setDeviceToken:deviceToken];\n\n     [clientInfo setVariantID:@"{{ variant.variantID }}"];\n     [clientInfo setVariantSecret:@"{{ variant.secret }}"];\n\n     // --optional config--\n     // set some \'useful\' hardware information params\n     UIDevice *currentDevice = [UIDevice currentDevice];\n     [clientInfo setOperatingSystem:[currentDevice systemName]];\n     [clientInfo setOsVersion:[currentDevice systemVersion]];\n     [clientInfo setDeviceType: [currentDevice model]];\n\n     } success:^() {\n       NSLog(@"UPS registration worked");\n\n     } failure:^(NSError *error) {\n       NSLog(@"UPS registration Error: %@", error);\n   }];\n }\n                  </script>\n\n                </tab>\n                <tab heading="iOS - Swift" ng-hide="variantType != \'ios\'" active="tab(\'iOSSwift\').active" ng-click="tab(\'iOSSwift\').active = true">\n                    <div class="ups-code-block" hljs compile="true" language="objectivec" include="\'swift\'"></div>\n                    <script type="text/ng-template" id="swift">\nfunc application(application: UIApplication!, didRegisterForRemoteNotificationsWithDeviceToken deviceToken: NSData!) {\n    println("APNS Success")\n\n    let registration = AGDeviceRegistration(serverURL: NSURL(string: "{{ currentLocation }}"))\n\n    registration.registerWithClientInfo({ (clientInfo: AGClientDeviceInformation!)  in\n        \n        // apply the token, to identify this device\n        clientInfo.deviceToken = deviceToken\n\n        clientInfo.variantID = "{{ variant.variantID }}"\n        clientInfo.variantSecret = "{{ variant.secret }}"\n\n        // --optional config--\n        // set some \'useful\' hardware information params\n        let currentDevice = UIDevice()        \n        clientInfo.operatingSystem = currentDevice.systemName\n        clientInfo.osVersion = currentDevice.systemVersion\n        clientInfo.deviceType = currentDevice.model\n\n    }, success: {\n        println("UPS registration worked");\n\n    }, failure: { (error:NSError!) -> () in\n        println("UPS registration Error: \\(error.localizedDescription)")\n    })\n}\n                    </script>\n\n                </tab>\n                <tab heading="Cordova" ng-hide="variantType == \'chrome\' || variantType == \'simplePush\' || variantType == \'send\'"\n                     active="tab(\'cordova\').active" ng-click="tab(\'cordova\').active = true">\n                    <div class="ups-code-block js" hljs compile="true">\nvar pushConfig = {\n   pushServerURL: "{{ currentLocation }}",\n   {{variant.type}}: {\n      {{ projectNumber(variant) }}\n      variantID: "{{ variant.variantID }}",\n      variantSecret: "{{ variant.secret }}"\n   }\n};\n\npush.register(onNotification, successHandler, errorHandler, pushConfig);\n\nfunction onNotification(event) {\n    alert(event.alert);\n}\n\nfunction successHandler() {\n    console.log(\'success\')\n}\n\nfunction errorHandler(message) {\n    console.log(\'error \' + message);\n}\n                    </div>\n                </tab>\n\n                <tab heading="Sending" ng-hide="variantType != \'send\'" active="tab(\'send\').active" ng-click="tab(\'send\').active = true">\n                    <div class="ups-code-block java" hljs compile="true">\nJavaSender defaultJavaSender = new SenderClient("{{ currentLocation }}");\nUnifiedMessage unifiedMessage = new UnifiedMessage.Builder()\n        .pushApplicationId("{{ applicationId }}")\n        .masterSecret("{{ application.masterSecret }}")\n        .alert("Hello from Java Sender API!")\n        .build();\ndefaultJavaSender.send(unifiedMessage, new MessageResponseCallback() {\n\n    @Override\n    public void onComplete(int statusCode) {\n        //do cool stuff\n    }\n\n    @Override\n    public void onError(Throwable throwable) {\n        //bring out the bad news\n    }\n});\n                    </div>\n                </tab>\n            </tabset>\n        </div>\n    </div>\n</div>\n'),$templateCache.put("views/installation.html",'<div class="col-md-10 lo-main-pane ng-scope">\n    <div class="row">\n        <div class="lo-content-area col-md-12">\n            <div ups-breadcrumb/>\n            <div class="panel lo-panel ups-panel-installations">\n                <div class="panel-heading">\n                    <div class="pull-right">\n                        <input type="search" class="form-control" placeholder="Search..." ng-model="search">\n                    </div>\n                    <div style="clear: both;"></div>\n                </div>\n                <p ng-hide="installations.length">No Installations yet</p>\n                <table class="ups-installations" ng-show="installations.length">\n                    <thead>\n                    <tr>\n                        <th class="col-md-6">Device token</th>\n                        <th class="col-md-2">Alias</th>\n                        <th class="col-md-2">OS</th>\n                        <th class="col-md-2">Receiving</th>\n                    </tr>\n                    </thead>\n                    <tbody >\n                    <tr ng-repeat-start="installation in installations | filter:search">\n                        <td>\n                            <a href="" ng-click="expand(installation)">\n                                <i class="fa" ng-class="{\'fa-caret-right\': isCollapsed(installation), \'fa-caret-down\': !isCollapsed(installation)}"></i>\n                                {{ installation.deviceToken | limitTo : 50 }}...\n                            </a>\n                        </td>\n                        <td>{{ installation.alias }} <div ng-hide="installation.alias.length">No alias</div></td>\n                        <td>{{ installation.os }}</td>\n                        <td>\n                            <label class="ups-switch">\n                                <input type="checkbox" class="ups-switch__input" ng-checked="installation.enabled" ng-click="update(installation)">\n                                <div class="ups-switch__toggle"></div>\n                            </label>\n                        </td>\n                    </tr>\n                    <tr collapse="isCollapsed(installation)" ng-repeat-end>\n                        <td colspan="4">\n                            <table style="" class="ups-installation-detail">\n                                <tr>\n                                    <td>Categories:</td>\n                                    <td>{{ installation.categories }}</td>\n                                </tr>\n                                <tr>\n                                    <td>Device type:</td>\n                                    <td>{{ installation.deviceType }}</td>\n                                </tr>\n                                <tr>\n                                    <td >Token:</td>\n                                    <td><div ng-bind-html="wrapText(installation.deviceToken)"></div></td>\n                                </tr>\n                            </table>\n                        </td>\n                    </tr>\n                    </tbody>\n                </table>\n            </div>\n            <pagination direction-links="true" boundary-links="false" total-items="totalItems" ng-model="currentPage" previous-text="&lsaquo;" next-text="&rsaquo;" class="pull-right ups-pagination" ng-show="installations.length" ng-change="pageChanged()" max-size="5" rotate="false"></pagination>\n        </div>\n    </div>\n</div>'),$templateCache.put("views/loading.html",'<div class="col-md-10">\n    <div class="row">\n        <div class="lo-content-area col-md-12">  \n          <i class="ups-spinner fa fa-spinner fa-spin fa-3x"></i>\n        </div>\n    </div>\n</div>\n\n'),$templateCache.put("views/notification.html",'<div class="col-md-10 lo-main-pane ng-scope">\n  <div class="row">\n    <div class="lo-content-area col-md-12">\n\n      <div ups-breadcrumb/>\n\n      <div class="panel lo-panel ups-panel" style="margin-top: 20px">\n        <div class="ups-padding-box">\n          <table class="expand">\n            <th>\n              <tr>\n                <td style="padding: 6px 0;"><strong>Notification</strong>\n                </td>\n                <td><strong>Receivers</strong>\n                </td>\n                <td><strong>Status</strong>\n                </td>\n                <td><strong>Timestamp</strong>\n                </td>\n              </tr>\n            </th>\n            <tr style="border-top: 1px #eee solid" ng-repeat-start="metric in pushMetrics">\n              <td style="padding: 8px 0;">\n                <a href ng-click="expand(metric)">\n                  <i class="fa"\n                     ng-class="{\'fa-plus-square-o\': isCollapsed(metric), \'fa-minus-square-o\': !isCollapsed(metric)}"></i>\n                  {{ metric.rawJsonMessage | limitTo : 50 }}...\n                </a>\n              </td>\n              <td>\n                <strong>{{ metric.totalReceivers ? metric.totalReceivers : \'All\'  }}</strong> installations\n              </td>\n              <td>\n                <strong>\n                  {{metric.deliveryStatus}}\n                  <i class="fa fa-warning" ng-show="metric.deliveryFailed == true"></i>\n                  {{ metric.deliveryFailed == true ? \'Failed\' : \'Succeeded\' }}\n                </strong>\n              </td>\n              <td>\n                {{ metric.submitDate | date : \'d MMM, HH:mm:ss, yyyy\' }}\n              </td>\n            </tr>\n            <tr collapse="isCollapsed(metric)" ng-repeat-end>\n              <td colspan="4" style="padding: 8px;">\n                <div class="ups-toggle-box ups-panel-details">\n                  <table>\n                    <tr>\n                      <td>Request IP:</td>\n                      <td><strong>{{ metric.ipAddress }}</strong>\n                      </td>\n                      <td><a href ng-click="showFullRequest(metric.rawJsonMessage)">Full Request</a>\n                      </td>\n                    </tr>\n                    <tr>\n                      <td>Message:</td>\n                      <td colspan="2"><strong>{ "message" : "{{ parse(metric).alert }}" }</strong></td>\n                    </tr>\n                  </table>\n                  <hr ng-show="metric.deliveryFailed">\n                  <table ng-show="metric.deliveryFailed">\n                    <tr>\n                      <td>Error:</td>\n                      <td><strong>Problem occurred during sending push notification(s)</strong></td>\n                      <td><a href="#/detail/{{applicationId}}">Edit Push Network...</a></td>\n                    </tr>\n                    <tr ng-if="detailsPage()">\n                      <td>Reason:</td>\n                      <td colspan="2">{{ metric.variantInformations[0].reason }}</td>\n                    </tr>\n                  </table>\n                  <hr ng-show="!detailsPage() && metric.variantInformations.length">\n                  <table ng-if="!detailsPage() && metric.variantInformations.length">\n                    <tr>\n                      <td>Variants:</td>\n                      <td>\n                        <table class="expand">\n                          <tr ng-repeat="variant in variantMetricInformation(metric.variantInformations)">\n                            <td>\n                              <a href="#/detail/{{applicationId}}">{{ variant.name ? variant.name : variant.variantID }}</a>\n                            </td>\n                            <td>{{ variant.deliveryStatus == false ? \'Failed\' : \'Succeeded\' }}</td>\n                            <td>\n                              <strong>{{ variant.receivers }}</strong> installations\n                            </td>\n                          </tr>\n                        </table>\n                      </td>\n                    </tr>\n                  </table>\n                </div>\n              </td>\n            </tr>\n          </table>\n        </div>\n        <pagination direction-links="true" boundary-links="false" total-items="totalItems" ng-model="currentPage" previous-text="&lsaquo;" next-text="&rsaquo;" class="pull-right ups-pagination"  ng-change="pageChanged()" max-size="5" rotate="false"></pagination>\n      </div>\n    </div>\n  </div>\n</div>'),$templateCache.put("views/dialogs/add-criteria.html",'<div class="modal-content">\n    <div class="modal-header">\n        <button type="button" class="close" aria-hidden="true" ng-click="cancel()">\n            <span class="pficon pficon-close"></span>\n        </button>\n        <h4 class="modal-title">Filters</h4>\n    </div>\n    <div class="modal-body">\n    <p style="opacity: 0.5">You can provide multiple values at a time by separating them by commas.</p>\n    <br>\n        <form name="form" class="form-horizontal">\n            <div class="form-group">\n                <label class="col-sm-3 control-label">Aliases</label>\n\n                <div class="col-sm-7">\n                    <input type="text" placeholder="All" class="form-control" ng-model="criteria.alias">\n                </div>\n            </div>\n            <div class="form-group">\n                <label class="col-sm-3 control-label">Device Types</label>\n\n                <div class="col-sm-7">\n                    <input type="text" placeholder="All" class="form-control" ng-model="criteria.deviceType">\n                </div>\n            </div>\n            <div class="form-group">\n                <label class="col-sm-3 control-label" >Categories</label>\n\n                <div class="col-sm-7">\n                    <input type="text" placeholder="All" class="form-control" ng-model="criteria.categories">\n                </div>\n            </div>\n        </form>\n    </div>\n    <div class="modal-footer">\n        <button type="button" class="btn btn-default" ng-click="cancel()">Cancel</button>\n        <button type="button" class="btn btn-primary" ng-click="ok(application)" ng-disabled="form.$pristine">Change</button>\n    </div>\n</div>'),$templateCache.put("views/dialogs/create-app.html",'<form name="form" class="modal-content">\n    <div class="modal-header">\n        <button type="button" class="close" aria-hidden="true" ng-click="cancel()">\n            <span class="pficon pficon-close"></span>\n        </button>\n        <h4 class="modal-title">{{ application.id ? \'Edit\' : \'Create\' }} Application</h4>\n    </div>\n    <div class="modal-body">\n        <div class="form-horizontal">\n            <div class="form-group">\n                <label class="col-sm-4 control-label" for="createAppName">Name</label>\n\n                <div class="col-sm-6">\n                    <input type="text" placeholder="e.g. MyApp" id="createAppName" class="form-control" ng-model="application.name" required pf-focused="true">\n                </div>\n            </div>\n            <div class="form-group">\n                <label class="col-sm-4 control-label" for="createAppDescription">Description</label>\n\n                <div class="col-sm-6">\n                    <input type="text" placeholder="e.g. A useful application for everyone." id="createAppDescription" class="form-control" ng-model="application.description">\n                </div>\n            </div>\n        </div>\n    </div>\n    <div class="modal-footer">\n        <input type="button" class="btn btn-default" ng-click="cancel()" value="Cancel" />\n        <input type="submit" class="btn btn-primary" ng-click="ok(application)" ng-disabled="form.$invalid" value="{{ application.id ? \'Save\' : \'Create\' }}" />\n    </div>\n</form>\n'),$templateCache.put("views/dialogs/create-variant.html",'<form name="form" class="modal-content ups-modal-content">\n  <div class="modal-header">\n    <button type="button" class="close" aria-hidden="true" ng-click="cancel()">\n      <span class="pficon pficon-close"></span>\n    </button>\n    <h4 class="modal-title">{{ variant.id ? \'Edit\' : \'Add\' }} Variant</h4>\n  </div>\n  <div class="modal-body">\n    <div class="form-horizontal">\n      <div class="form-group">\n        <label class="col-sm-3 control-label" for="createAppName">Name</label>\n        <div class="col-sm-7">\n          <input type="text" placeholder="e.g. Demo" id="createAppName" class="form-control" ng-model="variant.name" required pf-focused="true">\n        </div>\n      </div>\n      <div class="form-group">\n        <label class="col-sm-3 control-label" for="createAppDescription">Description</label>\n        <div class="col-sm-7">\n          <input type="text" placeholder="e.g. The free demo version" id="createAppDescription" class="form-control" ng-model="variant.description">\n        </div>\n      </div>\n\n      <div class="form-group" ng-hide="variant.id">\n        <hr>\n        <label class="col-sm-3 control-label"></label>\n        <div class="ups-platform-selection col-sm-7">\n          <div class="row">\n            <div class="radio ups-radio">\n              <input type="radio" name="createVariantType" id="variantTypeAndroid" ng-model="variant.type" value="android" ng-required="true">\n              <label for="variantTypeAndroid">\n                <div class="ups-platform android">\n                  <strong>Android</strong><br>\n                  <span>using Google Cloud Messaging</span>\n                </div>\n              </label>\n            </div>\n          </div>\n          <div class="row">\n            <div class="radio ups-radio">\n              <input type="radio" name="createVariantType" id="variantTypeIOS" ng-model="variant.type" value="ios"  ng-required="true">\n              <label for="variantTypeIOS">\n                <div class="ups-platform ios">\n                  <strong>iOS</strong><br>\n                  <span>using Apple Push Network</span>\n                </div>\n              </label>\n            </div>\n          </div>\n          <div class="row">\n            <div class="radio ups-radio">\n              <input type="radio" name="createVariantType" id="variantTypeChrome" ng-model="variant.type" value="chrome"  ng-required="true">\n              <label for="variantTypeChrome">\n                <div class="ups-platform chrome">\n                <b>Chrome</b><br />\n                <span>using Google Cloud Messaging for Chrome</span>\n                </div>\n              </label>\n            </div>\n          </div>\n          <div class="row">\n            <div class="radio ups-radio">\n              <input type="radio" name="createVariantType" id="variantTypeSimplePush" ng-model="variant.type" value="simplePush"  ng-required="true">\n              <label for="variantTypeSimplePush">\n                <div class="ups-platform simplepush">\n                <b>SimplePush</b><br />\n                <span>using the Mozilla WebAPI</span>\n                </div>\n              </label>\n            </div>\n          </div>\n        </div>\n        <hr>\n      </div>\n      \n      <div ng-show="variant.type">\n\n        <div ng-show="variant.type == \'android\'">\n          <div class="form-group">\n            <label class="col-sm-3 control-label" for="gcmApiKey">Push Network</label>\n            <div class="col-sm-7"><em>Google Cloud Messaging</em> Key<br>\n              <input type="text" placeholder="e.g. 5a448c2f31700a466fbc9d33d33942b043a27596" id="gcmApiKey" class="form-control" ng-model="variant.googleKey" ng-required="variant.type == \'android\'">\n            </div>\n          </div>    \n          <div class="form-group">\n            <label class="col-sm-3 control-label" for="gcmProjectNumber"></label>\n            <div class="col-sm-7">\n              Project Number<br>\n              <input type="text" placeholder="e.g. 42" id="gcmProjectNumber" class="form-control" ng-model="variant.projectNumber" ng-required="variant.type == \'android\'">\n            </div>\n          </div>\n        </div>\n        \n        <div ng-show="variant.type == \'simplePush\'">\n          <div class="form-group">\n            <label class="col-sm-3 control-label">Push Network</label>\n            <div class="col-sm-7"><strong>No configuration needed</strong><p>This server\'s <em>SimplePush</em> implementation will be used.</p></div>\n          </div>\n        </div>\n\n        <div ng-show="variant.type == \'ios\'">\n          <div class="form-group">\n            <label class="col-sm-3 control-label">Push Network</label>\n            <div class="col-sm-7">\n              <p><em>Apple Push Notification Service</em> certificate:</p>\n              <strong><input type="file" ups-files="variant.certificates" /></strong>\n              <div class="form-horizontal">\n                <div class="form-group">\n                  <div class="row">\n                    <br><label class="col-sm-3 control-label">Type</label>\n                    <div class="col-sm-9">\n                      <div class="row">\n                        <div class="radio">\n                          <label>\n                            <input type="radio" name="iosType" id="iosType1" ng-model="variant.production" value="true" checked>\n                            Production\n                          </label>\n                        </div>\n                      </div>\n                      <div class="row">\n                        <div class="radio">\n                          <label>\n                            <input type="radio" name="iosType" id="iosType2" ng-model="variant.production" value="false">\n                            Development\n                          </label>\n                        </div>\n                      </div>\n                    </div>\n                  </div>\n                </div>\n                <div class="form-group">\n                  <label class="col-sm-3 control-label" for="iosPassphrase">Passphrase</label>\n                  <div class="col-sm-9">\n                    <input type="password" id="iosPassphrase" class="form-control" ng-model="variant.passphrase" ng-required="variant.type == \'ios\' && !variant.id">\n                  </div>\n                </div>\n              </div>\n            </div>\n          </div>\n        </div>\n\n        <div ng-show="variant.type == \'chrome\'">\n          <div class="form-group">\n            <label class="col-sm-3 control-label">Push Network</label>\n            <div class="col-sm-7">\n              <div class="form-group">\n                <label class="col-sm-5 control-label" for="chromeClientId">Client ID</label>\n                <div class="col-sm-7">\n                  <input type="text" placeholder="e.g. 291796959215.apps.googleusercontent.com" id="chromeClientId" class="form-control" ng-model="variant.clientId" ng-required="variant.type == \'chrome\'">\n                </div>\n              </div>\n              <div class="form-group">\n                <label class="col-sm-5 control-label" for="chromeClientSecret">Client Secret</label>\n                <div class="col-sm-7">\n                  <input type="text" placeholder="e.g. 0bKUtXN6ykk7Mj1lQxoBZ2mh" id="chromeClientSecret" class="form-control" ng-model="variant.clientSecret" ng-required="variant.type == \'chrome\'">\n                </div>\n              </div>\n              <div class="form-group">\n                <label class="col-sm-5 control-label" for="chromeRefreshToken">Refresh Token</label>\n                <div class="col-sm-7">\n                  <input type="text" placeholder="e.g. 1%wMfyZvGcCxMSNEX4iTRdE0H1_Yt0wvImBz_iCuXF-UM" id="chromeRefreshToken" class="form-control" ng-model="variant.refreshToken" ng-required="variant.type == \'chrome\'">\n                </div>\n              </div>\n            </div>\n          </div>\n        </div>\n      </div>\n    </div>\n  </div>\n  \n  <div class="modal-footer">\n    <input type="button" class="btn btn-default" ng-click="cancel()" value="Cancel" />\n    <input type="submit" class="btn btn-primary" ng-click="ok(variant)" ng-disabled="form.$invalid" value="{{ variant.id ? \'Save\' : \'Add\' }}" />\n  </div>\n</form>\n'),$templateCache.put("views/dialogs/filter-variants.html",'<div class="modal-content">\n    <div class="modal-header">\n        <button type="button" class="close" aria-hidden="true" ng-click="cancel()">\n            <span class="pficon pficon-close"></span>\n        </button>\n        <h4 class="modal-title">&ldquo;{{application.name}}&rdquo; variants</h4>\n    </div>\n    <div class="modal-body">\n      <input type="checkbox" ng-checked="variantSelection.length == 0">All\n      <div>\n        <div ng-show="application.variants" ng-repeat="variant in application.variants">\n          <h5 style="text-transform: capitalize" ng-if="variant.type != \'ios\' && application.variants[$index - 1].type != variant.type">{{variant.type}}</h5>\n          <h5 ng-if="variant.type == \'ios\' && application.variants[$index - 1].type != variant.type">iOS</h5>\n          <ul style="margin-bottom: -1px;">\n          <li class="list-group-item">\n              <label>\n                  <input type="checkbox"  ng-checked="variantSelection.indexOf(variant) > -1" ng-click="toggleSelection(variant)">\n                  {{variant.name}}\n              </label>\n          </li>\n          </ul>\n        </div>\n      </div>\n    </div>\n    <div class="modal-footer">\n        <button type="button" class="btn btn-default" ng-click="cancel()">Cancel</button>\n        <button type="button" class="btn btn-primary" ng-click="ok(application)" ng-disabled="form.$pristine">Change</button>\n    </div>\n</div>'),$templateCache.put("views/dialogs/remove-app.html",'<div class="modal-content">\n    <div class="modal-header">\n        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">\n            <span class="pficon pficon-close"></span>\n        </button>\n        <h4 class="modal-title">Remove Application</h4>\n    </div>\n    <div class="modal-body">\n        <form>\n            <p>Do you want to remove application <strong>"{{ application.name }}"</strong>?</p>\n            <p>Please type in the name of the application to confirm.</p>\n            <p>\n                <input class="form-control" ng-model="confirmApplicationName" pf-focused="true" />\n            </p>\n        </form>\n    </div>\n    <div class="modal-footer">\n        <button type="button" class="btn btn-danger text-left" ng-click="ok()"\n                ng-disabled="application.name !== confirmApplicationName">\n            Remove\n        </button>\n        <button type="button" class="btn btn-default" ng-click="cancel()">Cancel</button>\n    </div>\n</div>\n'),$templateCache.put("views/dialogs/remove-variant.html",'<div class="modal-content">\n    <div class="modal-header">\n        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">\n            <span class="pficon pficon-close"></span>\n        </button>\n        <h4 class="modal-title">Remove Application</h4>\n    </div>\n    <div class="modal-body">\n        <form>\n            <p>Do you want to remove variant <strong>"{{ variant.name }}"</strong>?</p>\n            <p>Please type in the name of the variant to confirm.</p>\n            <p>\n                <input class="form-control" ng-model="confirmVariantName" pf-focused="true" />\n            </p>\n        </form>\n        \n    </div>\n    <div class="modal-footer">\n        <button type="button" class="btn btn-danger text-left" ng-click="ok(variant)"\n                ng-disabled="variant.name !== confirmVariantName">\n            Remove\n        </button>\n        <button type="button" class="btn btn-default" ng-click="cancel()">Cancel</button>\n    </div>\n</div>\n'),$templateCache.put("views/dialogs/renew-master-secret.html",'<div class="modal-content">\n    <div class="modal-header">\n        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">\n            <span class="pficon pficon-close"></span>\n        </button>\n        <h4 class="modal-title">Renew Master Secret</h4>\n    </div>\n    <div class="modal-body">\n        Are you sure you want to renew the Master Secret?\n    </div>\n    <div class="modal-footer">\n        <button type="button" class="btn btn-danger text-left" ng-click="ok()">Renew</button>\n        <button type="button" class="btn btn-default" ng-click="cancel()">Cancel</button>\n    </div>\n</div>\n'),$templateCache.put("views/dialogs/renew-variant-secret.html",'<div class="modal-content">\n    <div class="modal-header">\n        <button type="button" class="close" data-dismiss="modal" aria-hidden="true">\n            <span class="pficon pficon-close"></span>\n        </button>\n        <h4 class="modal-title">Renew Secret</h4>\n    </div>\n    <div class="modal-body">\n        Are you sure you want to renew the Secret?\n    </div>\n    <div class="modal-footer">\n        <button type="button" class="btn btn-danger text-left" ng-click="ok()">Renew</button>\n        <button type="button" class="btn btn-default" ng-click="cancel()">Cancel</button>\n    </div>\n</div>\n'),$templateCache.put("views/dialogs/request.html",'<div class="modal-content">\n  <div class="modal-header">\n    <button type="button" class="close" aria-hidden="true" ng-click="cancel()">\n      <span class="pficon pficon-close"></span>\n    </button>\n    <h4 class="modal-title">Full Request</h4>\n  </div>\n  <div class="modal-body">\n    <div class="ups-code-block" hljs source="request"></div>\n  </div>\n</div>\n'),$templateCache.put("views/include/compose.html",'<form class="form-horizontal">\n  <div class="form-group">\n    <label class="col-sm-2 control-label">Variants</label>\n\n    <div class="col-sm-10">\n      <div class="ups-fake-input">\n        <span ng-hide="variantSelection.length">All</span>\n        <span ng-repeat="variant in variantSelection">{{variant.name}}\n          <span ng-show=" ! $last ">,&nbsp;</span>\n        </span>\n      </div>\n    </div>\n  </div>\n  <div class="pull-right">\n    <button class="btn btn-default btn-sml" ng-click="changeVariant(application)">Change...</button>\n    <br><br></div>\n  <hr>\n\n  <div class="form-group">\n    <label class="col-sm-2 control-label" for="testMessage">Message</label>\n\n    <div class="col-sm-10">\n      <textarea rows="4" class="form-control" id="testMessage" ng-model="pushData.message.alert"></textarea>\n    </div>\n  </div>\n\n  <hr>\n\n  <div class="form-group">\n    <label class="col-sm-2 control-label">Aliases</label>\n\n    <div class="col-sm-10"><input disabled class="form-control" type="text"\n                                  value="{{criteria.alias.length > 0 ? criteria.alias : \'All\'}}"></div>\n  </div>\n  <div class="form-group">\n    <label class="col-sm-2 control-label">Device Types</label>\n\n    <div class="col-sm-10"><input disabled class="form-control" type="text"\n                                  value="{{criteria.deviceType.length > 0 ? criteria.deviceType : \'All\'}}"></div>\n  </div>\n  <div class="form-group">\n    <label class="col-sm-2 control-label">Categories</label>\n\n    <div class="col-sm-10">\n      <input disabled class="form-control" type="text" value="{{criteria.categories.length > 0 ? criteria.categories : \'All\'}}">\n    </div>\n  </div>\n  <div class="pull-right">\n    <button class="btn btn-default btn-sml" ng-click="changeCriteria(application)">Change...</button>\n    <br><br></div>\n\n  <hr>\n  <div class="pull-right">\n    <button ng-click="sendMessage()" class="btn btn-primary btn-lg" type="button">Send Push Notification</button>\n  </div>\n</form>')
}]);