angular.module('upsConsole').run(['$templateCache', function($templateCache) {
  'use strict';

  $templateCache.put('directives/ups-breadcrumb.html',
    "<ol class=\"breadcrumb\">\n" +
    "    <li ng-repeat=\"breadcrumb in breadcrumbs.get() track by breadcrumb.path\" ng-class=\"{ active: $last }\">\n" +
    "        <a ng-if=\"!$last\" ng-href=\"#{{ breadcrumb.path }}\" ng-bind=\"breadcrumb.label\" class=\"margin-right-xs\"></a>\n" +
    "        <span ng-if=\"$last\" ng-bind=\"breadcrumb.label\"></span>\n" +
    "    </li>\n" +
    "</ol>\n"
  );


  $templateCache.put('directives/ups-client-snippets.html',
    "<ul class=\"nav nav-tabs nav-justified ups-snippet-nav\" ng-if=\"typeEnum[variant.type].snippets.length\">\n" +
    "  <li ng-repeat=\"snippet in typeEnum[variant.type].snippets\"\n" +
    "      ng-init=\"state.activeSnippet = typeEnum[variant.type].snippets[0]\"\n" +
    "      ng-class=\"{ active: snippet == state.activeSnippet }\">\n" +
    "    <a ng-click=\"state.activeSnippet = snippet\">\n" +
    "      <span ng-if=\"snippet == 'android'\">Android</span>\n" +
    "      <span ng-if=\"snippet == 'simplePush'\">JavaScript</span>\n" +
    "      <span ng-if=\"snippet == 'ios-objc'\">ObjectiveC</span>\n" +
    "      <span ng-if=\"snippet == 'ios-swift'\">Swift</span>\n" +
    "      <span ng-if=\"snippet == 'wns'\">C#</span>\n" +
    "      <span ng-if=\"snippet == 'mpns'\">C#</span>\n" +
    "      <span ng-if=\"snippet == 'cordova'\">Cordova</span>\n" +
    "    </a>\n" +
    "  </li>\n" +
    "</ul>\n" +
    "\n" +
    "<div class=\"ups-snippet\" ng-if=\"typeEnum[variant.type].snippets.length\">\n" +
    "  <a data-placement=\"left\" title=\"Copy to clipboard\">Copy</a>\n" +
    "  <!-- use both ng-if and ng-show prevents screen flickering caused by reinsertion of DOM parts, ng-if turns the invalid sample off to avoid DOM pollution -->\n" +
    "  <pre class=\"pre-scrollable prettyprint\" ng-if=\"typeEnum[variant.type].indexOf('android') !== -1\" ng-show=\"state.activeSnippet == 'android'\"><ng-include src=\"'snippets/register-device/android.java'\"></ng-include></pre>\n" +
    "  <pre class=\"pre-scrollable prettyprint\" ng-if=\"typeEnum[variant.type].indexOf('cordova') !== -1\" ng-show=\"state.activeSnippet == 'cordova'\"><ng-include src=\"'snippets/register-device/cordova.js'\"></ng-include></pre>\n" +
    "  <pre class=\"pre-scrollable prettyprint\" ng-if=\"typeEnum[variant.type].indexOf('ios-objc') !== -1\" ng-show=\"state.activeSnippet == 'ios-objc'\"><ng-include src=\"'snippets/register-device/ios.objc'\"></ng-include></pre>\n" +
    "  <pre class=\"pre-scrollable prettyprint\" ng-if=\"typeEnum[variant.type].indexOf('ios-swift') !== -1\" ng-show=\"state.activeSnippet == 'ios-swift'\"><ng-include src=\"'snippets/register-device/ios.swift'\"></ng-include></pre>\n" +
    "  <pre class=\"pre-scrollable prettyprint\" ng-if=\"typeEnum[variant.type].indexOf('mpns') !== -1\" ng-show=\"state.activeSnippet == 'mpns'\"><ng-include src=\"'snippets/register-device/mpns.cs'\"></ng-include></pre>\n" +
    "  <pre class=\"pre-scrollable prettyprint\" ng-if=\"typeEnum[variant.type].indexOf('wns') !== -1\" ng-show=\"state.activeSnippet == 'wns'\"><ng-include src=\"'snippets/register-device/wns.cs'\"></ng-include></pre>\n" +
    "</div>\n"
  );


  $templateCache.put('directives/ups-navigation.html',
    "<aside class=\"lo-sidebar ups-sidebar col-md-2 fixed clearfix ng-isolate-scope\"\n" +
    "       data-lo-current=\"storage\" data-lo-apps=\"applications\" data-lo-app=\"curApp\">\n" +
    "\n" +
    "  <nav class=\"navbar navbar-vertical\" role=\"navigation\">\n" +
    "    <div class=\"bs-sidebar\">\n" +
    "      <ul>\n" +
    "        <li ng-class=\"{active: current == 'dashboard'}\" class=\"stats\">\n" +
    "          <a href=\"#/dashboard\">\n" +
    "            <i class=\"fa fa-tachometer fa-3x\"></i>Dashboard\n" +
    "          </a>\n" +
    "        </li>\n" +
    "        <li ng-class=\"{active: current == 'applications'}\">\n" +
    "          <a href=\"#/applications\">\n" +
    "            <i class=\"fa fa-th fa-3x\"></i>Applications\n" +
    "          </a>\n" +
    "        </li>\n" +
    "        <li ng-class=\"{active: current == 'compose'}\">\n" +
    "          <a href=\"#/compose\">\n" +
    "            <i class=\"fa fa-send-o fa-3x\"></i>Send Push\n" +
    "          </a>\n" +
    "        </li>\n" +
    "      </ul>\n" +
    "    </div>\n" +
    "  </nav>\n" +
    "</aside>\n"
  );


  $templateCache.put('directives/ups-sender-snippets.html',
    "<ul class=\"nav nav-tabs nav-tabs-pf\">\n" +
    "  <li ng-class=\"{ active: sender.activeSnippet == 'java' || !sender.activeSnippet }\"><a ng-click=\"sender.activeSnippet = 'java'\">Java Sender API</a></li>\n" +
    "  <li ng-class=\"{ active: sender.activeSnippet == 'nodejs' }\"><a ng-click=\"sender.activeSnippet = 'nodejs'\">Node.js Sender API</a></li>\n" +
    "  <li ng-class=\"{ active: sender.activeSnippet == 'curl' }\"><a ng-click=\"sender.activeSnippet = 'curl'\">REST Sender API (with CURL)</a></li>\n" +
    "</ul>\n" +
    "\n" +
    "\n" +
    "<div ng-if=\"sender.activeSnippet == 'java' || !sender.activeSnippet\">\n" +
    "  <h3>Set up Java UPS Sender API</h3>\n" +
    "  <p>First you need to add <code>unifiedpush-java-client.jar</code> as a <a href=\"https://aerogear.org/getstarted/downloads/#push\">dependency to your Java project</a>.</p>\n" +
    "  <p>Then let's use following snippet in your Java code to enable push notification sending.</p>\n" +
    "</div>\n" +
    "<div ng-if=\"sender.activeSnippet == 'nodejs'\">\n" +
    "  <h3>Set up Node.js Sender API</h3>\n" +
    "  <p>First you need to download add <code>unifiedpush-node-sender</code> as a <a href=\"https://aerogear.org/getstarted/downloads/#push\">dependency to your project</a>.</p>\n" +
    "  <p>Then let's use following snippet in your Node.js code to enable push notification sending.</p>\n" +
    "</div>\n" +
    "<div ng-if=\"sender.activeSnippet == 'curl'\">\n" +
    "  <h3>Use UPS REST Sender API (with CURL)</h3>\n" +
    "  <p>If none from the official client libs doesn't suit you or you just want to simply try out the notification sending, you can use REST API directly.</p>\n" +
    "  <p>Run following <code>curl</code> command in the shell to send notification to UPS server.</p>\n" +
    "</div>\n" +
    "\n" +
    "\n" +
    "<div class=\"ups-snippet\">\n" +
    "  <a href=\"#\" data-toggle=\"tooltip\" data-placement=\"left\" title=\"Copy to clipboard\">Copy</a>\n" +
    "  <pre class=\"pre-scrollable prettyprint\" ng-if=\"sender.activeSnippet == 'java' || !sender.activeSnippet\"><ng-include src=\"'snippets/senders/sender.java'\"></ng-include></pre>\n" +
    "  <pre class=\"pre-scrollable prettyprint\" ng-if=\"sender.activeSnippet == 'nodejs'\"><ng-include src=\"'snippets/senders/sender-nodejs.js'\"></ng-include></pre>\n" +
    "  <pre class=\"pre-scrollable prettyprint\" ng-if=\"sender.activeSnippet == 'curl'\"><ng-include src=\"'snippets/senders/sender-curl.sh'\"></ng-include></pre>\n" +
    "</div>\n" +
    "\n" +
    "\n" +
    "<div ng-if=\"sender.activeSnippet == 'java' || !sender.activeSnippet\">\n" +
    "  <p>Read more on the details of the <a href=\"https://aerogear.org/docs/specs/aerogear-unifiedpush-java-client/\">Java UPS Sender API in documentation</a>.</p>\n" +
    "</div>\n" +
    "<div ng-if=\"sender.activeSnippet == 'nodejs'\">\n" +
    "  <p>Read more on the details of the <a href=\"https://aerogear.org/docs/specs/aerogear-unifiedpush-nodejs-client/\">Node.js UPS Sender API in documentation</a>.</p>\n" +
    "</div>\n" +
    "<div ng-if=\"sender.activeSnippet == 'curl'\">\n" +
    "  <p>Read more on the details of the <a href=\"https://aerogear.org/docs/specs/aerogear-unifiedpush-rest/overview-index.html\">UPS REST Sender API in documentation</a>.</p>\n" +
    "</div>\n"
  );


  $templateCache.put('directives/variant-details.html',
    "<ul class=\"list-group \" style=\"margin-bottom: 0\">\n" +
    "    <li class=\"list-group-item\">\n" +
    "        <a class=\"clickable\" ng-click=\"expand(variant)\">\n" +
    "            <i class=\"fa\" ng-class=\"{'fa-plus-square-o': isCollapsed(variant), 'fa-minus-square-o': !isCollapsed(variant)}\"></i> {{ variant.name }}\n" +
    "        </a>\n" +
    "        <span>{{ variant.description }}</span>\n" +
    "        <div class=\"pull-left\" style=\"margin-left: -20px\">\n" +
    "          <a role=\"menuitem\" ng-click=\"editVariant(variant, variant.type)\" ng-show=\"variant.hasError\" title=\"reason: {{ variant.error }}\">\n" +
    "            <i class=\"fa fa-warning\"></i>\n" +
    "          </a>\n" +
    "        </div>\n" +
    "        <div class=\"pull-right dropdown\">\n" +
    "            <span>\n" +
    "                <span ng-show=\"!counts[variant.variantID]\">No installations</span>\n" +
    "                <span ng-show=\"counts[variant.variantID]\">\n" +
    "                    <strong>\n" +
    "                        <a href=\"#/{{applicationId}}/installations/{{variant.variantID}}\" ng-click=\"currentVariant(variant)\">\n" +
    "                            {{ counts[variant.variantID] }}\n" +
    "                        </a>\n" +
    "                    </strong>\n" +
    "                    <ng-pluralize count=\"counts[variant.variantID]\" when=\"{ 'one' : 'installation', 'other': 'installations'}\"></ng-pluralize>\n" +
    "                </span>\n" +
    "            </span>\n" +
    "\n" +
    "            <a data-toggle=\"dropdown\" class=\"dropdown-toggle\" href=\"#\"><i class=\"fa fa-cog\"></i> <i class=\"fa fa-caret-down\"></i></a>\n" +
    "            <ul class=\"dropdown-menu\">\n" +
    "                <li><a role=\"menuitem\" ng-click=\"detailCtrl.editVariant(variant, variant.type)\">Edit...</a></li>\n" +
    "                <li><a role=\"menuitem\" href=\"#/activity/{{applicationId}}/{{variant.variantID}}\">Activity</a></li>\n" +
    "                <li><a role=\"menuitem\" ng-click=\"detailCtrl.exportInstallations(variant)\">Export Installations</a></li>\n" +
    "                <li><a role=\"menuitem\" ng-click=\"detailCtrl.importInstallations(variant)\">Import Installations...</a></li>\n" +
    "                <li role=\"presentation\" class=\"divider\"></li>\n" +
    "                <li><a role=\"menuitem\" ng-click=\"detailCtrl.removeVariant(variant, variant.type)\">Remove...</a></li>\n" +
    "            </ul>\n" +
    "        </div>\n" +
    "        <div class=\"ups-toggle-box\" collapse=\"isCollapsed(variant)\">\n" +
    "            <div class=\"ups-panel-details\">\n" +
    "                <h3>Push Network Details</h3>\n" +
    "                <p ng-show=\"variant.type == 'ios'\">Apple's Push Network (APNs) will be used.\n" +
    "                To learn more about APNs, visit our <a href=\"http://aerogear.org/docs/unifiedpush/aerogear-push-ios/\">iOS</a>\n" +
    "                or <a href=\"http://aerogear.org/docs/guides/aerogear-cordova/AerogearCordovaPush/\">Apache Cordova</a> guides for push.\n" +
    "                </p>\n" +
    "                <p ng-show=\"variant.type == 'android'\">Google's Cloud Messaging Network (GCM) will be used.\n" +
    "                To learn more about GCM, visit our <a href=\"http://aerogear.org/docs/unifiedpush/aerogear-push-android/\">Android</a>, <a href='http://aerogear.org/docs/unifiedpush/aerogear-push-chrome/'>Chrome</a> or <a href=\"http://aerogear.org/docs/guides/aerogear-cordova/AerogearCordovaPush/\">Apache Cordova</a> guides for push.\n" +
    "                </p>\n" +
    "                <p ng-show=\"variant.type == 'simplePush'\">A Server implementing the <em>SimplePush</em> protocol will be used.\n" +
    "                More information can be found in <a href=\"https://wiki.mozilla.org/WebAPI/SimplePush/Protocol\">SimplePush Protocol Draft</a>.\n" +
    "                The <a href=\"https://github.com/aerogear/aerogear-simplepush-quickstart\">AeroGears' SimplePush Quickstart</a> also contains useful information.\n" +
    "                </p>\n" +
    "                <p ng-show=\"variant.type == 'adm'\">Amazon's Device Messaging Network (ADM) will be used.\n" +
    "                To learn more about, visit our <a href=\"http://aerogear.org/docs/unifiedpush/aerogear-push-adm/\">adm</a> or <a href=\"http://aerogear.org/docs/guides/aerogear-cordova/AerogearCordovaPush/\">Apache Cordova</a> guides for push.\n" +
    "                </p>\n" +
    "                <hr class=\"spacer-15\" />\n" +
    "                <table ng-show=\"variant.projectNumber.length\">\n" +
    "                    <tr><td>Project Number:</td><td>{{ variant.projectNumber }}</td></tr>\n" +
    "                    <tr><td>Google API Key:</td><td>{{ variant.googleKey }}</td></tr>\n" +
    "                </table>\n" +
    "                <table ng-show=\"variant.type == 'windows_wns'\">\n" +
    "                  <tr><td>Package SID:</td><td>{{ variant.sid }}</td></tr>\n" +
    "                  <tr><td>Client Secret:</td><td>{{ variant.clientSecret }}</td></tr>\n" +
    "                </table>\n" +
    "                <table ng-show=\"variant.production != undefined\">\n" +
    "                    <tr><td>Type:</td><td>{{ variant.production ? 'Production' : 'Development' }}</td></tr>\n" +
    "                </table>\n" +
    "                <table ng-show=\"variant.type == 'chrome'\">\n" +
    "                    <tr><td>Client Id:</td><td>{{ variant.clientId }}</td></tr>\n" +
    "                    <tr><td>Client Secret:</td><td>{{ variant.clientSecret }}</td></tr>\n" +
    "                    <tr><td>Refresh Token:</td><td>{{ variant.refreshToken }}</td></tr>\n" +
    "                </table>\n" +
    "                <table ng-show=\"variant.type == 'adm'\">\n" +
    "                    <tr><td>Client Id:</td><td>{{ variant.clientId }}</td></tr>\n" +
    "                    <tr><td>Client Secret:</td><td>{{ variant.clientSecret }}</td></tr>\n" +
    "                </table>\n" +
    "            </div>\n" +
    "            <hr class=\"spacer-15\" />\n" +
    "            <div class=\"ups-tip-panel\">\n" +
    "                <div class=\"ups-tip-panel-illustration ups-registering-installations\"></div>\n" +
    "                <div class=\"ups-tip-panel-body\">\n" +
    "                    <h2>Registering installations\n" +
    "                        <div class=\"pull-right dropdown\">\n" +
    "                            <a href=\"#/example/{{applicationId}}/{{variant.type}}/{{variant.variantID}}\" class=\"ups-tip-panel-link\">Example implementation</a>\n" +
    "                            <a data-toggle=\"dropdown\" class=\"dropdown-toggle\" href=\"#\"><i class=\"fa fa-cog\"></i>  <i class=\"fa fa-caret-down\"></i></a>\n" +
    "                            <ul class=\"dropdown-menu\">\n" +
    "                                <li><a role=\"menuitem\" ng-click=\"renewSecret()\">Renew Secret...</a></li>\n" +
    "                            </ul>\n" +
    "                        </div>\n" +
    "                    </h2>\n" +
    "                    <table class=\"ups-tip-panel-details\">\n" +
    "                        <tr><td>Server URL:</td><td>\n" +
    "                          <input type=\"text\" class=\"transparent\" readonly value=\"{{ currentLocation }}\">\n" +
    "                        </td></tr>\n" +
    "                        <tr><td>Variant ID:</td><td>\n" +
    "                          <input type=\"text\" class=\"transparent\" readonly value=\"{{ variant.variantID }}\">\n" +
    "                        </td></tr>\n" +
    "                        <tr><td>Secret: </td><td>\n" +
    "                          <input type=\"text\" class=\"transparent\" readonly value=\"{{ variant.secret }}\">\n" +
    "                        </td></tr>\n" +
    "                    </table>\n" +
    "                </div>\n" +
    "                <div class=\"clearfix\"></div>\n" +
    "            </div>\n" +
    "        </div>\n" +
    "    </li>\n" +
    "</ul>\n"
  );


  $templateCache.put('views/applications.html',
    "<div class=\"col-md-10 lo-main-pane ng-scope\">\n" +
    "    <div class=\"row\">\n" +
    "        <div class=\"lo-content-area col-md-12\">\n" +
    "            <h2>Applications</h2>\n" +
    "\n" +
    "            <div class=\"lo-page-info clearfix\">\n" +
    "                <p class=\"pull-left\">\n" +
    "                    You have <ups-pluralize noun=\"application\" zero=\"no\" count=\"appCtrl.totalItems\"></ups-pluralize>.\n" +
    "                </p>\n" +
    "                <div class=\"pull-right\">\n" +
    "                    <button class=\"btn btn-primary btn-lg\" type=\"button\" ng-click=\"appCtrl.open()\">Create Application</button>\n" +
    "                </div>\n" +
    "                <div class=\"clearfix\"></div>\n" +
    "            </div>\n" +
    "            <div class=\"panel panel-default ups-panel ups-panel-applications\" ng-repeat=\"application in appCtrl.applications\">\n" +
    "                <div class=\"panel-heading\">\n" +
    "                    <h3 class=\"panel-title\"><a href=\"#/detail/{{application.pushApplicationID}}\">{{ application.name }}</a></h3>\n" +
    "                    <div class=\"dropdown\">\n" +
    "                        <a class=\"dropdown-toggle\">\n" +
    "                            <i class=\"fa fa-cog\"></i> <i class=\"fa fa-caret-down\"></i></b>\n" +
    "                        </a>\n" +
    "                        <ul class=\"dropdown-menu pull-right\">\n" +
    "                            <li><a role=\"menuitem\" tabindex=\"-1\" ng-click=\"appCtrl.edit(application)\">Edit...</a></li>\n" +
    "                            <li class=\"divider\"></li>\n" +
    "                            <li><a role=\"menuitem\" tabindex=\"-1\" ng-click=\"appCtrl.remove(application)\">Remove...</a></li>\n" +
    "                        </ul>\n" +
    "                    </div>\n" +
    "                </div>\n" +
    "                <div class=\"panel-body\">\n" +
    "                    <p ng-show=\"application.description.length\"><em>&ldquo;{{ application.description }}&rdquo;</em><br><br></p>\n" +
    "                    <ul class=\"lo-app-opts\">\n" +
    "                      <li><i class=\"fa fa-cubes\"></i><a href=\"#/detail/{{application.pushApplicationID}}\"><ups-pluralize noun=\"variant\" count=\"application.variants.length\"></ups-pluralize></a></li>\n" +
    "                      <li><i class=\"fa fa-tachometer\"></i><a href=\"#/activity/{{application.pushApplicationID}}\">Activity</a></li>\n" +
    "                      <li><i class=\"fa fa-send\"></i><a href=\"#/compose/{{ application.pushApplicationID }}\">Send Push</a></li>\n" +
    "                      <li><i class=\"pficon pficon-user\"></i>{{ application.developer }}</li>\n" +
    "                    </ul>\n" +
    "                </div>\n" +
    "            </div>\n" +
    "\n" +
    "          <pagination items-per-page=\"8\" direction-links=\"true\" boundary-links=\"false\" total-items=\"appCtrl.totalItems\" ng-model=\"appCtrl.currentPage\" previous-text=\"&lsaquo;\" next-text=\"&rsaquo;\" class=\"pull-right ups-pagination\" ng-show=\"appCtrl.applications.length\" ng-change=\"appCtrl.pageChanged()\" max-size=\"5\" rotate=\"false\"></pagination>\n" +
    "        </div>\n" +
    "    </div>\n" +
    "</div>\n"
  );


  $templateCache.put('views/compose-app.html',
    "<div class=\"col-md-10 lo-main-pane ng-scope\">\n" +
    "  <div class=\"row\">\n" +
    "    <div class=\"lo-content-area col-md-12\">\n" +
    "      <div ups-breadcrumb/>\n" +
    "      <h2>Select application to send to</h2>\n" +
    "      <br>\n" +
    "\n" +
    "      <form class=\"form-horizontal\">\n" +
    "        <div class=\"form-group\">\n" +
    "          <label class=\"col-sm-2 control-label\" for=\"select\">Application</label>\n" +
    "\n" +
    "          <div class=\"col-sm-10\">\n" +
    "            <select class=\"form-control\" id=\"select\" ng-model=\"application\"\n" +
    "                    ng-options=\"app.name for app in preComposeCtrl.applications\" ng-change=\"preComposeCtrl.setApplication(application)\">\n" +
    "              <option value=\"\">-- choose application --</option>\n" +
    "            </select>\n" +
    "          </div>\n" +
    "        </div>\n" +
    "      </form>\n" +
    "\n" +
    "      <div ng-if=\"preComposeCtrl.applicationChosen\">\n" +
    "        <div ng-include=\"'views/include/compose.html'\" ng-controller=\"ComposeController as composeCtrl\"></div>\n" +
    "      </div>\n" +
    "    </div>\n" +
    "  </div>\n" +
    "</div>\n"
  );


  $templateCache.put('views/compose.html',
    "<div class=\"col-md-10 lo-main-pane ng-scope\">\n" +
    "  <div class=\"row\">\n" +
    "    <div class=\"lo-content-area col-md-12\">\n" +
    "      <div ups-breadcrumb/>\n" +
    "      <h2>Send push to &ldquo;<strong>{{ composeCtrl.application.name }}</strong>&rdquo; installations</h2>\n" +
    "      <br>\n" +
    "\n" +
    "      <div ng-include=\"'views/include/compose.html'\"></div>\n" +
    "\n" +
    "    </div>\n" +
    "  </div>\n" +
    "</div>"
  );


  $templateCache.put('views/dashboard.html',
    "<div class=\"col-md-10 lo-main-pane\">\n" +
    "  <div class=\"lo-content-area col-md-12\">\n" +
    "\n" +
    "\n" +
    "    <div class=\"row\">\n" +
    "    <div class=\"dash col-md-12\">\n" +
    "\n" +
    "    <h2>Welcome!</h2>\n" +
    "      <div class=\"panel ups-panel ups-padding-box\">\n" +
    "        <div class=\"pull-left ups-padding-box\">\n" +
    "          <div class=\"pull-left dashboard active-apps\">\n" +
    "            <i class=\"fa fa-list-alt\"></i>\n" +
    "            <span class=\"count\">{{ dashboardCtrl.dashboardData.applications }}</span>\n" +
    "          </div>\n" +
    "          <div class=\"pull-left\">applications\n" +
    "            <br>active\n" +
    "          </div>\n" +
    "        </div>\n" +
    "        <div class=\"pull-left ups-padding-box\">\n" +
    "          <div class=\"pull-left dashboard notifications\">\n" +
    "            <i class=\"fa fa-send\"></i>\n" +
    "            <span class=\"count\">{{ dashboardCtrl.dashboardData.messages }}</span>\n" +
    "          </div>\n" +
    "          <div class=\"pull-left\">\n" +
    "            notifications\n" +
    "            <br>delivered\n" +
    "          </div>\n" +
    "        </div>\n" +
    "        <div class=\"pull-left ups-padding-box\">\n" +
    "          <div class=\"pull-left dashboard installations\">\n" +
    "            <i class=\"fa fa-tablet\"></i>\n" +
    "            <span class=\"count\">{{ dashboardCtrl.dashboardData.devices }}</span>\n" +
    "          </div>\n" +
    "          <div class=\"pull-left\">installations\n" +
    "            <br>registered\n" +
    "          </div>\n" +
    "        </div>\n" +
    "        <div class=\"clearfix\"></div>\n" +
    "      </div>\n" +
    "    </div>\n" +
    "    </div>\n" +
    "\n" +
    "    <div class=\"row\">\n" +
    "      <div class=\"dash col-md-6\">\n" +
    "        <div class=\"panel lo-panel ups-panel-dashboard\">\n" +
    "          <div class=\"panel-heading\">\n" +
    "            <div class=\"pull-left\">\n" +
    "              <h2>Warnings</h2>\n" +
    "            </div>\n" +
    "            <div class=\"pull-right\">\n" +
    "              <span></span>\n" +
    "            </div>\n" +
    "            <div class=\"clearfix\"></div>\n" +
    "          </div>\n" +
    "          <ul class=\"list-group \">\n" +
    "            <li class=\"list-group-item\" ng-repeat=\"warning in dashboardCtrl.warnings\">\n" +
    "              <i class=\"fa fa-warning\"></i> {{ warning.applicationName }} &raquo; {{ warning.variant.name }}\n" +
    "              <a class=\"pull-right\" href=\"#/activity/{{warning.applicationID}}/{{warning.variant.variantID}}\">\n" +
    "                Activity &raquo;\n" +
    "              </a>\n" +
    "            </li>\n" +
    "            <li class=\"list-group-item\" ng-hide=\"dashboardCtrl.warnings.length\">\n" +
    "              <i class=\"fa fa-check-circle\"></i>&nbsp; No problems detected currently.\n" +
    "            </li>\n" +
    "          </ul>\n" +
    "        </div>\n" +
    "\n" +
    "      </div>\n" +
    "      <div class=\"dash col-md-6\">\n" +
    "\n" +
    "        <div class=\"panel lo-panel ups-panel-dashboard\">\n" +
    "          <div class=\"panel-heading\">\n" +
    "            <div class=\"pull-left\">\n" +
    "              <h2>Recent Activity</h2>\n" +
    "            </div>\n" +
    "            <div class=\"pull-right\">\n" +
    "              <span ng-show=\"dashboardCtrl.topThree.length\">Number of receivers</span>\n" +
    "            </div>\n" +
    "            <div class=\"clearfix\"></div>\n" +
    "          </div>\n" +
    "          <ul class=\"list-group \" id=\"recent-activity\">\n" +
    "            <li class=\"list-group-item\" ng-repeat=\"top in dashboardCtrl.topThree\">\n" +
    "              <a href=\"#/activity/{{top.id}}\">\n" +
    "                {{ top.name }} &nbsp; ({{ top.submittedDate | date : 'd MMM, HH:mm:ss, yyyy' }})\n" +
    "              </a>\n" +
    "              <div class=\"pull-right\">{{ top.totalReceivers}}</div>\n" +
    "            </li>\n" +
    "            <li class=\"list-group-item\" ng-hide=\"dashboardCtrl.topThree.length\">\n" +
    "              No notifications have yet been sent.\n" +
    "            </li>\n" +
    "          </ul>\n" +
    "        </div>\n" +
    "\n" +
    "      </div>\n" +
    "\n" +
    "    </div>\n" +
    "\n" +
    "  </div>\n" +
    "</div>\n"
  );


  $templateCache.put('views/detail.html',
    "<div class=\"col-md-10 lo-main-pane ng-scope\">\n" +
    "    <div class=\"row\">\n" +
    "        <div class=\"lo-content-area col-md-12\">\n" +
    "            <div ups-breadcrumb/>\n" +
    "\n" +
    "            <div class=\"lo-page-info\">\n" +
    "                <p ng-show=\"detailCtrl.application.description.length\"><em>&ldquo;{{ detailCtrl.application.description }}&rdquo;</em></p>\n" +
    "                <div class=\"clearfix\"></div>\n" +
    "            </div>\n" +
    "\n" +
    "            <div class=\"ups-tip-panel\">\n" +
    "                <div class=\"ups-tip-panel-illustration ups-sending-notifications\"></div>\n" +
    "                <div class=\"ups-tip-panel-body\">\n" +
    "                    <h2>Sending push notifications\n" +
    "                        <div class=\"pull-right dropdown\">\n" +
    "                            <a href=\"#/example/{{detailCtrl.application.pushApplicationID}}/send\" class=\"ups-tip-panel-link\">Example implementation</a>\n" +
    "\n" +
    "                            <a data-toggle=\"dropdown\" class=\"dropdown-toggle\" href=\"#\"><i class=\"fa fa-cog\"></i> <i class=\"fa fa-caret-down\"></i></a>\n" +
    "                            <ul class=\"dropdown-menu\">\n" +
    "                                <li><a role=\"menuitem\" ng-click=\"detailCtrl.renewMasterSecret()\">Renew Master Secret...</a></li>\n" +
    "                            </ul>\n" +
    "                        </div>\n" +
    "                    </h2>\n" +
    "                    <table class=\"ups-tip-panel-details\">\n" +
    "                        <tr>\n" +
    "                            <td>Server URL:</td>\n" +
    "                            <td>\n" +
    "                              <input type=\"text\" class=\"transparent\" readonly value=\"{{ detailCtrl.currentLocation }}\">\n" +
    "                            </td>\n" +
    "                        </tr>\n" +
    "                        <tr>\n" +
    "                            <td>Application ID:</td>\n" +
    "                            <td>\n" +
    "                              <input type=\"text\" class=\"transparent\" readonly value=\"{{ detailCtrl.application.pushApplicationID }}\">\n" +
    "                            </td>\n" +
    "                        </tr>\n" +
    "                        <tr>\n" +
    "                            <td>Master Secret:</td>\n" +
    "                            <td>\n" +
    "                              <input type=\"text\" class=\"transparent\" readonly value=\"{{ detailCtrl.application.masterSecret }}\">\n" +
    "                            </td>\n" +
    "                        </tr>\n" +
    "                    </table>\n" +
    "                </div>\n" +
    "                <div class=\"clearfix\"></div>\n" +
    "            </div>\n" +
    "\n" +
    "            <h2>Variants</h2>\n" +
    "\n" +
    "            <div class=\"lo-page-info\">\n" +
    "                <p class=\"pull-left\">\n" +
    "                    You have <ups-pluralize noun=\"variant\" count=\"detailCtrl.application.variants.length\"></ups-pluralize>.\n" +
    "                </p>\n" +
    "                <div class=\"pull-right\">\n" +
    "                    <a type=\"button\" class=\"clickable\" ng-click=\"detailCtrl.generatePushConfigDialog()\">Generate <tt>push-config.json</tt></a>\n" +
    "\n" +
    "                    <button class=\"btn btn-primary btn-lg\" type=\"button\" ng-click=\"detailCtrl.addVariant()\">Add Variant</button>\n" +
    "                </div>\n" +
    "                <div class=\"clearfix\"></div>\n" +
    "            </div>\n" +
    "\n" +
    "            <div ng-class=\"{'panel lo-panel ups-panel-variants': true, 'new-line':detailCtrl.application.variants[$index + 1].type == variant.type}\" ng-repeat=\"variant in detailCtrl.application.variants\">\n" +
    "              <div class=\"ups-panel-variants {{variant.type}}\" ng-if=\"detailCtrl.application.variants[$index - 1].type != variant.type\">\n" +
    "                <div class=\"panel-heading\">\n" +
    "                  <div class=\"pull-left\">\n" +
    "                    <h2 style=\"text-transform: capitalize\" ng-if=\"variant.type != 'ios' && variant.type.indexOf('window') == -1\">{{variant.type}}</h2>\n" +
    "                    <h2 ng-if=\"variant.type == 'ios'\">iOS</h2>\n" +
    "                    <h2 style=\"text-transform: capitalize\" ng-if=\"variant.type.indexOf('window') != -1\">Windows</h2>\n" +
    "                  </div>\n" +
    "                  <div class=\"pull-right\">\n" +
    "                    <ups-pluralize noun=\"installation\" count=\"detailCtrl.counts[variant.type]\" ></ups-pluralize>\n" +
    "                  </div>\n" +
    "                  <div class=\"clearfix\"></div>\n" +
    "                </div>\n" +
    "\n" +
    "              </div>\n" +
    "\n" +
    "              <variant variant=\"variant\" counts=\"detailCtrl.counts\" on-renew=\"detailCtrl.renewVariantSecret(variant)\"></variant>\n" +
    "              <div ng-class=\"{bottom: detailCtrl.application.variants[$index + 1].type != variant.type}\"></div>\n" +
    "            </div>\n" +
    "        </div>\n" +
    "    </div>\n" +
    "  <div style=\"clearfix\"></div>\n" +
    "</div>\n"
  );


  $templateCache.put('views/example.html',
    "<div class=\"col-md-10 lo-main-pane ng-scope\">\n" +
    "    <div class=\"row\">\n" +
    "        <div class=\"lo-content-area col-md-12\">\n" +
    "            <div ups-breadcrumb/>\n" +
    "\n" +
    "            <h1>Example:\n" +
    "                <span ng-hide=\"exampleCtrl.variantType != 'send'\">Sending push notifications</span>\n" +
    "                <span ng-show=\"exampleCtrl.variantType != 'send'\">Register devices for receiving notifications</span>\n" +
    "            </h1>\n" +
    "\n" +
    "            <p ng-hide=\"exampleCtrl.variantType != 'send'\">Make your backend server send push notifications through this UnifiedPush Server.</p>\n" +
    "\n" +
    "            <p ng-show=\"exampleCtrl.variantType != 'send'\">Use the code snippet bellow to register your device and allow it to receiving notifications through this UnifiedPush Server.</p>\n" +
    "\n" +
    "            <tabset class=\"ups-code-examples\">\n" +
    "                <tab heading=\"Simple push\" ng-hide=\"exampleCtrl.variantType != 'simplePush'\" active=\"exampleCtrl.tab('simplePush').active\">\n" +
    "                    <div class=\"ups-code-block js\" hljs compile=\"true\">\n" +
    "(function() {\n" +
    "     var endpoint, endpointRequest, SPClient, UPClient;\n" +
    "\n" +
    "     // config params for UnifiedPush server\n" +
    "     var variantId = \"{{ exampleCtrl.variant.variantID }}\";\n" +
    "     var variantSecret = \"{{ exampleCtrl.variant.secret }}\";\n" +
    "     var unifiedPushUrl = \"{{ exampleCtrl.currentLocation }}\";\n" +
    "\n" +
    "      // If your SimplePush Server is running on Openshift, the URL is {{ exampleCtrl.simplePushUrl() }}\n" +
    "      // If your SimplePush Server is using Mozilla's network, the URL will be wss://push.services.mozilla.com\n" +
    "      // or do you run a custom server?\n" +
    "     var simplePushUrl = \"[URL of the SimplePush Server you are using]\";\n" +
    "\n" +
    "      // create the 'UnifiedPush' client object:\n" +
    "     UPClient = AeroGear.UnifiedPushClient(variantId, variantSecret, unifiedPushUrl);\n" +
    "\n" +
    "     // onConnect callback function called when SimplePush\n" +
    "     // successfully establishes connection to the server\n" +
    "     function spConnect() {\n" +
    "\n" +
    "         // use 'PushManager' to request a new PushServer URL endpoint for 'Mail' notifications:\n" +
    "         endpointRequest = navigator.push.register();\n" +
    "          // the DOMRequest returns 'successfully':\n" +
    "         endpointRequest.onsuccess = function( event ) {\n" +
    "             // extract the endpoint object from the event:\n" +
    "             endpoint = event.target.result;\n" +
    "\n" +
    "             // if it is the first registration, need to register\n" +
    "             // the 'pushEndpoint' with the UnifiedPush server.\n" +
    "             if ( endpoint ) {\n" +
    "                 // assemble the metadata for registration with the UnifiedPush server\n" +
    "                 var metadata = {\n" +
    "                     deviceToken: endpoint\n" +
    "                 };\n" +
    "\n" +
    "                 var settings = {\n" +
    "                     success: function() {\n" +
    "                        //success handler\n" +
    "                     },\n" +
    "                     error: function() {\n" +
    "                        //error handler\n" +
    "                     }\n" +
    "                 };\n" +
    "\n" +
    "                 settings.metadata = metadata;\n" +
    "\n" +
    "                 // register with the server\n" +
    "                 UPClient.registerWithPushServer(settings);\n" +
    "             } else {\n" +
    "                 console.log(\"'Endpoint' was already registered!\");\n" +
    "             }\n" +
    "         };\n" +
    "         // set the notification handler:\n" +
    "         navigator.setMessageHandler( \"push\", function( message ) {\n" +
    "             if ( message.pushEndpoint === endpoint ) {\n" +
    "                 // let's react on the endpoint\n" +
    "             }\n" +
    "         });\n" +
    "     }\n" +
    "\n" +
    "     // onClose callback function:\n" +
    "     function spClose() {\n" +
    "         // handle onclose - e.g. allow reconnect\n" +
    "     }\n" +
    "\n" +
    "     SPClient = AeroGear.SimplePushClient({\n" +
    "         simplePushServerURL: simplePushUrl,\n" +
    "         onConnect: spConnect,\n" +
    "         onClose: spClose\n" +
    "    });\n" +
    " })();\n" +
    "                    </div>\n" +
    "                </tab>\n" +
    "                <tab heading=\"Android\" ng-hide=\"exampleCtrl.variantType != 'android'\" active=\"exampleCtrl.tab('android').active\" ng-click=\"exampleCtrl.tab('android').active = true\">\n" +
    " <div class=\"ups-code-block java\" hljs compile=\"true\">\n" +
    "package com.push.pushapplication;\n" +
    "\n" +
    "import org.jboss.aerogear.android.core.Callback;\n" +
    "import org.jboss.aerogear.android.unifiedpush.PushRegistrar;\n" +
    "import org.jboss.aerogear.android.unifiedpush.RegistrarManager;\n" +
    "import org.jboss.aerogear.android.unifiedpush.gcm.AeroGearGCMPushConfiguration;\n" +
    "\n" +
    "import android.app.Application;\n" +
    "\n" +
    "public class PushApplication extends Application {\n" +
    "\n" +
    "    private final String TAG = PushApplication.class.getName();\n" +
    "\n" +
    "    private final String VARIANT_ID       = \"{{ exampleCtrl.variant.variantID }}\";\n" +
    "    private final String SECRET           = \"{{ exampleCtrl.variant.secret }}\";\n" +
    "    private final String GCM_SENDER_ID    = \"{{ exampleCtrl.variant.projectNumber }}\";\n" +
    "    private final String UNIFIED_PUSH_URL = \"{{ exampleCtrl.currentLocation }}\";\n" +
    "\n" +
    "    @Override\n" +
    "    public void onCreate() {\n" +
    "        super.onCreate();\n" +
    "\n" +
    "        try {\n" +
    "\n" +
    "            RegistrarManager.config(\"register\", AeroGearGCMPushConfiguration.class)\n" +
    "                    .setPushServerURI(new URI(UNIFIED_PUSH_URL))\n" +
    "                    .setSenderIds(GCM_SENDER_ID)\n" +
    "                    .setVariantID(VARIANT_ID)\n" +
    "                    .setSecret(SECRET)\n" +
    "                    .asRegistrar();\n" +
    "\n" +
    "            PushRegistrar registrar = RegistrarManager.getRegistrar(\"register\");\n" +
    "            registrar.register(getApplicationContext(), new Callback<Void>() {\n" +
    "                @Override\n" +
    "                public void onSuccess(Void data) {\n" +
    "                    Log.i(TAG, \"Registration Succeeded!\");\n" +
    "                }\n" +
    "\n" +
    "                @Override\n" +
    "                public void onFailure(Exception e) {\n" +
    "                    Log.e(TAG, exception.getMessage(), exception);\n" +
    "                }\n" +
    "            });\n" +
    "\n" +
    "        } catch (IllegalArgumentException e) {\n" +
    "            throw new RuntimeException(e);\n" +
    "        } catch (URISyntaxException e) {\n" +
    "            throw new RuntimeException(e);\n" +
    "        }\n" +
    "    }\n" +
    "}\n" +
    "</div>\n" +
    "                </tab>\n" +
    "                <tab heading=\"iOS - Objective-C\" ng-hide=\"exampleCtrl.variantType != 'ios'\" active=\"exampleCtrl.tab('ios').active\" ng-click=\"exampleCtrl.tab('ios').active = true\">\n" +
    "                    <div class=\"ups-code-block\" hljs compile=\"true\" language=\"objectivec\" include=\"'objectivec'\"></div>\n" +
    "                    <script type=\"text/ng-template\" id=\"objectivec\">\n" +
    "- (void)application:(UIApplication *)application\n" +
    " didRegisterForRemoteNotificationsWithDeviceToken:(NSData *)deviceToken {\n" +
    "   NSLog(@\"APNS Success\");\n" +
    "\n" +
    "   AGDeviceRegistration *registration =\n" +
    "     [[AGDeviceRegistration alloc] initWithServerURL:\n" +
    "        [NSURL URLWithString:@\"{{ exampleCtrl.currentLocation }}\"]];\n" +
    "\n" +
    "   [registration registerWithClientInfo:^(id clientInfo) {\n" +
    "\n" +
    "     // apply the token, to identify this device\n" +
    "     [clientInfo setDeviceToken:deviceToken];\n" +
    "\n" +
    "     [clientInfo setVariantID:@\"{{ exampleCtrl.variant.variantID }}\"];\n" +
    "     [clientInfo setVariantSecret:@\"{{ exampleCtrl.variant.secret }}\"];\n" +
    "\n" +
    "     // --optional config--\n" +
    "     // set some 'useful' hardware information params\n" +
    "     UIDevice *currentDevice = [UIDevice currentDevice];\n" +
    "     [clientInfo setOperatingSystem:[currentDevice systemName]];\n" +
    "     [clientInfo setOsVersion:[currentDevice systemVersion]];\n" +
    "     [clientInfo setDeviceType: [currentDevice model]];\n" +
    "\n" +
    "     } success:^() {\n" +
    "       NSLog(@\"UPS registration worked\");\n" +
    "\n" +
    "     } failure:^(NSError *error) {\n" +
    "       NSLog(@\"UPS registration Error: %@\", error);\n" +
    "   }];\n" +
    " }\n" +
    "                  </script>\n" +
    "\n" +
    "                </tab>\n" +
    "                <tab heading=\"iOS - Swift\" ng-hide=\"exampleCtrl.variantType != 'ios'\" active=\"exampleCtrl.tab('iOSSwift').active\" ng-click=\"exampleCtrl.tab('iOSSwift').active = true\">\n" +
    "                    <div class=\"ups-code-block\" hljs compile=\"true\" language=\"objectivec\" include=\"'swift'\"></div>\n" +
    "                    <script type=\"text/ng-template\" id=\"swift\">\n" +
    "func application(application: UIApplication!, didRegisterForRemoteNotificationsWithDeviceToken deviceToken: NSData!) {\n" +
    "    println(\"APNS Success\")\n" +
    "\n" +
    "    let registration = AGDeviceRegistration(serverURL: NSURL(string: \"{{ exampleCtrl.currentLocation }}\"))\n" +
    "\n" +
    "    registration.registerWithClientInfo({ (clientInfo: AGClientDeviceInformation!)  in\n" +
    "\n" +
    "        // apply the token, to identify this device\n" +
    "        clientInfo.deviceToken = deviceToken\n" +
    "\n" +
    "        clientInfo.variantID = \"{{ exampleCtrl.variant.variantID }}\"\n" +
    "        clientInfo.variantSecret = \"{{ exampleCtrl.variant.secret }}\"\n" +
    "\n" +
    "        // --optional config--\n" +
    "        // set some 'useful' hardware information params\n" +
    "        let currentDevice = UIDevice()\n" +
    "        clientInfo.operatingSystem = currentDevice.systemName\n" +
    "        clientInfo.osVersion = currentDevice.systemVersion\n" +
    "        clientInfo.deviceType = currentDevice.model\n" +
    "\n" +
    "    }, success: {\n" +
    "        println(\"UPS registration worked\");\n" +
    "\n" +
    "    }, failure: { (error:NSError!) -> () in\n" +
    "        println(\"UPS registration Error: \\(error.localizedDescription)\")\n" +
    "    })\n" +
    "}\n" +
    "                    </script>\n" +
    "\n" +
    "                </tab>\n" +
    "              <tab heading=\"Amazon - FireOS\" ng-hide=\"exampleCtrl.variantType != 'adm'\" active=\"exampleCtrl.tab('adm').active\" ng-click=\"exampleCtrl.tab('adm').active = true\">\n" +
    "                <div class=\"ups-code-block java\" hljs compile=\"true\"  include=\"'adm'\"></div>\n" +
    "                <script type=\"text/ng-template\" id=\"adm\">\n" +
    "                 //TODO Will be filled in once the client SDK is there\n" +
    "                </script>\n" +
    "\n" +
    "              </tab>\n" +
    "              <tab heading=\"Cordova\" ng-hide=\"exampleCtrl.variantType == 'simplePush' || exampleCtrl.variantType == 'send'\" active=\"exampleCtrl.tab('cordova').active\" ng-click=\"exampleCtrl.tab('cordova').active = true\">\n" +
    "                    <div class=\"ups-code-block js\" hljs compile=\"true\">\n" +
    "var app = {\n" +
    "    // Application Constructor\n" +
    "    initialize: function() {\n" +
    "        this.bindEvents();\n" +
    "    },\n" +
    "    // Bind Event Listeners\n" +
    "    //\n" +
    "    // Bind any events that are required on startup. Common events are:\n" +
    "    // 'load', 'deviceready', 'offline', and 'online'.\n" +
    "    bindEvents: function() {\n" +
    "        document.addEventListener('deviceready', this.onDeviceReady, false);\n" +
    "    },\n" +
    "    // deviceready Event Handler\n" +
    "    //\n" +
    "    // The scope of 'this' is the event. In order to call the 'receivedEvent'\n" +
    "    // function, we must explicitly call 'app.receivedEvent(...);'\n" +
    "    onDeviceReady: function() {\n" +
    "        app.receivedEvent('deviceready');\n" +
    "        var pushConfig = {\n" +
    "           pushServerURL: \"{{ exampleCtrl.currentLocation }}\",\n" +
    "           {{ exampleCtrl.cordovaVariantType(exampleCtrl.variant) }}: {\n" +
    "              {{ exampleCtrl.projectNumber(exampleCtrl.variant) }}\n" +
    "              variantID: \"{{ exampleCtrl.variant.variantID }}\",\n" +
    "              variantSecret: \"{{ exampleCtrl.variant.secret }}\"\n" +
    "           }\n" +
    "        };\n" +
    "        push.register(app.onNotification, successHandler, errorHandler, pushConfig);\n" +
    "\n" +
    "        function successHandler() {\n" +
    "            console.log('success')\n" +
    "        }\n" +
    "\n" +
    "        function errorHandler(message) {\n" +
    "            console.log('error ' + message);\n" +
    "        }\n" +
    "    },\n" +
    "    onNotification: function(event) {\n" +
    "        alert(event.alert);\n" +
    "    },\n" +
    "    // Update DOM on a Received Event\n" +
    "    receivedEvent: function(id) {\n" +
    "        var parentElement = document.getElementById(id);\n" +
    "        var listeningElement = parentElement.querySelector('.listening');\n" +
    "        var receivedElement = parentElement.querySelector('.received');\n" +
    "\n" +
    "        listeningElement.setAttribute('style', 'display:none;');\n" +
    "        receivedElement.setAttribute('style', 'display:block;');\n" +
    "\n" +
    "        console.log('Received Event: ' + id);\n" +
    "    }\n" +
    "};\n" +
    "\n" +
    "app.initialize();\n" +
    "                    </div>\n" +
    "<br>\n" +
    "<p ng-show=\"exampleCtrl.variantType != 'send'\">It's also possible to use an external config file named <b>push-config.json</b> and placed in the root of your <b>www</b> folder :</p>\n" +
    "<br>\n" +
    "                    <div class=\"ups-code-block\">\n" +
    "<pre>\n" +
    "<code>\n" +
    "// ../www/push-config.json\n" +
    "{\n" +
    "  \"pushServerURL\": \"{{ exampleCtrl.currentLocation }}\",\n" +
    "  \"{{ exampleCtrl.cordovaVariantType(exampleCtrl.variant) }}\" : {\n" +
    "    {{ exampleCtrl.projectNumberJson(exampleCtrl.variant) }}\n" +
    "    \"variantID\": \"{{ exampleCtrl.variant.variantID }}\",\n" +
    "    \"variantSecret\": \"{{ exampleCtrl.variant.secret }}\"\n" +
    "  }\n" +
    "}\n" +
    "</code>\n" +
    "</pre>\n" +
    "                    </div>\n" +
    "<br>\n" +
    "And then :\n" +
    "<br>\n" +
    "                   <div class=\"ups-code-block js\" hljs compile=\"true\">\n" +
    "var app = {\n" +
    "  // Application Constructor\n" +
    "  initialize: function() {\n" +
    "      this.bindEvents();\n" +
    "  },\n" +
    "  // Bind Event Listeners\n" +
    "  //\n" +
    "  // Bind any events that are required on startup. Common events are:\n" +
    "  // 'load', 'deviceready', 'offline', and 'online'.\n" +
    "  bindEvents: function() {\n" +
    "      document.addEventListener('deviceready', this.onDeviceReady, false);\n" +
    "  },\n" +
    "  // deviceready Event Handler\n" +
    "  //\n" +
    "  // The scope of 'this' is the event. In order to call the 'receivedEvent'\n" +
    "  // function, we must explicitly call 'app.receivedEvent(...);'\n" +
    "  onDeviceReady: function() {\n" +
    "      app.receivedEvent('deviceready');\n" +
    "      push.register(app.onNotification, successHandler, errorHandler);\n" +
    "\n" +
    "      function successHandler() {\n" +
    "          console.log('success')\n" +
    "      }\n" +
    "\n" +
    "      function errorHandler(message) {\n" +
    "          console.log('error ' + message);\n" +
    "      }\n" +
    "  },\n" +
    "  onNotification: function(event) {\n" +
    "      alert(event.alert);\n" +
    "  },\n" +
    "  // Update DOM on a Received Event\n" +
    "  receivedEvent: function(id) {\n" +
    "      var parentElement = document.getElementById(id);\n" +
    "      var listeningElement = parentElement.querySelector('.listening');\n" +
    "      var receivedElement = parentElement.querySelector('.received');\n" +
    "\n" +
    "      listeningElement.setAttribute('style', 'display:none;');\n" +
    "      receivedElement.setAttribute('style', 'display:block;');\n" +
    "\n" +
    "      console.log('Received Event: ' + id);\n" +
    "  }\n" +
    "};\n" +
    "\n" +
    "app.initialize();\n" +
    "                    </div>\n" +
    "\n" +
    "                </tab>\n" +
    "\n" +
    "                <tab heading=\"Sending\" ng-hide=\"exampleCtrl.variantType != 'send'\" active=\"exampleCtrl.tab('send').active\" ng-click=\"exampleCtrl.tab('send').active = true\">\n" +
    "                    <div class=\"ups-code-block java\" hljs compile=\"true\">\n" +
    "JavaSender defaultJavaSender = new SenderClient.Builder(\"{{ exampleCtrl.currentLocation }}\").build();\n" +
    "UnifiedMessage unifiedMessage = new UnifiedMessage.Builder()\n" +
    "        .pushApplicationId(\"{{ exampleCtrl.applicationId }}\")\n" +
    "        .masterSecret(\"{{ exampleCtrl.application.masterSecret }}\")\n" +
    "        .alert(\"Hello from Java Sender API!\")\n" +
    "        .build();\n" +
    "defaultJavaSender.send(unifiedMessage, new MessageResponseCallback() {\n" +
    "\n" +
    "    @Override\n" +
    "    public void onComplete(int statusCode) {\n" +
    "        //do cool stuff\n" +
    "    }\n" +
    "\n" +
    "    @Override\n" +
    "    public void onError(Throwable throwable) {\n" +
    "        //bring out the bad news\n" +
    "    }\n" +
    "});\n" +
    "                    </div>\n" +
    "                </tab>\n" +
    "\n" +
    "                <tab heading=\"C#\" ng-hide=\"exampleCtrl.variantType != 'windows_wns'\" active=\"exampleCtrl.tab('windows_wns').active\" ng-click=\"exampleCtrl.tab('windows_wns').active = true\">\n" +
    "                    <div class=\"ups-code-block csharp\" hljs compile=\"true\">\n" +
    "using AeroGear.Push;\n" +
    "\n" +
    "protected async override void OnLaunched(LaunchActivatedEventArgs e)\n" +
    "{\n" +
    "  PushConfig pushConfig = new PushConfig() { UnifiedPushUri = new Uri(\"{{ exampleCtrl.currentLocation }}\"), VariantId = \"{{ exampleCtrl.variant.variantID }}\", VariantSecret = \"{{ exampleCtrl.variant.secret }}\" };\n" +
    "  Registration registration = new WnsRegistration();\n" +
    "  registration.PushReceivedEvent += HandleNotification;\n" +
    "  await registration.Register(pushConfig);\n" +
    "\n" +
    "  ...\n" +
    "}\n" +
    "\n" +
    "void HandleNotification(object sender, PushReceivedEvent e)\n" +
    "{\n" +
    "  Debug.WriteLine(\"notification received {0}\", e.Args.message);\n" +
    "}\n" +
    "\n" +
    "                    </div>\n" +
    "                </tab>\n" +
    "                <tab heading=\"C#\" ng-hide=\"exampleCtrl.variantType != 'windows_mpns'\" active=\"exampleCtrl.tab('windows_mpns').active\" ng-click=\"exampleCtrl.tab('windows_mpns').active = true\">\n" +
    "                    <div class=\"ups-code-block csharp\" hljs compile=\"true\">\n" +
    "using AeroGear.Push;\n" +
    "\n" +
    "protected async override void OnLaunched(LaunchActivatedEventArgs e)\n" +
    "{\n" +
    "  PushConfig pushConfig = new PushConfig() { UnifiedPushUri = new Uri(\"{{ exampleCtrl.currentLocation }}\"), VariantId = \"{{ exampleCtrl.variant.variantID }}\", VariantSecret = \"{{ exampleCtrl.variant.secret }}\" };\n" +
    "  Registration registration = new MpnsRegistration();\n" +
    "  registration.PushReceivedEvent += HandleNotification;\n" +
    "  await registration.Register(pushConfig);\n" +
    "\n" +
    "  ...\n" +
    "}\n" +
    "\n" +
    "void HandleNotification(object sender, PushReceivedEvent e)\n" +
    "{\n" +
    "  Debug.WriteLine(\"notification received {0}\", e.Args.message);\n" +
    "}\n" +
    "\n" +
    "                    </div>\n" +
    "                </tab>\n" +
    "\n" +
    "            </tabset>\n" +
    "\n" +
    "        </div>\n" +
    "    </div>\n" +
    "</div>\n"
  );


  $templateCache.put('views/installation.html',
    "<div class=\"col-md-10 lo-main-pane ng-scope\">\n" +
    "    <div class=\"row\">\n" +
    "        <div class=\"lo-content-area col-md-12\">\n" +
    "            <div ups-breadcrumb/>\n" +
    "            <div class=\"panel lo-panel ups-panel-installations\">\n" +
    "                <div class=\"panel-heading\">\n" +
    "                    <div class=\"pull-right\">\n" +
    "                        <input type=\"search\" class=\"form-control\" placeholder=\"Search...\" ng-model=\"search\">\n" +
    "                    </div>\n" +
    "                    <div style=\"clear: both;\"></div>\n" +
    "                </div>\n" +
    "                <p ng-hide=\"installationCtrl.installations.length\">No Installations yet</p>\n" +
    "                <table class=\"ups-installations\" ng-show=\"installationCtrl.installations.length\">\n" +
    "                    <thead>\n" +
    "                    <tr>\n" +
    "                        <th class=\"col-md-6\">Device token</th>\n" +
    "                        <th class=\"col-md-2\">Alias</th>\n" +
    "                        <th class=\"col-md-2\">OS</th>\n" +
    "                        <th class=\"col-md-2\">Receiving</th>\n" +
    "                    </tr>\n" +
    "                    </thead>\n" +
    "                    <tbody >\n" +
    "                    <tr ng-repeat-start=\"installation in installationCtrl.installations | filter:search\">\n" +
    "                        <td>\n" +
    "                            <a href=\"\" ng-click=\"installationCtrl.expand(installation)\">\n" +
    "                                <i class=\"fa\" ng-class=\"{'fa-caret-right': installationCtrl.isCollapsed(installation), 'fa-caret-down': !installationCtrl.isCollapsed(installation)}\"></i>\n" +
    "                                {{ installation.deviceToken | limitTo : 50 }}...\n" +
    "                            </a>\n" +
    "                        </td>\n" +
    "                        <td>{{ installation.alias }} <div ng-hide=\"installation.alias.length\">No alias</div></td>\n" +
    "                        <td>{{ installation.os }}</td>\n" +
    "                        <td>\n" +
    "                            <label class=\"ups-switch\">\n" +
    "                                <input type=\"checkbox\" class=\"ups-switch__input\" ng-checked=\"installation.enabled\" ng-click=\"installationCtrl.update(installation)\">\n" +
    "                                <div class=\"ups-switch__toggle\"></div>\n" +
    "                            </label>\n" +
    "                        </td>\n" +
    "                    </tr>\n" +
    "                    <tr collapse=\"installationCtrl.isCollapsed(installation)\" ng-repeat-end>\n" +
    "                        <td colspan=\"4\">\n" +
    "                            <table class=\"ups-installation-detail\">\n" +
    "                                <tr>\n" +
    "                                    <td>Categories:</td>\n" +
    "                                    <td class=\"cat\"><span ng-repeat=\"cat in installation.categories\">{{ cat.name }}</span></td>\n" +
    "                                </tr>\n" +
    "                                <tr>\n" +
    "                                    <td>Device type:</td>\n" +
    "                                    <td>{{ installation.deviceType }}</td>\n" +
    "                                </tr>\n" +
    "                                <tr>\n" +
    "                                    <td >Token:</td>\n" +
    "                                    <td><div class=\"device-token break-words\">{{ installation.deviceToken }}</div></td>\n" +
    "                                </tr>\n" +
    "                            </table>\n" +
    "                        </td>\n" +
    "                    </tr>\n" +
    "                    </tbody>\n" +
    "                </table>\n" +
    "            </div>\n" +
    "            <pagination direction-links=\"true\" boundary-links=\"false\" total-items=\"installationCtrl.totalItems\" ng-model=\"installationCtrl.currentPage\" previous-text=\"&lsaquo;\" next-text=\"&rsaquo;\" class=\"pull-right ups-pagination\" ng-show=\"installationCtrl.installations.length\" ng-change=\"installationCtrl.pageChanged()\" max-size=\"5\" rotate=\"false\"></pagination>\n" +
    "        </div>\n" +
    "    </div>\n" +
    "</div>\n"
  );


  $templateCache.put('views/loading.html',
    "<div class=\"col-md-10\">\n" +
    "    <div class=\"row\">\n" +
    "        <div class=\"lo-content-area col-md-12\">\n" +
    "          <div class=\"ups-spinner spinner spinner-lg\"></i>\n" +
    "        </div>\n" +
    "    </div>\n" +
    "</div>\n" +
    "\n"
  );


  $templateCache.put('views/notification.html',
    "<div class=\"col-md-10 lo-main-pane ng-scope\">\n" +
    "  <div class=\"row\">\n" +
    "    <div class=\"lo-content-area col-md-12\">\n" +
    "\n" +
    "      <div ups-breadcrumb/>\n" +
    "\n" +
    "      <div class=\"panel lo-panel ups-panel\" style=\"margin-top: 20px\">\n" +
    "        <div class=\"ups-padding-box\">\n" +
    "          <table class=\"expand\">\n" +
    "            <th>\n" +
    "              <tr>\n" +
    "                <td style=\"padding: 6px 0;\"><strong>Notification</strong>\n" +
    "                </td>\n" +
    "                <td><strong>Receivers</strong>\n" +
    "                </td>\n" +
    "                <td><strong>Status</strong>\n" +
    "                </td>\n" +
    "                <td><strong>Timestamp</strong>\n" +
    "                </td>\n" +
    "              </tr>\n" +
    "            </th>\n" +
    "            <tr style=\"border-top: 1px #eee solid\" ng-repeat-start=\"metric in activityCtrl.pushMetrics\">\n" +
    "              <td style=\"padding: 8px 0;\">\n" +
    "                <a href ng-click=\"activityCtrl.expand(metric)\">\n" +
    "                  <i class=\"fa\"\n" +
    "                     ng-class=\"{'fa-plus-square-o': activityCtrl.isCollapsed(metric), 'fa-minus-square-o': !activityCtrl.isCollapsed(metric)}\"></i>\n" +
    "                  {{ metric.rawJsonMessage | limitTo : 50 }}...\n" +
    "                </a>\n" +
    "              </td>\n" +
    "              <td>\n" +
    "                <strong>{{ metric.totalReceivers }}</strong> installations\n" +
    "              </td>\n" +
    "              <td>\n" +
    "                <strong>\n" +
    "                  {{metric.deliveryStatus}}\n" +
    "                  <i class=\"fa fa-warning\" ng-show=\"metric.deliveryFailed == true\"></i>\n" +
    "                  {{ metric.deliveryFailed == true ? 'Failed' : 'Succeeded' }}\n" +
    "                </strong>\n" +
    "              </td>\n" +
    "              <td>\n" +
    "                {{ metric.submitDate | date : 'd MMM, HH:mm:ss, yyyy' }}\n" +
    "              </td>\n" +
    "            </tr>\n" +
    "            <tr collapse=\"activityCtrl.isCollapsed(metric)\" ng-repeat-end>\n" +
    "              <td colspan=\"4\" style=\"padding: 8px;\">\n" +
    "                <div class=\"ups-toggle-box ups-panel-details\">\n" +
    "                  <table>\n" +
    "                    <tr>\n" +
    "                      <td>Request IP:</td>\n" +
    "                      <td><strong>{{ metric.ipAddress }}</strong>\n" +
    "                      </td>\n" +
    "                      <td><a href ng-click=\"activityCtrl.showFullRequest(metric.rawJsonMessage)\">Details</a>\n" +
    "                      </td>\n" +
    "                    </tr>\n" +
    "                    <tr>\n" +
    "                      <td>Message:</td>\n" +
    "                      <td colspan=\"2\"><strong>{{ activityCtrl.parse(metric).alert }}</strong></td>\n" +
    "                    </tr>\n" +
    "                  </table>\n" +
    "                  <hr ng-show=\"metric.deliveryFailed\">\n" +
    "                  <table ng-show=\"metric.deliveryFailed\">\n" +
    "                    <tr>\n" +
    "                      <td>Error:</td>\n" +
    "                      <td><strong>Problem occurred during sending push notification(s)</strong></td>\n" +
    "                      <td><a href=\"#/detail/{{activityCtrl.applicationId}}\">Edit Push Network...</a></td>\n" +
    "                    </tr>\n" +
    "                    <tr ng-if=\"activityCtrl.detailsPage()\">\n" +
    "                      <td>Reason:</td>\n" +
    "                      <td colspan=\"2\">{{ metric.variantInformations[0].reason }}</td>\n" +
    "                    </tr>\n" +
    "                  </table>\n" +
    "                  <hr ng-show=\"!activityCtrl.detailsPage() && metric.variantInformations.length\">\n" +
    "                  <table ng-if=\"!activityCtrl.detailsPage() && metric.variantInformations.length\">\n" +
    "                    <tr>\n" +
    "                      <td>Variants:</td>\n" +
    "                      <td>\n" +
    "                        <table class=\"expand\">\n" +
    "                          <tr ng-repeat=\"variant in activityCtrl.variantMetricInformation(metric.variantInformations)\">\n" +
    "                            <td>\n" +
    "                              <a href=\"#/detail/{{applicationId}}\">{{ variant.name ? variant.name : variant.variantID }}</a>\n" +
    "                            </td>\n" +
    "                            <td>{{ variant.deliveryStatus == false ? 'Failed' : 'Succeeded' }}</td>\n" +
    "                            <td>\n" +
    "                              <strong>{{ variant.receivers }}</strong> installations\n" +
    "                            </td>\n" +
    "                          </tr>\n" +
    "                        </table>\n" +
    "                      </td>\n" +
    "                    </tr>\n" +
    "                  </table>\n" +
    "                </div>\n" +
    "              </td>\n" +
    "            </tr>\n" +
    "          </table>\n" +
    "        </div>\n" +
    "        <pagination direction-links=\"true\" boundary-links=\"false\" total-items=\"activityCtrl.totalItems\" ng-model=\"activityCtrl.currentPage\" previous-text=\"&lsaquo;\" next-text=\"&rsaquo;\" class=\"pull-right ups-pagination\" ng-show=\"activityCtrl.pushMetrics.length\" ng-change=\"activityCtrl.pageChanged()\" max-size=\"5\" rotate=\"false\"></pagination>\n" +
    "      </div>\n" +
    "    </div>\n" +
    "  </div>\n" +
    "</div>\n"
  );


  $templateCache.put('views/dialogs/add-criteria.html',
    "<div class=\"modal-content\">\n" +
    "    <div class=\"modal-header\">\n" +
    "        <button type=\"button\" class=\"close\" aria-hidden=\"true\" ng-click=\"cancel()\">\n" +
    "            <span class=\"pficon pficon-close\"></span>\n" +
    "        </button>\n" +
    "        <h4 class=\"modal-title\">Filters</h4>\n" +
    "    </div>\n" +
    "    <div class=\"modal-body\">\n" +
    "    <p style=\"opacity: 0.5\">You can provide multiple values at a time by separating them by commas.</p>\n" +
    "    <br>\n" +
    "        <form name=\"form\" class=\"form-horizontal\">\n" +
    "            <div class=\"form-group\">\n" +
    "                <label class=\"col-sm-3 control-label\">Aliases</label>\n" +
    "\n" +
    "                <div class=\"col-sm-7\">\n" +
    "                    <input type=\"text\" placeholder=\"All\" class=\"form-control\" ng-model=\"criteria.alias\">\n" +
    "                </div>\n" +
    "            </div>\n" +
    "            <div class=\"form-group\">\n" +
    "                <label class=\"col-sm-3 control-label\">Device Types</label>\n" +
    "\n" +
    "                <div class=\"col-sm-7\">\n" +
    "                    <input type=\"text\" placeholder=\"All\" class=\"form-control\" ng-model=\"criteria.deviceType\">\n" +
    "                </div>\n" +
    "            </div>\n" +
    "            <div class=\"form-group\">\n" +
    "                <label class=\"col-sm-3 control-label\" >Categories</label>\n" +
    "\n" +
    "                <div class=\"col-sm-7\">\n" +
    "                    <input type=\"text\" placeholder=\"All\" class=\"form-control\" ng-model=\"criteria.categories\">\n" +
    "                </div>\n" +
    "            </div>\n" +
    "        </form>\n" +
    "    </div>\n" +
    "    <div class=\"modal-footer\">\n" +
    "        <button type=\"button\" class=\"btn btn-default\" ng-click=\"cancel()\">Cancel</button>\n" +
    "        <button type=\"button\" class=\"btn btn-primary\" ng-click=\"ok(application)\" ng-disabled=\"form.$pristine\">Change</button>\n" +
    "    </div>\n" +
    "</div>"
  );


  $templateCache.put('views/dialogs/create-app.html',
    "<form name=\"form\" class=\"modal-content\">\n" +
    "    <div class=\"modal-header\">\n" +
    "        <button type=\"button\" class=\"close\" aria-hidden=\"true\" ng-click=\"cancel()\">\n" +
    "            <span class=\"pficon pficon-close\"></span>\n" +
    "        </button>\n" +
    "        <h4 class=\"modal-title\">{{ application.id ? 'Edit' : 'Create' }} Application</h4>\n" +
    "    </div>\n" +
    "    <div class=\"modal-body\">\n" +
    "        <div class=\"form-horizontal\">\n" +
    "            <div class=\"form-group\">\n" +
    "                <label class=\"col-sm-4 control-label\" for=\"createAppName\">Name</label>\n" +
    "\n" +
    "                <div class=\"col-sm-6\">\n" +
    "                    <input type=\"text\" placeholder=\"e.g. MyApp\" id=\"createAppName\" class=\"form-control\" ng-model=\"application.name\" required pf-focused=\"true\">\n" +
    "                </div>\n" +
    "            </div>\n" +
    "            <div class=\"form-group\">\n" +
    "                <label class=\"col-sm-4 control-label\" for=\"createAppDescription\">Description</label>\n" +
    "\n" +
    "                <div class=\"col-sm-6\">\n" +
    "                    <input type=\"text\" placeholder=\"e.g. A useful application for everyone.\" id=\"createAppDescription\" class=\"form-control\" ng-model=\"application.description\">\n" +
    "                </div>\n" +
    "            </div>\n" +
    "        </div>\n" +
    "    </div>\n" +
    "    <div class=\"modal-footer\">\n" +
    "        <input type=\"button\" class=\"btn btn-default\" ng-click=\"cancel()\" value=\"Cancel\" />\n" +
    "        <input type=\"submit\" class=\"btn btn-primary\" ng-click=\"ok(application)\" ng-disabled=\"form.$invalid\" value=\"{{ application.id ? 'Save' : 'Create' }}\" />\n" +
    "    </div>\n" +
    "</form>\n"
  );


  $templateCache.put('views/dialogs/create-variant.html',
    "<form name=\"form\" class=\"modal-content ups-modal-content ups-add-variable\">\n" +
    "  <div class=\"modal-header\">\n" +
    "    <button type=\"button\" class=\"close\" aria-hidden=\"true\" ng-click=\"dismiss()\">\n" +
    "      <span class=\"pficon pficon-close\"></span>\n" +
    "    </button>\n" +
    "    <h4 class=\"modal-title\" id=\"myModalLabel\">{{ isNew ? 'Add' : 'Edit' }} Variant</h4>\n" +
    "  </div>\n" +
    "  <div class=\"modal-body form-horizontal\">\n" +
    "    <div class=\"form-group\">\n" +
    "      <label class=\"col-sm-3 control-label\" for=\"textInput-modal-markup\">Name</label>\n" +
    "      <div class=\"col-sm-9\">\n" +
    "        <input type=\"text\" id=\"textInput-modal-markup\" class=\"form-control\" placeholder=\"eg. Demo\" ng-model=\"variant.name\" required=\"required\">\n" +
    "      </div>\n" +
    "    </div>\n" +
    "\n" +
    "    <div class=\"form-group\" ng-if=\"isNew\">\n" +
    "      <label class=\"col-sm-3 control-label\" for=\"optionAndroid\">Choose a platform</label>\n" +
    "      <div class=\"col-sm-9\">\n" +
    "        <div class=\"radio\">\n" +
    "          <label>\n" +
    "            <input type=\"radio\" name=\"variantType\" id=\"optionAndroid\" value=\"android\" ng-model=\"variant.type\" ng-required=\"true\">\n" +
    "                <span class=\"ups-has-icon ups-variant-android\">\n" +
    "                  <strong>Android</strong><br>\n" +
    "                  using Google Cloud Messaging\n" +
    "                </span>\n" +
    "          </label>\n" +
    "        </div>\n" +
    "      </div>\n" +
    "    </div>\n" +
    "\n" +
    "\n" +
    "    <div class=\"form-group\" ng-if=\"isNew\">\n" +
    "      <label class=\"col-sm-3 control-label sr-only\" for=\"optionIos\">iOS</label>\n" +
    "      <div class=\"col-sm-9\">\n" +
    "        <div class=\"radio\">\n" +
    "          <label>\n" +
    "            <input type=\"radio\" name=\"variantType\" id=\"optionIos\" value=\"ios\" ng-model=\"variant.type\" ng-required=\"true\">\n" +
    "                <span class=\"ups-has-icon ups-variant-ios\">\n" +
    "                  <strong>iOS</strong><br>\n" +
    "                  using Apple Push Network\n" +
    "                </span>\n" +
    "          </label>\n" +
    "        </div>\n" +
    "      </div>\n" +
    "    </div>\n" +
    "\n" +
    "\n" +
    "    <div class=\"form-group\" ng-if=\"isNew\">\n" +
    "      <label class=\"col-sm-3 control-label sr-only\" for=\"optionWindows\">Windows</label>\n" +
    "      <div class=\"col-sm-9\">\n" +
    "        <div class=\"radio\">\n" +
    "          <label>\n" +
    "            <input type=\"radio\" name=\"variantType\" id=\"optionWindows\" value=\"windows\" ng-model=\"variant.type\" ng-required=\"true\">\n" +
    "                <span class=\"ups-has-icon ups-variant-windows\">\n" +
    "                  <strong>Windows</strong><br>\n" +
    "                  using Windows Network Services\n" +
    "                </span>\n" +
    "          </label>\n" +
    "        </div>\n" +
    "      </div>\n" +
    "    </div>\n" +
    "\n" +
    "    <div class=\"form-group\" ng-if=\"isNew\">\n" +
    "      <label class=\"col-sm-3 control-label sr-only\" for=\"optionSimplePush\">SimplePush</label>\n" +
    "      <div class=\"col-sm-9\">\n" +
    "        <div class=\"radio\">\n" +
    "          <label>\n" +
    "            <input type=\"radio\" name=\"variantType\" id=\"optionSimplePush\" value=\"simplePush\" ng-model=\"variant.type\" ng-required=\"true\">\n" +
    "                <span class=\"ups-has-icon ups-variant-simplePush\">\n" +
    "                  <strong>SimplePush</strong><br>\n" +
    "                  using the Mozilla WebAPI\n" +
    "                </span>\n" +
    "          </label>\n" +
    "        </div>\n" +
    "      </div>\n" +
    "    </div>\n" +
    "\n" +
    "    <div class=\"form-group\" ng-if=\"isNew\">\n" +
    "      <label class=\"col-sm-3 control-label sr-only\" for=\"optionsAdm\">SimplePush</label>\n" +
    "      <div class=\"col-sm-9\">\n" +
    "        <div class=\"radio\">\n" +
    "          <label>\n" +
    "            <input type=\"radio\" name=\"variantType\" id=\"optionsAdm\" value=\"adm\" ng-model=\"variant.type\" ng-required=\"true\">\n" +
    "                <span class=\"ups-has-icon ups-variant-adm\">\n" +
    "                  <strong>ADM</strong><br>\n" +
    "                  using Amazon Push Network\n" +
    "                </span>\n" +
    "          </label>\n" +
    "        </div>\n" +
    "      </div>\n" +
    "    </div>\n" +
    "\n" +
    "    <div ng-show=\"variant.type\">\n" +
    "\n" +
    "      <div ng-show=\"variant.type == 'android'\">\n" +
    "        <div class=\"form-group\">\n" +
    "          <label class=\"col-sm-3 control-label\" for=\"gcmApiKey\">Push Network</label>\n" +
    "          <div class=\"col-sm-7\"><em>Google Cloud Messaging</em> Key<br>\n" +
    "            <input type=\"text\" placeholder=\"e.g. 5a448c2f31700a466fbc9d33d33942b043a27596\" id=\"gcmApiKey\" class=\"form-control\" ng-model=\"variant.googleKey\" ng-required=\"variant.type == 'android'\">\n" +
    "          </div>\n" +
    "        </div>\n" +
    "        <div class=\"form-group\">\n" +
    "          <label class=\"col-sm-3 control-label\" for=\"gcmProjectNumber\"></label>\n" +
    "          <div class=\"col-sm-7\">\n" +
    "            Project Number<br>\n" +
    "            <input type=\"text\" placeholder=\"e.g. 42\" id=\"gcmProjectNumber\" class=\"form-control\" ng-model=\"variant.projectNumber\" ng-required=\"variant.type == 'android'\">\n" +
    "          </div>\n" +
    "        </div>\n" +
    "      </div>\n" +
    "\n" +
    "      <div ng-show=\"variant.type == 'ios'\">\n" +
    "        <div class=\"form-group\">\n" +
    "          <label class=\"col-sm-3 control-label\">Push Network</label>\n" +
    "          <div class=\"col-sm-7\">\n" +
    "            <p><em>Apple Push Notification Service</em> certificate:</p>\n" +
    "            <strong><input type=\"file\" ups-files=\"variant.certificates\" /></strong>\n" +
    "            <div class=\"form-horizontal\">\n" +
    "              <div class=\"form-group\">\n" +
    "                <div class=\"row\">\n" +
    "                  <br><label class=\"col-sm-3 control-label\">Type</label>\n" +
    "                  <div class=\"col-sm-9\">\n" +
    "                    <div class=\"row\">\n" +
    "                      <div class=\"radio\">\n" +
    "                        <label>\n" +
    "                          <input type=\"radio\" name=\"iosType\" id=\"iosType1\" ng-model=\"variant.production\" ng-value=\"true\" ng-required=\"variant.type == 'ios'\">\n" +
    "                          Production\n" +
    "                        </label>\n" +
    "                      </div>\n" +
    "                    </div>\n" +
    "                    <div class=\"row\">\n" +
    "                      <div class=\"radio\">\n" +
    "                        <label>\n" +
    "                          <input type=\"radio\" name=\"iosType\" id=\"iosType2\" ng-model=\"variant.production\" ng-value=\"false\" ng-required=\"variant.type == 'ios'\">\n" +
    "                          Development\n" +
    "                        </label>\n" +
    "                      </div>\n" +
    "                    </div>\n" +
    "                  </div>\n" +
    "                </div>\n" +
    "              </div>\n" +
    "              <div class=\"form-group\">\n" +
    "                <label class=\"col-sm-3 control-label\" for=\"iosPassphrase\">Passphrase</label>\n" +
    "                <div class=\"col-sm-9\">\n" +
    "                  <input type=\"password\" id=\"iosPassphrase\" class=\"form-control\" ng-model=\"variant.passphrase\" ng-disabled=\"!isNew && variant.certificates.length == 0\">\n" +
    "                </div>\n" +
    "              </div>\n" +
    "            </div>\n" +
    "          </div>\n" +
    "        </div>\n" +
    "      </div>\n" +
    "\n" +
    "      <div ng-show=\"variant.type.indexOf('windows') == 0\">\n" +
    "        <div class=\"form-group\">\n" +
    "          <label class=\"col-sm-3 control-label\">Push Network</label>\n" +
    "          <div class=\"col-sm-7\">\n" +
    "            <div class=\"form-horizontal\" ng-show=\"isNew\">\n" +
    "              <div class=\"form-group\">\n" +
    "                <div class=\"row\">\n" +
    "                  <br><label class=\"col-sm-3 control-label\">Type</label>\n" +
    "                  <div class=\"col-sm-9\">\n" +
    "                    <div class=\"row\">\n" +
    "                      <div class=\"radio\">\n" +
    "                        <label for=\"wnstype\">\n" +
    "                          <input type=\"radio\" name=\"protocolType\" id=\"wnstype\" ng-model=\"variant.protocolType\" value=\"wns\"  ng-required=\"variant.type == 'windows'\" checked>\n" +
    "                          Windows Push Network\n" +
    "                        </label>\n" +
    "                      </div>\n" +
    "                    </div>\n" +
    "                    <div class=\"row\">\n" +
    "                      <div class=\"radio\">\n" +
    "                        <label for=\"mpnstype\">\n" +
    "                          <input type=\"radio\" name=\"protocolType\" id=\"mpnstype\" ng-model=\"variant.protocolType\" value=\"mpns\"  ng-required=\"variant.type == 'windows'\">\n" +
    "                          Microsoft Push Notification Service\n" +
    "                        </label>\n" +
    "                      </div>\n" +
    "                    </div>\n" +
    "                  </div>\n" +
    "                </div>\n" +
    "              </div>\n" +
    "            </div>\n" +
    "          </div>\n" +
    "        </div>\n" +
    "        <div ng-if=\"variant.protocolType == 'wns'\">\n" +
    "          <div class=\"form-group\">\n" +
    "            <label class=\"col-sm-3 control-label\" for=\"sid\"></label>\n" +
    "            <div class=\"col-sm-7\"><em>Package SID</em><br>\n" +
    "              <input type=\"text\" placeholder=\"ms-app://s-1-15-2-3183935804-3637592178\" id=\"sid\" class=\"form-control\" ng-model=\"variant.sid\" ng-required=\"variant.protocolType == 'wns'\">\n" +
    "            </div>\n" +
    "          </div>\n" +
    "          <div class=\"form-group\">\n" +
    "            <label class=\"col-sm-3 control-label\" for=\"clientSecret\"></label>\n" +
    "            <div class=\"col-sm-7\">Client Secret<br>\n" +
    "              <input type=\"text\" placeholder=\"e.g. 42\" id=\"clientSecret\" class=\"form-control\" ng-model=\"variant.clientSecret\" ng-required=\"variant.protocolType == 'wns'\">\n" +
    "            </div>\n" +
    "          </div>\n" +
    "        </div>\n" +
    "      </div>\n" +
    "\n" +
    "      <div ng-show=\"variant.type == 'simplePush'\">\n" +
    "        <div class=\"form-group\">\n" +
    "          <label class=\"col-sm-3 control-label\">Push Network</label>\n" +
    "          <div class=\"col-sm-7\"><strong>No configuration needed</strong><p>This server's <em>SimplePush</em> implementation will be used.</p></div>\n" +
    "        </div>\n" +
    "      </div>\n" +
    "\n" +
    "      <div ng-show=\"variant.type == 'adm'\">\n" +
    "        <div class=\"form-group\">\n" +
    "          <label class=\"col-sm-3 control-label\" for=\"admClientId\">Push Network</label>\n" +
    "          <div class=\"col-sm-7\">Client ID<br>\n" +
    "            <input type=\"text\" placeholder=\"e.g. 5a448c2f31700a466fbc9d33d33942b043a27596\" id=\"admClientId\" class=\"form-control\" ng-model=\"variant.clientId\" ng-required=\"variant.type == 'adm'\">\n" +
    "          </div>\n" +
    "        </div>\n" +
    "        <div class=\"form-group\">\n" +
    "          <label class=\"col-sm-3 control-label\" for=\"admclientSecret\"></label>\n" +
    "          <div class=\"col-sm-7\">\n" +
    "            Client Secret<br>\n" +
    "            <input type=\"text\" placeholder=\"e.g. 5da448c2f31700a466fbc9d33d33942b043a27596\" id=\"admclientSecret\" class=\"form-control\" ng-model=\"variant.clientSecret\" ng-required=\"variant.type == 'adm'\">\n" +
    "          </div>\n" +
    "        </div>\n" +
    "      </div>\n" +
    "\n" +
    "    </div>\n" +
    "\n" +
    "  </div>\n" +
    "  <div class=\"modal-footer\">\n" +
    "    <button ng-click=\"dismiss()\" type=\"button\" class=\"btn btn-default\">Cancel</button>\n" +
    "    <button ng-click=\"confirm()\" class=\"btn btn-primary\" ng-disabled=\"form.$invalid || !validateFileInputs()\">{{ isNew ? 'Create' : 'Save' }}</button>\n" +
    "  </div>\n" +
    "</form>\n"
  );


  $templateCache.put('views/dialogs/export-installations.html',
    "<div class=\"modal-content\">\n" +
    "  <div class=\"modal-header\">\n" +
    "    <button type=\"button\" class=\"close\" aria-hidden=\"true\" ng-click=\"cancel()\">\n" +
    "      <span class=\"pficon pficon-close\"></span>\n" +
    "    </button>\n" +
    "    <h4 class=\"modal-title\">Export Installations </h4>\n" +
    "  </div>\n" +
    "  <div class=\"modal-body\">\n" +
    "    <b>{{variant.total}}</b> installations will be exported.\n" +
    "  </div>\n" +
    "  <div class=\"modal-footer\">\n" +
    "    <button type=\"button\" class=\"btn btn-primary text-left\" ng-click=\"ok()\">Export</button>\n" +
    "    <button type=\"button\" class=\"btn btn-default\" ng-click=\"cancel()\">Cancel</button>\n" +
    "  </div>\n" +
    "</div>\n"
  );


  $templateCache.put('views/dialogs/filter-variants.html',
    "<div class=\"modal-content\">\n" +
    "    <div class=\"modal-header\">\n" +
    "        <button type=\"button\" class=\"close\" aria-hidden=\"true\" ng-click=\"cancel()\">\n" +
    "            <span class=\"pficon pficon-close\"></span>\n" +
    "        </button>\n" +
    "        <h4 class=\"modal-title\">&ldquo;{{application.name}}&rdquo; variants</h4>\n" +
    "    </div>\n" +
    "    <div class=\"modal-body\">\n" +
    "      <input type=\"checkbox\" ng-checked=\"variantSelection.length == 0\">All\n" +
    "      <div>\n" +
    "        <div ng-show=\"application.variants\" ng-repeat=\"variant in application.variants\">\n" +
    "          <h5 style=\"text-transform: capitalize\" ng-if=\"variant.type != 'ios' && application.variants[$index - 1].type != variant.type\">{{variant.type}}</h5>\n" +
    "          <h5 ng-if=\"variant.type == 'ios' && application.variants[$index - 1].type != variant.type\">iOS</h5>\n" +
    "          <ul style=\"margin-bottom: -1px;\">\n" +
    "          <li class=\"list-group-item\">\n" +
    "              <label>\n" +
    "                  <input type=\"checkbox\"  ng-checked=\"variantSelection.indexOf(variant) > -1\" ng-click=\"toggleSelection(variant)\">\n" +
    "                  {{variant.name}}\n" +
    "              </label>\n" +
    "          </li>\n" +
    "          </ul>\n" +
    "        </div>\n" +
    "      </div>\n" +
    "    </div>\n" +
    "    <div class=\"modal-footer\">\n" +
    "        <button type=\"button\" class=\"btn btn-default\" ng-click=\"cancel()\">Cancel</button>\n" +
    "        <button type=\"button\" class=\"btn btn-primary\" ng-click=\"ok(application)\" ng-disabled=\"form.$pristine\">Change</button>\n" +
    "    </div>\n" +
    "</div>"
  );


  $templateCache.put('views/dialogs/generate-push-config.html',
    "<div class=\"modal-content\">\n" +
    "    <div class=\"modal-header\">\n" +
    "        <button type=\"button\" class=\"close\" aria-hidden=\"true\" ng-click=\"cancel()\">\n" +
    "            <span class=\"pficon pficon-close\"></span>\n" +
    "        </button>\n" +
    "        <h4 class=\"modal-title\">Generate <tt>push-config.json</tt> for &ldquo;{{application.name}}&rdquo;</h4>\n" +
    "    </div>\n" +
    "    <div class=\"modal-body\">\n" +
    "      <div>\n" +
    "        <div ng-show=\"application.variants\" ng-repeat=\"variant in application.variants\">\n" +
    "          <h5 style=\"text-transform: capitalize\" ng-if=\"variant.type != 'ios' && application.variants[$index - 1].type != variant.type\">{{variant.type}}</h5>\n" +
    "          <h5 ng-if=\"variant.type == 'ios' && application.variants[$index - 1].type != variant.type\">iOS</h5>\n" +
    "          <ul style=\"margin-bottom: -1px;\">\n" +
    "          <li class=\"list-group-item\">\n" +
    "              <label>\n" +
    "                  <input type=\"radio\" name=\"{{variant.type}}\" ng-checked=\"variantSelection.indexOf(variant) > -1\" ng-click=\"toggleSelection(variant)\">\n" +
    "                  {{variant.name}}\n" +
    "              </label>\n" +
    "          </li>\n" +
    "          </ul>\n" +
    "        </div>\n" +
    "      </div>\n" +
    "      <div class=\"panel lo-panel ups-panel-variants\">\n" +
    "          <div class=\"ups-panel-variants\">\n" +
    "              <div class=\"ups-code-block json\" hljs source=\"generatePushConfig()\"></div>\n" +
    "          </div>\n" +
    "      </div>\n" +
    "    </div>\n" +
    "    <div class=\"modal-footer\">\n" +
    "        <button type=\"button\" class=\"btn btn-default\" ng-click=\"cancel()\">Cancel</button>\n" +
    "        <!-- <button type=\"button\" class=\"btn btn-primary\" ng-click=\"ok(application)\" ng-disabled=\"form.$pristine\">Change</button> -->\n" +
    "        <a class=\"btn btn-primary\" ng-click=\"downloadPushConfig()\">Download</a>\n" +
    "    </div>\n" +
    "</div>"
  );


  $templateCache.put('views/dialogs/import-installations.html',
    "<form name=\"form\" class=\"modal-content ups-modal-content\">\n" +
    "  <div class=\"modal-content\">\n" +
    "    <div class=\"modal-header\">\n" +
    "      <button type=\"button\" class=\"close\" aria-hidden=\"true\" ng-click=\"cancel()\">\n" +
    "        <span class=\"pficon pficon-close\"></span>\n" +
    "      </button>\n" +
    "      <h4 class=\"modal-title\">Import Installations </h4>\n" +
    "    </div>\n" +
    "    <div class=\"modal-body\">\n" +
    "      <p>\n" +
    "        <strong><input type=\"file\" ups-files=\"variant.installations\" preview-import=\"previewImport()\"/></strong>\n" +
    "      </p>\n" +
    "\n" +
    "      <p ng-show=\"importPreview\">\n" +
    "        <ups-pluralize noun=\"installation\" count=\"importPreview\" zero=\"No\"></ups-pluralize>\n" +
    "        <span>will be imported</span>\n" +
    "      </p>\n" +
    "      <p ng-show=\"incorrectFormat\">\n" +
    "        <strong>\n" +
    "          <i class=\"fa fa-warning\"></i>\n" +
    "          This file can not be parsed !\n" +
    "        </strong>\n" +
    "      </p>\n" +
    "    </div>\n" +
    "    <div class=\"modal-footer\">\n" +
    "      <button ng-disabled=\"!importPreview\" type=\"submit\" class=\"btn btn-primary text-left\" ng-click=\"ok(variant)\">Import</button>\n" +
    "      <button type=\"button\" class=\"btn btn-default\" ng-click=\"cancel()\">Cancel</button>\n" +
    "    </div>\n" +
    "  </div>\n" +
    "</form>\n"
  );


  $templateCache.put('views/dialogs/remove-app.html',
    "<form name=\"form\" class=\"modal-content\">\n" +
    "  <div class=\"modal-header\">\n" +
    "    <button type=\"button\" class=\"close\" aria-hidden=\"true\" ng-click=\"dismiss()\">\n" +
    "      <span class=\"pficon pficon-close\"></span>\n" +
    "    </button>\n" +
    "    <h4 class=\"modal-title\">Delete Application</h4>\n" +
    "  </div>\n" +
    "  <div class=\"modal-body\">\n" +
    "    <p>Do you really want to delete the application <strong>\"{{ app.name }}\"</strong>?</p>\n" +
    "  </div>\n" +
    "  <div class=\"modal-footer\">\n" +
    "    <button type=\"button\" class=\"btn btn-default\" ng-click=\"dismiss()\">Cancel</button>\n" +
    "    <button type=\"submit\" class=\"btn btn-danger text-left\" ng-click=\"confirm()\">\n" +
    "      Delete\n" +
    "    </button>\n" +
    "  </div>\n" +
    "</form>\n"
  );


  $templateCache.put('views/dialogs/remove-variant.html',
    "<form class=\"modal-content\">\n" +
    "  <div class=\"modal-header\">\n" +
    "    <button type=\"button\" class=\"close\" aria-hidden=\"true\" ng-click=\"dismiss()\">\n" +
    "      <span class=\"pficon pficon-close\"></span>\n" +
    "    </button>\n" +
    "    <h4 class=\"modal-title\">Remove Variant</h4>\n" +
    "  </div>\n" +
    "  <div class=\"modal-body\">\n" +
    "    <p>Do you really want to delete the variant <strong>\"{{ variant.name }}\"</strong>?</p>\n" +
    "  </div>\n" +
    "  <div class=\"modal-footer\">\n" +
    "    <button type=\"button\" class=\"btn btn-default\" ng-click=\"dismiss()\">Cancel</button>\n" +
    "    <button type=\"submit\" class=\"btn btn-danger text-left\" ng-click=\"confirm()\">Delete</button>\n" +
    "  </div>\n" +
    "</form>\n"
  );


  $templateCache.put('views/dialogs/renew-master-secret.html',
    "<div class=\"modal-content\">\n" +
    "    <div class=\"modal-header\">\n" +
    "        <button type=\"button\" class=\"close\" aria-hidden=\"true\" ng-click=\"cancel()\">\n" +
    "            <span class=\"pficon pficon-close\"></span>\n" +
    "        </button>\n" +
    "        <h4 class=\"modal-title\">Renew Master Secret</h4>\n" +
    "    </div>\n" +
    "    <div class=\"modal-body\">\n" +
    "        Are you sure you want to renew the Master Secret?\n" +
    "    </div>\n" +
    "    <div class=\"modal-footer\">\n" +
    "        <button type=\"button\" class=\"btn btn-danger text-left\" ng-click=\"ok()\">Renew</button>\n" +
    "        <button type=\"button\" class=\"btn btn-default\" ng-click=\"cancel()\">Cancel</button>\n" +
    "    </div>\n" +
    "</div>\n"
  );


  $templateCache.put('views/dialogs/renew-variant-secret.html',
    "<div class=\"modal-content\">\n" +
    "    <div class=\"modal-header\">\n" +
    "        <button type=\"button\" class=\"close\" aria-hidden=\"true\" ng-click=\"cancel()\">\n" +
    "            <span class=\"pficon pficon-close\"></span>\n" +
    "        </button>\n" +
    "        <h4 class=\"modal-title\">Renew Secret</h4>\n" +
    "    </div>\n" +
    "    <div class=\"modal-body\">\n" +
    "        Are you sure you want to renew the Secret?\n" +
    "    </div>\n" +
    "    <div class=\"modal-footer\">\n" +
    "        <button type=\"button\" class=\"btn btn-danger text-left\" ng-click=\"ok()\">Renew</button>\n" +
    "        <button type=\"button\" class=\"btn btn-default\" ng-click=\"cancel()\">Cancel</button>\n" +
    "    </div>\n" +
    "</div>\n"
  );


  $templateCache.put('views/dialogs/request.html',
    "<div class=\"modal-content\">\n" +
    "  <div class=\"modal-header\">\n" +
    "    <button type=\"button\" class=\"close\" aria-hidden=\"true\" ng-click=\"cancel()\">\n" +
    "      <span class=\"pficon pficon-close\"></span>\n" +
    "    </button>\n" +
    "    <h4 class=\"modal-title\">Request Details</h4>\n" +
    "  </div>\n" +
    "  <div class=\"modal-body\">\n" +
    "    <div class=\"ups-code-block\" hljs source=\"request\"></div>\n" +
    "  </div>\n" +
    "</div>\n"
  );


  $templateCache.put('views/dialogs/send-push-notification.html',
    "<form name=\"form\" class=\"modal-content\">\n" +
    "  <div class=\"modal-header\">\n" +
    "    <button type=\"button\" class=\"close\" data-dismiss=\"modal\" aria-hidden=\"true\">\n" +
    "      <span class=\"pficon pficon-close\"></span>\n" +
    "    </button>\n" +
    "    <h4 class=\"modal-title\" id=\"myModalLabel\">Send push to Application One</h4>\n" +
    "  </div>\n" +
    "  <div class=\"modal-body form-horizontal\">\n" +
    "\n" +
    "    <div class=\"form-group\">\n" +
    "      <label class=\"col-sm-3 control-label\" for=\"textInput-modal-markup\">Message</label>\n" +
    "      <div class=\"col-sm-9\">\n" +
    "        <textarea class=\"form-control\" rows=\"3\" placeholder=\"Write the notification\" ng-model=\"pushData.message.alert\" ng-required=\"true\"></textarea>\n" +
    "      </div>\n" +
    "    </div>\n" +
    "\n" +
    "\n" +
    "\n" +
    "    <div class=\"form-group\">\n" +
    "      <label class=\"col-sm-3 control-label\" for=\"textInput-modal-markup\">Variants</label>\n" +
    "      <div class=\"col-sm-9\">\n" +
    "        <select class=\"selectpicker\" multiple ng-model=\"selectedVariants\" ng-options=\"variant.variantID as variant.name for variant in app.variants\"></select>\n" +
    "      </div>\n" +
    "    </div>\n" +
    "\n" +
    "\n" +
    "    <div class=\"form-group\">\n" +
    "      <label class=\"col-sm-3 control-label\" for=\"textInput-modal-markup\">Aliases</label>\n" +
    "      <div class=\"col-sm-9\">\n" +
    "        <input type=\"text\" id=\"textInput-modal-markup\" class=\"form-control\" placeholder=\"All\" ng-model=\"aliases\">\n" +
    "      </div>\n" +
    "    </div>\n" +
    "\n" +
    "\n" +
    "    <div class=\"form-group\">\n" +
    "      <label class=\"col-sm-3 control-label\" for=\"textInput-modal-markup\">Device Types</label>\n" +
    "      <div class=\"col-sm-9\">\n" +
    "        <input type=\"text\" id=\"textInput-modal-markup\" class=\"form-control\" placeholder=\"All\" ng-model=\"deviceTypes\">\n" +
    "      </div>\n" +
    "    </div>\n" +
    "\n" +
    "\n" +
    "    <div class=\"form-group\">\n" +
    "      <label class=\"col-sm-3 control-label\" for=\"textInput-modal-markup\">Categories</label>\n" +
    "      <div class=\"col-sm-9\">\n" +
    "        <input type=\"text\" id=\"textInput-modal-markup\" class=\"form-control\" placeholder=\"All\" ng-model=\"categories\">\n" +
    "      </div>\n" +
    "    </div>\n" +
    "\n" +
    "\n" +
    "    <span id=\"helpBlock\" class=\"help-block\">You can provide multiple values at a time by separating them by commas.</span>\n" +
    "\n" +
    "\n" +
    "\n" +
    "  </div>\n" +
    "  <div class=\"modal-footer\">\n" +
    "    <button class=\"btn btn-default\" ng-click=\"cancel()\">Cancel</button>\n" +
    "    <button class=\"btn btn-primary\" ng-click=\"send()\" ng-disabled=\"form.$invalid\">Send Push Notification</button>\n" +
    "  </div>\n" +
    "</form>\n"
  );


  $templateCache.put('views/include/compose.html',
    "<form class=\"form-horizontal\">\n" +
    "  <div class=\"form-group\">\n" +
    "    <label class=\"col-sm-2 control-label\">Variants</label>\n" +
    "\n" +
    "    <div class=\"col-sm-10\">\n" +
    "      <div class=\"ups-fake-input\">\n" +
    "        <span ng-hide=\"composeCtrl.variantSelection.length\">All</span>\n" +
    "        <span ng-repeat=\"variant in composeCtrl.variantSelection\">{{variant.name}}\n" +
    "          <span ng-show=\" ! $last \">,&nbsp;</span>\n" +
    "        </span>\n" +
    "      </div>\n" +
    "    </div>\n" +
    "  </div>\n" +
    "  <div class=\"pull-right\">\n" +
    "    <button class=\"btn btn-default btn-sml\" ng-click=\"composeCtrl.changeVariant(application)\">Change...</button>\n" +
    "    <br><br></div>\n" +
    "  <hr>\n" +
    "\n" +
    "  <div class=\"form-group\">\n" +
    "    <label class=\"col-sm-2 control-label\" for=\"testMessage\">Message</label>\n" +
    "\n" +
    "    <div class=\"col-sm-10\">\n" +
    "      <textarea rows=\"4\" class=\"form-control\" id=\"testMessage\" ng-model=\"composeCtrl.pushData.message.alert\"></textarea>\n" +
    "    </div>\n" +
    "  </div>\n" +
    "\n" +
    "  <hr>\n" +
    "\n" +
    "  <div class=\"form-group\">\n" +
    "    <label class=\"col-sm-2 control-label\">Aliases</label>\n" +
    "\n" +
    "    <div class=\"col-sm-10\"><input disabled class=\"form-control\" type=\"text\"\n" +
    "                                  value=\"{{composeCtrl.criteria.alias.length > 0 ? composeCtrl.criteria.alias : 'All'}}\"></div>\n" +
    "  </div>\n" +
    "  <div class=\"form-group\">\n" +
    "    <label class=\"col-sm-2 control-label\">Device Types</label>\n" +
    "\n" +
    "    <div class=\"col-sm-10\"><input disabled class=\"form-control\" type=\"text\"\n" +
    "                                  value=\"{{composeCtrl.criteria.deviceType.length > 0 ? composeCtrl.criteria.deviceType : 'All'}}\"></div>\n" +
    "  </div>\n" +
    "  <div class=\"form-group\">\n" +
    "    <label class=\"col-sm-2 control-label\">Categories</label>\n" +
    "\n" +
    "    <div class=\"col-sm-10\">\n" +
    "      <input disabled class=\"form-control\" type=\"text\" value=\"{{composeCtrl.criteria.categories.length > 0 ? composeCtrl.criteria.categories : 'All'}}\">\n" +
    "    </div>\n" +
    "  </div>\n" +
    "  <div class=\"pull-right\">\n" +
    "    <button class=\"btn btn-default btn-sml\" ng-click=\"composeCtrl.changeCriteria(application)\">Change...</button>\n" +
    "    <br><br></div>\n" +
    "\n" +
    "  <hr>\n" +
    "  <div class=\"pull-right\">\n" +
    "    <button ng-click=\"composeCtrl.sendMessage()\" class=\"btn btn-primary btn-lg\" type=\"button\">Send Push Notification</button>\n" +
    "  </div>\n" +
    "</form>"
  );

}]);
