angular.module('upsConsole').run(['$templateCache', function($templateCache) {
  'use strict';

  $templateCache.put('directives/ups-client-snippets.html',
    "<ul class=\"nav nav-tabs nav-justified ups-snippet-nav\" ng-if=\"typeEnum[variant.type].snippets.length\">\n" +
    "  <li ng-repeat=\"snippet in typeEnum[variant.type].snippets\"\n" +
    "      ng-init=\"state.activeSnippet = typeEnum[variant.type].snippets[0]\"\n" +
    "      ng-class=\"{ active: snippet == state.activeSnippet }\">\n" +
    "    <a href ng-click=\"state.activeSnippet = snippet\">\n" +
    "      <span ng-if=\"snippet == 'android'\">Android</span>\n" +
    "      <span ng-if=\"snippet == 'simplePush'\">JavaScript</span>\n" +
    "      <span ng-if=\"snippet == 'ios_objc'\">ObjectiveC</span>\n" +
    "      <span ng-if=\"snippet == 'ios_swift'\">Swift</span>\n" +
    "      <span ng-if=\"snippet == 'wns'\">C#</span>\n" +
    "      <span ng-if=\"snippet == 'mpns'\">C#</span>\n" +
    "      <span ng-if=\"snippet == 'cordova'\">Cordova</span>\n" +
    "      <span ng-if=\"snippet == 'adm'\">ADM</span>\n" +
    "    </a>\n" +
    "  </li>\n" +
    "</ul>\n" +
    "\n" +
    "<div class=\"ups-snippet\" ng-if=\"typeEnum[variant.type].snippets.length\">\n" +
    "  <a href tooltip=\"{{ clipText }}\" tooltip-placement=\"right\" clip-copy=\"copySnippet()\" clip-click=\"copied()\">Copy</a>\n" +
    "  <!-- use both ng-if and ng-show prevents screen flickering caused by reinsertion of DOM parts, ng-if turns the invalid sample off to avoid DOM pollution -->\n" +
    "  <pre ng-bind=\"snippets.android.source\" class=\"pre-scrollable prettyprint\" ng-if=\"typeEnum[variant.type].indexOf('android') !== -1\" ng-show=\"state.activeSnippet == 'android'\"></pre>\n" +
    "  <pre ng-bind=\"snippets.cordova.source\" class=\"pre-scrollable prettyprint\" ng-if=\"typeEnum[variant.type].indexOf('cordova') !== -1\" ng-show=\"state.activeSnippet == 'cordova'\"></pre>\n" +
    "  <pre ng-bind=\"snippets.ios_objc.source\" class=\"pre-scrollable prettyprint\" ng-if=\"typeEnum[variant.type].indexOf('ios_objc') !== -1\" ng-show=\"state.activeSnippet == 'ios_objc'\"></pre>\n" +
    "  <pre ng-bind=\"snippets.ios_swift.source\" class=\"pre-scrollable prettyprint\" ng-if=\"typeEnum[variant.type].indexOf('ios_swift') !== -1\" ng-show=\"state.activeSnippet == 'ios_swift'\"></pre>\n" +
    "  <pre ng-bind=\"snippets.mpns.source\" class=\"pre-scrollable prettyprint\" ng-if=\"typeEnum[variant.type].indexOf('mpns') !== -1\" ng-show=\"state.activeSnippet == 'mpns'\"></pre>\n" +
    "  <pre ng-bind=\"snippets.wns.source\" class=\"pre-scrollable prettyprint\" ng-if=\"typeEnum[variant.type].indexOf('wns') !== -1\" ng-show=\"state.activeSnippet == 'wns'\"></pre>\n" +
    "  <pre ng-bind=\"snippets.adm.source\" class=\"pre-scrollable prettyprint\" ng-if=\"typeEnum[variant.type].indexOf('adm') !== -1\" ng-show=\"state.activeSnippet == 'adm'\"></pre>\n" +
    "</div>\n"
  );


  $templateCache.put('directives/ups-sender-snippets.html',
    "<ul class=\"nav nav-tabs nav-tabs-pf\">\n" +
    "  <li ng-class=\"{ active: activeSnippet == 'java' || !activeSnippet }\"><a href ng-click=\"activeSnippet = 'java'\">Java Sender API</a></li>\n" +
    "  <li ng-class=\"{ active: activeSnippet == 'nodejs' }\"><a href ng-click=\"activeSnippet = 'nodejs'\">Node.js Sender API</a></li>\n" +
    "  <li ng-class=\"{ active: activeSnippet == 'curl' }\"><a href ng-click=\"activeSnippet = 'curl'\">REST Sender API (with CURL)</a></li>\n" +
    "</ul>\n" +
    "\n" +
    "\n" +
    "<div ng-if=\"activeSnippet == 'java' || !activeSnippet\">\n" +
    "  <h3>Set up Java UPS Sender API</h3>\n" +
    "  <p>First you need to add <code>unifiedpush-java-client.jar</code> as a <a ups-doc=\"sender-downloads-java\">dependency to your Java project</a>.</p>\n" +
    "  <p>Then let's use following snippet in your Java code to enable push notification sending.</p>\n" +
    "</div>\n" +
    "<div ng-if=\"activeSnippet == 'nodejs'\">\n" +
    "  <h3>Set up Node.js Sender API</h3>\n" +
    "  <p>First you need to download add <code>unifiedpush-node-sender</code> as a <a ups-doc=\"sender-downloads-nodejs\">dependency to your project</a>.</p>\n" +
    "  <p>Then let's use following snippet in your Node.js code to enable push notification sending.</p>\n" +
    "</div>\n" +
    "<div ng-if=\"activeSnippet == 'curl'\">\n" +
    "  <h3>Use UPS REST Sender API (with CURL)</h3>\n" +
    "  <p>If none from the official client libs doesn't suit you or you just want to simply try out the notification sending, you can use REST API directly.</p>\n" +
    "  <p>Run following <code>curl</code> command in the shell to send notification to UPS server.</p>\n" +
    "</div>\n" +
    "\n" +
    "<div class=\"ups-snippet\">\n" +
    "  <a href tooltip=\"{{ clipText }}\" tooltip-placement=\"right\" clip-copy=\"copySnippet()\" clip-click=\"copied()\">Copy</a>\n" +
    "  <pre ng-bind=\"snippets.java.source\" class=\"pre-scrollable prettyprint\" ng-if=\"activeSnippet == 'java' || !activeSnippet\"></pre>\n" +
    "  <pre ng-bind=\"snippets.nodejs.source\" class=\"pre-scrollable prettyprint\" ng-if=\"activeSnippet == 'nodejs'\"></pre>\n" +
    "  <pre ng-bind=\"snippets.curl.source\" class=\"pre-scrollable prettyprint\" ng-if=\"activeSnippet == 'curl'\"></pre>\n" +
    "</div>\n" +
    "\n" +
    "\n" +
    "<div ng-if=\"activeSnippet == 'java' || !activeSnippet\">\n" +
    "  <p>Read more on the details of the <a ups-doc=\"sender-api-java\">Java UPS Sender API in documentation</a>.</p>\n" +
    "  <p>If you have questions about this process, <a ups-doc=\"sender-step-by-step-java\">visit the documentation for full step by step explanation</a>.</p>\n" +
    "</div>\n" +
    "<div ng-if=\"activeSnippet == 'nodejs'\">\n" +
    "  <p>Read more on the details of the <a ups-doc=\"sender-api-nodejs\">Node.js UPS Sender API in documentation</a>.</p>\n" +
    "</div>\n" +
    "<div ng-if=\"activeSnippet == 'curl'\">\n" +
    "  <p>Read more on the details of the <a ups-doc=\"sender-api-rest\">UPS REST Sender API in documentation</a>.</p>\n" +
    "</div>\n"
  );

}]);
