angular.module("upsConsole").run(["$templateCache",function($templateCache){"use strict";$templateCache.put("components/app-detail/app-detail.html",'<div class="container-fluid">\n  <div class="row">\n    <div class="col-sm-8 col-md-9">\n\n      <ol class="breadcrumb">\n        <li><a ng-link="href">Applications</a></li>\n        <li><strong>{{ appDetail.app.name }}:</strong> Variants</li>\n      </ol>\n\n      <div class="ups-app-header">\n        <div class="actions pull-right">\n          <button id="send-notification-btn" class="btn btn-default" ng-click="appDetail.sendNotification()" ng-disabled="!appDetail.app.variants.length"><i class="fa fa-paper-plane"></i> Send Notification to this app</button>\n        </div>\n        <h1>{{ appDetail.app.name }}</h1>\n      </div><!-- app header -->\n\n      <ul class="nav nav-tabs">\n        <li ng-class="{ active: appDetail.tab == \'analytics\' }" ng-if="appDetail.app.variants.length">\n          <a id="analytics-tab" ng-link="appDetail({app: appDetail.app.pushApplicationID, tab: \'analytics\'})">Analytics</a>\n        </li>\n        <li ng-class="{ active: appDetail.tab == \'variants\' }">\n          <a id="variants-tab" ng-link="appDetail({app: appDetail.app.pushApplicationID, tab: \'variants\'})">Variants</a>\n        </li>\n        <li ng-class="{ active: appDetail.tab == \'sender\' }" ng-if="appDetail.app.variants.length">\n          <a id="sender-tab" ng-link="appDetail({app: appDetail.app.pushApplicationID, tab: \'sender\'})">Sender API</a>\n        </li>\n        <li ng-class="{ active: appDetail.tab == \'activity\' }"  ng-if="appDetail.app.variants.length">\n          <a id="activity-tab" ng-link="appDetail({app: appDetail.app.pushApplicationID, tab: \'activity\'})">Activity log</a>\n        </li>\n      </ul>\n\n      <ng-include id="analytics-panel" src="\'components/app-detail/include/analytics.html\'" ng-if="appDetail.tab == \'analytics\'"  ng-controller="AnalyticsController as analyticsCtrl"></ng-include>\n      <ng-include id="blank-panel" src="\'components/app-detail/include/blank.html\'" ng-if="appDetail.tab == \'variants\' && !appDetail.app.variants.length" ng-controller="VariantsController as variants"></ng-include>\n      <ng-include id="variants-panel" src="\'components/app-detail/include/variants.html\'" ng-if="appDetail.tab == \'variants\' && appDetail.app.variants.length" ng-controller="VariantsController as variants"></ng-include>\n      <ng-include id="sender-panel" src="\'components/app-detail/include/sender.html\'" ng-if="appDetail.tab == \'sender\'" ng-controller="SenderController as sender"></ng-include>\n      <ng-include id="activity-panel" src="\'components/app-detail/include/activity.html\'" ng-if="appDetail.tab == \'activity\'" ng-controller="ActivityController as activity"></ng-include>\n    </div><!-- /col -->\n\n    <div class="col-sm-4 col-md-3 sidebar-pf sidebar-pf-right">\n\n      <div class="sidebar-header sidebar-header-bleed-left sidebar-header-bleed-right">\n        <h2 class="h5">App Statistics</h2>\n      </div>\n      <ul class="list-unstyled ups-statistics">\n        <li id="stat-variant-count"><ups-pluralize noun="Variant" count="appDetail.app.variants.length"></ups-pluralize></li>\n        <li id="stat-message-count"><span class="count">{{ appDetail.app.$messageCount }}</span>Messages</li>\n        <li id="stat-device-count"><ups-pluralize noun="Device" count="appDetail.app.$deviceCount"></ups-pluralize></li>\n      </ul>\n\n\n      <div class="sidebar-header sidebar-header-bleed-left sidebar-header-bleed-right"\n           ng-if="appDetail.app.$messageCount">\n        <h2 class="h5">App Notifications</h2>\n      </div>\n      <div class="list-group" ng-if="appDetail.app.$messageCount">\n        <a class="list-group-item" ng-repeat="notification in appDetail.notifications | limitTo:4">\n          <h3 class="list-group-item-heading">{{ appDetail.app.name }}</h3>\n          <p class="list-group-item-text">{{ notification.submitDate | date:\'d MMM, H:mm:ss, yyyy\' }}</p>\n        </a>\n      </div>\n      <p><a id="see-notifications" ng-hide="appDetail.tab == \'activity\' || appDetail.app.$messageCount == 0" ng-link="appDetail({app: appDetail.app.pushApplicationID, tab: \'activity\'})"><span class="pficon pficon-history"></span> See all notifications</a></p>\n    </div><!-- /col -->\n\n  </div><!-- /row -->\n</div><!-- /container -->\n'),$templateCache.put("components/app-detail/include/activity.html",'<div ng-if="activity.totalCount > 0 || activity.isSearchActive()">\n  <h3>Notification activity</h3>\n\n  <p>Explore push messages that you have sent to the registered devices.</p>\n\n  <div class="dataTables_wrapper no-footer">\n    <div class="dataTables_header">\n      <div class="dataTables_filter">\n        <label><input type="search" class="" aria-controls="DataTables_Table_0" ng-model="activity.searchString" ng-model-options="{debounce: 300}"></label>\n      </div>\n      <div class="dataTables_info" role="status" aria-live="polite">\n        Showing <b>{{ activity.currentStart }}</b> to <b>{{ activity.currentEnd }}</b> of <b>{{ activity.totalCount }}</b> Messages\n      </div>\n    </div>\n\n    <div class="table-responsive">\n\n  <table id="activity-table" class="datatable table table-striped table-bordered" pf-datatable>\n    <thead>\n    <tr>\n      <th></th>\n      <th>Message</th>\n      <th>IP Address</th>\n      <th>Installations</th>\n      <th>Status</th>\n      <th>Sent</th>\n      <th>First time opened</th>\n      <th>Last time opened</th>\n    </tr>\n    </thead>\n    <tbody>\n    <tr class="odd" ng-if="activity.totalCount === 0">\n      <td valign="top" align="center" colspan="8" class="dataTables_empty">\n        <p>No message matches the given search criteria.</p>\n      </td>\n    </tr>\n    <tr ng-repeat-start="metric in activity.metrics">\n      <td>\n        <a href ng-click="metric.$toggled = !metric.$toggled">\n          <i class="fa" ng-class="{ \'fa-plus-square-o icon-plus-sign-alt\': !metric.$toggled, \'fa-minus-square-o icon-minus-sign-alt\': metric.$toggled }"></i>\n        </a>\n      </td>\n      <td>{{ metric.$message.alert | limitTo : 15 }}{{ metric.$message.alert.length > 15 ? \'&hellip;\' : \'\' }}</td>\n      <td>{{ metric.ipAddress }}</td>\n      <td>{{ metric.totalReceivers }} receivers / {{ metric.appOpenCounter }} opened</td>\n      <td ng-if="metric.servedVariants < metric.totalVariants">\n        <!--<i class="pficon-running"></i>-->\n        <span class="pficon spinner spinner-sm spinner-inline"></span>\n        Pending...</td>\n      <td ng-if="metric.servedVariants == metric.totalVariants && metric.deliveryFailed != true" class="success"><i class="fa fa-check"></i> Succeeded</td>\n      <td ng-if="metric.servedVariants == metric.totalVariants && metric.deliveryFailed == true" class="danger">\n          <span class="pficon-layered">\n            <span class="pficon pficon-error-octagon"></span>\n            <span class="pficon pficon-error-exclamation"></span>\n          </span>\n        Failed\n      </td>\n      <td>{{ metric.submitDate | date : \'d MMM, HH:mm:ss, yyyy\' }}</td>\n      <td>\n        {{ metric.firstOpenDate | date : \'d MMM, HH:mm:ss, yyyy\'}}\n      </td>\n      <td>\n        {{ metric.lastOpenDate | date : \'d MMM, HH:mm:ss, yyyy\'}}\n      </td>\n    </tr>\n    <tr ng-repeat-end ng-if="metric.$toggled">\n      <td colspan="8" class="ups-pushmessage-detail">\n        <div class="alert alert-warning" ng-repeat="variantInformation in metric.variantInformations | filter: { deliveryStatus: false} ">\n          <span class="pficon-layered">\n            <span class="pficon pficon-warning-triangle"></span>\n            <span class="pficon pficon-warning-exclamation"></span>\n          </span>\n\n\n          <strong>Variant <a href ng-link="appDetail({app: activity.app.pushApplicationID, tab: \'variants\'})">{{ variantInformation.$variant.name }}</a> has failed:</strong> {{ variantInformation.reason }}\n        </div>\n        <pre>{{ metric.$message | json  }}</pre>\n      </td>\n    </tr>\n    </tbody>\n  </table>\n\n    </div>\n\n    <div class="dataTables_footer" ng-if="activity.totalCount / activity.perPage > 1">\n      <div class="dataTables_paginate paging_bootstrap_input">\n        <pagination direction-links="true" boundary-links="false"\n                    total-items="activity.totalCount"\n                    ng-model="activity.currentPage"\n                    previous-text="&lsaquo;" next-text="&rsaquo;"\n                    class="pull-right ups-pagination"\n                    max-size="10"\n                    ng-change="activity.onPageChange( activity.currentPage )"\n                    rotate="false">\n        </pagination>\n      </div>\n    </div>\n  </div>\n</div><!-- ng-if -->\n\n<div class="blank-slate-pf" ng-if="activity.totalCount == 0 && !activity.isSearchActive()">\n  <div class="blank-slate-pf-icon">\n    <i class="fa fa-table"></i>\n  </div>\n\n  <h1 ng-if="appDetail.app.$deviceCount == 0">You have no devices registered</h1>\n  <h1 ng-if="appDetail.app.$deviceCount != 0">You haven\'t send push notifications yet</h1>\n\n  <div ng-if="appDetail.app.$deviceCount == 0">\n    <p>There are no registered device for this application.</p>\n    <p>Check out the documentation on how to get started to <a ups-doc="docs-push-getting-started">register a device</a>.</p>\n  </div>\n\n  <div ng-if="appDetail.app.$deviceCount != 0">\n    <p>You haven\'t send push notifications to the device yet.</p>\n    <div class="blank-slate-pf-main-action">\n      <button class="btn btn-primary btn-lg" ng-click="appDetail.sendNotification()" ng-disabled="!appDetail.app.variants.length">\n        <i class="fa fa-paper-plane"></i>\n        Send Notification to this app\n      </button>\n    </div>\n  </div>\n</div>\n'),$templateCache.put("components/app-detail/include/analytics.html",'<div ng-if="appDetail.app.$messageCount > 0">\n  <div class="ups-app-header">\n    <h3>App Analytics</h3>\n  </div><!-- app header -->\n\n  <div class="row analytics">\n\n    <div class="col-sm-3">\n      <div class="panel panel-default">\n        <div class="panel-heading">\n          <h3 class="panel-title">Push Messages</h3>\n        </div>\n        <div class="panel-body">\n          <h2 id="message-count">{{ appDetail.app.$messageCount | number:0 }}</h2>\n          <div class="analytics-help" tooltip-placement="bottom"\n               tooltip="Number of push messages sent to UnifiedPush Server for dispatching to registered devices">\n            <span class="pficon pficon-help"></span>\n          </div>\n        </div>\n      </div>\n    </div>\n\n    <div class="col-sm-3">\n      <div class="panel panel-default">\n        <div class="panel-heading">\n          <h3 class="panel-title">Notifications Dispatched</h3>\n        </div>\n        <div class="panel-body">\n          <h2 id="receiver-count">{{ analyticsCtrl.receivers | number:0 }}</h2>\n          <div class="analytics-help" tooltip-placement="bottom"\n               tooltip="Number of notifications dispatched via Push Networks to registered device">\n            <span class="pficon pficon-help"></span>\n          </div>\n        </div>\n      </div>\n    </div>\n\n\n    <div class="col-sm-3">\n      <div class="panel panel-default">\n        <div class="panel-heading">\n          <h3 class="panel-title">Notifications Opened</h3>\n        </div>\n        <div class="panel-body">\n          <h2 id="opened-count">{{ analyticsCtrl.appOpenedCounter | number:0 }}</h2>\n          <div class="analytics-help" tooltip-placement="bottom"\n               tooltip="Number of notifications that were delivered to registered device and opened by a user">\n            <span class="pficon pficon-help"></span>\n          </div>\n        </div>\n      </div>\n    </div>\n\n\n    <div class="col-sm-3">\n      <div class="panel panel-default">\n        <div class="panel-heading">\n          <h3 class="panel-title">Average Open Rate</h3>\n        </div>\n        <div class="panel-body">\n          <h2 id="opened-rate">{{ analyticsCtrl.appOpenedRate | number:2 }} %</h2>\n          <div class="analytics-help" tooltip-placement="bottom"\n               tooltip="Notifications Opened / Notifications Dispatched">\n            <span class="pficon pficon-help"></span>\n          </div>\n        </div>\n      </div>\n    </div>\n\n  </div> <!-- row -->\n\n\n  <div class="row" ng-if="analyticsCtrl.app.$deviceCount > 0 && analyticsCtrl.receivers > 0">\n    <div class="col-sm-8" ng-if="analyticsCtrl.app.$deviceCount > 0 && analyticsCtrl.performance[0].length > 1">\n      <h3>Performance</h3>\n      <c3-chart id="performance" config="analyticsCtrl.performanceChartConfig"></c3-chart>\n    </div><!-- col -->\n\n    <div class="col-sm-4" ng-if="analyticsCtrl.app.$deviceCount > 0">\n      <h3>Push Networks</h3>\n      <c3-chart id="pushNetworks" config="analyticsCtrl.pushNetworksChartConfig"></c3-chart>\n    </div><!-- col -->\n\n  </div><!-- row -->\n</div><!-- ng-if -->\n\n<div class="blank-slate-pf" ng-if="appDetail.app.$messageCount == 0 || appDetail.app.$deviceCount == 0 || analyticsCtrl.receivers == 0">\n  <div class="blank-slate-pf-icon">\n    <i class="fa fa-bar-chart"></i>\n  </div>\n\n  <h1 ng-if="appDetail.app.$messageCount == 0">No Analytics yet</h1>\n  <h1 ng-if="appDetail.app.$messageCount != 0">No Charts yet</h1>\n\n  <div ng-if="appDetail.app.$deviceCount == 0">\n    <p>There are no registered device for this application.</p>\n    <p>Check out the documentation on how to get started to <a ups-doc="docs-push-getting-started">register a device</a>.</p>\n  </div>\n\n  <div ng-if="appDetail.app.$deviceCount != 0">\n    <p>You haven\'t send push notifications to the device yet.</p>\n    <div class="blank-slate-pf-main-action">\n      <button class="btn btn-primary btn-lg" ng-click="appDetail.sendNotification()" ng-disabled="!appDetail.app.variants.length">\n        <i class="fa fa-paper-plane"></i>\n        Send Notification to this app\n      </button>\n    </div>\n  </div>\n</div>\n'),$templateCache.put("components/app-detail/include/blank.html",'<div class="blank-slate-pf">\n  <div class="blank-slate-pf-icon">\n    <i class="fa fa-mobile"></i>\n  </div>\n\n  <h1>There are no variants yet.</h1>\n\n  <p>The first step to set up your mobile device is to add a variants. That will generate the code necessary to register UPS on your device.</p>\n\n  <p>Learn more about variants <a ups-doc="add-variant">in the documentation</a>.</p>\n\n  <div class="blank-slate-pf-main-action">\n    <button id="add-variant-btn" class="btn btn-primary btn-lg" ng-click="variants.add()">\n      <span class="pficon pficon-add"></span> Add a variant\n    </button> \n  </div>\n</div>'),$templateCache.put("components/app-detail/include/sender.html",'<h3>Sending push notifications</h3>\n<p>Make your backend server send push notifications through this UnifiedPush Server using supported sender APIs.</p>\n<dl class="dl-horizontal">\n  <dt>Server URL</dt>\n  <dd id="server-url">{{ appDetail.contextPath }}</dd>\n  <dt>Application ID</dt>\n  <dd id="application-id">{{ appDetail.app.pushApplicationID }}</dd>\n  <dt>Master Secret</dt>\n  <dd id="master-secret">{{ appDetail.app.masterSecret }}\n    <br /><button id="renew-master-secret" class="btn btn-sm btn-default" ng-click="sender.renewMasterSecret()"><span class="pficon pficon-refresh"></span> Renew Master Secret</button>\n  </dd>\n</dl>\n\n<div class="alert alert-info">\n  <span class="pficon pficon-info"></span>\n  <strong>Keep this info secure!</strong> Never expose your Master Secret or Application ID publicly.\n</div>\n\n<ups-sender-snippets app="appDetail.app"></ups-sender-snippets>\n\n<script type="text/ng-template" id="inline:renew-master-secret.html">\n  <div class="modal-header">\n    <button type="button" class="close" aria-hidden="true" ng-click="dismiss()">\n      <span class="pficon pficon-close"></span>\n    </button>\n    <h4 class="modal-title" id="myModalLabel">Renew Master Secret</h4>\n  </div>\n  <div class="modal-body">\n    <h4>You are about to change the master secret for application <strong>"{{app.name}}"</strong>!</h4>\n    <p>Be aware that this cannot be undone and you\'ll have to change your sender in order to continue sending push notifications.</p>\n    <p>Please type in the name of the app to confirm.</p>\n    <p>\n      <input class="form-control" ng-model="confirmAppName" pf-focused="true" />\n    </p>\n\n  </div>\n  <div class="modal-footer">\n    <button class="btn btn-default" ng-click="dismiss()">\n      Cancel\n    </button>\n    <button class="btn btn-danger" ng-click="confirm()" ng-disabled="app.name !== confirmAppName">\n      Renew Master Secret\n    </button>\n  </div>\n</script>\n'),$templateCache.put("components/app-detail/include/variantDetail.html",'\n\n<p ng-if="variant.type == \'ios\'">\n  Apple\'s Push Network (APNs) will be used.\n  To learn more about APNs, visit our <a ups-doc="docs-push-ios">iOS</a>\n  or <a ups-doc="docs-push-cordova">Apache Cordova</a> guides for push.\n</p>\n<p ng-if="variant.type == \'android\'">\n  Google\'s Cloud Messaging Network (GCM) will be used.\n  To learn more about GCM, visit our <a ups-doc="docs-push-android">Android</a>, <a ups-doc="docs-push-chrome">Chrome</a> or <a ups-doc="docs-push-cordova">Apache Cordova</a> guides for push.\n</p>\n<p ng-if="variant.type == \'simplePush\'">\n  A Server implementing the <em>SimplePush</em> protocol will be used.\n  More information can be found in <a ups-doc="simplepush-protocol">SimplePush Protocol Draft</a>.\n  The <a ups-doc="simplepush-quickstart">AeroGears\' SimplePush Quickstart</a> also contains useful information.<br/>\n</p>\n<p ng-if="variant.type == \'adm\'">Amazon\'s Device Messaging Network (ADM) will be used.\n  This is still experimental, the client SDK is not yet there.\n</p>\n<p ng-if="variant.type == \'windows_mpns\'">Microsoft\'s Push Notification Service (MPNS) in Windows Phone will be used.\n  <i>This type of Push Network is deprecated and will be removed in future versions</i>.\n</p>\n\n\n<!--\n  TODO:\n  - generat correct info for the server, id and secret box\n-->\n\n<dl class="dl-horizontal">\n  <dt>Server URL:</dt>\n  <dd class="server-url">{{ variantDetail.contextPath }}</dd>\n  <dt>Variant ID:</dt>\n  <dd class="variant-id">{{ variant.variantID }}</dd>\n  <dt>Variant Secret:</dt>\n  <dd class="variant-secret">\n    {{ variant.secret }}<br />\n    <button class="renew-variant-secret btn btn-sm btn-default" ng-click="variants.renewVariantSecret( variant )"><span class="pficon pficon-refresh"></span> Renew Variant Secret</button>\n  </dd>\n</dl>\n\n\n\n<dl class="dl-horizontal" ng-if="variant.type == \'android\'">\n  <dt>Project Number:</dt>\n  <dd class="project-number">{{ variant.projectNumber }}</dd>\n  <dt>Google API Key:</dt>\n  <dd class="google-key">\n    {{ variant.googleKey }}<br />\n    <button class="btn btn-sm btn-default" ng-click="variants.edit( variant )"><span class="fa fa-pencil"></span> Edit network options</button>\n  </dd>\n</dl>\n<dl class="dl-horizontal" ng-if="variant.type == \'windows_mpns\'">\n  <dt>Type:</dt>\n  <dd>\n    Microsoft Push Notification Service<br />\n  </dd>\n</dl>\n<dl class="dl-horizontal" ng-if="variant.type == \'windows_wns\'">\n  <dt>Type:</dt>\n  <dd>Windows Push Network</dd>\n  <dt>Package SID:</dt>\n  <dd class="package-sid">{{ variant.sid }}</dd>\n  <dt>Client Secret:</dt>\n  <dd class="client-secret">\n    {{ variant.clientSecret }}<br />\n    <button class="btn btn-sm btn-default" ng-click="variants.edit( variant )"><span class="fa fa-pencil"></span> Edit network options</button>\n  </dd>\n</dl>\n<dl class="dl-horizontal" ng-if="variant.type == \'ios\'">\n  <dt>Type:</dt>\n  <dd>\n    {{ variant.production ? \'Production\' : \'Development\' }}<br />\n    <button class="btn btn-sm btn-default" ng-click="variants.edit( variant )"><span class="fa fa-pencil"></span> Edit network options</button>\n  </dd>\n</dl>\n<dl class="dl-horizontal" ng-if="variant.type == \'chrome\'">\n  <dt>Client Id:</dt>\n  <dd>{{ variant.clientId }}</dd>\n  <dt>Client Secret:</dt>\n  <dd>{{ variant.clientSecret }}</dd>\n  <dt>Refresh Token:</dt>\n  <dd>\n    {{ variant.refreshToken }}<br />\n    <button class="btn btn-sm btn-default" ng-click="variants.edit( variant )"><span class="fa fa-pencil"></span> Edit network options</button>\n  </dd>\n</dl>\n<dl class="dl-horizontal" ng-if="variant.type == \'adm\'">\n  <dt>Client Id:</dt>\n  <dd>{{ variant.clientId }}</dd>\n  <dt>Client Secret:</dt>\n  <dd>\n    {{ variant.clientSecret }}<br />\n    <button class="btn btn-sm btn-default" ng-click="variants.edit( variant )"><span class="fa fa-pencil"></span> Edit network options</button>\n  </dd>\n</dl>\n<dl class="dl-horizontal" ng-if="variant.type == \'simplePush\'">\n  <dt>Network Type:</dt>\n  <dd>\n    SimplePush<br/>\n  </dd>\n</dl>\n\n<ups-client-snippets variant="variant" all-variants="appDetail.app.variants" ng-if="variant.$deviceCount == 0 || variantDetail.forceShowSnippets"></ups-client-snippets>\n\n<p ng-if="variant.$deviceCount > 0">\n  This is a list of devices using this variable.\n  <a href ng-click="variantDetail.forceShowSnippets = true" ng-if="!variantDetail.forceShowSnippets">To see installation instructions and code snippet click here</a>\n</p>\n\n<div class="dataTables_wrapper no-footer" ng-if="variant.$deviceCount > 0">\n  <div class="dataTables_header">\n    <div class="dataTables_filter">\n      <label><input type="search" ng-model="variantDetail.searchString" ng-model-options="{debounce: 300}"></label>\n    </div>\n    <div class="dataTables_info" role="status" aria-live="polite">\n      Showing <b>{{ variantDetail.currentStart }}</b> to <b>{{ variantDetail.currentEnd }}</b> of <b>{{ variantDetail.totalCount }}</b> Devices\n    </div>\n  </div>\n\n  <div class="table-responsive">\n    <table class="datatable table table-striped table-bordered" pf-datatable>\n      <thead>\n      <tr>\n        <th>Device token</th>\n        <th>Device type</th>\n        <th>Categories</th>\n        <th>Alias</th>\n        <th>Receiving</th>\n      </tr>\n      </thead>\n      <tbody>\n      <tr ng-repeat="installation in variantDetail.installations">\n        <td title="{{ installation.deviceToken }}">{{ installation.deviceToken | limitTo : 25 }}{{ installation.deviceToken.length > 25 ? \'&hellip;\' : \'\' }}</td>\n        <td>{{ installation.deviceType }}</td>\n        <td><span ng-repeat="cat in installation.categories">{{cat.name}}{{$last ? \'\' : \', \'}}</span></td>\n        <td title="{{ installation.alias }}">{{ installation.alias  | limitTo : 15 }}{{ installation.alias.length > 15 ? \'&hellip;\' : \'\' }}</td>\n        <td><input type="checkbox" ng-checked="installation.enabled" ng-click="variantDetail.enableInstallation(variant, installation, !installation.enabled)"></td>\n      </tr>\n      </tbody>\n    </table>\n\n  </div>\n\n  <div class="dataTables_footer" ng-if="variantDetail.totalCount / variantDetail.perPage > 1">\n    <div class="dataTables_paginate paging_bootstrap_input">\n      <pagination direction-links="true" boundary-links="false"\n                  total-items="variantDetail.totalCount"\n                  ng-model="variantDetail.currentPage"\n                  previous-text="&lsaquo;" next-text="&rsaquo;"\n                  class="pull-right ups-pagination"\n                  max-size="10"\n                  ng-change="variantDetail.onPageChange( variantDetail.currentPage )"\n                  rotate="false">\n      </pagination>\n    </div>\n  </div>\n</div>\n'),$templateCache.put("components/app-detail/include/variants.html",'<div class="actions pull-right ups-main-action" ng-if="variants.isAllowedToAddVariant()">\n  <button id="add-variant-btn" class="btn btn-primary" ng-click="variants.add()"><span class="pficon pficon-add"></span> Add a variant</button>\n</div>\n\n<h3>You have {{ appDetail.app.variants.length }} Variants</h3>\n\n<div class="panel panel-default ups-panel" ng-repeat="(variantType, variantList) in variants.byType">\n\n  <div class="panel-heading ups-has-icon ups-variant-{{ variantType }}">\n    <h3 class="panel-title">{{ variants.typeEnum[variantType].name }} Variants</h3>\n    <ul class="list-inline">\n      <li id="message-count-{{ variantType }}"><span class="pficon pficon-messages"></span> <strong>{{ variantList.$messageCount }}</strong> Messages</li>\n      <li id="device-count-{{ variantType }}"><i class="fa fa-mobile"></i> <strong>{{ variantList.$deviceCount }}</strong> Devices</li>\n    </ul>\n\n  </div>\n\n  <div class="panel-body">\n    <div class="ups-variant" ng-repeat="variant in variantList">\n      <div class="ups-variant-header" ng-click="variant.$toggled = !variant.$toggled">\n        <div class="actions pull-right">\n          <ul class="list-inline">\n            <li><a ng-click="$event.stopPropagation(); variants.editName( variant );"><span class="pficon pficon-edit"></span> Edit name</a></li>\n            <li class="danger"><a ng-click="$event.stopPropagation(); variants.delete( variant );"><span class="pficon pficon-delete"></span> Remove</a></li>\n            <li class="ups-drop" onclick="event.stopPropagation()">\n              More\n              <i class="fa fa-angle-down"></i>\n              <ul class="list-unstyled">\n                <li><a ng-click="$event.stopPropagation(); variants.importInstallations( variant )"><span class="pficon pficon-import"></span> Import</a></li>\n                <li><a ng-click="$event.stopPropagation(); variants.exportInstallations( variant )" ng-if="variant.$deviceCount > 0"><span class="pficon pficon-export"></span> Export</a></li>\n              </ul>\n            </li>\n          </ul>\n        </div>\n\n        <h4><i class="fa" ng-class="{ \'fa-plus-square-o icon-plus-sign-alt\': !variant.$toggled, \'fa-minus-square-o icon-minus-sign-alt\': variant.$toggled }"></i> {{ variant.name }}</h4>\n        <ul class="list-inline">\n          <li class="warning" ng-repeat="warning in variants.getWarningsForVariant( app.warnings, variant ) | limitTo: 1">\n              <span class="pficon-layered">\n                <span class="pficon pficon-warning-triangle"></span>\n                <span class="pficon pficon-warning-exclamation"></span>\n              </span>\n            Warning\n          </li>\n          <li ng-if="variant.$deviceCount == 0"><i class="fa fa-ban"></i> No installation yet</li>\n          <li ng-if="variant.$deviceCount > 0"><span class="pficon pficon-messages"></span> <strong>{{ variant.$messageCount }}</strong> Messages</li>\n          <li ng-if="variant.$deviceCount > 0"><i class="fa fa-mobile"></i> <strong>{{ variant.$deviceCount }}</strong> Devices</li>\n        </ul>\n\n      </div><!-- vaiant header -->\n\n      <div class="ups-variant-body" ng-if="variant.$toggled">\n        <ng-include src="\'components/app-detail/include/variantDetail.html\'" ng-controller="VariantDetailController as variantDetail"></ng-include>\n      </div><!-- variant content -->\n\n    </div><!-- variant -->\n\n\n  </div><!-- panel body -->\n</div><!-- panel -->\n'),$templateCache.put("components/bootstrap/bootstrap.html",'<form name="form" class="ups-add-variable form-horizontal">\n\n  <div class="form-group" ng-if="bootstrap.allowCreate(\'android\')">\n    <label class="col-sm-3 control-label"></label>\n    <div class="col-sm-9">\n      <div class="checkbox">\n        <label>\n          <input type="checkbox" ng-model="bootstrap.types.android">\n              <span class="ups-has-icon ups-variant-android">\n                <strong>Android</strong><br>\n                using Google Cloud Messaging\n              </span>\n        </label>\n      </div>\n    </div>\n  </div>\n\n  <div ng-if="bootstrap.types.android">\n    <div class="form-group">\n      <label class="col-sm-3 control-label" for="gcmApiKey"></label>\n      <div class="col-sm-7"><em>Google Cloud Messaging</em> Key<br>\n        <input type="text" placeholder="e.g. AIza5a448c2f31700a466fbc9d33d33942b043a27596" id="gcmApiKey" class="form-control" ng-model="bootstrap.config.android.googleKey" ng-required="bootstrap.types.android">\n      </div>\n    </div>\n    <div class="form-group">\n      <label class="col-sm-3 control-label" for="gcmProjectNumber"></label>\n      <div class="col-sm-7">\n        Project Number<br>\n        <input type="text" placeholder="e.g. 42" id="gcmProjectNumber" class="form-control" ng-model="bootstrap.config.android.projectNumber" ng-required="bootstrap.types.android">\n      </div>\n    </div>\n  </div>\n\n\n  <div class="form-group" ng-if="bootstrap.allowCreate(\'ios\')">\n    <label class="col-sm-3 control-label sr-only">iOS</label>\n    <div class="col-sm-9">\n      <div class="checkbox">\n        <label>\n          <input type="checkbox" ng-model="bootstrap.types.ios">\n              <span class="ups-has-icon ups-variant-ios">\n                <strong>iOS</strong><br>\n                using Apple Push Network\n              </span>\n        </label>\n      </div>\n    </div>\n  </div>\n\n  <div ng-if="bootstrap.types.ios">\n    <div class="form-group">\n      <label class="col-sm-3 control-label"></label>\n      <div class="col-sm-7">\n        <div class="form-horizontal">\n          <div class="form-group">\n            <label class="col-sm-3 control-label" for="iosPassphrase">Certificate</label>\n            <div class="col-sm-9">\n              <strong><input type="file" ups-files="bootstrap.iosCertificates" /></strong>\n            </div>\n          </div>\n          <div class="form-group">\n            <div class="row">\n              <br><label class="col-sm-3 control-label">Type</label>\n              <div class="col-sm-9">\n                <div class="row">\n                  <div class="radio">\n                    <label>\n                      <input type="radio" name="iosType" id="iosType1" ng-model="bootstrap.config.ios.production" ng-value="true" ng-required="bootstrap.types.ios">\n                      Production\n                    </label>\n                  </div>\n                </div>\n                <div class="row">\n                  <div class="radio">\n                    <label>\n                      <input type="radio" name="iosType" id="iosType2" ng-model="bootstrap.config.ios.production" ng-value="false" ng-required="bootstrap.types.ios">\n                      Development\n                    </label>\n                  </div>\n                </div>\n              </div>\n            </div>\n          </div>\n          <div class="form-group">\n            <label class="col-sm-3 control-label" for="iosPassphrase">Passphrase</label>\n            <div class="col-sm-9">\n              <input type="password" id="iosPassphrase" class="form-control" ng-model="bootstrap.config.ios.passphrase" ng-required="bootstrap.types.ios">\n            </div>\n          </div>\n        </div>\n      </div>\n    </div>\n  </div>\n\n\n  <div class="form-group" ng-if="bootstrap.allowCreate(\'windows_wns\')">\n    <label class="col-sm-3 control-label sr-only">Windows WNS</label>\n    <div class="col-sm-9">\n      <div class="checkbox">\n        <label>\n          <input type="checkbox" ng-model="bootstrap.types.windows_wns" ng-disabled="bootstrap.types.windows_mpns">\n              <span class="ups-has-icon ups-variant-windows">\n                <strong>Windows</strong><br>\n                using Windows Push Notification Services (WNS)\n              </span>\n        </label>\n      </div>\n    </div>\n  </div>\n\n  <div ng-if="bootstrap.types.windows_wns">\n    <div class="form-group">\n      <label class="col-sm-3 control-label" for="sid"></label>\n      <div class="col-sm-7"><em>Package SID</em><br>\n        <input type="text" placeholder="ms-app://s-1-15-2-3183935804-3637592178" id="sid" class="form-control" ng-model="bootstrap.config.windows_wns.sid" ng-required="bootstrap.types.windows_wns">\n      </div>\n    </div>\n    <div class="form-group">\n      <label class="col-sm-3 control-label" for="clientSecret"></label>\n      <div class="col-sm-7">Client Secret<br>\n        <input type="text" placeholder="e.g. 42" id="clientSecret" class="form-control" ng-model="bootstrap.config.windows_wns.clientSecret" ng-required="bootstrap.types.windows_wns">\n      </div>\n    </div>\n  </div>\n\n\n  <div class="form-group" ng-if="bootstrap.allowCreate(\'windows_mpns\')">\n    <label class="col-sm-3 control-label sr-only">Windows MPNS</label>\n    <div class="col-sm-9">\n      <div class="checkbox">\n        <label>\n          <input type="checkbox" ng-model="bootstrap.types.windows_mpns" ng-disabled="bootstrap.types.windows_wns">\n              <span class="ups-has-icon ups-variant-windows">\n                <strong>Windows</strong><br>\n                using Microsoft Push Notification Service (MPNS)\n              </span>\n        </label>\n      </div>\n    </div>\n  </div>\n\n  <div class="form-group" ng-if="bootstrap.allowCreate(\'simplePush\')">\n    <label class="col-sm-3 control-label sr-only">SimplePush</label>\n    <div class="col-sm-9">\n      <div class="checkbox">\n        <label>\n          <input type="checkbox" ng-model="bootstrap.types.simplePush">\n              <span class="ups-has-icon ups-variant-simplePush">\n                <strong>SimplePush</strong><br>\n                using the Mozilla WebAPI\n              </span>\n        </label>\n      </div>\n    </div>\n  </div>\n\n  <div class="form-group" ng-if="bootstrap.allowCreate(\'adm\')">\n    <label class="col-sm-3 control-label sr-only">ADM</label>\n    <div class="col-sm-9">\n      <div class="checkbox">\n        <label>\n          <input type="checkbox" ng-model="bootstrap.types.adm">\n              <span class="ups-has-icon ups-variant-adm">\n                <strong>ADM</strong><br>\n                using Amazon Push Network\n              </span>\n        </label>\n      </div>\n    </div>\n  </div>\n\n  <div ng-if="bootstrap.types.adm">\n    <div class="form-group">\n      <label class="col-sm-3 control-label" for="admClientId"></label>\n      <div class="col-sm-7">Client ID<br>\n        <input type="text" placeholder="e.g. 5a448c2f31700a466fbc9d33d33942b043a27596" id="admClientId" class="form-control" ng-model="bootstrap.config.adm.clientId" ng-required="bootstrap.types.adm">\n      </div>\n    </div>\n    <div class="form-group">\n      <label class="col-sm-3 control-label" for="admclientSecret"></label>\n      <div class="col-sm-7">\n        Client Secret<br>\n        <input type="text" placeholder="e.g. 5da448c2f31700a466fbc9d33d33942b043a27596" id="admclientSecret" class="form-control" ng-model="bootstrap.config.adm.clientSecret" ng-required="bootstrap.types.adm">\n      </div>\n    </div>\n  </div>\n\n\n\n\n  <div class="form-group">\n    <label class="col-sm-3"></label>\n    <div class="col-sm-9">\n      <button id="enablePush" ng-click="bootstrap.bootstrapApplication()" class="btn btn-primary" ng-disabled="form.$invalid || !bootstrap.validateForm() || !bootstrap.validateFileInputs()">Enable Push</button>\n    </div>\n  </div>\n</form>\n\n'),
$templateCache.put("components/home/home.html",'<div class="container-fluid">\n  <div class="row">\n\n    <div class="col-sm-8 col-md-9">\n\n      <div class="page-header page-header-bleed-right">\n        <div class="actions pull-right">\n          <a ng-link="welcome" class="btn btn-primary ups-create-app-btn"><span class="pficon pficon-add"></span> Create Application</a>\n        </div>\n        <h1>Applications</h1>\n      </div>\n\n      <div class="ups-sub-header">\n\n        <!--<form role="form" class="search-pf has-button">-->\n          <!--<div class="form-group has-clear">-->\n            <!--<div class="search-pf-input-group">-->\n              <!--<label for="search1" class="sr-only">Search</label>-->\n              <!--<input id="search1" type="search" class="form-control" placeholder="Search">-->\n              <!--<button type="button" class="clear" aria-hidden="true"><span class="pficon pficon-close"></span></button>-->\n            <!--</div>-->\n          <!--</div>-->\n          <!--<div class="form-group">-->\n            <!--<button class="btn btn-default" type="button"><span class="fa fa-search"></span></button>-->\n          <!--</div>-->\n        <!--</form>-->\n      </div><!-- subheader -->\n\n\n      <ul class="media-list ups-app-stream">\n\n        <li class="media" ng-repeat="app in home.apps">\n          <div class="actions">\n            <ul class="list-inline">\n              <li><a href ng-click="home.changeName(app)"><span class="pficon pficon-edit"></span> Edit name</a></li>\n              <li class="danger"><a href="#" ng-click="home.deleteApp( app )"><span class="pficon pficon-delete"></span> Delete</a></li>\n            </ul>\n          </div>\n\n          <a ng-link="appDetail({app: app.pushApplicationID, tab: \'variants\'})">\n            <div class="media-left">\n              <div class="app-icon">{{ app.name | limitTo: 1 }}</div>\n            </div>\n\n            <div class="media-body">\n\n              <h2 class="media-heading">{{ app.name }} <small></small></h2>\n              <ul class="list-inline">\n                <li><span class="pficon pficon-user"></span> created by  <strong>{{ app.developer }}</strong></li>\n                <li><i class="fa fa-code-fork"></i> <ups-pluralize noun="variant" count="app.variants.length"></ups-pluralize></li>\n                <li><span class="pficon pficon-messages"></span> <ups-pluralize noun="message" count="app.$messageCount"></ups-pluralize> sent</li>\n                <li><i class="fa fa-mobile"></i> <ups-pluralize noun="device" count="app.$deviceCount"></ups-pluralize> registered</li>\n              </ul>\n\n            </div>\n          </a>\n\n        </li>\n\n      </ul>\n\n      <pagination items-per-page="8" max-size="5" total-items="home.totalItems"\n                  ng-model="home.currentPage"\n                  ng-change="home.pageChanged(home.currentPage)"\n                  ng-show="home.totalItems / 8 > 1"\n                  direction-links="true" boundary-links="false" rotate="false"\n                  previous-text="&lsaquo;" next-text="&rsaquo;" class="ups-pagination">\n      </pagination>\n\n      <pagination direction-links="true" boundary-links="false" total-items="100" ng-model="metrics.currentPage" previous-text="&lsaquo;" next-text="&rsaquo;" class="pull-right ups-pagination" ng-show="activityCtrl.pushMetrics.length" ng-change="activityCtrl.pageChanged()" max-size="5" rotate="false"></pagination>\n\n    </div><!-- /col -->\n\n\n    <div class="col-sm-4 col-md-3 sidebar-pf sidebar-pf-right">\n\n      <div class="sidebar-header sidebar-header-bleed-left sidebar-header-bleed-right">\n        <h2 class="h5">General Statistics</h2>\n      </div>\n      <ul class="list-unstyled ups-statistics">\n        <li><ups-pluralize noun="App" count="app.stats.applications"></ups-pluralize></li>\n        <li><span class="count">{{ app.stats.messages }}</span>Messages</li>\n        <li><ups-pluralize noun="Device" count="app.stats.devices"></ups-pluralize></li>\n      </ul>\n\n      <div class="sidebar-header sidebar-header-bleed-left sidebar-header-bleed-right"\n           ng-if="app.stats.messages">\n        <h2 class="h5">Latest Notifications</h2>\n      </div>\n      <div class="list-group" ng-if="app.stats.messages">\n        <a ng-link="appDetail({app: notification.id, tab: \'variants\'})" class="list-group-item" ng-repeat="notification in home.topNotifications | limitTo:4">\n          <h3 class="list-group-item-heading">{{ notification.name }}</h3>\n          <p class="list-group-item-text">{{ notification.submittedDate | date:\'d MMM, H:mm:ss, yyyy\' }}</p>\n        </a>\n      </div>\n      <!--           <p><a href="#"><span class="pficon pficon-history"></span> See all notifications</a></p> -->\n    </div><!-- /col -->\n\n  </div><!-- /row -->\n</div><!-- /container -->\n'),$templateCache.put("components/links-check/links-check.html",'<div class="container-fluid">\n  <div class="row">\n\n    <div class="col-sm-8 col-md-9 form-horizontal">\n\n      <h1>Links Check</h1>\n\n      <div class="form-group" ng-repeat="(name, link) in linksCheck.links">\n        <label class="col-sm-3 control-label">{{ name }}</label>\n        <div class="col-sm-9">\n          <a href="{{ link }}" target="_blank">{{link}}</a>\n        </div>\n      </div>\n    </div>\n\n  </div><!-- /row -->\n</div><!-- /container -->\n'),$templateCache.put("components/welcome/welcome.html",'<div class="container-fluid">\n  <div class="row  ups-wizard" ups-wizard>\n\n    <div class="col-sm-12">\n\n      <div class="page-header">\n        <h1>Welcome to Unified Push Server</h1>\n        <p>This console will help you registering apps and variants to manage push notifications. Follow these steps to set up your application.</p>\n      </div>\n\n      <div class="row boxes">\n        <div class="col-sm-3">\n          <div class="well" id="box1">\n            <div class="ups-number"><span>1</span></div>\n            <p><i class="fa fa-rocket fa-4x muted"></i></p>\n            <h4>Create your Application</h4>\n            <p>Give a name to your application. Set up just one application for all your platforms and devices.</p>\n          </div><!-- well -->\n        </div>\n        <div class="col-sm-3">\n          <div class="well"  id="box2">\n            <div class="ups-number"><span>2</span></div>\n            <p><i class="fa fa-code-fork fa-4x muted"></i></p>\n            <h4>Add a variant</h4>\n            <p>A variant is a group of devices under a platform. Add your first variant for this application and set it up on your device code. Later on you will be able to add one variant for each platform.</p>\n          </div>\n        </div>\n        <div class="col-sm-3" id="box3">\n          <div class="well">\n            <div class="ups-number"><span>3</span></div>\n            <p><i class="fa fa-paper-plane fa-4x muted"></i></p>\n            <h4>Send a notification</h4>\n            <p>Test your setup. Send your first push notification!</p>\n          </div>\n        </div>\n        <div class="col-sm-3">\n          <div class="well" id="box4">\n            <div class="ups-number"><span>4</span></div>\n            <p><i class="fa fa-desktop fa-4x muted"></i></p>\n            <h4>Set up sender API</h4>\n            <p>This is the backend code. We have sender API configuration for Java, Node.js or Curl that will help get everything up and running fast. You can do your own sender if you want.</p>\n          </div>\n        </div>\n      </div><!-- row -->\n      <p>\n        <a ng-link="wizard01CreateApp" class="btn btn-primary btn-lg">\n          START HERE\n        </a>\n      </p>\n      <p ng-if="app.stats.applications > 0">\n        <a ng-link="home">Cancel the wizard</a>\n      </p>\n    </div><!-- col -->\n\n\n  </div><!-- /row -->\n</div><!-- /container -->\n'),$templateCache.put("components/wizard01-create-app/wizard01-create-app.html",'<div class="container-fluid">\n  <div class="row">\n    <div class="col-sm-8 col-md-9">\n\n      <div class="page-header page-header-bleed-right">\n        <h1>Welcome to Unified Push Server</h1>\n      </div>\n\n      <div class="blank-slate-pf">\n        <div class="blank-slate-pf-icon">\n          <i class="fa fa-rocket"></i>\n        </div>\n\n        <h1>Create your an application</h1>\n        <p>We will hold your hand and guide you all the way. Sit back and enjoy the ride.</p>\n        <p>If you want to read about the process, <a ups-doc="create-app" param="\'123\'">go to the documentation</a>.</p>\n\n        <div class="blank-slate-pf-main-action">\n          <form class="form-inline" name="form">\n            <div class="form-group">\n              <label class="sr-only" for="appname"></label>\n              <input type="text" id="appname" class="form-control input-lg" placeholder="Application name" required ng-model="wizard01CreateApp.application.name" pf-focused="true">\n            </div>\n            <button ng-click="wizard01CreateApp.createApp()"  class="btn btn-primary btn-lg" ng-disabled="form.$invalid">Create App</button>\n          </form>\n        </div>\n\n      </div><!-- blank-slate-pf -->\n\n    </div><!-- /col -->\n\n\n    <div class="col-sm-4 col-md-3 sidebar-pf sidebar-pf-right">\n\n      <div class="sidebar-header sidebar-header-bleed-left sidebar-header-bleed-right">\n        <div class="actions pull-right" ng-if="app.stats.applications > 0">\n          <a ng-link="home">Cancel the wizard <i class="fa fa-angle-double-right"></i></a>\n        </div>\n        <h2 class="h5">Wizard steps</h2>\n      </div>\n      <ol class="list-unstyled ups-steps">\n        <li class="active"><strong>1</strong> Create your first Application</li>\n        <li><strong>2</strong> Add a variant</li>\n        <li><strong>3</strong> Mobile device: Set up variant</li>\n        <li><strong>4</strong> Test! Send notification</li>\n        <li><strong>5</strong> Backend: Set up sender API</li>\n      </ol>\n\n    </div><!-- /col -->\n  </div><!-- /row -->\n</div><!-- /container -->\n'),$templateCache.put("components/wizard02-add-variant/wizard02-add-variant.html",'<div class="container-fluid">\n  <div class="row">\n    <div class="col-sm-8 col-md-9">\n\n      <div class="page-header page-header-bleed-right">\n\n        <div class="actions pull-right">\n          <ul class="list-inline">\n            <li><a href ng-click="wizard02AddVariant.editAppName()"><span class="pficon pficon-edit"></span> Edit Name</a></li>\n          </ul>\n        </div>\n\n        <h1>{{ wizard02AddVariant.app.name }}</h1>\n\n      </div>\n\n\n      <div class="blank-slate-pf">\n        <div class="blank-slate-pf-icon">\n          <i class="fa fa-code-fork"></i>\n        </div>\n      \n        <h1>Add a variant for {{ wizard02AddVariant.app.name }}.</h1>\n        <p>The first step to set up your mobile device is to add a variants. That will generate the code necessary to register UPS on your device.</p>\n        <p>Learn more about variants <a ups-doc="add-variant">in the documentation</a>.</p>\n      \n        <div class="blank-slate-pf-main-action">\n          <button class="btn btn-primary btn-lg" ng-click="wizard02AddVariant.addVariant()">\n            <span class="pficon pficon-add"></span> Add a variant\n          </button>\n        </div>\n      </div><!-- blank-slate-pf -->\n\n    </div><!-- /col -->\n\n\n    <div class="col-sm-4 col-md-3 sidebar-pf sidebar-pf-right">\n\n      <div class="sidebar-header sidebar-header-bleed-left sidebar-header-bleed-right">\n        <div class="actions pull-right">\n          <a ng-link="appDetail({app: wizard02AddVariant.app.pushApplicationID, tab: \'variants\'})">Skip the wizard <i class="fa fa-angle-double-right"></i></a>\n        </div>\n        <h2 class="h5">Wizard steps</h2>\n      </div>\n      <ol class="list-unstyled ups-steps">\n        <li class="done"><strong><i class="fa fa-check"></i></strong> Create your first Application</li>\n        <li class="active"><strong>2</strong> Add a variant</li>\n        <li><strong>3</strong> Mobile device: Set up variant</li>\n        <li><strong>4</strong> Test! Send notification</li>\n        <li><strong>5</strong> Backend: Set up sender API</li>\n      </ol>\n\n\n\n\n    </div><!-- /col -->\n  </div><!-- /row -->\n</div><!-- /container -->\n'),$templateCache.put("components/wizard03-register-device/wizard03-register-device.html",'<div class="container-fluid">\n  <div class="row">\n    <div class="col-sm-8 col-md-9">\n\n\n      <div class="page-header page-header-bleed-right">\n\n        <div class="actions pull-right">\n          <ul class="list-inline">\n            <li><a href ng-click="wizard03RegisterDevice.editAppName()"><span class="pficon pficon-edit"></span> Edit Name</a></li>\n          </ul>\n        </div>\n\n        <h1>{{ wizard03RegisterDevice.app.name }}</h1>\n      </div>\n\n\n      <div class="actions pull-right">\n        <ul class="list-inline">\n          <li><a href ng-click="wizard03RegisterDevice.editVariant()"><span class="pficon pficon-edit"></span> Edit Variant</a></li>\n        </ul>\n      </div>\n\n      <h2 class="ups-variant-name-header ups-has-icon ups-variant-{{ wizard03RegisterDevice.variant.type }}">\n        <strong>{{ wizard03RegisterDevice.variant.name }}:</strong>\n        <span class="muted"><i class="fa fa-ban"></i> No installation yet</span>\n      </h2>\n\n      <p><strong>We are half way there!</strong> Use the code snippet bellow to <a ups-doc="register-device-{{ wizard03RegisterDevice.variant.type }}">register your device</a> and allow it to receiving notifications through this UnifiedPush Server. If you don\'t know how to do this, <a ups-doc="step-by-step-{{ wizard03RegisterDevice.variant.type }}">go to the documentation for full step by step explanation</a>.</p>\n\n      <ol>\n        <li>Copy the code snippet and paste it on your device code.</li>\n        <li>Build and deploy your app.</li>\n        <li>Click <a ng-link="wizard04SendPushNotification">Next (Bellow)</a></li>\n      </ol>\n\n\n\n      <ups-client-snippets variant="wizard03RegisterDevice.variant" all-variants="[wizard03RegisterDevice.variant]"></ups-client-snippets>\n\n      <p>Next we are going to send a test notification. Make sure you <a ups-doc="build-and-deploy-{{ wizard03RegisterDevice.variant.type }}">build or deploy your app</a> after pasting the snippet.</p>\n\n      <div class="actions pull-right ups-wizard-actions">\n        <a ng-link="wizard04SendPushNotification" class="btn btn-primary btn-lg">Next <i class="fa fa-angle-double-right"></i></a>\n      </div>\n\n\n    </div><!-- /col -->\n\n\n    <div class="col-sm-4 col-md-3 sidebar-pf sidebar-pf-right">\n\n      <div class="sidebar-header sidebar-header-bleed-left sidebar-header-bleed-right">\n        <div class="actions pull-right">\n          <a href="#"><a ng-link="appDetail({app: wizard03RegisterDevice.app.pushApplicationID, tab: \'variants\'})">Skip the wizard <i class="fa fa-angle-double-right"></i></a>\n        </div>\n        <h2 class="h5">Wizard steps</h2>\n      </div>\n      <ol class="list-unstyled ups-steps">\n        <li class="done"><strong><i class="fa fa-check"></i></strong> Create your first Application</li>\n        <li class="done"><strong><i class="fa fa-check"></i></strong> Add a variant</li>\n        <li class="active"><strong>3</strong> Mobile device: Set up variant</li>\n        <li><strong>4</strong> Test! Send notification</li>\n        <li><strong>5</strong> Backend: Set up sender API</li>\n      </ol>\n\n\n\n    </div><!-- /col -->\n  </div><!-- /row -->\n</div><!-- /container -->\n'),$templateCache.put("components/wizard04-send-push-notification/wizard04-send-push-notification.html",'<div class="container-fluid">\n  <div class="row">\n    <div class="col-sm-8 col-md-9">\n\n      <div class="page-header page-header-bleed-right">\n\n        <div class="actions pull-right">\n          <ul class="list-inline">\n            <li><a href ng-click="wizard04SendPushNotification.editAppName()"><span class="pficon pficon-edit"></span> Edit Name</a></li>\n          </ul>\n        </div>\n\n        <h1>{{ wizard04SendPushNotification.app.name }}</h1>\n      </div>\n\n\n      <h2 class="ups-variant-name-header ups-has-icon ups-variant-{{ wizard04SendPushNotification.variant.type }}">\n        <strong>{{ wizard04SendPushNotification.variant.name }}:</strong>\n        <span ng-if="wizard04SendPushNotification.deviceCount == 0" class="muted"><i class="fa fa-ban"></i> No installation yet</span>\n        <span ng-if="wizard04SendPushNotification.deviceCount > 0"><i class="fa fa-check"></i> Successful installation</span>\n      </h2>\n\n      <div ng-if="wizard04SendPushNotification.deviceCount == 0">\n        <p><strong>Build your app!</strong> You need a recipient to send the test notification. You can go back to get instructions on how to build your app or skip this and continue with the wizard.</p>\n        <p>You can always <a ng-link="wizard05SetupSender()">Skip the wizard</a> altogether if you want.</p>\n      </div>\n      <p ng-if="wizard04SendPushNotification.deviceCount > 0">\n        <strong>Excellent!</strong> Now lets test by sending a notification and see if everything adds up.\n      </p>\n\n      <form>\n        <div class="form-group">\n          <label class="control-label">Message</label>\n          <textarea class="form-control" rows="3" ng-model="wizard04SendPushNotification.pushData.message.alert" ng-disabled="wizard04SendPushNotification.deviceCount == 0" pf-focused="true"></textarea>\n        </div>\n\n        <div ng-if="wizard04SendPushNotification.deviceCount == 0" class="form-group pull-right">\n          <a ng-link="wizard03RegisterDevice()" class="btn btn-primary btn-lg"><i class="fa fa-angle-left"></i> Back to variant set up </a>\n          <a ng-link="wizard05SetupSender()" class="btn btn-default btn-lg">Skip this step <i class="fa fa-angle-right"></i></a>\n        </div>\n        <div ng-if="wizard04SendPushNotification.deviceCount > 0" class="form-group pull-right">\n          <button class="btn btn-primary btn-lg" ng-click="wizard04SendPushNotification.sendNotification()">Send Push Notification and Continue <i class="fa fa-angle-double-right"></i></button>\n        </div>\n      </form>\n\n    </div><!-- /col -->\n\n\n    <div class="col-sm-4 col-md-3 sidebar-pf sidebar-pf-right">\n\n      <div class="sidebar-header sidebar-header-bleed-left sidebar-header-bleed-right">\n        <div class="actions pull-right">\n          <a ng-link="appDetail({app: wizard04SendPushNotification.app.pushApplicationID, tab: \'variants\'})">Skip the wizard <i class="fa fa-angle-double-right"></i></a>\n        </div>\n        <h2 class="h5">Wizard steps</h2>\n      </div>\n      <ol class="list-unstyled ups-steps">\n        <li class="done"><strong><i class="fa fa-check"></i></strong> Create your first Application</li>\n        <li class="done"><strong><i class="fa fa-check"></i></strong> Add a variant</li>\n        <li class="done"><strong><i class="fa fa-check"></i></strong> Mobile device: Set up variant</li>\n        <li class="active"><strong>4</strong> Test! Send notification</li>\n        <li><strong>5</strong> Backend: Set up sender API</li>\n      </ol>\n\n\n\n\n    </div><!-- /col -->\n  </div><!-- /row -->\n</div><!-- /container -->\n'),$templateCache.put("components/wizard05-setup-sender/wizard05-setup-sender.html",'<div class="container-fluid">\n  <div class="row">\n    <div class="col-sm-8 col-md-9">\n\n\n\n\n      <div class="page-header page-header-bleed-right">\n\n        <div class="actions pull-right">\n          <ul class="list-inline">\n            <li><a href ng-click="wizard05SetupSender.editAppName()"><span class="pficon pficon-edit"></span> Edit Name</a></li>\n          </ul>\n        </div>\n\n        <h1>{{ wizard05SetupSender.app.name }}</h1>\n      </div>\n\n\n      <h2><strong>Backend:</strong> Set up sender API</h2>\n      <p><strong>Last step!</strong> Now that your mobile device is set up, lets make your backend server send notifications to this UnifiedPush Server using <a ups-doc="sender-api">UPS Sender API</a>:</p>\n      <dl class="dl-horizontal">\n        <dt>Server URL</dt>\n        <dd>{{ wizard05SetupSender.contextPath }}</dd>\n        <dt>Application ID</dt>\n        <dd>{{ wizard05SetupSender.app.pushApplicationID }}</dd>\n        <dt>Master Secret</dt>\n        <dd>{{ wizard05SetupSender.app.masterSecret }}</dd>\n      </dl>\n\n      <ups-sender-snippets app="wizard05SetupSender.app"></ups-sender-snippets>\n\n      <div class="actions pull-right ups-wizard-actions">\n        <a ng-link="wizard06Done" class="btn btn-primary btn-lg">Next <i class="fa fa-angle-double-right"></i></a>\n      </div>\n\n\n    </div><!-- /col -->\n\n\n    <div class="col-sm-4 col-md-3 sidebar-pf sidebar-pf-right">\n\n      <div class="sidebar-header sidebar-header-bleed-left sidebar-header-bleed-right">\n        <div class="actions pull-right">\n          <a href="#"><a ng-link="appDetail({app: wizard05SetupSender.app.pushApplicationID, tab: \'variants\'})">Skip the wizard <i class="fa fa-angle-double-right"></i></a>\n        </div>\n        <h2 class="h5">Wizard steps</h2>\n      </div>\n      <ol class="list-unstyled ups-steps">\n        <li class="done"><strong><i class="fa fa-check"></i></strong> Create your first Application</li>\n        <li class="done"><strong><i class="fa fa-check"></i></strong> Add a variant</li>\n        <li class="done"><strong><i class="fa fa-check"></i></strong> Mobile device: Set up variant</li>\n        <li class="done"><strong><i class="fa fa-check"></i></strong> Test! Send notification</li>\n        <li class="active"><strong>5</strong> Backend: Set up sender API</li>\n      </ol>\n\n    </div><!-- /col -->\n  </div><!-- /row -->\n</div><!-- /container -->\n'),$templateCache.put("components/wizard06-done/wizard06-done.html",'<div class="container-fluid">\n  <div class="row">\n    <div class="col-sm-8 col-md-9">\n\n      <div class="page-header page-header-bleed-right">\n        <h1>Well done!</h1>\n      </div>\n\n\n      <div class="blank-slate-pf">\n        <div class="blank-slate-pf-icon">\n          <i class="fa fa-check-square-o"></i>\n        </div>\n      \n        <h1>Congratulations! you have created an app</h1>\n        <p>Now go ahead and add more variants, send test notifications and create more applications!</p>\n      \n        <div class="blank-slate-pf-main-action">\n          <a ng-link="home" class="btn btn-primary btn-lg">\n            Done! Go to homepage\n          </a> \n        </div>\n      </div>\n\n\n    </div><!-- /col -->\n\n\n    <div class="col-sm-4 col-md-3 sidebar-pf sidebar-pf-right">\n\n      <div class="sidebar-header sidebar-header-bleed-left sidebar-header-bleed-right">\n        <h2 class="h5">Wizard steps</h2>\n      </div>\n      <ol class="list-unstyled ups-steps">\n        <li class="done"><strong><i class="fa fa-check"></i></strong> Create your first Application</li>\n        <li class="done"><strong><i class="fa fa-check"></i></strong> Add a variant</li>\n        <li class="done"><strong><i class="fa fa-check"></i></strong> Mobile device: Set up variant</li>\n        <li class="done"><strong><i class="fa fa-check"></i></strong> Test! Send notification</li>\n        <li class="done"><strong><i class="fa fa-check"></i></strong> Backend: Set up sender API</li>\n      </ol>\n\n\n\n    </div><!-- /col -->\n  </div><!-- /row -->\n</div><!-- /container -->\n'),$templateCache.put("snippets/register-device/adm.txt",'/**\n *\n * The ADM (Amazon Device Messaging) support is still experimental in the UnifiedPush Server.\n * ADM Push Network connection is implemented on the server side but the client SDK is not yet there.\n * You can find more information about ADM on the client side here :\n * https://developer.amazon.com/public/apis/engage/device-messaging/tech-docs/04-integrating-your-app-with-adm\n * To register "manually" to the UnifiedPush Service you will need these values :\n * - pushServerURL: "{{ contextPath }}"\n * - variantID: "{{ variant.variantID }}",\n * - variantSecret: "{{ variant.secret }}"\n * The endpoint to register is documented here :\n * https://aerogear.org/docs/specs/aerogear-unifiedpush-rest/registry/device/index.html\n *\n */\n'),$templateCache.put("snippets/register-device/android.java",'package com.push.pushapplication;\n\nimport android.util.Log;\nimport android.app.Application;\n\nimport org.jboss.aerogear.android.core.Callback;\nimport org.jboss.aerogear.android.unifiedpush.PushRegistrar;\nimport org.jboss.aerogear.android.unifiedpush.RegistrarManager;\nimport org.jboss.aerogear.android.unifiedpush.gcm.AeroGearGCMPushConfiguration;\n\npublic class PushApplication extends Application {\n\n    private final String VARIANT_ID       = "{{ variant.variantID }}";\n    private final String SECRET           = "{{ variant.secret }}";\n    private final String GCM_SENDER_ID    = "{{ variant.projectNumber }}";\n    private final String UNIFIED_PUSH_URL = "{{ contextPath }}";\n\n    @Override\n    public void onCreate() {\n        super.onCreate();\n\n        RegistrarManager.config("register", AeroGearGCMPushConfiguration.class)\n                    .setPushServerURI(URI.create(UNIFIED_PUSH_URL))\n                    .setSenderIds(GCM_SENDER_ID)\n                    .setVariantID(VARIANT_ID)\n                    .setSecret(SECRET)\n                    .asRegistrar();\n\n        PushRegistrar registrar = RegistrarManager.getRegistrar("register");\n        registrar.register(getApplicationContext(), new Callback<Void>() {\n            @Override\n            public void onSuccess(Void data) {\n                Log.i(TAG, "Registration Succeeded!");\n            }\n\n            @Override\n            public void onFailure(Exception e) {\n                Log.e(TAG, exception.getMessage(), exception);\n            }\n        });\n\n    }\n}\n'),$templateCache.put("snippets/register-device/cordova.js","var app = {\n  // Application Constructor\n  initialize: function() {\n    this.bindEvents();\n  },\n  // Bind Event Listeners\n  //\n  // Bind any events that are required on startup. Common events are:\n  // 'load', 'deviceready', 'offline', and 'online'.\n  bindEvents: function() {\n    document.addEventListener('deviceready', this.onDeviceReady, false);\n  },\n  // deviceready Event Handler\n  //\n  // The scope of 'this' is the event. In order to call the 'receivedEvent'\n  // function, we must explicitly call 'app.receivedEvent(...);'\n  onDeviceReady: function() {\n    app.receivedEvent('deviceready');\n    var pushConfig = {\n      pushServerURL: \"{{ contextPath }}\",\n      {{ cordovaVariantType }}: { {{ senderID ? '\\n        senderID: \"' + senderID + '\",' : '' }}\n        variantID: \"{{ variant.variantID }}\",\n        variantSecret: \"{{ variant.secret }}\"\n      }\n    };\npush.register(app.onNotification, successHandler, errorHandler, pushConfig);\n\nfunction successHandler() {\n  console.log('success')\n}\n\nfunction errorHandler(message) {\n  console.log('error ' + message);\n}\n},\nonNotification: function(event) {\n  alert(event.alert);\n},\n// Update DOM on a Received Event\nreceivedEvent: function(id) {\n  var parentElement = document.getElementById(id);\n  var listeningElement = parentElement.querySelector('.listening');\n  var receivedElement = parentElement.querySelector('.received');\n\n  listeningElement.setAttribute('style', 'display:none;');\n  receivedElement.setAttribute('style', 'display:block;');\n\n  console.log('Received Event: ' + id);\n}\n};\n\napp.initialize();\n"),$templateCache.put("snippets/register-device/dotnet.cs",'using AeroGear.Push;\n\nprotected async override void OnLaunched(LaunchActivatedEventArgs e)\n{\n  var pushConfig = new PushConfig()\n  {\n    UnifiedPushUri = new Uri("{{ contextPath}}"),\n    VariantId = "{{ variant.variantID }}",\n    VariantSecret = "{{ variant.secret }}"\n  };\n  Registration registration = new Registration();\n  registration.PushReceivedEvent += HandleNotification;\n  await registration.Register(pushConfig);\n\n  ...\n}\n\nvoid HandleNotification(object sender, PushReceivedEvent e)\n{\n  Debug.WriteLine("notification received {0}", e.Args.Message);\n}\n'),$templateCache.put("snippets/register-device/ios.objc",'- (void)application:(UIApplication *)application\n didRegisterForRemoteNotificationsWithDeviceToken:(NSData *)deviceToken {\n   NSLog(@"APNS Success");\n\n   AGDeviceRegistration *registration =\n     [[AGDeviceRegistration alloc] initWithServerURL:\n        [NSURL URLWithString:@"{{ contextPath }}"]];\n\n   [registration registerWithClientInfo:^(id clientInfo) {\n\n     // apply the token, to identify this device\n     [clientInfo setDeviceToken:deviceToken];\n\n     [clientInfo setVariantID:@"{{ variant.variantID }}"];\n     [clientInfo setVariantSecret:@"{{ variant.secret }}"];\n\n     // --optional config--\n     // set some \'useful\' hardware information params\n     UIDevice *currentDevice = [UIDevice currentDevice];\n     [clientInfo setOperatingSystem:[currentDevice systemName]];\n     [clientInfo setOsVersion:[currentDevice systemVersion]];\n     [clientInfo setDeviceType: [currentDevice model]];\n\n     } success:^() {\n       NSLog(@"UPS registration worked");\n\n     } failure:^(NSError *error) {\n       NSLog(@"UPS registration Error: %@", error);\n   }];\n }\n'),$templateCache.put("snippets/register-device/ios.swift",'func application(application: UIApplication!, didRegisterForRemoteNotificationsWithDeviceToken deviceToken: NSData!) {\n    println("APNS Success")\n\n    let registration = AGDeviceRegistration(serverURL: NSURL(string: "{{ contextPath }}"))\n\n    registration.registerWithClientInfo({ (clientInfo: AGClientDeviceInformation!)  in\n\n        // apply the token, to identify this device\n        clientInfo.deviceToken = deviceToken\n\n        clientInfo.variantID = "{{ variant.variantID }}"\n        clientInfo.variantSecret = "{{ variant.secret }}"\n\n        // --optional config--\n        // set some \'useful\' hardware information params\n        let currentDevice = UIDevice()\n        clientInfo.operatingSystem = currentDevice.systemName\n        clientInfo.osVersion = currentDevice.systemVersion\n        clientInfo.deviceType = currentDevice.model\n\n    }, success: {\n        println("UPS registration worked");\n\n    }, failure: { (error:NSError!) -> () in\n        println("UPS registration Error: \\(error.localizedDescription)")\n    })\n}\n'),$templateCache.put("snippets/senders/sender-curl.sh",'curl -u "{{ app.pushApplicationID }}:{{ app.masterSecret }}"  \\\n   -v -H "Accept: application/json" -H "Content-type: application/json"  \\\n   -X POST  -d \\\n  \'{\n     "message": {\n      "alert": "Hello from the curl HTTP Sender!",\n      "sound": "default"\n     }\n   }\'  \\\n   {{ contextPath }}rest/sender\n'),$templateCache.put("snippets/senders/sender-nodejs.js",'var agSender = require( "unifiedpush-node-sender" ),\n  settings = {\n    url: "{{ contextPath }}",\n    applicationId: "{{ app.pushApplicationID }}",\n    masterSecret: "{{ app.masterSecret }}"\n  },\n  message = {\n    alert: "Hello from the Node.js Sender API!"\n  },\n  options = {\n    config: {\n        ttl: 3600,\n    }\n  };\n\nagSender.Sender( settings ).send( message, options ).on( "success", function( response ) {\n  console.log( "success called", response );\n});\n'),$templateCache.put("snippets/senders/sender.java",'final PushSender sender =\n    DefaultPushSender.withRootServerURL("{{ contextPath }}")\n        .pushApplicationId("{{ app.pushApplicationID }}")\n        .masterSecret("{{ app.masterSecret }}")\n    .build();\n\nfinal UnifiedMessage unifiedMessage = UnifiedMessage.\n    withMessage()\n        .alert("Hello from Java Sender API!")\n    .build();\n\n\nsender.send(unifiedMessage, new MessageResponseCallback() {\n\n    @Override\n    public void onComplete() {\n        //do cool stuff\n    }\n});\n'),
$templateCache.put("directives/ups-client-snippets.html",'<ul class="nav nav-tabs nav-justified ups-snippet-nav" ng-if="typeEnum[variant.type].snippets.length">\n  <li ng-repeat="snippet in typeEnum[variant.type].snippets"\n      ng-init="state.activeSnippet = typeEnum[variant.type].snippets[0]"\n      ng-class="{ active: snippet == state.activeSnippet }">\n    <a href ng-click="state.activeSnippet = snippet">\n      <span ng-if="snippet == \'android\'">Android</span>\n      <span ng-if="snippet == \'simplePush\'">JavaScript</span>\n      <span ng-if="snippet == \'ios_objc\'">ObjectiveC</span>\n      <span ng-if="snippet == \'ios_swift\'">Swift</span>\n      <span ng-if="snippet == \'dotnet\'">C#</span>\n      <span ng-if="snippet == \'cordova\'">Cordova</span>\n      <span ng-if="snippet == \'adm\'">ADM</span>\n      <span ng-if="snippet == \'push_config\'">push-config.json</span>\n    </a>\n  </li>\n</ul>\n\n<div class="ups-snippet" ng-if="typeEnum[variant.type].snippets.length">\n  <a href tooltip="{{ clipText }}" tooltip-placement="right" clip-copy="copySnippet()" clip-click="copied()">Copy</a>\n  <!-- use both ng-if and ng-show prevents screen flickering caused by reinsertion of DOM parts, ng-if turns the invalid sample off to avoid DOM pollution -->\n  <pre ng-bind="snippets.android.source" class="pre-scrollable prettyprint" ng-if="typeEnum[variant.type].indexOf(\'android\') !== -1" ng-show="state.activeSnippet == \'android\'"></pre>\n  <pre ng-bind="snippets.cordova.source" class="pre-scrollable prettyprint" ng-if="typeEnum[variant.type].indexOf(\'cordova\') !== -1" ng-show="state.activeSnippet == \'cordova\'"></pre>\n  <pre ng-bind="snippets.ios_objc.source" class="pre-scrollable prettyprint" ng-if="typeEnum[variant.type].indexOf(\'ios_objc\') !== -1" ng-show="state.activeSnippet == \'ios_objc\'"></pre>\n  <pre ng-bind="snippets.ios_swift.source" class="pre-scrollable prettyprint" ng-if="typeEnum[variant.type].indexOf(\'ios_swift\') !== -1" ng-show="state.activeSnippet == \'ios_swift\'"></pre>\n  <pre ng-bind="snippets.dotnet.source" class="pre-scrollable prettyprint" ng-if="typeEnum[variant.type].indexOf(\'mpns\') !== -1 || typeEnum[variant.type].indexOf(\'wns\') !== -1" ng-show="state.activeSnippet == \'dotnet\'"></pre>\n  <pre ng-bind="snippets.adm.source" class="pre-scrollable prettyprint" ng-if="typeEnum[variant.type].indexOf(\'adm\') !== -1" ng-show="state.activeSnippet == \'adm\'"></pre>\n  <pre ng-bind="pushConfigSource" class="pre-scrollable prettyprint" ng-if="typeEnum[variant.type].indexOf(\'push_config\') !== -1" ng-show="state.activeSnippet == \'push_config\'"></pre>\n</div>\n'),$templateCache.put("directives/ups-sender-snippets.html",'<ul class="nav nav-tabs nav-tabs-pf">\n  <li id="java-snippet-tab" ng-class="{ active: activeSnippet == \'java\' }" ng-show=" snippets.java.show"><a href ng-click="activeSnippet = \'java\'">Java Sender API</a></li>\n  <li id="nodejs-snippet-tab" ng-class="{ active: activeSnippet == \'nodejs\' }"  ng-show=" snippets.nodejs.show"><a href ng-click="activeSnippet = \'nodejs\'">Node.js Sender API</a></li>\n  <li id="curl-snippet-tab" ng-class="{ active: activeSnippet == \'curl\' }"  ng-show=" snippets.curl.show"><a href ng-click="activeSnippet = \'curl\'">REST Sender API (with CURL)</a></li>\n</ul>\n\n\n<div ng-if="activeSnippet == \'java\'">\n  <h3>Set up Java UPS Sender API</h3>\n  <div ups-bind-html-compile="snippets.java.text.before"></div>\n</div>\n<div ng-if="activeSnippet == \'nodejs\'">\n  <h3>Set up Node.js Sender API</h3>\n  <div ups-bind-html-compile="snippets.nodejs.text.before"></div>\n</div>\n<div ng-if="activeSnippet == \'curl\'">\n  <h3>Use UPS REST Sender API (with CURL)</h3>\n  <div ups-bind-html-compile="snippets.curl.text.before"></div>\n</div>\n\n<div class="ups-snippet">\n  <a href tooltip="{{ clipText }}" tooltip-placement="right" clip-copy="copySnippet()" clip-click="copied()">Copy</a>\n  <pre ng-bind="snippets.java.source" class="pre-scrollable prettyprint" ng-if="activeSnippet == \'java\'"></pre>\n  <pre ng-bind="snippets.nodejs.source" class="pre-scrollable prettyprint" ng-if="activeSnippet == \'nodejs\'"></pre>\n  <pre ng-bind="snippets.curl.source" class="pre-scrollable prettyprint" ng-if="activeSnippet == \'curl\'"></pre>\n</div>\n\n\n<div ng-if="activeSnippet == \'java\'">\n  <div ups-bind-html-compile="snippets.java.text.after"></div>\n</div>\n<div ng-if="activeSnippet == \'nodejs\'">\n  <div ups-bind-html-compile="snippets.nodejs.text.after"></div>\n</div>\n<div ng-if="activeSnippet == \'curl\'">\n  <div ups-bind-html-compile="snippets.curl.text.after"></div>\n</div>\n'),$templateCache.put("dialogs/create-app.html",'<form name="form" class="modal-content">\n    <div class="modal-header">\n        <button type="button" class="close" aria-hidden="true" ng-click="cancel()">\n            <span class="pficon pficon-close"></span>\n        </button>\n        <h4 class="modal-title">{{ application.id ? \'Edit\' : \'Create\' }} Application</h4>\n    </div>\n    <div class="modal-body">\n        <div class="form-horizontal">\n            <div class="form-group">\n                <label class="col-sm-4 control-label" for="createAppName">Name</label>\n\n                <div class="col-sm-6">\n                    <input type="text" placeholder="e.g. MyApp" id="createAppName" class="form-control" ng-model="application.name" required pf-focused="true">\n                </div>\n            </div>\n            <div class="form-group">\n                <label class="col-sm-4 control-label" for="createAppDescription">Description</label>\n\n                <div class="col-sm-6">\n                    <input type="text" placeholder="e.g. A useful application for everyone." id="createAppDescription" class="form-control" ng-model="application.description">\n                </div>\n            </div>\n        </div>\n    </div>\n    <div class="modal-footer">\n        <input type="button" class="btn btn-default" ng-click="cancel()" value="Cancel" />\n        <input type="submit" class="btn btn-primary" ng-click="ok(application)" ng-disabled="form.$invalid" value="{{ application.id ? \'Save\' : \'Create\' }}" />\n    </div>\n</form>\n'),$templateCache.put("dialogs/create-variant.html",'<form name="form" class="modal-content ups-modal-content ups-add-variable">\n  <div class="modal-header">\n    <button type="button" class="close" aria-hidden="true" ng-click="dismiss()">\n      <span class="pficon pficon-close"></span>\n    </button>\n    <h4 class="modal-title" id="myModalLabel">{{ isNew ? \'Add\' : \'Edit\' }} Variant</h4>\n  </div>\n  <div class="modal-body form-horizontal">\n\n    <div class="form-group" ng-if="isNew">\n      <label class="col-sm-3 control-label" for="textInput-modal-markup">Name</label>\n      <div class="col-sm-9">\n        <input type="text" id="textInput-modal-markup" class="form-control" placeholder="eg. Demo" ng-model="variant.name" required="required" pf-focused="true">\n      </div>\n    </div>\n\n    <div class="form-group" ng-if="isNew && allowCreate(\'android\')">\n      <label class="col-sm-3 control-label" for="optionAndroid">Choose a platform</label>\n      <div class="col-sm-9">\n        <div class="radio">\n          <label>\n            <input type="radio" name="variantType" id="optionAndroid" value="android" ng-model="variant.type" ng-required="true">\n                <span class="ups-has-icon ups-variant-android">\n                  <strong>Android</strong><br>\n                  using Google Cloud Messaging\n                </span>\n          </label>\n        </div>\n      </div>\n    </div>\n\n\n    <div class="form-group" ng-if="isNew && allowCreate(\'ios\')">\n      <label class="col-sm-3 control-label sr-only" for="optionIos">iOS</label>\n      <div class="col-sm-9">\n        <div class="radio">\n          <label>\n            <input type="radio" name="variantType" id="optionIos" value="ios" ng-model="variant.type" ng-required="true">\n                <span class="ups-has-icon ups-variant-ios">\n                  <strong>iOS</strong><br>\n                  using Apple Push Network\n                </span>\n          </label>\n        </div>\n      </div>\n    </div>\n\n\n    <div class="form-group" ng-if="isNew && allowCreate(\'windows_wns\')">\n      <label class="col-sm-3 control-label sr-only" for="optionWindowsWns">Windows</label>\n      <div class="col-sm-9">\n        <div class="radio">\n          <label>\n            <input type="radio" name="variantType" id="optionWindowsWns" value="windows_wns" ng-model="variant.type" ng-required="true">\n                <span class="ups-has-icon ups-variant-windows">\n                  <strong>Windows/WNS</strong><br>\n                  using Windows Push Notification Services (WNS)\n                </span>\n          </label>\n        </div>\n      </div>\n    </div>\n\n\n    <div class="form-group" ng-if="isNew && allowCreate(\'windows_mpns\')">\n      <label class="col-sm-3 control-label sr-only" for="optionWindowsMpns">Windows</label>\n      <div class="col-sm-9">\n        <div class="radio">\n          <label>\n            <input type="radio" name="variantType" id="optionWindowsMpns" value="windows_mpns" ng-model="variant.type" ng-required="true">\n                <span class="ups-has-icon ups-variant-windows">\n                  <strong>Windows/MPNS (deprecated)</strong><br>\n                  using Microsoft Push Notification Service (MPNS)\n                </span>\n          </label>\n        </div>\n      </div>\n    </div>\n\n    <div class="form-group" ng-if="isNew && allowCreate(\'simplePush\')">\n      <label class="col-sm-3 control-label sr-only" for="optionSimplePush">SimplePush</label>\n      <div class="col-sm-9">\n        <div class="radio">\n          <label>\n            <input type="radio" name="variantType" id="optionSimplePush" value="simplePush" ng-model="variant.type" ng-required="true">\n                <span class="ups-has-icon ups-variant-simplePush">\n                  <strong>SimplePush</strong><br>\n                  using the Mozilla WebAPI\n                </span>\n          </label>\n        </div>\n      </div>\n    </div>\n\n    <div class="form-group" ng-if="isNew && allowCreate(\'adm\')">\n      <label class="col-sm-3 control-label sr-only" for="optionsAdm">ADM</label>\n      <div class="col-sm-9">\n        <div class="radio">\n          <label>\n            <input type="radio" name="variantType" id="optionsAdm" value="adm" ng-model="variant.type" ng-required="true">\n                <span class="ups-has-icon ups-variant-adm">\n                  <strong>ADM (experimental)</strong><br>\n                  using Amazon Push Network\n                </span>\n          </label>\n        </div>\n      </div>\n    </div>\n\n    <div ng-show="variant.type">\n\n      <div ng-show="variant.type == \'android\'">\n        <div class="form-group">\n          <label class="col-sm-3 control-label" for="gcmApiKey">Push Network</label>\n          <div class="col-sm-7"><em>Google Cloud Messaging</em> Key<br>\n            <input type="text" placeholder="e.g. AIza5a448c2f31700a466fbc9d33d33942b043a27596" id="gcmApiKey" class="form-control" ng-model="variant.googleKey" ng-required="variant.type == \'android\'">\n          </div>\n        </div>\n        <div class="form-group">\n          <label class="col-sm-3 control-label" for="gcmProjectNumber"></label>\n          <div class="col-sm-7">\n            Project Number<br>\n            <input type="text" placeholder="e.g. 42" id="gcmProjectNumber" class="form-control" ng-model="variant.projectNumber" ng-required="variant.type == \'android\'">\n          </div>\n        </div>\n      </div>\n\n      <div ng-show="variant.type == \'ios\'">\n        <div class="form-group">\n          <label class="col-sm-3 control-label">Push Network</label>\n          <div class="col-sm-7">\n            <p><em>Apple Push Notification Service</em> certificate:</p>\n            <strong><input type="file" ups-files="variant.certificates" /></strong>\n            <div class="form-horizontal">\n              <div class="form-group">\n                <div class="row">\n                  <br><label class="col-sm-3 control-label">Type</label>\n                  <div class="col-sm-9">\n                    <div class="row">\n                      <div class="radio">\n                        <label>\n                          <input type="radio" name="iosType" id="iosType1" ng-model="variant.production" ng-value="true" ng-required="variant.type == \'ios\'">\n                          Production\n                        </label>\n                      </div>\n                    </div>\n                    <div class="row">\n                      <div class="radio">\n                        <label>\n                          <input type="radio" name="iosType" id="iosType2" ng-model="variant.production" ng-value="false" ng-required="variant.type == \'ios\'">\n                          Development\n                        </label>\n                      </div>\n                    </div>\n                  </div>\n                </div>\n              </div>\n              <div class="form-group">\n                <label class="col-sm-3 control-label" for="iosPassphrase">Passphrase</label>\n                <div class="col-sm-9">\n                  <input type="password" id="iosPassphrase" class="form-control" ng-model="variant.passphrase" ng-disabled="!isNew && variant.certificates.length == 0">\n                </div>\n              </div>\n            </div>\n          </div>\n        </div>\n      </div>\n\n      <div ng-show="variant.type == \'windows_wns\'">\n        <div class="form-group">\n          <label class="col-sm-3 control-label" for="sid">Push Network</label>\n          <div class="col-sm-7"><em>Package SID</em><br>\n            <input type="text" placeholder="ms-app://s-1-15-2-3183935804-3637592178" id="sid" class="form-control" ng-model="variant.sid" ng-required="variant.protocolType == \'wns\'">\n          </div>\n        </div>\n        <div class="form-group">\n          <label class="col-sm-3 control-label" for="clientSecret"></label>\n          <div class="col-sm-7">Client Secret<br>\n            <input type="text" placeholder="e.g. 42" id="clientSecret" class="form-control" ng-model="variant.clientSecret" ng-required="variant.protocolType == \'wns\'">\n          </div>\n        </div>\n      </div>\n\n      <div ng-show="variant.type == \'windows_mpns\'">\n        <div class="form-group">\n          <label class="col-sm-3 control-label">Push Network</label>\n          <div class="col-sm-7"><strong>No configuration needed</strong></div>\n        </div>\n      </div>\n\n      <div ng-show="variant.type == \'simplePush\'">\n        <div class="form-group">\n          <label class="col-sm-3 control-label">Push Network</label>\n          <div class="col-sm-7"><strong>No configuration needed</strong><p>This server\'s <em>SimplePush</em> implementation will be used.</p></div>\n        </div>\n      </div>\n\n      <div ng-show="variant.type == \'adm\'">\n        <div class="form-group">\n          <label class="col-sm-3 control-label" for="admClientId">Push Network</label>\n          <div class="col-sm-7">Client ID<br>\n            <input type="text" placeholder="e.g. 5a448c2f31700a466fbc9d33d33942b043a27596" id="admClientId" class="form-control" ng-model="variant.clientId" ng-required="variant.type == \'adm\'">\n          </div>\n        </div>\n        <div class="form-group">\n          <label class="col-sm-3 control-label" for="admclientSecret"></label>\n          <div class="col-sm-7">\n            Client Secret<br>\n            <input type="text" placeholder="e.g. 5da448c2f31700a466fbc9d33d33942b043a27596" id="admclientSecret" class="form-control" ng-model="variant.clientSecret" ng-required="variant.type == \'adm\'">\n          </div>\n        </div>\n      </div>\n\n    </div>\n\n  </div>\n  <div class="modal-footer">\n    <button ng-click="dismiss()" type="button" class="btn btn-default">Cancel</button>\n    <button ng-click="confirm()" class="btn btn-primary" ng-disabled="form.$invalid || !validateFileInputs()">{{ isNew ? \'Create\' : \'Save\' }}</button>\n  </div>\n</form>\n'),$templateCache.put("dialogs/edit-app-name.html",'<form name="form" class="modal-content">\n  <div class="modal-header">\n    <button type="button" class="close" aria-hidden="true" ng-click="dismiss()">\n      <span class="pficon pficon-close"></span>\n    </button>\n    <h4 class="modal-title">Edit Application Name</h4>\n  </div>\n  <div class="modal-body  form-horizontal">\n    <div class="form-group">\n      <label class="col-sm-3 control-label" for="name">Name</label>\n      <div class="col-sm-9">\n        <input type="text" id="name" class="form-control" placeholder="eg. Demo" ng-model="app.name" required="required" pf-focused="true">\n      </div>\n    </div>\n  </div>\n  <div class="modal-footer">\n    <button type="button" class="btn btn-default" ng-click="dismiss()">Cancel</button>\n    <button type="submit" class="btn btn-primary text-left" ng-click="confirm()" ng-disabled="form.$invalid">\n      Save\n    </button>\n  </div>\n</form>\n'),$templateCache.put("dialogs/edit-variant-name.html",'<form name="form" class="modal-content">\n  <div class="modal-header">\n    <button type="button" class="close" aria-hidden="true" ng-click="dismiss()">\n      <span class="pficon pficon-close"></span>\n    </button>\n    <h4 class="modal-title">Edit Variant Name</h4>\n  </div>\n  <div class="modal-body  form-horizontal">\n    <div class="form-group">\n      <label class="col-sm-3 control-label" for="name">Name</label>\n      <div class="col-sm-9">\n        <input type="text" id="name" class="form-control" placeholder="eg. Demo" ng-model="variant.name" required="required" pf-focused="true">\n      </div>\n    </div>\n  </div>\n  <div class="modal-footer">\n    <button type="button" class="btn btn-default" ng-click="dismiss()">Cancel</button>\n    <button type="submit" class="btn btn-primary text-left" ng-click="confirm()" ng-disabled="form.$invalid">\n      Save\n    </button>\n  </div>\n</form>\n'),$templateCache.put("dialogs/export-installations.html",'<div class="modal-content">\n  <div class="modal-header">\n    <button type="button" class="close" aria-hidden="true" ng-click="dismiss()">\n      <span class="pficon pficon-close"></span>\n    </button>\n    <h4 class="modal-title">Export Installations </h4>\n  </div>\n  <div class="modal-body">\n    <b>{{ variant.$deviceCount }}</b> installations will be exported.\n  </div>\n  <div class="modal-footer">\n    <button type="button" class="btn btn-primary text-left" ng-click="confirm()">Export</button>\n    <button type="button" class="btn btn-default" ng-click="dismiss()">Cancel</button>\n  </div>\n</div>\n'),$templateCache.put("dialogs/import-installations.html",'<form name="form" class="modal-content ups-modal-content">\n  <div class="modal-content">\n    <div class="modal-header">\n      <button type="button" class="close" aria-hidden="true" ng-click="dismiss()">\n        <span class="pficon pficon-close"></span>\n      </button>\n      <h4 class="modal-title">Import Installations </h4>\n    </div>\n    <div class="modal-body">\n      <p>\n        <strong><input type="file" ups-files="installations" on-change="previewImport()"/></strong>\n      </p>\n\n      <p ng-show="importPreview">\n        <ups-pluralize noun="installation" count="importPreview" zero="No"></ups-pluralize>\n        <span>will be imported</span>\n      </p>\n      <p ng-show="incorrectFormat">\n        <strong>\n          <i class="fa fa-warning"></i>\n          This file can not be parsed !\n        </strong>\n      </p>\n    </div>\n    <div class="modal-footer">\n      <button ng-disabled="!importPreview" type="submit" class="btn btn-primary text-left" ng-click="confirm(variant)">Import</button>\n      <button type="button" class="btn btn-default" ng-click="dismiss()">Cancel</button>\n    </div>\n  </div>\n</form>\n'),$templateCache.put("dialogs/remove-app.html",'<form name="form" class="modal-content">\n  <div class="modal-header">\n    <button type="button" class="close" aria-hidden="true" ng-click="dismiss()">\n      <span class="pficon pficon-close"></span>\n    </button>\n    <h4 class="modal-title">Delete Application</h4>\n  </div>\n  <div class="modal-body">\n    <p>Do you really want to delete the application <strong>"{{ app.name }}"</strong>?</p>\n    <p>Please type in the name of the variant to confirm.</p>\n    <p>\n      <input class="form-control" ng-model="confirmAppName" pf-focused="true" />\n    </p>\n  </div>\n  <div class="modal-footer">\n    <button type="button" class="btn btn-default" ng-click="dismiss()">\n      Cancel\n    </button>\n    <button type="submit" class="btn btn-danger text-left" ng-click="confirm()" ng-disabled="app.name !== confirmAppName">\n      Delete\n    </button>\n  </div>\n</form>\n'),$templateCache.put("dialogs/remove-variant.html",'<form class="modal-content">\n  <div class="modal-header">\n    <button type="button" class="close" aria-hidden="true" ng-click="dismiss()">\n      <span class="pficon pficon-close"></span>\n    </button>\n    <h4 class="modal-title">Remove Variant</h4>\n  </div>\n  <div class="modal-body">\n    <p>Do you really want to delete the variant <strong>"{{ variant.name }}"</strong>?</p>\n    <p>Please type in the name of the variant to confirm.</p>\n    <p>\n      <input class="form-control" ng-model="confirmVariantName" pf-focused="true" />\n    </p>\n  </div>\n  <div class="modal-footer">\n    <button type="button" class="btn btn-default" ng-click="dismiss()">\n      Cancel\n    </button>\n    <button type="submit" class="btn btn-danger text-left" ng-click="confirm()" ng-disabled="variant.name !== confirmVariantName">\n      Delete\n    </button>\n  </div>\n</form>\n'),$templateCache.put("dialogs/renew-variant-secret.html",'<div class="modal-header">\n  <button type="button" class="close" aria-hidden="true" ng-click="dismiss()">\n    <span class="pficon pficon-close"></span>\n  </button>\n  <h4 class="modal-title" id="myModalLabel">Renew Variant Secret</h4>\n</div>\n<div class="modal-body">\n  <h4>You are about to change the variant secret for variant <strong>"{{variant.name}}"</strong>!</h4>\n  <p>Be aware that this cannot be undone and you\'ll have to change secret on all the installed devices in order to continue receiving push notifications.</p>\n  <p>Please type in the name of the variant to confirm.</p>\n  <p>\n    <input class="form-control" ng-model="confirmVariantName" pf-focused="true" />\n  </p>\n\n</div>\n<div class="modal-footer">\n  <button class="btn btn-default" ng-click="dismiss()">\n    Cancel\n  </button>\n  <button class="btn btn-danger" ng-click="confirm()" ng-disabled="variant.name !== confirmVariantName">\n    Renew Variant Secret\n  </button>\n</div>\n'),$templateCache.put("dialogs/send-push-notification.html",'<form name="form" class="modal-content">\n  <div class="modal-header">\n    <button type="button" class="close" aria-hidden="true" ng-click="cancel()">\n      <span class="pficon pficon-close"></span>\n    </button>\n    <h4 class="modal-title" id="myModalLabel">Send push to Application One</h4>\n  </div>\n  <div class="modal-body form-horizontal">\n\n    <div class="form-group">\n      <label class="col-sm-3 control-label" for="textInput-modal-markup">Message</label>\n      <div class="col-sm-9">\n        <textarea id="pushAlert" class="form-control" rows="3" placeholder="Write the notification" ng-model="pushData.message.alert" ng-required="true" pf-focused="true"></textarea>\n      </div>\n    </div>\n\n\n\n    <div class="form-group">\n      <label class="col-sm-3 control-label" for="textInput-modal-markup">Variants</label>\n      <div class="col-sm-9">\n        <select pf-select="{ noneSelectedText: \'All Variants\' }" multiple ng-model="selectedVariants" ng-options="variant.variantID as variant.name for variant in app.variants"></select>\n      </div>\n    </div>\n\n\n    <div class="form-group">\n      <label class="col-sm-3 control-label" for="textInput-modal-markup">Aliases</label>\n      <div class="col-sm-9">\n        <input type="text" id="textInput-modal-markup" class="form-control" placeholder="All" ng-model="aliases">\n      </div>\n    </div>\n\n\n    <div class="form-group">\n      <label class="col-sm-3 control-label" for="textInput-modal-markup">Device Types</label>\n      <div class="col-sm-9">\n        <input type="text" id="textInput-modal-markup" class="form-control" placeholder="All" ng-model="deviceTypes">\n      </div>\n    </div>\n\n\n    <div class="form-group">\n      <label class="col-sm-3 control-label" for="textInput-modal-markup">Categories</label>\n      <div class="col-sm-9">\n        <input type="text" id="textInput-modal-markup" class="form-control" placeholder="All" ng-model="categories">\n      </div>\n    </div>\n\n\n    <span id="helpBlock" class="help-block">You can provide multiple values at a time by separating them by commas.</span>\n\n\n\n  </div>\n  <div class="modal-footer">\n    <button id="cancelPush" class="btn btn-default" ng-click="cancel()">Cancel</button>\n    <button id="sendPush" class="btn btn-primary" ng-click="send()" ng-disabled="form.$invalid">Send Push Notification</button>\n  </div>\n</form>\n')}]);