/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.system;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigurationUtils {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationUtils.class);

    private ConfigurationUtils() {
    }

    public static String tryGetProperty(String key) {
        return ConfigurationUtils.tryGetProperty(key, null);
    }

    public static String tryGetProperty(String key, String defaultValue) {
        try {
            return System.getProperty(key, defaultValue);
        }
        catch (SecurityException e) {
            logger.error("Could not get value of property {} due to SecurityManager. Using null value.", (Object)key);
            return null;
        }
    }

    public static Integer tryGetIntegerProperty(String key) {
        return ConfigurationUtils.tryGetIntegerProperty(key, null);
    }

    public static Integer tryGetIntegerProperty(String key, Integer defaultValue) {
        try {
            return Integer.getInteger(key, defaultValue);
        }
        catch (SecurityException e) {
            logger.error("Could not get value of property {} due to SecurityManager. Using null value.", (Object)key, (Object)e);
            return defaultValue;
        }
    }
}

