/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.system;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ConfigurationUtils {
    private static final Logger logger = LoggerFactory.getLogger(ConfigurationUtils.class);

    private ConfigurationUtils() {
    }

    private static String tryGetProperty(String key, String defaultValue) {
        try {
            return System.getProperty(key, defaultValue);
        }
        catch (SecurityException e) {
            logger.error("Could not get value of property {} due to SecurityManager. Using default value.", (Object)key);
            return null;
        }
    }

    private static Integer tryGetIntegerProperty(String key, Integer defaultValue) {
        try {
            return Integer.getInteger(key, defaultValue);
        }
        catch (SecurityException e) {
            logger.error("Could not get value of property {} due to SecurityManager. Using default value.", (Object)key, (Object)e);
            return defaultValue;
        }
    }

    public static String formatEnvironmentVariable(String key) {
        return key.toUpperCase().replaceAll("\\.", "_");
    }

    public static String tryGetGlobalProperty(String key, String defaultValue) {
        try {
            String value = System.getenv(ConfigurationUtils.formatEnvironmentVariable(key));
            if (value == null) {
                value = ConfigurationUtils.tryGetProperty(key, defaultValue);
            }
            return value;
        }
        catch (SecurityException e) {
            logger.error("Could not get value of global property {} due to SecurityManager. Using default value.", (Object)key, (Object)e);
            return defaultValue;
        }
    }

    public static String tryGetGlobalProperty(String key) {
        return ConfigurationUtils.tryGetGlobalProperty(key, null);
    }

    public static Integer tryGetGlobalIntegerProperty(String key, Integer defaultValue) {
        try {
            String value = System.getenv(ConfigurationUtils.formatEnvironmentVariable(key));
            if (value == null) {
                return ConfigurationUtils.tryGetIntegerProperty(key, defaultValue);
            }
            return Integer.parseInt(value);
        }
        catch (NumberFormatException | SecurityException e) {
            logger.error("Could not get value of global property {} due to SecurityManager. Using default value.", (Object)key, (Object)e);
            return defaultValue;
        }
    }

    public static Integer tryGetGlobalIntegerProperty(String key) {
        return ConfigurationUtils.tryGetGlobalIntegerProperty(key, null);
    }
}

