/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.rest.metrics;

import java.util.List;
import javax.ejb.Singleton;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.jboss.aerogear.unifiedpush.rest.util.HttpRequestUtil;
import org.jboss.aerogear.unifiedpush.service.dashboard.DashboardData;
import org.jboss.aerogear.unifiedpush.service.dashboard.DashboardService;

@Singleton
@Path(value="/metrics/dashboard")
public class DashboardEndpoint {
    @Inject
    private DashboardService service;

    @GET
    @Produces(value={"application/json"})
    public Response totalApplications(@Context HttpServletRequest request) {
        String principalName = HttpRequestUtil.extractUsername(request);
        DashboardData dataForUser = this.service.loadDashboardData(principalName);
        return Response.ok((Object)dataForUser).build();
    }

    @GET
    @Path(value="/warnings")
    @Produces(value={"application/json"})
    public Response getVariantsWithWarnings(@Context HttpServletRequest request) {
        String principalName = HttpRequestUtil.extractUsername(request);
        List variantsWithWarnings = this.service.getVariantsWithWarnings(principalName);
        return Response.ok((Object)variantsWithWarnings).build();
    }

    @GET
    @Path(value="/active")
    @Produces(value={"application/json"})
    public Response getTopThreeVariants(@Context HttpServletRequest request) {
        String principalName = HttpRequestUtil.extractUsername(request);
        List variantsWithWarnings = this.service.getTopThreeBusyVariants(principalName);
        return Response.ok((Object)variantsWithWarnings).build();
    }
}

