/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.rest.metrics;

import java.util.List;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.jboss.aerogear.unifiedpush.rest.util.HttpRequestUtil;
import org.jboss.aerogear.unifiedpush.service.metrics.PushMessageMetricsService;

@Stateless
@Path(value="/metrics/messages")
public class PushMetricsEndpoint {
    @Inject
    private PushMessageMetricsService metricsService;

    @GET
    @Path(value="/application/{id}")
    @Produces(value={"application/json"})
    public Response pushMessageInformationPerApplication(@Context HttpServletRequest request, @PathParam(value="id") String id, @QueryParam(value="sort") String sorting) {
        if (id == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Could not find requested information").build();
        }
        List messageInformations = this.metricsService.findAllForPushApplication(id, HttpRequestUtil.extractSortingQueryParamValue(sorting).booleanValue());
        return Response.ok((Object)messageInformations).build();
    }

    @GET
    @Path(value="/variant/{id}")
    @Produces(value={"application/json"})
    public Response pushMessageInformationPerVariant(@Context HttpServletRequest request, @PathParam(value="id") String id, @QueryParam(value="sort") String sorting) {
        if (id == null) {
            return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Could not find requested information").build();
        }
        List messageInformations = this.metricsService.findAllForVariant(id, HttpRequestUtil.extractSortingQueryParamValue(sorting).booleanValue());
        return Response.ok((Object)messageInformations).build();
    }
}

