/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.rest.registry.applications;

import java.util.UUID;
import java.util.logging.Level;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.jboss.aerogear.unifiedpush.api.Variant;
import org.jboss.aerogear.unifiedpush.rest.AbstractBaseEndpoint;
import org.jboss.aerogear.unifiedpush.rest.util.HttpRequestUtil;
import org.jboss.aerogear.unifiedpush.service.GenericVariantService;
import org.jboss.aerogear.unifiedpush.service.PushApplicationService;

public abstract class AbstractVariantEndpoint
extends AbstractBaseEndpoint {
    @Inject
    protected PushApplicationService pushAppService;
    @Inject
    protected GenericVariantService variantService;

    @PUT
    @Path(value="/{variantId}/reset")
    @Consumes(value={"application/json"})
    public Response resetSecret(@Context HttpServletRequest request, @PathParam(value="variantId") String variantId) {
        Variant variant = this.variantService.findByVariantIDForDeveloper(variantId, HttpRequestUtil.extractUsername(request));
        if (variant != null) {
            this.logger.log(Level.FINEST, "Resetting secret for: " + variant.getClass().getSimpleName());
            String newSecret = UUID.randomUUID().toString();
            variant.setSecret(newSecret);
            this.variantService.updateVariant(variant);
            return Response.ok((Object)variant).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Could not find requested Variant").build();
    }

    @GET
    @Path(value="/{variantId}")
    @Produces(value={"application/json"})
    public Response findVariantById(@Context HttpServletRequest request, @PathParam(value="variantId") String variantId) {
        Variant variant = this.variantService.findByVariantIDForDeveloper(variantId, HttpRequestUtil.extractUsername(request));
        if (variant != null) {
            return Response.ok((Object)variant).build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Could not find requested Variant").build();
    }

    @DELETE
    @Path(value="/{variantId}")
    public Response deleteVariant(@Context HttpServletRequest request, @PathParam(value="variantId") String variantId) {
        Variant variant = this.variantService.findByVariantIDForDeveloper(variantId, HttpRequestUtil.extractUsername(request));
        if (variant != null) {
            this.logger.log(Level.FINEST, "Deleting: " + variant.getClass().getSimpleName());
            this.variantService.removeVariant(variant);
            return Response.noContent().build();
        }
        return Response.status((Response.Status)Response.Status.NOT_FOUND).entity((Object)"Could not find requested Variant").build();
    }
}

