/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.aerogear.unifiedpush.rest.sender;

import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.ejb.Stateless;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import org.jboss.aerogear.unifiedpush.api.PushApplication;
import org.jboss.aerogear.unifiedpush.message.SenderService;
import org.jboss.aerogear.unifiedpush.message.UnifiedPushMessage;
import org.jboss.aerogear.unifiedpush.rest.util.HttpBasicHelper;
import org.jboss.aerogear.unifiedpush.rest.util.HttpRequestUtil;
import org.jboss.aerogear.unifiedpush.service.PushApplicationService;

@Stateless
@Path(value="/sender")
public class PushNotificationSenderEndpoint {
    private final Logger logger = Logger.getLogger(PushNotificationSenderEndpoint.class.getName());
    @Inject
    private PushApplicationService pushApplicationService;
    @Inject
    private SenderService senderService;

    @POST
    @Consumes(value={"application/json"})
    public Response send(Map<String, Object> message, @Context HttpServletRequest request) {
        PushApplication pushApplication = this.loadPushApplicationWhenAuthorized(request);
        if (pushApplication == null) {
            return Response.status((Response.Status)Response.Status.UNAUTHORIZED).header("WWW-Authenticate", (Object)"Basic realm=\"AeroGear UnifiedPush Server\"").entity((Object)"Unauthorized Request").build();
        }
        UnifiedPushMessage payload = new UnifiedPushMessage(message);
        payload.setIpAddress(HttpRequestUtil.extractIPAddress(request));
        payload.setClientIdentifier(HttpRequestUtil.extractAeroGearSenderInformation(request));
        this.senderService.send(pushApplication, payload);
        this.logger.log(Level.FINE, "Message sent by: '" + payload.getClientIdentifier() + "'");
        this.logger.log(Level.INFO, "Message submitted to PushNetworks for further processing");
        return Response.status((Response.Status)Response.Status.OK).entity((Object)"Job submitted").build();
    }

    private PushApplication loadPushApplicationWhenAuthorized(HttpServletRequest request) {
        String[] credentials = HttpBasicHelper.extractUsernameAndPasswordFromBasicHeader(request);
        String pushApplicationID = credentials[0];
        String secret = credentials[1];
        PushApplication pushApplication = this.pushApplicationService.findByPushApplicationID(pushApplicationID);
        if (pushApplication != null && pushApplication.getMasterSecret().equals(secret)) {
            return pushApplication;
        }
        return null;
    }
}

